#!/bin/bash
a=$1
b=$2
Prefix=${a}_${b}

aCtg=${a}.ctg.fa
bCtg=${b}.ctg.fa

if [ ! -f $aCtg ]
then
    echo "$aCtg not exist"
    exit
fi
if [ ! -f $bCtg ]
then
    echo "$bCtg not exist"
    exit
fi

nucmer -maxmatch -l 30 -banded -D 5 -p $Prefix $aCtg $bCtg
delta-filter -q -i 95 -o 95 ${Prefix}.delta >${Prefix}.f_delta
dnadiff -d ${Prefix}.f_delta -p ${Prefix}

rm ${Prefix}.f_delta

exit

