#!/bin/bash
Prefix=$1
Readfile=$2
Bowtie2OptFile=$3   
#"--no-head --phred64"
if [ ! -f $Bowtie2OptFile ]; then 
    echo "$Bowtie2OptFile not exist"
    exit
fi

read Bowtie2Opt < $Bowtie2OptFile

Filter=$4
FilterOptFile=$5
#"-l 15"


if [ ! -f $Readfile ]; then
    echo "$Readfile not exist"
    exit
fi
if [ ! -r $Readfile ]; then
    echo "$Readfile can not be read"
    exit
fi
i=0
while read line
do
    if echo "$line" | grep -q -E "^$|^#"
    then
        continue
    fi
    readpairarray[${i}]=$line
    i=$i+1
done < $Readfile

bowtie2-build ${Prefix}.ctg.fa ${Prefix}

for ((i=0; i <${#readpairarray[*]}; ++i))
do
    j=0
    for fastq in ${readpairarray[${i}]}
    do
        Fastq[${j}]=$fastq
        j=${j}+1
    done
    if [[ ${j} -eq 2 ]]; then
        Fastq1=${Fastq[0]}
        Fastq2=${Fastq[1]}

        bowtie2 -x ${Prefix} -1 $Fastq1 -2 $Fastq2 -S ${Prefix}_${i}.sam --no-head $Bowtie2Opt
    elif [[ ${j} -eq 1 ]]; then
        Fastqsg=${Fastq[0]}

        bowtie2 -x ${Prefix} -U $Fastqsg -S ${Prefix}_${i}.sam --no-head $Bowtie2Opt
    fi
done

if [[ $Filter -eq 1 ]]; then
    if [ ! -f $FilterOptFile ]; then
        echo "$FilterOptFile not exist"
        exit
    fi

    read FilterOpt < $FilterOptFile

    scriptdir=`dirname $0`
    sampuncfile=${scriptdir}/puncsamfile.sh
    if [ ! -f $sampuncfile ]
    then
        echo "$sampuncfile not exist"
        exit
    fi
    samfile=`bash $sampuncfile .`
    FilterCtgCov=${scriptdir}/FilterCtgCov
    if [ ! -f $FilterCtgCov ]; then
        echo "$FilterCtgCov not exist"
        exit
    fi
    echo "$FilterCtgCov -c ${Prefix}.ctg.fa -b $samfile -o ${Prefix} $FilterOpt"
    $FilterCtgCov -c ${Prefix}.ctg.fa -b $samfile -o ${Prefix} $FilterOpt
fi


