#!/bin/bash
scriptdir=$1
MergeOptFile=$2
subject=$3
query=$4
subjectvalidate=$5
queryvalidate=$6
subjectctgfile=${subject}.ctg.fa
queryctgfile=${query}.ctg.fa

pairmatch=${scriptdir}/godnadiff_pairctg.sh
if [ ! -f $pairmatch ]
then
    echo "$pairmatch not exist"
    exit
fi



echo "bash godnadiff_pairctg.sh $subject $query"
bash $pairmatch $subject $query
echo "bash godnadiff_pairctg.sh $query $subject"
bash $pairmatch $query $subject

subjectsam=$7
querysam=$8

ctgvalidate=${scriptdir}/ctgvalidate
if [ ! -f $ctgvalidate ]; then
    echo "error no $ctgvalidate"
    exit
fi

if [ ${subjectvalidate} == 1 ]; then
    echo "ctgvalidate $subjcetctgfile "
    if [ ! -f ${subjectctgfile}.fea ]; then
        $ctgvalidate -c $subjectctgfile -b $subjectsam
    fi
fi
if [ ${queryvalidate} == 1 ]; then  
    echo "ctgvalidate $queryctgfile"
    if [ ! -f ${queryctgfile}.fea ]; then 
        $ctgvalidate -c $queryctgfile -b $querysam
    fi
fi

read MergeOpt < $MergeOptFile
echo "merge"
mergedir=$scriptdir
mergeassembly=${mergedir}/mergeassembly
if [ ! -f $mergeassembly ]; then
    echo "error no $mergeassembly"
    exit
fi

$mergeassembly -s $subject -q $query $MergeOpt


