#!/bin/bash
#scriptdir=`dirname $0`

workdir=`pwd`

cd `dirname $0`
scriptdir=`pwd`
echo "@M: scriptdir: $scriptdir"

cd $workdir

echo "@M: workdir: $workdir"

BowtieOptFile=$1
if [ ! -f $BowtieOptFile ]; then
    echo "error no $BowtieOptFile"
    exit
fi


puncsamfile=${scriptdir}/puncsamfile.sh
if [ ! -f ${puncsamfile} ]; then
    echo "@M: ${puncsamfile} not exist!"
    exit
fi

mapandfiltersh=${scriptdir}/gomapandfilter.sh
if [ ! -f $mapandfiltersh ]; then
    echo "@M: $mapandfiltersh not exist"
    exit
fi

HighCovTag=$2

mergepair=${scriptdir}/gomerge.sh
if [ ! -f $mergepair ]; then
    echo "@M: $mergepair not exist"
    exit
fi

HighCovSuc=0
if [ $HighCovTag == 1 ]; then
    echo "@M: HighCovTag=1"
    ABySSdir=${workdir}/ABySS.d
    if [ ! -d ${ABySSdir} ]; then
        echo "@M: $ABySSdir not exist!"
        exit
    fi
    IDBAhighdir=${workdir}/IDBA_UD_high.d
    if [ ! -d $IDBAhighdir ]; then
        echo "@M: $IDBAhighdir not exist!"
        exit
    fi

    ABySSCtg=${ABySSdir}/abyss.flt.fa
    IDBAhighCtg=${IDBAhighdir}/idba.flt.fa
    ABySSsam=`bash ${puncsamfile} ${ABySSdir}`
    IDBAhighsam=`bash ${puncsamfile} ${IDBAhighdir}`

    AssHigh=1
    if [ ! -f ${ABySSCtg} ]; then
        echo "@M: $ABySSCtg not exist"
        AssHigh=0
    fi
    if [ ! -f $IDBAhighCtg ]; then
        echo "@M: $IDBAhighCtg not exist"
        AssHigh=0
    fi
    if [ $AssHigh == 1 ]; then
        if [ ! -d merge-IDBAcor-ABySS ]; then
            mkdir merge-IDBAcor-ABySS
        fi
        cd merge-IDBAcor-ABySS
        if [ ! -f HighCov.ctg.fa ]; then
            ln -s ${ABySSCtg} abyss.ctg.fa
            ln -s ${IDBAhighCtg} idba.ctg.fa
            echo "@M:gomerge IDBAhigh ABySS"
            echo "-r 0" > MergeOptFile
            echo "@M: bash $mergepair $scriptdir MergeOptFile idba abyss 1 1 $IDBAhighsam $ABySSsam"
            bash $mergepair $scriptdir MergeOptFile idba abyss 1 1 $IDBAhighsam $ABySSsam
            mergefa=out.fa
            if [ -f $mergefa ]; then
                echo "@M: merge successfully!"
                HighCovSuc=1

                #map read to out.fa
                mv $mergefa HighCov.ctg.fa
                Readfile=${workdir}/cor_read_file
                if [ ! -f $Readfile ]; then
                    ehco "@M: $Readfile not exist"
                    exit
                fi

           #     echo "--no-head --phred64" > BowtieOptFile
            

                echo "@M: map reads to HighCov"
                bash $mapandfiltersh HighCov $Readfile $BowtieOptFile 0

            fi
        else
            echo "@M: HighCov.ctg.fa exist"
            HighCovSuc=1
        fi
    fi

fi

cd $workdir

#Merge CABOG and IDBA
LowCovSuc=0
echo "@M: merge CABOG and IDBA"
CABOGdir=${workdir}/CABOG.d
if [ ! -d ${CABOGdir} ]; then
    echo "@M: $CABOGdir not exist!"
    exit
fi
IDBAdir=${workdir}/IDBA_UD_low.d
if [ ! -d ${IDBAdir} ]; then
    echo "@M: $IDBAdir not exist!"
    exit
fi

CABOGCtg=${CABOGdir}/cabog.ctg.fa
if [ $HighCovTag == 1 ]; then
    IDBACtg=${IDBAdir}/idba.flt.fa
else
    IDBACtg=${IDBAdir}/idba.ctg.fa
fi
CABOGsam=`bash ${puncsamfile} ${CABOGdir}`
IDBAsam=`bash ${puncsamfile} ${IDBAdir}`
if [ ! -f $CABOGCtg ]; then
    echo "@M: $CABOGCtg not exist"
    exit
fi
if [ ! -f $IDBACtg ]; then
    echo "@M: $IDBACtg not exist"
    exit
fi
if [ ! -d merge-IDBA-CABOG ]; then
    mkdir merge-IDBA-CABOG
fi
cd merge-IDBA-CABOG
if [ ! -f LowCov.ctg.fa ]; then
    ln -s $CABOGCtg cabog.ctg.fa
    ln -s $IDBACtg idba.ctg.fa
    echo "@M: gomerge idba cabog"
    echo "-r 1" > MergeOptFile
    echo "@M: bash $mergepair $scriptdir MergeOptFile idba cabog 1 1 $IDBAsam $CABOGsam"
    bash $mergepair $scriptdir MergeOptFile idba cabog 1 1 $IDBAsam $CABOGsam
    mergefa=out.fa
    if [ -f $mergefa ]; then
        echo "@M: merge successfully"
        LowCovSuc=1
        #map read to out.fa
        mv $mergefa LowCov.ctg.fa
        Readfile=${workdir}/tot_read_file
        if [ ! -f $Readfile ]; then
            echo "@M: $Readfile not exist!"
            exit
        fi
    #    echo "--no-head --phred64" > BowtieOptFile
    #    ln -s $BowtieOptFile .
        echo "@M: map reads to LowCov"
        bash $mapandfiltersh LowCov $Readfile $BowtieOptFile 0
    fi
else
    echo "@M: LowCov.ctg.fa exist"
    LowCovSuc=1
fi

cd $workdir
Tsuc=0
if [ $HighCovSuc -eq 1 -a $LowCovSuc -eq 1 ]; then
    echo "@M: merge HighCov and LowCov"
    LowCovdir=${workdir}/merge-IDBA-CABOG
    if [ ! -d ${LowCovdir} ]; then
        echo "@M: $LowCovdir not exist!"
        exit
    fi
    HighCovdir=${workdir}/merge-IDBAcor-ABySS
    if [ ! -d ${HighCovdir} ]; then
        echo "@M: $HighCovdir not exist"
        exit
    fi
    LowCovCtg=${LowCovdir}/LowCov.ctg.fa
    HighCovCtg=${HighCovdir}/HighCov.ctg.fa
    LowCovsam=`bash ${puncsamfile} ${LowCovdir}`
    HighCovsam=`bash ${puncsamfile} ${HighCovdir}`
    if [ ! -f $LowCovCtg ]; then
        echo "@M: $LowCovCtg not exist"
        exit
    fi
    if [ ! -f $HighCovCtg ]; then
        echo "@M: $HighCovCtg not exist"
        exit
    fi

    mkdir merge-HighCov-LowCov
    cd merge-HighCov-LowCov
    ln -s $LowCovCtg lowcov.ctg.fa
    ln -s $HighCovCtg highcov.ctg.fa
    echo "@M: gomerge highcov lowcov"
    echo "-r 1" > MergeOptFile
    echo "@M: bash $mergepair $scriptdir MergeOptFile highcov lowcov 1 1 $HighCovsam $LowCovsam"
    bash $mergepair $scriptdir MergeOptFile highcov lowcov 1 1 $HighCovsam $LowCovsam

    mergefa=out.fa
    if [ -f $mergefa ]; then
        echo "@M: merge successfully"
        TSuc=1
        
    fi
fi

cd $workdir

if [ $TSuc == 1 ]; then
    cp merge-HighCov-LowCov/out.fa out.fa
    echo "@M: output out.fa from merge-HighCov-LowCov"
elif [ $LowCovSuc == 1 ]; then
    cp merge-IDBA-CABOG/LowCov.ctg.fa out.fa
    echo "@M: output out.fa from merge-IDBA-CABOG"
fi

exit


