#!/usr/bin/env python

import sys
import os
from string import *

if len(sys.argv) == 1:
    print 'runabyss.py parafile readfile'

parafile = sys.argv[1]
if not os.path.isfile( parafile ):
    print 'error parafile for runabyss', parafile, 'not found'
    exit()
abyssparaf = file( parafile )
abysspar = abyssparaf.readline()
if abysspar[-1] == '\n':
    abysspar = abysspar[:-1]
abyssparaf.close()
try:
    f = file(sys.argv[2])
except:
    print '\nerror when read in read file', sys.argv[2]
    exit()

pairreads_ve = []
while True:
    line = f.readline()
    if len(line) == 0:
        break
    s = split( line )
    if len(s) == 2:
        pairreads = []
        for i in s:
            if len( os.path.split(i)[0]) == 0:
                r = os.getcwd() + os.path.sep +i
                pairreads.append(r)
            else:
                pairreads.append(i)
        pairreads_ve.append( pairreads)
        del pairreads
f.close()

scriptdir = os.path.dirname(os.path.abspath(sys.argv[0]))

if not os.path.isdir( 'ABySS.d' ):
    os.mkdir('ABySS.d')
os.chdir('ABySS.d')

if len(pairreads_ve) == 0:
    print 'no paired end reads, cancel running abyss'
    exit()

if len(pairreads_ve) == 1:
    readp = ' '.join(pairreads_ve[0])
    readpj = '"'.join( ['in=', readp, ''] )
    cmmd = ' '.join(['abyss-pe name=abyss', abysspar, readpj ])
    print cmmd
    os.system( cmmd )
else:
    id = 0
    libname = []
    libreadj = []
    for p in pairreads_ve:
        id = id + 1
        libname.append('lib'+str(id))
        libreadj.append('lib'+str(id)+'="'+' '.join(p)+'"')
    libnamej = 'iib="'+' '.join(libname)+'"'
    libreadj_j = ' '.join(libreadj)
    readpj = ' '.join([libnamej, libreadj_j])
    cmmd = ' '.join(['abyss-pe name=abyss', abysspar, readpj])
    print cmmd
    os.system(cmmd)

scftoctg = scriptdir+os.path.sep+'SCFtoCTG'
if not os.path.exists(scftoctg):
    print 'error not find scftoctg', scftoctg
    exit()
cmmd = ' '.join([scftoctg, 'abyss-contigs.fa', 'abyss.scf.ctg.fa'])
print cmmd
os.system(cmmd)

fastatrans = scriptdir + os.path.sep+'fastatrans'
if not os.path.exists(fastatrans):
    print 'error no fastatrans', fastatrans
    exit()

cmmd = ' '.join([fastatrans, 'abyss.scf.ctg.fa', '200', 'abyss.ctg.fa' ])
print cmmd
os.system(cmmd)

os.chdir('..')

