#!/usr/bin/env python

import sys
import os
from string import *

if len(sys.argv) == 1:
    print 'Usage: runcabog.py parafile readfile [libraryinfofile]'
    exit()
parafile = sys.argv[1]
if not os.path.isfile( parafile ):
    print 'error parafile for runcabog', parafile, 'not found'
    exit()
parafile = os.path.abspath(parafile)
print parafile

try: 
    f = file( sys.argv[2] )
except:
    print '\nerror when read in read file', sys.argv[2]
    exit()

pairreads_ve = []
singlereads_ve = []

while True:
    line = f.readline()
    if len( line ) == 0:
        break
    s = split( line )
    if len(s) == 2:
        pairreads = []
        for i in s:
            if len( os.path.split(i)[0]) == 0:
                r = os.getcwd() + os.path.sep + i
                pairreads.append( r) 
            else:
                pairreads.append(i)
        pairreads_ve.append( pairreads )
        del pairreads
    elif len(s) == 1:
        for i in s:
            if len( os.path.split(i)[0]) == 0:
                r = os.getcwd() + os.path.sep+ i
                singlereads_ve.append(r)
            else:
                singlereads_ve.append(i)
f.close()

libraryinfo = []
if len( sys.argv ) == 4:
    try:
        f = file( sys.argv[3] )
    except:
        print 'error when open insertsize file', sys.argv[2]
        exit()
    while True:
        line = f.readline()
        if len( line ) == 0:
            break
        if line[-1] == '\n':
            line = line[:-1]
        libraryinfo.append(line)
f.close()

scriptdir = os.path.dirname( os.path.abspath( sys.argv[0] ) )
extractread = scriptdir+os.path.sep+'extract_fastqread'
if not os.path.isfile(extractread ):
    print 'error no extract_fastqread', extractread
    exit()
fltpairreads_ve = []
fltsinglereads_ve = []
SreadFile = os.getcwd()+os.path.sep+'IDBA_UD_low.d/idba.sread'
if not os.path.isfile(SreadFile):
    print 'error no find', SreadFile
    exit()

if not os.path.isdir('CABOG.d'):
    os.mkdir('CABOG.d')

os.chdir('CABOG.d')
id = 0
for p in pairreads_ve:
    id = id + 1
    jp = ' '.join(['-1', p[0], '-2', p[1]])
    sp = ' '.join(['-r', SreadFile])
    cmmd = ' '.join([ extractread, sp, jp, '-o forCABOG_p'+str(id) ])
    print cmmd
    os.system(cmmd)
    fltpairreads_ve.append(['forCABOG_p'+str(id)+'_1.fastq', 'forCABOG_p'+str(id)+'_2.fastq'])

sid = 0
for g in singlereads_ve:
    sid = sid + 1
    js = ' '.join(['-s', g])
    ss = ' '.join(['-r', SreadFile])
    cmmd = ' '.join([extractread, ss, js, '-o forCABOG_s'+str(sid)])
    print cmmd
    os.system(cmmd)
    fltsinglereads_ve.append('forCABOG_s'+str(sid)+'.fastq')

#############
# run cabog
#############
id = 0
for p in fltpairreads_ve:
    id = id + 1
    libi = ''
    if len(libraryinfo) >= id:
        libi = libraryinfo[id-1]
    else:
        libi = '-insertsize 400 40 '+'-libraryname p'+str(id)
    mates = ','.join(p)
    cmmd = ' '.join(['fastqToCA', libi, '-mates', mates, '>', 'forCABOG_p'+str(id)+'.frg' ])
    print cmmd
    os.system( cmmd )
sid = 0
for g in fltsinglereads_ve:
    sid = sid + 1
    id = id + 1
    libi = ''
    if len(libraryinfo) >= id:
        libi = libraryinfo[id-1]
    else:
        libi = '-libraryname s'+str(sid)
    cmmd = ' '.join(['fastqToCA', libi, '-reads', g, '>', 'forCABOG_s'+str(sid)+'.frg'])
    print cmmd
    os.system( cmmd )

cmmd = ' '.join(['runCA -d . -p cabog -s', parafile, '*.frg' ])
print cmmd
os.system(cmmd)

fastatrans = scriptdir+os.path.sep+'fastatrans'
if not os.path.exists(fastatrans):
    print 'error no', fastatrans, 'found'
    exit()
if os.path.exists('10-toggledAsm/9-terminator/cabog.ctg.fasta'):
    cmmd = ' '.join([fastatrans, '10-toggledAsm/9-terminator/cabog.deg.fasta', '200', 'cabog.deg-200bp.fa'])
    print cmmd
    os.system(cmmd)
    cmmd = 'cat 10-toggledAsm/9-terminator/cabog.ctg.fasta cabog.deg-200bp.fa > cabog.ctg.fa'
    print cmmd
    os.system(cmmd)
elif os.path.exists('9-terminator/cabog.ctg.fasta'):
    cmmd = ' '.join([fastatrans, '9-terminator/cabog.deg.fasta', '200', 'cabog.deg-200bp.fa'])
    print cmmd
    os.system(cmmd)
    cmmd = 'cat 9-terminator/cabog.ctg.fasta cabog.deg-200bp.fa > cabog.ctg.fa'
    print cmmd
    os.system(cmmd)
else:
    print 'cabog failed'
    exit() 
os.chdir('..')


