#!/usr/bin/env python

import sys
import os
from string import *

scriptdir = os.path.dirname(sys.argv[0])

if len( sys.argv ) != 3:
    print 'Usage errcor.py readfile quakeparafile'
    exit()

try:
    f = file( sys.argv[1] )
except:
    print '\nerror when read in readfile'
    exit

runquake = scriptdir+os.path.sep+'runquake.py'
if not os.path.isfile( runquake ):
    print "error no runquake.py"
    exit()
runrfh = scriptdir+os.path.sep+'runrfh.py'
if not os.path.isfile( runrfh ):
    print "error no runrfh.py"
    exit()

pairreads_ve = []
singlereads_ve = []
while True:
    line = f.readline()
    if len( line ) == 0:
        break
    s = split(line)
    if len(s) == 2:
        pairreads = []
        for i in s:
            if not os.path.exists(i):
                print i, 'not found'
                exit()
            if len( os.path.split(i)[0] ) == 0:
                r = os.getcwd() + os.path.sep + i
                pairreads.append(r)
            else:
                pairreads.append(i)

        pairreads_ve.append( pairreads )
        del pairreads
    elif len(s) == 1:
        for i in s:
            if not os.path.exists(i):
                print i, 'not found'
                exit()
            if len( os.path.split(i)[0]) == 0:
                r = os.getcwd() + os.path.sep + i
                singlereads_ve.append(r)
            else:
                singlereads_ve.append(i)
f.close()

if not os.path.isfile( sys.argv[2] ):
    print 'error', sys.argv[2], 'not found'
    exit()

#############################
# run quake

print 'run quake'
if not os.path.isdir('cor_read_set'):
    os.mkdir('cor_read_set')
if not os.path.isdir("tot_read_set"):
    os.mkdir('tot_read_set')

cor_read_file = open('cor_read_file', 'w')
tot_read_file = open('tot_read_file', 'w')

id = 0
for p in pairreads_ve:
    id = id + 1
    prds = []
    p1 = p[0]
    p2 = p[1]
    bp1 = os.path.basename(p1)
    bp2 = os.path.basename(p2)
    if not os.path.exists( bp1 ):
        cmmd = ' '.join(['ln -s', p1, '.'])
        os.system( cmmd )
    if not os.path.exists( bp2 ):
        cmmd = ' '.join(['ln -s', p2, '.'])
        os.system( cmmd )
    rdf = file('pair_read_file_'+str(id), 'w' )
    rdf.write( ' '.join([bp1, bp2]))
    rdf.close()
    
    cmmd = ' '.join([ 'python', runquake, sys.argv[2], ' '.join([bp1,bp2]) ])
    print cmmd
    os.system(cmmd)

    ####################################
    # merge reads
    bp1_pref = bp1[:bp1.rfind('.')]
    bp2_pref = bp2[:bp2.rfind('.')]
    bp1_cor = bp1_pref + '.cor.fastq'
    bp2_cor = bp2_pref + '.cor.fastq'
    if not os.path.exists( bp1_cor ):
        print 'error no', bp1_cor
        exit()
    if not os.path.exists( bp2_cor ):
        print 'error no', bp2_cor
        exit()
    cmmd = ' '.join(['cat', bp1_pref+'.cor.fastq', bp1_pref+'.cor_single.fastq',
        bp1_pref+'.err_single.fastq', bp1_pref+'.err.fastq', '>', bp1_pref+".tot.fastq"])
    print cmmd
    os.system( cmmd )

    cmmd = ' '.join(['cat', bp2_pref+'.cor.fastq', bp2_pref+'.err_single.fastq',
        bp2_pref+'.cor_single.fastq', bp2_pref+'.err.fastq', '>', bp2_pref+'.tot.fastq'])
    print cmmd
    os.system( cmmd )



    bp1_tot = bp1_pref + '.tot.fastq'
    bp2_tot = bp2_pref + '.tot.fastq'
    if not os.path.exists( bp1_tot ):
        print 'error no', bp1_tot
        exit()
    if not os.path.exists( bp2_tot ):
        print 'error no', bp2_tot
        exit()

    corfile = file('corfile', 'w')
    corfile.write( ' '.join([bp1_cor, bp2_cor]))
    corfile.close()
    #cmmd = 'python runrfh.py corfile'
    cmmd = ' '.join(['python', runrfh, 'corfile' ])
    print cmmd
    os.system( cmmd )
    os.remove( 'corfile')

    totfile = file('totfile', 'w')
    totfile.write( ' '.join([bp1_tot, bp2_tot]) )
    totfile.close()
    #cmmd = 'python runrfh.py totfile'
    cmmd = ' '.join(['python', runrfh, 'totfile'])
    print cmmd
    os.system(cmmd)
    os.remove( 'totfile' )
    
    bp1_cor_rfh = bp1_pref+".cor_rfh.fastq"
    bp2_cor_rfh = bp2_pref+'.cor_rfh.fastq'
    bp1_tot_rfh = bp1_pref+'.tot_rfh.fastq'
    bp2_tot_rfh = bp2_pref+'.tot_rfh.fastq'
    
    bp1_cor_tgt = os.path.join( os.getcwd()+os.path.sep+'cor_read_set', bp1_pref+'.cor.fastq')
    open( bp1_cor_tgt, 'wb' ).write(open(bp1_cor_rfh, 'rb').read() )
    bp2_cor_tgt = os.path.join(os.getcwd()+os.path.sep+'cor_read_set', bp2_pref+'.cor.fastq')
    open( bp2_cor_tgt, 'wb' ).write(open(bp2_cor_rfh, 'rb').read() )
    bp1_tot_tgt = os.path.join( os.getcwd()+os.path.sep+'tot_read_set', bp1_pref+'.tot.fastq')
    open( bp1_tot_tgt, 'wb' ).write(open(bp1_tot_rfh, 'rb').read() )
    bp2_tot_tgt = os.path.join(os.getcwd()+os.path.sep+'tot_read_set', bp2_pref+'.tot.fastq')
    open( bp2_tot_tgt, 'wb' ).write(open(bp2_tot_rfh, 'rb').read() )
    
    cor_read_file.write( ' '.join([bp1_cor_tgt, bp2_cor_tgt]) )
    cor_read_file.write('\n')
    tot_read_file.write( ' '.join([bp1_tot_tgt, bp2_tot_tgt]) )
    tot_read_file.write('\n')

    cmmd = ' '.join(['rm -f', bp1_pref+'.cor.fastq', bp1_pref+'.cor_single.fastq', bp1_pref+'.err_single.fastq', bp1_pref+'.err.fastq'])
    print cmmd
    os.system(cmmd)
    cmmd = ' '.join(['rm -f', bp2_pref+'.cor.fastq', bp2_pref+'err_single.fastq', bp2_pref+'.cor.single.fastq', bp2_pref+'.err.fastq'])
    print cmmd
    os.system(cmmd)

cor_read_file.close()
tot_read_file.close()



        

