#!/usr/bin/env python

import sys
import os
from string import *

scriptdir = os.path.dirname(os.path.abspath(sys.argv[0]))
if len( sys.argv ) != 4:
    print 'Usage: runidba.py parafile readfile outputpathdir'
    exit()
try:
    f = file( sys.argv[2])
except:
    print '\nerror when read in readfile', sys.argv[1]
    exit()

pairreads_ve = []
singlereads_ve = []

while True:
    line = f.readline()
    if len(line) == 0:
        break
    s = split(line)
    if len (s) == 2:
        pairreads = []
        for i in s:
            pairreads.append(i)
        pairreads_ve.append( pairreads )
        del pairreads
    elif len(s) == 1:
        for i in s:
            if not os.path.exists(i):
                print i, 'not found'
                exit()
            singlereads_ve.append(i)
f.close()

idbaparaf = file( sys.argv[1] )
idbapar = idbaparaf.readline()
if idbapar[-1] == '\n':
    idbapar = idbapar[:-1]
idbaparaf.close()

if not os.path.isdir( sys.argv[3]):
    os.mkdir( sys.argv[3] )
DIR = sys.argv[3]
os.chdir(DIR)

mergefastq = scriptdir+os.path.sep+'mergefastq-p'
if not os.path.exists(mergefastq):
    print 'error no mergefastq-p', mergefastq
    exit()

fastqtofasta = scriptdir+os.path.sep+'fastqtofasta'
if not os.path.exists(fastqtofasta):
    print 'error no fastqtofasta', fastqtofasta
    exit()

id = 0
pairfa_ve = []
preads = ''
for p in pairreads_ve:
    id = id + 1
    jp = ' '.join(p)
    cmmd = ' '.join([mergefastq, jp, 'idba-p'+str(id)] )
    print cmmd
    os.system(cmmd)
    fq = 'idba-p'+str(id)+'.fastq'
    fa = 'idba-p'+str(id)+'.fasta'
    cmmd = ' '.join([fastqtofasta, fq, fa])
    print cmmd
    os.system(cmmd)
    pairfa_ve.append( fa )
    if id == 1:
        preads = '-r '+fa
    else:
        preads = preads + " --read_level_"+str(id)+' '+fa
sid = 0
sreads = ''
singlefa_ve = []
for p in singlereads_ve:
    sid = sid + 1
    fa = 'idba-s' + str(sid)+'.fasta'
    cmmd = ' '.join([fastqtofasta, p, fa ])
    print cmmd
    os.system( cmmd )
    singlefa_ve.append( fa )
    if sid == 1:
        sreads = '-l '+fa

cmmd = ' '.join([ 'idba_ud', preads, sreads, idbapar ])
print cmmd
os.system(cmmd)

scftoctg = scriptdir+os.path.sep+'SCFtoCTG'
if not os.path.exists(scftoctg):
    print 'error no scftoctg', scftoctg
    exit()

ctgfile = 'idba.ctg.fa'
if id == 0:
    os.rename( 'out/contig.fa', 'idba.ctg.fa' )
elif id == 1:
    cmmd = ' '.join([scftoctg, 'out/scaffold.fa', 'idba.ctg.fa'])
    print cmmd
    os.system( cmmd )
else:
    scf = 'out/scaffold-level-'+str(id)+'.fa'
    cmmd = ' '.join([scftoctg, scf, ctgfile ])
    print cmmd
    os.system( cmmd )
exit()



