#include <map>
#include <set>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>
#include <sstream>
#include <list>
#include <cstdlib>
using namespace std;

class mapping_on_contig
{
public:
	int start_pos;
	int end_pos;
	string rid;
	int lib;
};

class Contig
{
public:
	string name;
	int length;
	string seq;
	double cov;
	double gc;
};

double calculategc( string &seq )
{
	if ( seq.empty() )
		return 0;
	int c = 0;
	for ( size_t i = 0; i < seq.size(); ++i )
	{
		if ( seq[i] == 'c' || seq[i] == 'C' || seq[i] == 'g' || seq[i] == 'G' )
			c += 1;
	}
	int t = (int)seq.size();
	return (double)c / t;
}

void readinbowtieout( string & file, map< string, vector<mapping_on_contig > > &maps, double minq )
{
	ifstream inf( file.data() );
	if ( !inf.good() )
	{
		cout<<"error can not open file "<<file<<endl; exit(1);
	}

	while ( !inf.eof() )
	{
		string line;
		getline( inf, line );
		if ( line.empty() )
			break;
		
		string rid = "";
		string ctgid = "";
		string score = "";
		string seq = "";
		string pos = "";
		string s = "";
		
		int c = 0;
		bool stat_on = false;
		for ( size_t i = 0; i < line.size(); ++i )
		{
			if ( stat_on )
			{
				if ( line[i] == ' ' || line[i] == '\t' )
				{
					c+=1; 
					if ( c == 1 )
					{
						rid = s;
						s = "";
					} else if ( c == 2 )
					{
						score = s;
						s = "";
					} else if ( c == 3 )
					{
						ctgid = s;
						s = "";
					} else if ( c == 4 )
					{
						pos = s;
						s = "";
					} else if ( c == 10 )
					{
						seq = s;
						s = "";
						break;
					}
						

					stat_on = false;

				} else
				{
					s += line[i];
				}
			} else
			{
				if ( line[i] != ' ' || line[i] == '\t' )
				{
					s += line[i];
					stat_on = true;
				} 
			}
			
		}

		// alignment quality score filter
		bool qual = true;
		double scq = 0;
		if ( line.find( "AS:i:" ) != line.npos )
		{
			string subl = line.substr( line.find("AS:i:") );
			string sc = "";
			for ( size_t g = 0; g < subl.size(); ++g )
			{
				if ( subl[g] == ' ' || subl[g] == '\t' )
					break;
				sc += subl[g];
			}
			sc = sc.substr( 5 );
			scq = atof( sc.c_str() );
			if ( scq > 0 )
			{
				cout<<"Error align score: "<<scq<<", "<<sc<<", "<<subl<<", "<<line<<endl; exit(1);
			}
			
		}

		if ( scq >= minq )
		{
			if ( ctgid != "*" )
			{
				mapping_on_contig mp;
				mp.rid = rid;
				mp.start_pos = atoi( pos.c_str() );
				int l = (int)seq.size();
				mp.end_pos = mp.start_pos + l - 1;
				maps[ctgid].push_back( mp );
			}
		}
	}
}

void readinbowtieout_pairmode( string & file, map< string, vector<mapping_on_contig > > &maps, double minq, int lib )
{
	ifstream inf( file.data() );
	if ( !inf.good() )
	{
		cout<<"error can not open file "<<file<<endl; exit(1);
	}

	while ( !inf.eof() )
	{
		string line;
		getline( inf, line );
		if ( line.empty() )
			break;
		
		string rid = "";
		string ctgid = "";
		string score = "";
		string seq = "";
		string pos = "";
		string s = "";
		string matealign = "";
		int c = 0;
		bool stat_on = false;
		for ( size_t i = 0; i < line.size(); ++i )
		{
			if ( stat_on )
			{
				if ( line[i] == ' ' || line[i] == '\t' )
				{
					c+=1; 
					if ( c == 1 )
					{
						rid = s;
						s = "";
					} else if ( c == 2 )
					{
						score = s;
						s = "";
					} else if ( c == 3 )
					{
						ctgid = s;
						s = "";
					} else if ( c == 4 )
					{
						pos = s;
						s = "";
					} else if ( c == 5 )
					{
						s = "";
					} else if ( c == 6 )
					{
						s = "";
					} else if ( c == 7 )
					{
						matealign = s;
						s = "";
					} else if ( c == 8 )
					{
						s = "";
					} else if ( c == 9 )
					{
						s = "";
					} else if ( c == 10 )
					{
						seq = s;
						s = "";
						break;
					}
						

					stat_on = false;

				} else
				{
					s += line[i];
				}
			} else
			{
				if ( line[i] != ' ' || line[i] == '\t' )
				{
					s += line[i];
					stat_on = true;
				} 
			}
			
		}

		

		// alignment quality score filter
		
		double scq = 0;
		if ( line.find( "AS:i:" ) != line.npos )
		{
			string subl = line.substr( line.find("AS:i:") );
			string sc = "";
			for ( size_t g = 0; g < subl.size(); ++g )
			{
				if ( subl[g] == ' ' || subl[g] == '\t' )
					break;
				sc += subl[g];
			}
			sc = sc.substr( 5 );
			scq = atof( sc.c_str() );
			if ( scq > 0 )
			{
				cout<<"Error align score: "<<scq<<", "<<sc<<", "<<subl<<", "<<line<<endl; exit(1);
			}
			
		}
		double matescq = 0;
		if ( line.find( "YS:i:" ) != line.npos )
		{
			string subl = line.substr( line.find("YS:i:") );
			string sc = "";
			for ( size_t g = 0; g < subl.size(); ++g )
			{
				if ( subl[g] == ' ' || subl[g] == '\t' )
					break;
				sc += subl[g];
			}
			sc = sc.substr( 5 );
			matescq = atof( sc.c_str() );
			if ( matescq > 0 )
			{
				cout<<"Error align score: "<<matescq<<", "<<sc<<", "<<subl<<", "<<line<<endl; exit(1);
			}
			
		}

		if ( scq >= minq && matescq >= minq )
		{
			if ( ctgid != "*" )
			{
				mapping_on_contig mp;
				mp.lib = lib;
				mp.rid = rid;
				mp.start_pos = atoi( pos.c_str() );
				int l = (int)seq.size();
				mp.end_pos = mp.start_pos + l - 1;
				maps[ctgid].push_back( mp );
			}
		}
	}
}

void GetContigFromFile( string filename, vector<Contig> &ctg_ve )
{

	
	ifstream inf ( filename.data() );
	if ( !inf.good() ) {
		cout<<"could not open file "<<filename<<endl;  exit(1);
	}
	string line;
	
	string id;
	getline( inf, line );

	while(!inf.eof()){
		id = line.substr(1);
		getline( inf,line );
		string seq;
		while ( line.find(">") == std::string::npos )              
		{
			
			seq+=line;

			if ( inf.eof() )
				break;
			getline( inf, line);
			
		}

		Contig ctg;
		ctg.name = id;
	//	ctg.seq = seq;
		ctg.length = (int)seq.size();
		ctg.gc = calculategc( seq );
		ctg_ve.push_back( ctg );
		
		


	}



	inf.close();

}

void CalculateCov( vector<Contig > &ctg_ve, map< string, vector<mapping_on_contig > > &maps )
{
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		string ctgid = ctg_ve[i].name;
		if ( maps.find( ctgid ) != maps.end() )
		{
			int st = ctg_ve[i].length;
			int ed = 0;
			long sum = 0;
			for ( size_t j = 0; j < maps[ctgid].size(); ++j )
			{
				if ( maps[ctgid][j].start_pos < st )
					st = maps[ctgid][j].start_pos;
				if ( maps[ctgid][j].end_pos > ed )
					ed = maps[ctgid][j].end_pos;
				sum += ( maps[ctgid][j].end_pos - maps[ctgid][j].start_pos + 1 );
			}
			int r = ed - st;
			double cov = 0;
			if ( r > 0 )
			{
			
				cov = sum * 1.0 / r ;
			}
			ctg_ve[i].cov = cov;
		} else
			ctg_ve[i].cov = 0;
	}
}

void FilterCtg( double lowerb, double upperb, vector< Contig > &ctg_ve, string &file,  string& ctgfile )
{

	string detfile = file +".det";
	ofstream detf( detfile.data() );
	
	set< string > fltctg;
	set< string > lowcovctg;
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		detf<<ctg_ve[i].name<<","<<ctg_ve[i].length<<","<<ctg_ve[i].cov<<endl;
		if ( ctg_ve[i].cov >= lowerb && ctg_ve[i].cov <= upperb )
		{
			fltctg.insert( ctg_ve[i].name );
			
		} else if ( ctg_ve[i].cov < lowerb )
			lowcovctg.insert( ctg_ve[i].name );
	}

	int l = (int)lowerb;
	int u = (int)upperb;
	ostringstream lost, uost;
	lost << l;
	string ls = lost.str();
	uost << u;
	string us = uost.str();

	string routf = file + ".flt.fa";	

	ifstream inf( ctgfile.data() );
	ofstream outf( routf.data() );

	string line;
	string seq;
	string id;
	getline( inf, line );

	while(!inf.eof())
	{
		id = line.substr(1);
		bool flt = false;
		if ( fltctg.find( id ) != fltctg.end() )
			flt = true;

		if ( flt )
			outf<<line<<endl;

		getline( inf,line );

		while ( line.find(">") == std::string::npos )              
		{
			if ( flt )
				outf<<line<<endl;
			if ( inf.eof() )
				break;
			getline( inf, line);
		}
	}

	inf.close();
	outf.close();

	if ( !lowcovctg.empty() )
	{
		string routf2 = file + "_0" + "x_" + ls + "x.fa";	

		ifstream inf2( ctgfile.data() );
		ofstream outf2( routf2.data() );
		getline( inf2, line );

		while(!inf2.eof())
		{
			id = line.substr(1);
			bool flt = false;
			if ( lowcovctg.find( id ) != lowcovctg.end() )
				flt = true;

			if ( flt )
				outf2<<line<<endl;

			getline( inf2, line );

			while ( line.find(">") == std::string::npos )              
			{
				if ( flt )
					outf2<<line<<endl;
				if ( inf2.eof() )
					break;
				getline( inf2, line );
			}
		}

		inf2.close();
		outf2.close();
	}
	
}

void Outputmappedread( vector<Contig > &ctg_ve, 
	map< string, vector<mapping_on_contig > > &maps,
	double lowerb, double upperb, string &outfile )
{
	int l = (int)lowerb;
	int u = (int)upperb;
	ostringstream lost, uost;
	lost << l;
	string ls = lost.str();
	uost << u;
	string us = uost.str();

	string routf = outfile + ".sread";	
	ofstream outf( routf.data() );
	if ( lowerb >= upperb )
	{
		outf.close();
		return;
	}
	int alen = 0;
	
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( maps.find( ctg_ve[i].name ) != maps.end() )
		{
			if ( ctg_ve[i].cov >= lowerb && ctg_ve[i].cov <= upperb )
			{
				alen += ctg_ve[i].length;
				for ( size_t j = 0; j < maps[ctg_ve[i].name].size(); ++j )
				{
					
					outf<<maps[ctg_ve[i].name][j].rid<<endl;
				}
			}
		}
	}
	outf.close();
	ofstream lf("FilterCtgLength");
	lf<<alen;
	lf.close();

}

void Outputmappedread( vector<Contig > &ctg_ve, 
	map< string, vector<mapping_on_contig > > &maps,
	double lowerb, double upperb, string &outfile, char suf )
{
	int l = (int)lowerb;
	int u = (int)upperb;
	ostringstream lost, uost;
	lost << l;
	string ls = lost.str();
	uost << u;
	string us = uost.str();

	string routf = outfile  + ".sread";	
	ofstream outf( routf.data() );
	if ( lowerb >= upperb )
	{
		outf.close();
		return;
	}
	int alen = 0;
	int count = 0;
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( maps.find( ctg_ve[i].name ) != maps.end() )
		{
			if ( ctg_ve[i].cov >= lowerb && ctg_ve[i].cov <= upperb )
			{
				count += 1;
			//	cout<<ctg_ve[i].length<<endl;
				alen += ctg_ve[i].length;
				for ( size_t j = 0; j < maps[ctg_ve[i].name].size(); ++j )
				{
					string id = maps[ctg_ve[i].name][j].rid;
					
					if ( (id[id.size()-2] == suf && id[id.size()-1]== '1') || (id[id.size()-2] == suf && id[id.size()-1]== '2') )
					{
						id = id.substr( 0, id.size()-2 ); 
					}
					outf<<id<<endl;
					
				}
			}
		}
	}
	outf.close();
	ofstream lf("FilterCtgLength");
	lf<<alen;
	lf.close();

}


///////////////////////////
// cluster ctgs by cov and gc
class ClusterCore
{
public:
	double gc_mean;
	double cov_mean;
	set< size_t > ctg_set;
	int lenp;
};

void clusterbygc( double peak,
	double up_bottom,
	double down_bottom,
	multimap< double, size_t, greater<double > > &cov_ctg_map,
	vector<Contig > &ctg_ve,
	vector< ClusterCore > &cc_ve,
	set< size_t > &target );

void getfilterctg_refinebound( vector<Contig > &ctg_ve, double lowerb, double upperb, string &fileprefix, double& refined_lowerb, double& refined_upperb,
	double seclowerb, double secupperb,  double& refined_seclowerb, double& refined_secupperb )
{
//	cout<<"ctg cluster coverage lower bound: "<<lowerb<<", upper bound: "<<upperb<<endl;
	multimap< double, size_t, greater<double > > cov_ctg_map;
//	set< size_t > ctgtarget;
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		cov_ctg_map.insert( make_pair( ctg_ve[i].cov, i ) );
	//	ctgtarget.insert( i );

	}

	map<double, int > densitymap; 
	for ( multimap< double, size_t, greater<double > >::reverse_iterator rite = cov_ctg_map.rbegin(); rite != cov_ctg_map.rend(); ++rite )
	{
		int d = (int)rite->first;
		double g;
		if ( rite->first - d >= 0.5 )
			g = d + 0.5;
		else
			g = d;
		int lenp = ctg_ve[rite->second].length / 100;
		if ( densitymap.find( g ) == densitymap.end() )
			densitymap[g] = lenp;
		else
			densitymap[g] += lenp;
	}
	string disfile = fileprefix+".covdensity";
	ofstream oof( disfile.data() );
	for ( map<double, int >::iterator ite = densitymap.begin(); ite != densitymap.end(); ++ite )
	{
		oof<<ite->first<<","<<ite->second<<endl;

	}
	oof.close();  

	int last_m = 0;
	int top_peak = 0;
	double top_peak_cov = 0;
	int added_m = 0;
	set< double > truepeak;
	map< double, double > peak_bottom_map;
	double last_peak;
	bool m_cut = false;
	int deep_bottom = 1000000;
	double deep_bottom_cov = 0;
	bool bottom_open = false;
	double last_true_peak = 0;
	for ( map<double, int >::reverse_iterator rite = densitymap.rbegin(); rite != densitymap.rend(); ++rite )
	{
		if ( rite->first < 5 )
		{
			
			break;
		}
		bool peak = false;
		bool bottom = false;
		map<double, int >::reverse_iterator next_rite = rite;
		++next_rite;
		if ( rite->second > last_m )
		{
			if ( next_rite == densitymap.rend() )
			{
					peak = true;
			} else
			{
				if ( rite->second > next_rite->second  )
				{
					peak = true;
				
				} else if ( rite->second == next_rite->second )
				{
					map<double, int >::reverse_iterator goon_rite = next_rite;
					++goon_rite;
					if ( goon_rite == densitymap.rend() )
						peak = true;
					else
					{
						while ( rite->second >= goon_rite->second )
						{
							if ( rite->second > goon_rite->second )
							{
								peak = true;
								break;
							} else if ( rite->second == goon_rite->second )
							{
								++goon_rite;
								if ( goon_rite == densitymap.rend() )
								{
									peak = true;
									break;
								}
							}
							
						}
					}
				}
			}
		} else if ( rite->second < last_m ) {
			if ( next_rite != densitymap.rend() )
			{
				if ( rite->second < next_rite->second )
					bottom = true;
				else if ( rite->second == next_rite->second )
				{
					map<double, int >::reverse_iterator goon_rite = next_rite;
					++goon_rite;
					if ( goon_rite != densitymap.rend() )
					{
						while ( rite->second <= goon_rite->second )
						{
							if ( rite->second < goon_rite->second )
							{
								bottom = true;
								break;
							} else if ( rite->second == goon_rite->second )
							{
								++goon_rite;
								if ( goon_rite == densitymap.rend() )
									break;
							}
							
						}
					}
				}
			}
		}
		
		added_m += rite->second;
		if ( peak )
		{
			if ( rite->second > 500 )
			{
				//// figure out the bottom after last peak. 
				if ( last_true_peak != 0 )
				{
					if ( deep_bottom != 1000000 )
					{
							
						peak_bottom_map.insert( make_pair( last_true_peak, deep_bottom_cov ) );
					} else
						bottom_open = true;
				} else
					bottom_open = true;
				
				truepeak.insert( rite->first );
			//	cout<<"get peak cov "<<rite->first<<endl;
				last_peak = rite->first;
				m_cut = true;
				top_peak = 0;
				top_peak_cov = 0;
				
				last_true_peak = rite->first;
				deep_bottom_cov = 0;
				deep_bottom = 1000000;
			} else if ( rite->second > top_peak )
			{
				top_peak = rite->second;
				top_peak_cov = rite->first;
			}
		} else if ( bottom )
		{
			if ( truepeak.empty() )
			{
				if ( added_m > 10000 )
				{
					truepeak.insert( top_peak_cov );
				//	cout<<"get peak cov "<<top_peak_cov<<endl;
					last_peak = top_peak_cov;
					peak_bottom_map.insert( make_pair( last_peak, rite->first ) );
					deep_bottom = 1000000;
					deep_bottom_cov = 0;
					added_m = 0;
					m_cut = false;

					last_true_peak = top_peak_cov;
					bottom_open = false;
				}
			} else
			{
				if ( bottom_open )
				{
					if ( rite->second < deep_bottom )
					{
						deep_bottom = rite->second;
						deep_bottom_cov = rite->first;
						added_m = 0;
						m_cut = true;
					}
				}
			}
		}

		last_m = rite->second;
	}

	// merge sub top peak
	set< double > subtoppeak;
	for ( set< double >::iterator ite = truepeak.begin(); ite != truepeak.end(); ++ite )
	{
		if ( densitymap[*ite] >= 4000 )
			continue;
		for ( set< double >::iterator comi = truepeak.begin(); comi != truepeak.end(); ++comi )
		{
			if ( *comi + 5 < *ite )
				continue;
			if ( *comi - 5 > *ite )
				break;
			if ( *ite == *comi )
				continue;
			if ( densitymap[*ite] < densitymap[*comi]  )
			{
				subtoppeak.insert( *ite );
				
				break;
			}
		}
	}
	for ( set<double >::iterator ite = subtoppeak.begin(); ite != subtoppeak.end(); ++ite )
	{
		truepeak.erase( *ite );
		
	}
	for ( map< double, double >::iterator ite = peak_bottom_map.begin(); ite != peak_bottom_map.end(); ++ite  )
	{
		if ( subtoppeak.find( ite->first ) != subtoppeak.end() )
			continue;
		double down_peak = 0;
		map< double, double >::iterator secite = ite;
		while ( secite != peak_bottom_map.end() )
		{
			
			--secite;
			if ( subtoppeak.find( secite->first ) == subtoppeak.end() )
			{
				down_peak = secite->first;
				break;
			}
		}

		for ( set< double >::reverse_iterator si = subtoppeak.rbegin(); si != subtoppeak.rend(); ++si )
		{
			if ( *si <= down_peak )
				break;
			if ( *si < ite->first - 5 )
				break;
			if ( *si < ite->first )
			{
				peak_bottom_map[ite->first] = peak_bottom_map[*si];
			}
		}
	}
	for ( set<double >::iterator ite = subtoppeak.begin(); ite != subtoppeak.end(); ++ite )
	{
		
		peak_bottom_map.erase( *ite ); 
	}
//	for ( map< double, double >::iterator ite = peak_bottom_map.begin(); ite != peak_bottom_map.end(); ++ite  )
//		cout<<"peak_bottom:"<<ite->first<<","<<ite->second<<endl;
	
	refined_upperb = upperb;
	if ( upperb < 100000 )
	{
		for ( set< double >::reverse_iterator rite = truepeak.rbegin(); rite != truepeak.rend(); ++rite )
		{
			if ( *rite > upperb )
				continue;
		
			double up_bottom = cov_ctg_map.begin()->first;
			if ( rite != truepeak.rbegin() )
			{
				set< double >::reverse_iterator sec_rite = rite;
				--sec_rite;
				up_bottom = peak_bottom_map[*sec_rite];
			}
			refined_upperb = up_bottom;
			break;
		}
	}
	refined_lowerb = lowerb;
	if ( lowerb > 0 )
	{
		
		for ( set< double >::iterator ite = truepeak.begin(); ite != truepeak.end(); ++ite )
		{
			if ( *ite < lowerb )
				continue;
			refined_lowerb = peak_bottom_map[*ite];
			break;
		}
	}
//	cout<<"refined upperb: "<<refined_upperb<<", refined lowerb: "<<refined_lowerb<<endl;

	refined_secupperb = secupperb;
	if ( secupperb < 100000 )
	{
		for ( set< double >::reverse_iterator rite = truepeak.rbegin(); rite != truepeak.rend(); ++rite )
		{
			if ( *rite > secupperb )
				continue;
		
			double up_bottom = cov_ctg_map.begin()->first;
			if ( rite != truepeak.rbegin() )
			{
				set< double >::reverse_iterator sec_rite = rite;
				--sec_rite;
				up_bottom = peak_bottom_map[*sec_rite];
			}
			refined_secupperb = up_bottom;
			break;
		}
	}
	refined_seclowerb = seclowerb;
	if ( seclowerb > 0 )
	{
		
		for ( set< double >::iterator ite = truepeak.begin(); ite != truepeak.end(); ++ite )
		{
			if ( *ite < seclowerb )
				continue;
			refined_seclowerb = peak_bottom_map[*ite];
			break;
		}
	}
//	cout<<"refined secupperb: "<<refined_secupperb<<", refined seclowerb: "<<refined_seclowerb<<endl;


}

void clusterctgs( vector<Contig > &ctg_ve, double lowerb, vector< ClusterCore > & CC_ve, set<size_t > &Unclustered, string &fileprefix )
{
//	cout<<"ctg cluster coverage lower bound: "<<lowerb<<endl;
	multimap< double, size_t, greater<double > > cov_ctg_map;
	set< size_t > ctgtarget;
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		cov_ctg_map.insert( make_pair( ctg_ve[i].cov, i ) );
		ctgtarget.insert( i );
	}

	//// test 
	map<double, int > densitymap; 
	for ( multimap< double, size_t, greater<double > >::reverse_iterator rite = cov_ctg_map.rbegin(); rite != cov_ctg_map.rend(); ++rite )
	{
		int d = (int)rite->first;
		double g;
		if ( rite->first - d >= 0.5 )
			g = d + 0.5;
		else
			g = d;
		int lenp = ctg_ve[rite->second].length / 100;
		if ( densitymap.find( g ) == densitymap.end() )
			densitymap[g] = lenp;
		else
			densitymap[g] += lenp;
	}
	string disfile = fileprefix+".covdensity";
	ofstream oof( disfile.data() );
	for ( map<double, int >::iterator ite = densitymap.begin(); ite != densitymap.end(); ++ite )
	{
		oof<<ite->first<<","<<ite->second<<endl;

	}
	oof.close();  
	/////////////////////////////////

	// get peak of the cov
	int last_m = 0;
	int top_peak = 0;
	double top_peak_cov = 0;
	int added_m = 0;
	set< double > truepeak;
	map< double, double > peak_bottom_map;
	double last_peak;
	bool m_cut = false;
	int deep_bottom = 1000000;
	double deep_bottom_cov = 0;
	bool bottom_open = false;
	double last_true_peak = 0;
	for ( map<double, int >::reverse_iterator rite = densitymap.rbegin(); rite != densitymap.rend(); ++rite )
	{
		if ( rite->first < 5 )
		{
			
			break;
		}
		bool peak = false;
		bool bottom = false;
		map<double, int >::reverse_iterator next_rite = rite;
		++next_rite;
		if ( rite->second >= last_m )
		{
			if ( next_rite == densitymap.rend() )
			{
					peak = true;
			} else
			{
				if ( rite->second > next_rite->second  )
				{
					peak = true;
				
				}
			}
		} else {
			if ( next_rite != densitymap.rend() )
			{
				if ( rite->second < next_rite->second )
					bottom = true;
			}
		}
		
		added_m += rite->second;
		if ( peak )
		{
			if ( rite->second > 500 )
			{
				//// figure out the bottom after last peak. 
				if ( last_true_peak != 0 )
				{
					if ( deep_bottom != 1000000 )
					{
						
						peak_bottom_map.insert( make_pair( last_true_peak, deep_bottom_cov ) );
					} else
						bottom_open = true;
				} else
					bottom_open = true;
				
				truepeak.insert( rite->first );
			//	cout<<"get peak cov "<<rite->first<<endl;
				last_peak = rite->first;
				m_cut = true;
				top_peak = 0;
				top_peak_cov = 0;
				
				last_true_peak = rite->first;
				deep_bottom_cov = 0;
				deep_bottom = 1000000;
			} else if ( rite->second > top_peak )
			{
				top_peak = rite->second;
				top_peak_cov = rite->first;
			}
		} else if ( bottom )
		{
			if ( truepeak.empty() )
			{
				if ( added_m > 10000 )
				{
					truepeak.insert( top_peak_cov );
				//	cout<<"get peak cov "<<top_peak_cov<<endl;
					last_peak = top_peak_cov;
					peak_bottom_map.insert( make_pair( last_peak, rite->first ) );
					deep_bottom = 1000000;
					deep_bottom_cov = 0;
					added_m = 0;
					m_cut = false;

					last_true_peak = top_peak_cov;
					bottom_open = false;
				}
			} else
			{
				if ( bottom_open )
				{
					if ( rite->second < deep_bottom )
					{
						deep_bottom = rite->second;
						deep_bottom_cov = rite->first;
						added_m = 0;
						m_cut = true;
					}
				}
			}
		}

		last_m = rite->second;
	}
//	for ( map< double, double >::iterator ite = peak_bottom_map.begin(); ite != peak_bottom_map.end(); ++ite  )
//		cout<<"peak_bottom:"<<ite->first<<","<<ite->second<<endl;
	// merge sub top peak
	set< double > subtoppeak;
	for ( set< double >::iterator ite = truepeak.begin(); ite != truepeak.end(); ++ite )
	{
		if ( densitymap[*ite] >= 4000 )
			continue;
		for ( set< double >::iterator comi = truepeak.begin(); comi != truepeak.end(); ++comi )
		{
			if ( *comi + 5 < *ite )
				continue;
			if ( *comi - 5 > *ite )
				break;
			if ( *ite == *comi )
				continue;
			if ( densitymap[*ite] < densitymap[*comi]  )
			{
				subtoppeak.insert( *ite );
				
				break;
			}
		}
	}
	for ( set<double >::iterator ite = subtoppeak.begin(); ite != subtoppeak.end(); ++ite )
	{
		truepeak.erase( *ite );
		
	}
	for ( map< double, double >::iterator ite = peak_bottom_map.begin(); ite != peak_bottom_map.end(); ++ite  )
	{
		if ( subtoppeak.find( ite->first ) != subtoppeak.end() )
			continue;
		double down_peak = 0;
		map< double, double >::iterator secite = ite;
		while ( secite != peak_bottom_map.end() )
		{
			
			--secite;
			if ( subtoppeak.find( secite->first ) == subtoppeak.end() )
			{
				down_peak = secite->first;
				break;
			}
		}

		for ( set< double >::reverse_iterator si = subtoppeak.rbegin(); si != subtoppeak.rend(); ++si )
		{
			if ( *si <= down_peak )
				break;
			if ( *si < ite->first - 5 )
				break;
			if ( *si < ite->first )
			{
				peak_bottom_map[ite->first] = peak_bottom_map[*si];
			}
		}
	}
	for ( set<double >::iterator ite = subtoppeak.begin(); ite != subtoppeak.end(); ++ite )
	{
		
		peak_bottom_map.erase( *ite ); 
	}
//	for ( map< double, double >::iterator ite = peak_bottom_map.begin(); ite != peak_bottom_map.end(); ++ite  )
//		cout<<"peak_bottom:"<<ite->first<<","<<ite->second<<endl;
	
/*	for ( set<double >::iterator ite = truepeak.begin(); ite != truepeak.end(); ++ite )
	{
		cout<<"truepeak "<<*ite<<endl;
	}*/

	////////////////////////////////////

	////////////////////////////////////
	// cluster by gc
	// get ClusterCore

	for ( set< double >::reverse_iterator rite = truepeak.rbegin(); rite != truepeak.rend(); ++rite )
	{
		if ( *rite < lowerb )
			break;
		vector< ClusterCore > cc_ve;
		double up_bottom = cov_ctg_map.begin()->first;
		if ( rite != truepeak.rbegin() )
		{
			set< double >::reverse_iterator sec_rite = rite;
			--sec_rite;
			up_bottom = peak_bottom_map[*sec_rite];
		}
		clusterbygc( *rite, up_bottom, peak_bottom_map[*rite], cov_ctg_map, ctg_ve, cc_ve, ctgtarget );
		CC_ve.insert( CC_ve.end(), cc_ve.begin(), cc_ve.end() );
		//////
		//erase cc.ctgset from ctgtarget.
		for ( size_t i = 0; i < cc_ve.size(); ++i )
		{
			for ( set< size_t >::iterator ci = cc_ve[i].ctg_set.begin(); ci != cc_ve[i].ctg_set.end(); ++ci )
			{
				ctgtarget.erase( *ci );
			}
		}
	}
	
	double top_peak_below_lowerb = 0;
	for ( set< double >::reverse_iterator rite = truepeak.rbegin(); rite != truepeak.rend(); ++rite )
	{
		if ( *rite >= lowerb )
			continue;
		top_peak_below_lowerb = *rite;
		break;
	}
	if ( top_peak_below_lowerb == 0 )
	{
		cout<<"Top peak below lowerb: None!"<<endl;
	} else
	{
		cout<<"Top peak below lowerb: "<<top_peak_below_lowerb<<endl;
	}

	////////////////////////
	// output
	string ccfile = fileprefix + ".ClusterCtg";
	ofstream ccf( ccfile.data() );
	for ( size_t i = 0; i < CC_ve.size(); ++i )
	{
		ccf<<">Cluster"<<i+1<<endl;
		ccf<<"ctg num:"<<CC_ve[i].ctg_set.size()<<", lenp:"<<CC_ve[i].lenp<<", gc_mean:"<<CC_ve[i].gc_mean<<", cov_mean:"<<CC_ve[i].cov_mean<<endl;
		for( set<size_t>::iterator ci = CC_ve[i].ctg_set.begin(); ci != CC_ve[i].ctg_set.end(); ++ci )
		{
			ccf<<ctg_ve[*ci].name<<","<<ctg_ve[*ci].length<<","<<ctg_ve[*ci].gc<<","<<ctg_ve[*ci].cov<<endl;
		}
	}
	ccf.close();
/*	ofstream ucf( "UnclusteredCtg");
	for ( multimap< double, size_t, greater<double > >::iterator ite = cov_ctg_map.begin(); ite != cov_ctg_map.end(); ++ite )
	{
		if ( ite->first < lowerb )
			break;
		if ( ctgtarget.find( ite->second ) != ctgtarget.end() )
		{
			ucf<<ctg_ve[ite->second].name<<","<<ctg_ve[ite->second].length<<","<<ctg_ve[ite->second].gc<<","<<ctg_ve[ite->second].cov<<endl;
		}
	}
	ucf.close();
*/

	/////////////////////////
	// From the remaining targeted ctg, filter out the ctg with cov < lowb*2 and length < 10000bp.
	double cov_upperb = lowerb * 2;
	int len_upperb = 10000;
/*	if ( top_peak_below_lowerb != 0 )
	{
		cov_upperb = top_peak_below_lowerb * 2;
	}
	*/
	for ( multimap< double, size_t, greater<double > >::iterator ite = cov_ctg_map.begin(); ite != cov_ctg_map.end(); ++ite )
	{
		if ( ite->first < lowerb )
			break;
		if ( ctgtarget.find( ite->second ) != ctgtarget.end() )
		{
			if ( ctg_ve[ite->second].cov >= cov_upperb || ctg_ve[ite->second].length >= len_upperb )
				Unclustered.insert( ite->second );
		}
	}

	string ucfile = fileprefix + ".UnclusteredCtg";
	ofstream ucf2( ucfile.data() );
	for ( set< size_t >::iterator ite = Unclustered.begin(); ite != Unclustered.end(); ++ite )
	{
		ucf2<<ctg_ve[*ite].name<<","<<ctg_ve[*ite].length<<","<<ctg_ve[*ite].gc<<","<<ctg_ve[*ite].cov<<endl;
	}
	ucf2.close();
	/////////////////////////////
}

void calculate_lenweightedmean( set< size_t > &ctgset, vector<Contig > &ctg_ve, double &gc, double &cov, int &len )
{
	double gc_add = 0;
	double cov_add = 0;
	int len_add = 0;
	if ( ctgset.empty() )
		return;
	for ( set< size_t >::iterator ite = ctgset.begin(); ite != ctgset.end(); ++ite )
	{
		int lenp = ctg_ve[*ite].length / 100;
		cov_add += ctg_ve[*ite].cov * lenp;
		gc_add += ctg_ve[*ite].gc * lenp;
		len_add += lenp;
	}
	gc = gc_add / len_add;
	cov = cov_add / len_add;
	len = len_add;
}

void clusterbygc( double peak,
	double up_bottom,
	double down_bottom,
	multimap< double, size_t, greater<double > > &cov_ctg_map,
	vector<Contig > &ctg_ve,
	vector< ClusterCore > &cc_ve,
	set< size_t > &target )
{
//	cout<<"peak "<<peak<<", up_bottom "<<up_bottom<<", down_bottom "<<down_bottom<<endl;
	double peak_lowb = peak;
	double peak_upb = peak+0.5;
	// get cor ctg.
	ClusterCore cc;
	size_t corctg;
	int corlen = 0;
	for ( multimap< double, size_t, greater<double > >::iterator ite = cov_ctg_map.begin(); ite != cov_ctg_map.end(); ++ite )
	{
		if ( ite->first < down_bottom )
			break;
		if ( ite->first >= up_bottom )
			continue;
		if ( ctg_ve[ite->second].length > corlen )
		{
			corlen = ctg_ve[ite->second].length;
			
			corctg = ite->second;
		}
	}
	if ( corlen == 0 )
	{
		cout<<"Unable to get cor ctg. peak="<<peak<<endl; exit(1);
	}
	double cor_gc = ctg_ve[corctg].gc;
	cc.ctg_set.insert( corctg );
	bool cor_remain = false;   //  to get possible another cor
	for ( multimap<double, size_t, greater<double > >::iterator ite = cov_ctg_map.begin(); ite != cov_ctg_map.end(); ++ite )
	{
		if ( ite->first < down_bottom )
			break;
		if ( ite->first >= up_bottom )
			continue;
		if ( target.find( ite->second ) == target.end() )
			continue;
		if ( ctg_ve[ite->second].gc - cor_gc <= 0.03 && ctg_ve[ite->second].gc - cor_gc >= -0.03 )
		{
			cc.ctg_set.insert( ite->second );
		//	cout<<"in "<<ctg_ve[ite->second].name<<","<<ctg_ve[ite->second].length<<","<<ctg_ve[ite->second].gc<<","<<ctg_ve[ite->second].cov<<endl;
		} else
		{
		//	cout<<"out "<<ctg_ve[ite->second].name<<","<<ctg_ve[ite->second].length<<","<<ctg_ve[ite->second].gc<<","<<ctg_ve[ite->second].cov<<endl;
			int l = ctg_ve[ite->second].length / 100;
			if ( l > 100 )
				cor_remain = true;
		}
	}
	
	calculate_lenweightedmean( cc.ctg_set, ctg_ve, cc.gc_mean, cc.cov_mean, cc.lenp );
//	cout<<"cc gc_mean "<<cc.gc_mean<<" cov_mean "<<cc.cov_mean<<endl;

	for ( multimap<double, size_t, greater<double > >::iterator ite = cov_ctg_map.begin(); ite != cov_ctg_map.end(); ++ite )
	{
		if ( ite->first < down_bottom )
			break;
		if ( target.find( ite->second ) == target.end() )
			continue;
		if ( cc.ctg_set.find( ite->second ) != cc.ctg_set.end() )
			continue;
		if ( ctg_ve[ite->second].gc - cc.gc_mean <= 0.04 && ctg_ve[ite->second].gc - cc.gc_mean >= -0.04 )
		{
		//	cout<<"sec in "<<ctg_ve[ite->second].name<<","<<ctg_ve[ite->second].length<<","<<ctg_ve[ite->second].gc<<","<<ctg_ve[ite->second].cov<<endl;
			cc.ctg_set.insert( ite->second );
		} else
		{
		//	cout<<"sec out "<<ctg_ve[ite->second].name<<","<<ctg_ve[ite->second].length<<","<<ctg_ve[ite->second].gc<<","<<ctg_ve[ite->second].cov<<endl;
		}
	
	}  
	calculate_lenweightedmean( cc.ctg_set, ctg_ve, cc.gc_mean, cc.cov_mean, cc.lenp );
//	cout<<"sec cc gc_mean "<<cc.gc_mean<<" cov_mean "<<cc.cov_mean<<endl;   exit(1);
	cc_ve.push_back( cc );

	set< size_t > in_ctg_set;
	in_ctg_set.insert( cc.ctg_set.begin(), cc.ctg_set.end() );

	//////check second potential cor
	while ( cor_remain )
	{
		cor_remain = false;
		bool remaincorctg = false;
		bool seccluster = false;
		ClusterCore sec_cc;
		corlen = 0;
		for ( multimap< double, size_t, greater<double > >::iterator ite = cov_ctg_map.begin(); ite != cov_ctg_map.end(); ++ite )
		{
			if ( ite->first < down_bottom )
				break;
			if ( ite->first >= up_bottom )
				continue;
			if ( in_ctg_set.find( ite->second ) != in_ctg_set.end() )
				continue;
			if ( ctg_ve[ite->second].length > corlen )
			{
				corlen = ctg_ve[ite->second].length;
			
				corctg = ite->second;
			}
		}
		if ( corlen == 0 )
		{
			break;
		}
		cor_gc = ctg_ve[corctg].gc;
		
		for ( multimap<double, size_t, greater<double > >::iterator ite = cov_ctg_map.begin(); ite != cov_ctg_map.end(); ++ite )
		{
			if ( ite->first < down_bottom )
				break;
			if ( ite->first >= up_bottom )
				continue;
			if ( target.find( ite->second ) == target.end() )
				continue;
			if ( in_ctg_set.find( ite->second ) != in_ctg_set.end() )
				continue;
			if ( ctg_ve[ite->second].gc - cor_gc <= 0.03 && ctg_ve[ite->second].gc - cor_gc >= -0.03 )
			{
				sec_cc.ctg_set.insert( ite->second );
				
			} else 
			{
				int l = ctg_ve[ite->second].length / 100;
				if ( l > 100 )
					remaincorctg = true;
			}
		}
		calculate_lenweightedmean( sec_cc.ctg_set, ctg_ve, sec_cc.gc_mean, sec_cc.cov_mean, sec_cc.lenp );
		if ( sec_cc.lenp > 100 )
		{
			
			for ( multimap<double, size_t, greater<double > >::iterator ite = cov_ctg_map.begin(); ite != cov_ctg_map.end(); ++ite )
			{
				if ( ite->first < down_bottom )
					break;
				if ( target.find( ite->second ) == target.end() )
					continue;
				if ( sec_cc.ctg_set.find( ite->second ) != sec_cc.ctg_set.end() )
					continue;
				if ( in_ctg_set.find( ite->second ) != in_ctg_set.end() )
					continue;
				if ( ctg_ve[ite->second].gc - sec_cc.gc_mean <= 0.04 && ctg_ve[ite->second].gc - sec_cc.gc_mean >= -0.04 )
				{
					sec_cc.ctg_set.insert( ite->second );
					
				}
			}
			calculate_lenweightedmean( sec_cc.ctg_set, ctg_ve, sec_cc.gc_mean, sec_cc.cov_mean, sec_cc.lenp );
			if ( sec_cc.lenp >= 1000 )
			{
				cc_ve.push_back( sec_cc );
				in_ctg_set.insert( sec_cc.ctg_set.begin(), sec_cc.ctg_set.end() );
				seccluster = true;
			}
		} else 
			break;
		if ( remaincorctg && seccluster )
			cor_remain = true;
	}
}

void FilterCtg( set< size_t > &FiltedCtg, vector< Contig > &ctg_ve, string &file, string& ctgfile )
{
	string detfile = file +".det";
	ofstream detf( detfile.data() );
	
	set< string > fltctg;
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		detf<<ctg_ve[i].name<<","<<ctg_ve[i].length<<","<<ctg_ve[i].cov<<endl;
		if ( FiltedCtg.find( i ) != FiltedCtg.end() )
		{
			fltctg.insert( ctg_ve[i].name );
			
		}
	}

	ifstream inf( ctgfile.data() );
	ofstream outf( file.data() );

	string line;
	string seq;
	string id;
	getline( inf, line );

	while(!inf.eof())
	{
		id = line.substr(1);
		bool flt = false;
		if ( fltctg.find( id ) != fltctg.end() )
			flt = true;

		if ( flt )
			outf<<line<<endl;

		getline( inf,line );

		while ( line.find(">") == std::string::npos )              
		{
			if ( flt )
				outf<<line<<endl;
			if ( inf.eof() )
				break;
			getline( inf, line);
		}
	}
	
}
/*
void Outputmappedread( vector<Contig > &ctg_ve, 
	map< string, vector<mapping_on_contig > > &maps,
	set< size_t > &FiltedCtg, string &outfile )
{
	
	string routf = outfile + ".sread";	
	ofstream outf( routf.data() );
	
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( maps.find( ctg_ve[i].name ) != maps.end() )
		{
			if ( FiltedCtg.find( i ) != FiltedCtg.end() )
			{
				for ( size_t j = 0; j < maps[ctg_ve[i].name].size(); ++j )
				{
					
					outf<<maps[ctg_ve[i].name][j].rid<<endl;
				}
			}
		}
	}

}

void Outputmappedread( vector<Contig > &ctg_ve, 
	map< string, vector<mapping_on_contig > > &maps,
	set< size_t > &FiltedCtg, string &outfile, char suf )
{
	
	string routf = outfile + ".sread";	
	ofstream outf( routf.data() );
	
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( maps.find( ctg_ve[i].name ) != maps.end() )
		{
			if ( FiltedCtg.find( i ) != FiltedCtg.end() )
			{
				for ( size_t j = 0; j < maps[ctg_ve[i].name].size(); ++j )
				{
					string id = maps[ctg_ve[i].name][j].rid;
					
					if ( (id[id.size()-2] == suf && id[id.size()-1]== '1') || id[id.size()-2] == suf && id[id.size()-1]== '2' )
					{
						id = id.substr( 0, id.size()-2 ); 
					}
					outf<<id<<endl;
				}
			}
		}
	}

}
*/
void getredundantreads( vector<Contig > &ctg_ve, 
	map< string, vector<mapping_on_contig > > &maps,
	 double cutcov, string &outfile, char suf )
{
	string routf = outfile + ".sread";	
	ofstream outf( routf.data() );

	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{

		if ( ctg_ve[i].cov <= cutcov )
			continue;

		double redundant_ratio = (  ctg_ve[i].cov - cutcov ) / ctg_ve[i].cov;
		if ( maps.find( ctg_ve[i].name ) == maps.end() )
		{
			cout<<"error maps not find ctg "<<ctg_ve[i].name<<endl; exit(1);
		}
		map< int, vector< string > > lib_rid_map;
		map< string, int > rid_occur; 
		for ( size_t j = 0; j < maps[ctg_ve[i].name].size(); ++j )
		{
			string id = maps[ctg_ve[i].name][j].rid;
			if ( (id[id.size()-2] == suf && id[id.size()-1]== '1') || (id[id.size()-2] == suf && id[id.size()-1]== '2') )
			{
				id = id.substr( 0, id.size()-2 ); 
			}
			int lib = maps[ctg_ve[i].name][j].lib;
			lib_rid_map[lib].push_back( id );
			if ( rid_occur.find( id ) == rid_occur.end() )
				rid_occur[id] = 1;
			else
				rid_occur[id] += 1;
		}

	//	cout<<ctg_ve[i].name<<", "<<ctg_ve[i].cov<<", "<<" "<<redundant_ratio<<endl;
		vector< string > eraid;
		for ( map< int, vector< string > >::iterator ite = lib_rid_map.begin(); ite != lib_rid_map.end(); ++ite )
		{
			int n = (int)ite->second.size();
			int redun = (int)( redundant_ratio * n );
			if ( redun > n )
			{
				cout<<"error redun "<<redun <<" "<<n<<endl; exit(1);
			}
			int add = 0;
			for ( size_t j = 0; j < ite->second.size(); ++j )
			{
				if ( rid_occur[ite->second[j]] > 1 )
				{
					eraid.push_back( ite->second[j] );
					add += 1;
					if ( add >= redun )
						break;
				}

			}
			if ( add < redun )
			{
				for ( size_t j = 0; j < ite->second.size(); ++j )
				{
					if ( rid_occur[ite->second[j]] == 1 )
					{
						eraid.push_back( ite->second[j] );
						add += 1;
						if ( add >= redun )
							break;
					}
				}
			}

		}

		for ( size_t i = 0; i < eraid.size(); ++i )
		{
			outf<<eraid[i]<<endl;
		}
	}
}

void exit_with_help( const char c[] )
{
	cout<<c<<endl;
	cerr <<"Usage:	Filter [OPTION1] [VALUE1] [[OPTION2] [VALUE2] ...]" <<endl;
	cerr <<"Options:" <<endl;
	cerr <<"-c		Contig file name" <<endl;
	cerr <<"-b      Comma-seperated bowtie output files"<<endl;
	cerr <<"-o		Output file name" <<endl;
	cerr <<"-l      Filter coverage lower bound[0]"<<endl;
	cerr <<"-u		Filter coverage upper bound[100000]" <<endl;
	cerr <<"-L      Second lower bound, for reads output[0]"<<endl;
	cerr <<"-U      Second upper bound, for reads output[100000]"<<endl;
	cerr <<"-s      for paired-end fastq reads, the least second character[none]"<<endl;
	cerr <<"-q      minimal alignment quality score[-12]"<<endl;
	cerr <<"-t		Filter Ctg and output[default 1], if 0 do not filter"<<endl;
	cerr <<"-r		Filter Reads and output[default 0], if not 0 do filter"<<endl;
	cerr <<"-C		Filter redundant reads for cabog"<<endl;
	cerr <<"-d		Filter redundant coverage for cabog[50x]"<<endl;
	exit(1);

}

int main( int argc, char* argv[] )
{
	string ctgfile;
	vector< string > bowtiefile;
	string outfile;
	double lowerb = 0;
	double upperb = 100000;
	double minqual = -18;
	bool ctgfilter = true;
	bool readfilter = false;
	bool cabogfilter = true;
	string in_secl, in_secu;
	string s;
	bool paired = true;
	char spl = '/';
	double redundant_cov = 50.0;
	for(int i=1; i<argc; i++)
	{
		if(argv[i][0] != '-')
			exit_with_help("Options must start with \'-\'.");

		if(argv[i][2] != '\0')
			exit_with_help("The option should be exactly one letter.");
		int option = argv[i][1];

		i++;
		if(i == argc)
			exit_with_help("The last option has no value.");

		switch(option)
		{
	

		case 'c':
			ctgfile = argv[i]; break;
		case 'b':
			s = argv[i];
			{
				string file = "";
				for ( size_t j = 0; j < s.size(); ++j ) {
					if ( s[j] == ',' ) {
						if ( !file.empty() ) {
							bowtiefile.push_back( file );
							file = "";
						}
					} else
						file += s[j];
				}
				if ( !file.empty() )
					bowtiefile.push_back( file );
			}
			break;

		case 'o': 
			outfile = argv[i]; break;
		case 'l':
			lowerb = atof( argv[i] ); break;
		case 'u':
			upperb = atof( argv[i] ); break;
		case 'L':
			in_secl = argv[i]; break;
		case 'U':
			in_secu = argv[i]; break;
		case 's':
			spl = argv[i][0]; paired = true; break;
		case 'q':
			minqual = atof( argv[i] ); break;
		case 't':
			if ( atoi( argv[i] ) == 0 )
				ctgfilter = false;
			break;
		case 'r':
			if ( atoi( argv[i] ) != 0 )
				readfilter = true;
			break;
		case 'C':
			if ( atoi( argv[i] ) == 0 )
			{
				cabogfilter = false;
			}
			break;
		case 'd':
			redundant_cov = atof( argv[i] );
			break;
		default:
			exit_with_help( "Unexpected option!" );
		}
	}

	if ( ctgfile.empty() )
		exit_with_help( "No ctg file assigned!");
	if ( bowtiefile.empty() )
		exit_with_help( "No bowtiefile assigned!" );
	if ( outfile.empty() )
		outfile = "out.fa";
	
	double sec_lowerb = 0;
	double sec_upperb = 100000;
	if ( !in_secl.empty() )
		sec_lowerb = atoi( in_secl.c_str() );
	
	if ( !in_secu.empty() )
		sec_upperb = atoi( in_secu.c_str() );
	

//	cout<<"cabogfilter:"<<cabogfilter<<endl;
//	cout<<"ctgfilter:"<<ctgfilter<<endl;
//	cout<<"readfilter:"<<readfilter<<endl;
//	cout<<"read in contigs"<<endl;
	vector< Contig > ctg_ve;
	GetContigFromFile( ctgfile, ctg_ve );
	

//	cout<<"read in maps from bowtie file"<<endl;
	map< string, vector<mapping_on_contig > > maps;
	for ( size_t i = 0; i < bowtiefile.size(); ++i )
	{
		int lib = (int)i;
		readinbowtieout_pairmode( bowtiefile[i], maps, minqual, lib );
	}
	
//	cout<<"calculate coverage"<<endl;
	CalculateCov( ctg_ve, maps );

	if ( cabogfilter )
	{
//		cout<<"Filter reads for cabog"<<endl;
		getredundantreads( ctg_ve, maps, redundant_cov, outfile, spl );
	}

	if ( !ctgfilter && !readfilter )
	{
		return 1;
	}

//	cout<<"getfilterctg_refinebound"<<endl;
	double refined_lowerb, refined_upperb;
	double refined_seclowerb, refined_secupperb;
	getfilterctg_refinebound( ctg_ve, lowerb, upperb, outfile, refined_lowerb, refined_upperb, sec_lowerb, sec_upperb, refined_seclowerb, refined_secupperb );

	if ( ctgfilter )
	{
//		cout<<"Filter and output"<<endl;
//		cout<<"refined_lowerb:"<<refined_lowerb<<", refined_upperb:"<<refined_upperb<<endl;
		FilterCtg( refined_lowerb, refined_upperb, ctg_ve, outfile, ctgfile );
	}

	if ( readfilter )
	{
//		cout<<"Output mapped reads in second range"<<endl;
		refined_secupperb = min ( sec_upperb+10, refined_secupperb );
		refined_seclowerb = min ( refined_seclowerb, sec_lowerb );
//		cout<<"refined_seclowerb:"<<refined_seclowerb<<", refined_secupperb:"<<refined_secupperb<<endl;
		if ( paired )
		{
//			cout<<"spl "<<spl<<endl;
			Outputmappedread( ctg_ve, maps, refined_seclowerb, refined_secupperb, outfile, spl );
		} else
			Outputmappedread( ctg_ve, maps, refined_seclowerb, refined_secupperb, outfile ); 
	}
		
	return 1;
}


