#include <iostream>
#include <fstream>
#include <map>
#include <set>
#include <string>
#include <vector>
#include <stdlib.h>

using namespace std;

void GetSCFFromFile( string filename, vector< pair< string ,string > > &SCF )
{
	
	ifstream inf ( filename.data() );
	if ( !inf.good() ) {
		cout<<"could not open file "<<filename<<endl;  exit(1);
	}
	string line;
	string seq;
	string id;
	getline( inf, line );

	while(!inf.eof()){
		line = line.substr(1);
		id = "";
		for ( size_t i = 0; i < line.size(); ++i ) {
			if ( line[i] == ' ')
				break;
			id += line[i];
		}
		getline( inf,line );

		while ( line.find(">") == std::string::npos )              
		{
			
			seq+=line;

			if ( inf.eof() )
				break;
			getline( inf, line);
			
		}

		SCF.push_back( make_pair( id, seq ) );

		

	//	if ( (int)ass_bank.Contigs.size() == 10 )
	//		break;

		seq.erase( seq.begin(), seq.end() );


	}

	inf.close();
}

void spiltSCF( string &scf, vector< string > &ctgve, char s, int l ) 
{
	string ctg = "";
	int state = 0;
	for ( size_t i = 0; i < scf.size(); ++i ) {
		if (state == 0) {
			if ( scf[i] != s )
				ctg += scf[i];
			else {
                                int c = 1;
                                
                                string tmp_s = "";
                                tmp_s += scf[i];
                                ++i;
                                bool single = false;
                                while ( i<scf.size() )
                                {
                                    tmp_s += scf[i];
                                    if ( scf[i] != s )
                                    {
                                        ctg += tmp_s;
                                        single = true;
                                        break;
                                    }
                                    c++;
                                    if ( c >= l )
                                        break;
                                    ++i;
                                }
                                if ( !single )
                                {
				    state = 1;
				    ctgve.push_back( ctg );
				    ctg = "";
                                }
			}
		} else if ( state == 1 ) {
			if ( scf[i] != s ) {
				ctg += scf[i];
				state = 0;
			}
		} 
	}
	if ( !ctg.empty() )
		ctgve.push_back(ctg);

}

void splitSCFandoutput( string file, vector< pair< string ,string > > &SCF, char splitsig, int extl )
{


	ofstream outf( file.data() );

	for ( size_t i = 0; i < SCF.size(); ++i ) {
		
		if ( SCF[i].second.find(splitsig) == SCF[i].second.npos ) {

			outf<<">"<< SCF[i].first << "\n";
			string seq = SCF[i].second;
			int k;
			for( k = 0; k < (int)seq.size()/65; k++ )
				outf << seq.substr(65*k,65) << endl;
			if ( seq.substr(65*k).size() != 0 )    //пһС
				outf << seq.substr(65*k) << endl;
		} else {
		//	char aff = 'a';
			vector< string > ctgve;
			
			spiltSCF( SCF[i].second, ctgve, splitsig, extl );

			for ( int j = 0; j < (int)ctgve.size(); ++j ) {
				
				char *b = new char[10];
				sprintf(b, "%d", j);
				string aa = b;
				delete b;
				string id = SCF[i].first + "_ctg" + aa;
				outf<<">"<<id<<endl;
				string seq = ctgve[j];
				int k;
				for( k = 0; k < (int)seq.size()/65; k++ )
					outf << seq.substr(65*k,65) << endl;
				if ( seq.substr(65*k).size() != 0 )    //пһС
					outf << seq.substr(65*k) << endl;

			}
		}
	}
}

int main( int argc, char* argv[] )
{
	if ( argc != 3 ) {
		cout<<"usage: SCFtoCTG inputfile outputfile"<<endl;  exit(1);
	}

	string infile = argv[1];
	string outfile = argv[2];

	char splits = 'N';
        int extl = 3;

	vector< pair< string , string > > SCF;

	GetSCFFromFile( infile, SCF );
	cout<<"ouput"<<endl;


	splitSCFandoutput( outfile, SCF, splits, extl );

	return 1;
}

