#include <map>
#include <set>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>
#include <list>
#include <iomanip>
#include <stdio.h>  
#include <stdlib.h> 

#include <math.h>
using namespace std;

class Lib
{
public:
	string name;
	double mean_size;
	double stdve_size;
	int matepair_numb;
	bool mate;
};

class mapping_on_contig
{
public:
	int lib;
	int start_pos;
	int end_pos;
	bool pairalign;
	bool forward;
	int insertsize;
	string rid;
	int matestart;
	bool single;
};

class Contig
{
public:
	string name;
	int length;
	string seq;
	vector< int > base_cov;
//	vector< int > base_forward_cov;
//	vector< int > base_reverse_cov;
	vector< int > base_mate_cov;
	map< int, double > base_insertsize_mean;    // pvalue
	vector< double > base_remarkpvalue_rate; 
	vector< int > base_unpair_forward_cov;
	vector< double > base_unpair_forward_rate;
	vector< double > base_unpair_reverse_cov;
	vector< double > base_unpair_reverse_rate;
	vector< double > base_pair_forward_cov;
	vector< double > base_pair_reverse_cov;
//	vector< double > _100rg_unpair_forward_rate;
//	vector< double > _100rg_unpair_reverse_rate;
	double cov;
	double gc;

	vector< pair<int, int > > bad_upairrate_forward;
	vector< pair<int, int > > bad_upairrate_reverse;
	vector< pair<int, int > > bad_insertsize;
};

void FlagInfo( int f, bool &single, bool &pair_aligned, bool &SelfNotAligned, bool &MateNotAligned, bool &forward )
{
	int mate2 = f / 128;
	f -= mate2*128;
	int mate1 = f / 64;
	f -= mate1*64;
	int matereversealign = f / 32;
	f -= matereversealign * 32;
	int reversealign = f / 16;
	f -= reversealign * 16;
	int mateNoAlign = f / 8;
	f -= mateNoAlign * 8;
	int NoAlign = f / 4;
	f -= NoAlign * 4;
	int PairAlign = f / 2;
	f -= PairAlign * 2;
	int Pair = f / 1;
	if ( !Pair )
	{
		single = true;
		pair_aligned = false;
		if ( NoAlign != 0 )
			SelfNotAligned = true;
		else 
			SelfNotAligned = false;
		
		MateNotAligned = true;
		return;
	} else
	{
		single = false;
		if ( PairAlign != 0 )
			pair_aligned = true;
		else
			pair_aligned = false;
		if ( NoAlign != 0 )
			SelfNotAligned = true;
		else
			SelfNotAligned = false;
		if ( mateNoAlign != 0 )
			MateNotAligned = true;
		else
			MateNotAligned = false;

		
		
			if ( reversealign )
				forward = false;
			else
				forward = true;
		
	}
	
}

void readinbowtieout_pairmode( string & file, map< string, vector<mapping_on_contig > > &maps, double minq, int lib )
{
	ifstream inf( file.data() );
	if ( !inf.good() )
	{
		cout<<"error can not open file "<<file<<endl; exit(1);
	}

	while ( !inf.eof() )
	{
		string line;
		getline( inf, line );
		if ( line.empty() )
			break;
		
		string rid = "";
		string ctgid = "";
		string flag = "";
		string seq = "";
		string pos = "";
		string s = "";
		string matealign = "";
		string insertsize = "";
		string matestart = "";
		int c = 0;
		bool stat_on = false;
		for ( size_t i = 0; i < line.size(); ++i )
		{
			if ( stat_on )
			{
				if ( line[i] == ' ' || line[i] == '\t' )
				{
					c+=1; 
					if ( c == 1 )
					{
						rid = s;
						s = "";
					} else if ( c == 2 )
					{
						flag = s;
						s = "";
					} else if ( c == 3 )
					{
						ctgid = s;
						s = "";
					} else if ( c == 4 )
					{
						pos = s;
						s = "";
					} else if ( c == 5 )
					{
						s = "";
					} else if ( c == 6 )
					{
						s = "";
					} else if ( c == 7 )
					{
						matealign = s;
						s = "";
					} else if ( c == 8 )
					{
						matestart = s;
						s = "";
					} else if ( c == 9 )
					{
						insertsize = s;
						s = "";
					} else if ( c == 10 )
					{
						seq = s;
						s = "";
						break;
					}
						

					stat_on = false;

				} else
				{
					s += line[i];
				}
			} else
			{
				if ( line[i] != ' ' || line[i] == '\t' )
				{
					s += line[i];
					stat_on = true;
				} 
			}
			
		}

		

		// alignment quality score filter
		
		double scq = 0;
		if ( line.find( "AS:i:" ) != line.npos )
		{
			string subl = line.substr( line.find("AS:i:") );
			string sc = "";
			for ( size_t g = 0; g < subl.size(); ++g )
			{
				if ( subl[g] == ' ' || subl[g] == '\t' )
					break;
				sc += subl[g];
			}
			sc = sc.substr( 5 );
			scq = atof( sc.c_str() );
			if ( scq > 0 )
			{
				cout<<"Error align score: "<<scq<<", "<<sc<<", "<<subl<<", "<<line<<endl; exit(1);
			}
			
		}
		double matescq = 0;
		if ( line.find( "YS:i:" ) != line.npos )
		{
			string subl = line.substr( line.find("YS:i:") );
			string sc = "";
			for ( size_t g = 0; g < subl.size(); ++g )
			{
				if ( subl[g] == ' ' || subl[g] == '\t' )
					break;
				sc += subl[g];
			}
			sc = sc.substr( 5 );
			matescq = atof( sc.c_str() );
			if ( matescq > 0 )
			{
				cout<<"Error align score: "<<matescq<<", "<<sc<<", "<<subl<<", "<<line<<endl; exit(1);
			}
			
		}

		int flag_i = atoi( flag.c_str() );
		bool single, pairalign, selfnoalign, matenoalign, forward;
		FlagInfo( flag_i, single, pairalign, selfnoalign, matenoalign, forward );

		if ( !selfnoalign && scq >= minq )
		{
			mapping_on_contig mp;
			mp.lib = lib;
			mp.rid = rid;
			mp.start_pos = atoi( pos.c_str() );
			int l = (int)seq.size();
			mp.end_pos = mp.start_pos + l - 1;
			mp.single = single;
			if ( pairalign && matescq >= minq )
			{
				mp.pairalign = true;
				mp.forward = forward;
				if ( mp.forward )
				{
					mp.insertsize = atoi( insertsize.c_str() );
					mp.matestart = atoi( matestart.c_str() );
					if ( mp.insertsize < 0 )
						mp.insertsize = 0;
				/*	if ( mp.insertsize <= 0 )
					{
						cout<<"error insertsize "<<mp.insertsize<<endl;
						cout<<pairalign<<","<< selfnoalign<<","<<  matenoalign<<","<<  forward<<endl;
						cout<<line<<endl;
						exit(1);
					} */
				}
			} else
			{
				mp.pairalign = false;
			}
			maps[ctgid].push_back( mp );
		}
	/*	if ( scq >= minq && matescq >= minq )
		{
			if ( ctgid != "*" )
			{
				mapping_on_contig mp;
				mp.rid = rid;
				mp.start_pos = atoi( pos.c_str() );
				int l = (int)seq.size();
				mp.end_pos = mp.start_pos + l - 1;
				maps[ctgid].push_back( mp );
			}
		} */
	}
}

double phi(double u)
{
	if(u < 0){
		cout<<"error: u < 0!"<<endl;  exit(1);
	}
	double v;
	int c = floor(u * 10);
	switch(c){
		case 0:      v = 0.5;    break;
		case 1:      v = 0.54;   break;
		case 2:      v = 0.58;   break;
		case 3:      v = 0.618;  break;
		case 4:      v = 0.655;  break;
		case 5:      v = 0.692;  break;
		case 6:      v = 0.726;  break;
		case 7:      v = 0.758;  break;
		case 8:      v = 0.788;  break;
		case 9:      v = 0.816;  break;
		case 10:     v = 0.841;  break;
		case 11:     v = 0.864;  break;
		case 12:     v = 0.885;  break;
		case 13:     v = 0.903;  break;
		case 14:     v = 0.919;  break;
		case 15:     v = 0.933;  break;
		case 16:     v = 0.945;  break;
		case 17:     v = 0.955;  break;
		case 18:     v = 0.964;  break;
		case 19:     v = 0.971;  break;
		case 20:     v = 0.977;  break;
		case 21:     v = 0.982;  break;
		case 22:     v = 0.986;  break;
		case 23:     v = 0.989;  break;
		case 24:     v = 0.991;  break;
		case 25:     v = 0.994;  break;
		case 26:     v = 0.995;  break;
		case 27:     v = 0.996;  break;
		case 28:     v = 0.997;  break;
		case 29:     v = 0.998;  break;
		case 30:     v = 0.999;  break;
		default:     v = 1;
	}

	return v;
}

double miuf(double u)
{
	if(u >= 0)
		return 1 - phi(u);
	else
		return 1 - phi(-1 * u);
}

double pvalue(double exp, double var, int x)
{
	if(var == 0)
	{
		cout<<"error: var == 0"<<endl;
	}
	double u = double(x-exp) / var;

	return miuf(u);
}

double calculategc( string &seq )
{
	if ( seq.empty() )
		return 0;
	int c = 0;
	for ( size_t i = 0; i < seq.size(); ++i )
	{
		if ( seq[i] == 'c' || seq[i] == 'C' || seq[i] == 'g' || seq[i] == 'G' )
			c += 1;
	}
	int t = (int)seq.size();
	return (double)c / t;
}

void GetContigFromFile( string filename, vector<Contig> &ctg_ve )
{

	
	ifstream inf ( filename.data() );
	if ( !inf.good() ) {
		cout<<"could not open file "<<filename<<endl;  exit(1);
	}
	string line;
	
	string id;
	getline( inf, line );

	while(!inf.eof()){
		id = line.substr(1);
		getline( inf,line );
		string seq;
		while ( line.find(">") == std::string::npos )              
		{
			
			seq+=line;

			if ( inf.eof() )
				break;
			getline( inf, line);
			
		}

		Contig ctg;
		ctg.name = id;
	//	ctg.seq = seq;
		ctg.length = (int)seq.size();
		ctg.gc = calculategc( seq );
		ctg_ve.push_back( ctg );
		
		


	}



	inf.close();

}

void CalculateCov( vector<Contig > &ctg_ve, map< string, vector<mapping_on_contig > > &maps, map< int, Lib > &libmap, double remarkpvalue,
	double lower_cov, double upper_cov )
{

	bool cov_strain = false;
	if ( lower_cov > 0 || upper_cov != 100000 )
		cov_strain = true;
	/// first calculate lib size 
	map< int, vector< int > > libsize_map;
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		
		string ctgid = ctg_ve[i].name;
		if ( maps.find( ctgid ) != maps.end() )
		{
			for ( size_t j = 0; j < maps[ctgid].size(); ++j )
			{
				if ( !maps[ctgid][j].single )
				{
					if ( maps[ctgid][j].pairalign && maps[ctgid][j].forward )
					{
						libsize_map[maps[ctgid][j].lib].push_back( maps[ctgid][j].insertsize );
					
					}
				}
			}
		}
		
	}

	for ( map< int, vector< int > >::iterator ite = libsize_map.begin(); ite != libsize_map.end(); ++ite )
	{
		double mean = 0;
		int count = (int)ite->second.size();
		int cc = 0;
		for ( vector<int>::iterator si = ite->second.begin(); si != ite->second.end(); ++si )
		{
			mean = ( mean*cc + *si ) / (cc+1);
			cc += 1;
		
		}
		if ( count == 0 )
		{
			libmap[ite->first].mean_size = 0;
			libmap[ite->first].stdve_size = 0;
			continue;
		} else if ( count == 1 )
		{
			libmap[ite->first].mean_size = *ite->second.begin();
			libmap[ite->first].stdve_size = 0;
		}

		
		double sum_s = 0;
		for ( vector<int>::iterator si = ite->second.begin(); si != ite->second.end(); ++si  )
		{
			sum_s += (*si-mean) * (*si-mean);
		}
		double p = pow( (double)sum_s / (count-1), 0.5 );
		libmap[ite->first].mean_size = mean;
		libmap[ite->first].stdve_size = p;
		libmap[ite->first].matepair_numb = count;
	}
	double minconstrain = libmap.begin()->second.mean_size;
	for ( map< int, Lib >::iterator ite = libmap.begin(); ite != libmap.end(); ++ite )
	{
		if ( ite->second.matepair_numb < 1000 )
		{
			cout<<"Lib"<<ite->first<<", matepair_numb:"<<ite->second.matepair_numb<<", single"<<endl; 
			ite->second.mate = false;
			continue;
		} else
		{
			ite->second.mate = true;
			if ( ite->second.mean_size < minconstrain )
				minconstrain = ite->second.mean_size;
			cout<<"Lib"<<ite->first<<", insert size mean: "<<ite->second.mean_size<<", insert size stdev: "<<ite->second.stdve_size
				<<", matepair_numb:"<<ite->second.matepair_numb<<endl;
		}
	}

	if ( cov_strain )
	{
		for ( size_t i = 0; i < ctg_ve.size(); ++i )
		{
			string ctgid = ctg_ve[i].name;
			if ( maps.find( ctgid ) != maps.end() )
			{
				
			//	long sum = 0;
				int add = 0;
				for ( size_t j = 0; j < maps[ctgid].size(); ++j )
				{
					int l = maps[ctgid][j].end_pos-maps[ctgid][j].start_pos+1;
					add += l;
				}
				if ( ctg_ve[i].length == 0 )
					continue;
				ctg_ve[i].cov = (double) add / ctg_ve[i].length;
			}

		}
	}

	int pcount = 0;
	int rcount = 0;
	int minlen = 2 * (int)minconstrain;
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].length < minlen )
			continue;
	
		if ( cov_strain )
		{
			if ( ctg_ve[i].cov < lower_cov || ctg_ve[i].cov > upper_cov )
				continue;
		}
		string ctgid = ctg_ve[i].name;

		ctg_ve[i].base_cov.reserve(ctg_ve[i].length);
	//	ctg_ve[i].base_forward_cov.reserve(ctg_ve[i].length);
	//	ctg_ve[i].base_reverse_cov.reserve(ctg_ve[i].length);
		ctg_ve[i].base_unpair_forward_cov.reserve(ctg_ve[i].length);
		ctg_ve[i].base_unpair_reverse_cov.reserve(ctg_ve[i].length);
		ctg_ve[i].base_pair_forward_cov.reserve( ctg_ve[i].length );
		ctg_ve[i].base_pair_reverse_cov.reserve( ctg_ve[i].length );
		for ( int j = 0; j < ctg_ve[i].length; ++j )
		{
			ctg_ve[i].base_cov.push_back(0);
		//	ctg_ve[i].base_forward_cov.push_back(0);
		//	ctg_ve[i].base_reverse_cov.push_back(0);
		
			ctg_ve[i].base_unpair_forward_cov.push_back(0);
			ctg_ve[i].base_unpair_reverse_cov.push_back(0);
			ctg_ve[i].base_pair_forward_cov.push_back(0);
			ctg_ve[i].base_pair_reverse_cov.push_back(0);
		}
		map< int, vector< double > > pos_pvalue_insertsize;
		if ( maps.find( ctgid ) != maps.end() )
		{
			int st = ctg_ve[i].length;
			int ed = 0;
		//	long sum = 0;
		//	cout<<maps[ctgid].size()<<" "<<ctgid<<endl; 
			for ( size_t j = 0; j < maps[ctgid].size(); ++j )
			{
				if ( maps[ctgid][j].start_pos > ctg_ve[i].length )
				{
				//	cout<<"warning s "<< maps[ctgid][j].start_pos<<" "<<ctg_ve[i].length<<endl;
					continue;
				}
				if ( maps[ctgid][j].end_pos > ctg_ve[i].length )
				{
				//	cout<<"warning "<< maps[ctgid][j].end_pos<<" "<<ctg_ve[i].length<<endl;
					maps[ctgid][j].end_pos = ctg_ve[i].length;
				}
			/*	if ( maps[ctgid][j].start_pos < st )
					st = maps[ctgid][j].start_pos;
				if ( maps[ctgid][j].end_pos > ed )
					ed = maps[ctgid][j].end_pos;
				sum += ( maps[ctgid][j].end_pos - maps[ctgid][j].start_pos + 1 );  */

				////////////
				// for base cal
				for ( int k = maps[ctgid][j].start_pos; k <= maps[ctgid][j].end_pos; ++k )
				{
					ctg_ve[i].base_cov[k-1] += 1;
					 
				}  
				
				if ( !maps[ctgid][j].single && maps[ctgid][j].pairalign && maps[ctgid][j].forward )
				{
					if ( libmap.find( maps[ctgid][j].lib ) == libmap.end() )
					{
						cout<<"error no lib "<<maps[ctgid][j].lib<<endl; exit(1);
					}
					if ( libmap[maps[ctgid][j].lib].mate )
					{
						if ( libmap[maps[ctgid][j].lib].stdve_size == 0 )
						{
							cout<<"error lib stdve_size "<<endl; exit(1);
						}
						double mean = libmap[maps[ctgid][j].lib].mean_size;
						double stdve = libmap[maps[ctgid][j].lib].stdve_size;
						double p = pvalue( mean, stdve, maps[ctgid][j].insertsize );
				
			
						int gap_start = maps[ctgid][j].end_pos + 1;
						int gap_end = maps[ctgid][j].matestart - 1;
						int gap_len = gap_end - gap_start + 1;
						if ( gap_len > 0 && gap_len < maps[ctgid][j].insertsize )
						{
							for ( int k = gap_start; k < gap_end; ++k )
							{
								pos_pvalue_insertsize[k].push_back( p );
							}
						}
					}
				} 
				if ( !maps[ctgid][j].pairalign && !maps[ctgid][j].single )
				{
				//	cout<<"unpair "<<maps[ctgid][j].start_pos<<" "<<maps[ctgid][j].end_pos<< " "<<endl;
					if ( libmap[maps[ctgid][j].lib].mate )
					{	
						for ( int k = maps[ctgid][j].start_pos; k <= maps[ctgid][j].end_pos; ++k )
						{
							if ( maps[ctgid][j].forward )
								ctg_ve[i].base_unpair_forward_cov[k-1] += 1;
							else
								ctg_ve[i].base_unpair_reverse_cov[k-1] += 1;
						}
					}
				} else if ( maps[ctgid][j].pairalign )
				{
					
					if ( libmap[maps[ctgid][j].lib].mate )
					{
						for ( int k = maps[ctgid][j].start_pos; k <= maps[ctgid][j].end_pos; ++k )
						{
							if ( maps[ctgid][j].forward )
								ctg_ve[i].base_pair_forward_cov[k-1] += 1;
							else
								ctg_ve[i].base_pair_reverse_cov[k-1] += 1;
						}
					}
				}
			}
		/*	int r = ed - st;
			double cov = 0;
			if ( r > 0 )
			{
			
				cov = sum * 1.0 / r ;
			}
			ctg_ve[i].cov = cov;  */

		} else
			ctg_ve[i].cov = 0;
		map<int, double > remarkpvalue_rate_map;
		for ( map< int, vector< double > >::iterator ite = pos_pvalue_insertsize.begin(); ite != pos_pvalue_insertsize.end(); ++ite )
		{
		
			double remarkpvalue_rate = 0;
			int added = 0;
			for ( vector< double >::iterator si = ite->second.begin(); si != ite->second.end(); ++si )
			{
				if ( *si <= remarkpvalue )
					added += 1;
			}
			if ( !ite->second.empty() )
			{
				remarkpvalue_rate = (double) added / (int)ite->second.size();
			}
			if ( remarkpvalue_rate > 0 && added >= 3 )
				remarkpvalue_rate_map.insert( make_pair( ite->first, remarkpvalue_rate ) );
		}
		ctg_ve[i].base_remarkpvalue_rate.clear();
		ctg_ve[i].base_remarkpvalue_rate.reserve(ctg_ve[i].length);
		for (  size_t j = 0; j < ctg_ve[i].base_cov.size(); ++j )
		{
			if ( remarkpvalue_rate_map.find( (int)j+1 ) != remarkpvalue_rate_map.end() )
			{
				ctg_ve[i].base_remarkpvalue_rate.push_back( remarkpvalue_rate_map[(int)j+1] );
			} else
				ctg_ve[i].base_remarkpvalue_rate.push_back( 0 );
		} 
		if ( ctg_ve[i].base_pair_forward_cov.size() != ctg_ve[i].base_unpair_forward_cov.size() )
		{
			cout<<"error base_cov and base_unpair_cov size different "<< ctg_ve[i].base_pair_forward_cov.size() <<", "<<ctg_ve[i].base_unpair_forward_cov.size() <<endl; exit(1);
		}
		if ( ctg_ve[i].base_pair_reverse_cov.size() != ctg_ve[i].base_unpair_reverse_cov.size() )
		{
			cout<<"error base_cov and base_unpair_cov size different "<< ctg_ve[i].base_pair_reverse_cov.size() <<", "<<ctg_ve[i].base_unpair_forward_cov.size() <<endl; exit(1);
		}
		ctg_ve[i].base_unpair_forward_rate.clear();
		ctg_ve[i].base_unpair_forward_rate.reserve( ctg_ve[i].length );
		for ( size_t j = 0; j < ctg_ve[i].base_pair_forward_cov.size(); ++j )
		{
			if ( ctg_ve[i].base_unpair_forward_cov[j] == 0 && ctg_ve[i].base_pair_forward_cov[j] == 0 )
			{
				ctg_ve[i].base_unpair_forward_rate.push_back( 0 );
				
			} else
			{
				double r = (double)ctg_ve[i].base_unpair_forward_cov[j] / ( ctg_ve[i].base_pair_forward_cov[j] + ctg_ve[i].base_unpair_forward_cov[j] );
				ctg_ve[i].base_unpair_forward_rate.push_back( r );
				
			}

		}
		ctg_ve[i].base_unpair_reverse_rate.clear();
		ctg_ve[i].base_unpair_reverse_rate.reserve( ctg_ve[i].length );
		for ( size_t j = 0; j < ctg_ve[i].base_pair_reverse_cov.size(); ++j )
		{
			if ( ctg_ve[i].base_pair_reverse_cov[j] == 0 && ctg_ve[i].base_unpair_reverse_cov[j] == 0 )
			{
				ctg_ve[i].base_unpair_reverse_rate.push_back( 0 );
				
			} else
			{
				double r = (double)ctg_ve[i].base_unpair_reverse_cov[j] / ( ctg_ve[i].base_pair_reverse_cov[j] + ctg_ve[i].base_unpair_reverse_cov[j] );
				ctg_ve[i].base_unpair_reverse_rate.push_back( r );
				
			}

		} 
		
		
	}
/*	cout<<"ctg0 "<<ctg_ve[0].base_cov.size()<<" "<<ctg_ve[0].base_pair_forward_cov.size()<<" "<<ctg_ve[0].base_pair_reverse_cov.size()
		<<" "<<ctg_ve[0].base_unpair_forward_cov.size()<<" "<<ctg_ve[0].base_unpair_reverse_cov.size()
		<<" " <<ctg_ve[0].base_unpair_forward_rate.size()<<" "<<ctg_ve[0].base_unpair_forward_rate.size()<<endl;  */
}

void Mark( vector<Contig > &ctg_ve, int minunpaircov, double minunpairrate, int minunpair_len, double minpvaluerate, int minpvalue_len )
{

	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_unpair_forward_rate.empty() )
			continue;
		int start_pos = 0;
		
		bool start_fw = false;
		for ( size_t j = 0; j < (int)ctg_ve[i].base_unpair_forward_rate.size(); ++j )
		{
			if ( start_fw )
			{
				if ( ctg_ve[i].base_unpair_forward_rate[j] >= minunpairrate && ctg_ve[i].base_unpair_forward_cov[j] >= minunpaircov )
				{
					continue;
				} else
				{
					int end_pos = (int)j+1 - 1;
					if ( end_pos - start_pos + 1 > minunpair_len )
					{
						ctg_ve[i].bad_upairrate_forward.push_back( make_pair( start_pos, end_pos ) );
						
					}
					start_fw = false;
				}
			} else
			{
				if ( ctg_ve[i].base_unpair_forward_rate[j] >= minunpairrate && ctg_ve[i].base_unpair_forward_cov[j] >= minunpaircov )
				{
					start_pos = (int)j+1;
					start_fw = true;
				}
			}
		}
		if ( start_fw )
		{
			int end_pos = (int)ctg_ve[i].base_unpair_forward_rate.size();
			if ( end_pos - start_pos + 1 > minunpair_len )
				ctg_ve[i].bad_upairrate_forward.push_back( make_pair( start_pos, end_pos ) );
		}
		
		start_pos = 0;
		bool start_rv = false;
		for ( size_t j = 0; j < (int)ctg_ve[i].base_unpair_reverse_rate.size(); ++j )
		{
			if ( start_rv )
			{
				if ( ctg_ve[i].base_unpair_reverse_rate[j] >= minunpairrate && ctg_ve[i].base_unpair_reverse_cov[j] >= minunpaircov )
				{
					continue;
				} else
				{
					int end_pos = (int)j+1 - 1;
					if ( end_pos - start_pos + 1 > minunpair_len )
						ctg_ve[i].bad_upairrate_reverse.push_back( make_pair( start_pos, end_pos ) );
					start_rv = false;
				}
			} else
			{
				if ( ctg_ve[i].base_unpair_reverse_rate[j] >= minunpairrate && ctg_ve[i].base_unpair_reverse_cov[j] >= minunpaircov )
				{
					start_pos = (int)j+1;
					start_rv = true;
				}
			}
		}
		if ( start_rv )
		{
			int end_pos = (int)ctg_ve[i].base_unpair_reverse_rate.size();
			if ( end_pos - start_pos + 1 > minunpair_len )
				ctg_ve[i].bad_upairrate_reverse.push_back( make_pair( start_pos, end_pos ) );
		}

		start_pos = 0;
		bool start_ins = false;
		for ( size_t j = 0; j < (int)ctg_ve[i].base_remarkpvalue_rate.size(); ++j )
		{
			if ( start_ins )
			{
				if ( ctg_ve[i].base_remarkpvalue_rate[j] >= minpvaluerate )
				{
					continue;
				} else
				{
					int end_pos = (int)j+1 - 1;
					if ( end_pos - start_pos + 1 >= minpvalue_len )
						ctg_ve[i].bad_insertsize.push_back( make_pair( start_pos, end_pos ) );
					start_ins = false;
				}
			} else
			{
				if ( ctg_ve[i].base_remarkpvalue_rate[j] >= minpvaluerate )
				{
					start_pos = (int)j+1;
					start_ins = true;
				}
			}

		}
		if ( start_ins )
		{
			int end_pos = (int)ctg_ve[i].base_remarkpvalue_rate.size();
			if ( end_pos - start_pos + 1 > minunpair_len )
				ctg_ve[i].bad_insertsize.push_back( make_pair( start_pos, end_pos ) );
		}  

	
	}

/*	cout<<"sec ctg0 "<<ctg_ve[0].base_cov.size()<<" "<<ctg_ve[0].base_pair_forward_cov.size()<<" "<<ctg_ve[0].base_pair_reverse_cov.size()
		<<" "<<ctg_ve[0].base_unpair_forward_cov.size()<<" "<<ctg_ve[0].base_unpair_reverse_cov.size()
		<<" " <<ctg_ve[0].base_unpair_forward_rate.size()<<" "<<ctg_ve[0].base_unpair_forward_rate.size()<<endl; */
}

void getunpairmeanandoutput( vector<Contig > &ctg_ve, string &outprefix )
{
	map< size_t, vector< double > > _100rg_unpair_forward_rate;
	map< size_t, vector< double > > _100rg_unpair_reverse_rate;
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
	//	cout<<"f"<<i<<endl;
		if ( !( !ctg_ve[i].bad_upairrate_forward.empty() || !ctg_ve[i].bad_upairrate_reverse.empty() || !ctg_ve[i].bad_insertsize.empty() ) )
			continue;
		int k = (int)ctg_ve[i].base_unpair_forward_rate.size() / 100;
		_100rg_unpair_forward_rate[i].reserve(k+1);
		for ( int j = 0; j < k; ++j )
		{
			double add = 0;
			for ( int m = j*100; m < (j+1)*100; ++m )
			{
				add += ctg_ve[i].base_unpair_forward_rate[m];
			}
			double mean = add / 100;
			_100rg_unpair_forward_rate[i].push_back( mean );
		}
		if ( (int)ctg_ve[i].base_unpair_forward_rate.size() % 100 != 0 )
		{
			double add = 0;
			for ( int m = k*100; m < (int)ctg_ve[i].base_unpair_forward_rate.size(); ++m )
			{
				add += ctg_ve[i].base_unpair_forward_rate[m];
			}
			double mean = add / 100;
			_100rg_unpair_forward_rate[i].push_back( mean );
		}
	}

	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( !( !ctg_ve[i].bad_upairrate_forward.empty() || !ctg_ve[i].bad_upairrate_reverse.empty() || !ctg_ve[i].bad_insertsize.empty() ) )
			continue;
	//	cout<<"r"<<i<<endl;
		int k = (int)ctg_ve[i].base_unpair_reverse_rate.size() / 100;
		_100rg_unpair_reverse_rate[i].reserve(k+1);
		for ( int j = 0; j < k; ++j )
		{
			double add = 0;
			for ( int m = j*100; m < (j+1)*100; ++m )
			{
				add += ctg_ve[i].base_unpair_reverse_rate[m];
			}
			double mean = add / 100;
			_100rg_unpair_reverse_rate[i].push_back( mean );
		}
		if ( (int)ctg_ve[i].base_unpair_reverse_rate.size() % 100 != 0 )
		{
			double add = 0;
			for ( int m = k*100; m < (int)ctg_ve[i].base_unpair_reverse_rate.size(); ++m )
			{
				add += ctg_ve[i].base_unpair_reverse_rate[m];
			}
			double mean = add / 100;
			_100rg_unpair_reverse_rate[i].push_back( mean );
		}
	}
	
	////
	string outforwardfile = outprefix+"._100rgunpairforwardrate";
	ofstream fwf( outforwardfile.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( !( !ctg_ve[i].bad_upairrate_forward.empty() || !ctg_ve[i].bad_upairrate_reverse.empty() || !ctg_ve[i].bad_insertsize.empty() ) )
			continue;
		fwf<<">"<<ctg_ve[i].name<<endl;
		for ( int j = 0; j < (int)_100rg_unpair_forward_rate[i].size(); ++j )
		{
		/*	if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					fwf<<"\n";
				fwf<<"\t"<<j*100<<"\t--\t";
			} else 
				fwf<<"\t";
			fwf<<ctg_ve[i]._100rg_unpair_forward_rate[j];  */
			if ( _100rg_unpair_forward_rate[i][j] >= 0.05 )
			{
				fwf<<j<<"\t"<<_100rg_unpair_forward_rate[i][j]<<endl;
			}
		}
		
	}
	fwf.close();
	string outreversefile = outprefix+"._100rgunpairreverserate";
	ofstream rvf( outreversefile.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_cov.empty() )
			continue;
		rvf<<">"<<ctg_ve[i].name<<endl;
		for ( int j = 0; j < (int)_100rg_unpair_reverse_rate[i].size(); ++j )
		{
		/*	if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					rvf<<"\n";
				rvf<<"\t"<<j*100<<"\t--\t";
			} else 
				rvf<<"\t";
			rvf<<ctg_ve[i]._100rg_unpair_reverse_rate[j];  */
			if ( _100rg_unpair_reverse_rate[i][j] >= 0.05 )
			{
				rvf<<j<<"\t"<<_100rg_unpair_reverse_rate[i][j]<<endl;
			}
		}
		
	}
	rvf.close();

/*	cout<<"44 ctg0 "<<ctg_ve[0].base_cov.size()<<" "<<ctg_ve[0].base_pair_forward_cov.size()<<" "<<ctg_ve[0].base_pair_reverse_cov.size()
		<<" "<<ctg_ve[0].base_unpair_forward_cov.size()<<" "<<ctg_ve[0].base_unpair_reverse_cov.size()
		<<" " <<ctg_ve[0].base_unpair_forward_rate.size()<<" "<<ctg_ve[0].base_unpair_forward_rate.size()<<endl;  */
	
}

void adjustmarked( vector<Contig > &ctg_ve )
{
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( !ctg_ve[i].bad_upairrate_forward.empty() )
		{
			vector< pair<int, int > > new_ve;
			for ( size_t j = 0; j < ctg_ve[i].bad_upairrate_forward.size(); ++j )
			{
				ctg_ve[i].bad_upairrate_forward[j].second = min( ctg_ve[i].bad_upairrate_forward[j].second + 100, ctg_ve[i].length );
			//	if ( ctg_ve[i].bad_upairrate_forward[j].second > 500 )
			//	{
			//		ctg_ve[i].bad_upairrate_forward[j].first = max( ctg_ve[i].bad_upairrate_forward[j].first, 500 );
					if ( ctg_ve[i].bad_upairrate_forward[j].first < ctg_ve[i].length-200 )
					{
						ctg_ve[i].bad_upairrate_forward[j].second = min( ctg_ve[i].length-200, ctg_ve[i].bad_upairrate_forward[j].second );
						new_ve.push_back( ctg_ve[i].bad_upairrate_forward[j] );
					}
			//	} 
			}
			ctg_ve[i].bad_upairrate_forward = new_ve;
		}
		if ( !ctg_ve[i].bad_upairrate_reverse.empty() )
		{
			vector< pair<int, int > > new_ve;
			for ( size_t j = 0; j < ctg_ve[i].bad_upairrate_reverse.size(); ++j )
			{
				ctg_ve[i].bad_upairrate_reverse[j].first = max(1, ctg_ve[i].bad_upairrate_reverse[j].first - 100);
				if ( ctg_ve[i].bad_upairrate_reverse[j].second > 200 )
				{
					ctg_ve[i].bad_upairrate_reverse[j].first = max( ctg_ve[i].bad_upairrate_reverse[j].first, 200 );
					new_ve.push_back( ctg_ve[i].bad_upairrate_reverse[j] );
				/*	if ( ctg_ve[i].bad_upairrate_reverse[j].first < ctg_ve[i].length-500 )
					{
						ctg_ve[i].bad_upairrate_reverse[j].second = min( ctg_ve[i].length-500, ctg_ve[i].bad_upairrate_reverse[j].second );
						new_ve.push_back( ctg_ve[i].bad_upairrate_reverse[j] );
					}*/
				} 
			}
			ctg_ve[i].bad_upairrate_reverse = new_ve;
		} 
	
	}
}

void OutputMarked( vector<Contig > &ctg_ve, string prefix )
{
/*	string markforwardup = prefix + ".fwunpair";
	ofstream mfwf( markforwardup.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( !ctg_ve[i].bad_upairrate_forward.empty() )
		{
			mfwf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
			for ( size_t j = 0; j < ctg_ve[i].bad_upairrate_forward.size(); ++j )
			{
				mfwf<<ctg_ve[i].bad_upairrate_forward[j].first<<"\t"<<ctg_ve[i].bad_upairrate_forward[j].second<<endl;
			}
		}
	}
	mfwf.close();
	string markreverseup = prefix + ".rvunpair";
	ofstream mrvf( markreverseup.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( !ctg_ve[i].bad_upairrate_reverse.empty() )
		{
			mrvf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
			for ( size_t j = 0; j < ctg_ve[i].bad_upairrate_reverse.size(); ++j )
			{
				mrvf<<ctg_ve[i].bad_upairrate_reverse[j].first<<"\t"<<ctg_ve[i].bad_upairrate_reverse[j].second<<endl;
			}
		}
	}
	mrvf.close();
	string markinsertsize = prefix + ".insertsizefea";
	ofstream mitf( markinsertsize.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( !ctg_ve[i].bad_insertsize.empty() )
		{
			mitf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
			for ( size_t j = 0; j < ctg_ve[i].bad_insertsize.size(); ++j )
			{
				mitf<<ctg_ve[i].bad_insertsize[j].first<<"\t"<<ctg_ve[i].bad_insertsize[j].second<<endl;
			}
		}
	}
	mitf.close();   */

	string markall = prefix + ".fea";
	ofstream af( markall.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( !ctg_ve[i].bad_upairrate_forward.empty() || !ctg_ve[i].bad_upairrate_reverse.empty() || !ctg_ve[i].bad_insertsize.empty() )
		{
			af<<">"<<ctg_ve[i].name<<endl;
			for ( size_t j = 0; j < ctg_ve[i].bad_upairrate_forward.size(); ++j )
			{
				af<<"FWUP\t"<<ctg_ve[i].bad_upairrate_forward[j].first<<"\t"<<ctg_ve[i].bad_upairrate_forward[j].second<<endl;
			}
			for ( size_t j = 0; j < ctg_ve[i].bad_upairrate_reverse.size(); ++j )
			{
				af<<"RVUP\t"<<ctg_ve[i].bad_upairrate_reverse[j].first<<"\t"<<ctg_ve[i].bad_upairrate_reverse[j].second<<endl;
			}
			for ( size_t j = 0; j < ctg_ve[i].bad_insertsize.size(); ++j )
			{
				af<<"PRSZ\t"<<ctg_ve[i].bad_insertsize[j].first<<"\t"<<ctg_ve[i].bad_insertsize[j].second<<endl;
			}
		}
	}
	af.close();
}

void OutputUnpairAndInsertsize( vector<Contig > &ctg_ve, string &prefix )
{
	
	string basecov = prefix + ".basecov";
	ofstream bcf( basecov.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_cov.empty() )
			continue;
		bcf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<",mean_gc_"<<ctg_ve[i].gc<<endl;
		for ( int j = 0; j < (int)ctg_ve[i].base_cov.size(); ++j )
		{
			if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					bcf<<"\n";
				bcf<<"\t"<<j+1<<"\t--\t";
			} else 
				bcf<<"\t";
			bcf<<ctg_ve[i].base_cov[j];
		}
		bcf<<endl;
	}
	bcf.close();
	string basefwcov = prefix + ".basepairforwardcov";
	ofstream bcwf( basefwcov.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_pair_forward_cov.empty() )
			continue;
		bcwf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<",mean_gc_"<<ctg_ve[i].gc<<endl;
		for ( int j = 0; j < (int)ctg_ve[i].base_pair_forward_cov.size(); ++j )
		{
			if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					bcwf<<"\n";
				bcwf<<"\t"<<j+1<<"\t--\t";
			} else 
				bcwf<<"\t";
			bcwf<<ctg_ve[i].base_pair_forward_cov[j];
		}
		bcwf<<endl;
	}
	bcwf.close();  
	string unpfwcov = prefix + ".unpairbaseforwardcov";
	ofstream ucwf ( unpfwcov.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_unpair_forward_cov.empty() )
			continue;
		ucwf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
		for ( int j = 0; j < (int)ctg_ve[i].base_unpair_forward_cov.size(); ++j )
		{
			if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					ucwf<<"\n";
				ucwf<<"\t"<<j+1<<"\t--\t";
			} else 
				ucwf<<"\t";
			ucwf<<ctg_ve[i].base_unpair_forward_cov[j];
		}
		ucwf<<endl;
	}
	ucwf.close();   
	string unpfwrate = prefix + ".unpairbaseforwardrate";
	ofstream urwf ( unpfwrate.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_unpair_forward_rate.empty() )
			continue;
		urwf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
		for ( int j = 0; j < (int)ctg_ve[i].base_unpair_forward_rate.size(); ++j )
		{
			if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					urwf<<"\n";
				urwf<<"\t"<<j+1<<"\t--\t";
			} else 
				urwf<<"\t";
			urwf<<setprecision(3)<<ctg_ve[i].base_unpair_forward_rate[j];
		}
		urwf<<endl;
	}
	urwf.close();
	string baservcov = prefix + ".basepairreversecov";
	ofstream bcvf( baservcov.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_pair_reverse_cov.empty() )
			continue;
		bcvf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<",mean_gc_"<<ctg_ve[i].gc<<endl;
		for ( int j = 0; j < (int)ctg_ve[i].base_pair_reverse_cov.size(); ++j )
		{
			if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					bcvf<<"\n";
				bcvf<<"\t"<<j+1<<"\t--\t";
			} else 
				bcvf<<"\t";
			bcvf<<ctg_ve[i].base_pair_reverse_cov[j];
		}
		bcvf<<endl;
	}
	bcvf.close();  
	string unprvcov = prefix + ".unpairbasereversecov";
	ofstream ucvf ( unprvcov.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_unpair_reverse_cov.empty() )
			continue;
		ucvf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
		for ( int j = 0; j < (int)ctg_ve[i].base_unpair_reverse_cov.size(); ++j )
		{
			if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					ucvf<<"\n";
				ucvf<<"\t"<<j+1<<"\t--\t";
			} else 
				ucvf<<"\t";
			ucvf<<ctg_ve[i].base_unpair_reverse_cov[j];
		}
		ucvf<<endl;
	}
	ucvf.close();
	string unprvrate = prefix + ".unpairbasereverserate";
	ofstream urvf ( unprvrate.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_unpair_reverse_rate.empty() )
			continue;
		urvf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
		for ( int j = 0; j < (int)ctg_ve[i].base_unpair_reverse_rate.size(); ++j )
		{
			if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					urvf<<"\n";
				urvf<<"\t"<<j+1<<"\t--\t";
			} else 
				urvf<<"\t";
			urvf<<setprecision(3)<<ctg_ve[i].base_unpair_reverse_rate[j];
		}
		urvf<<endl;
	}
	urvf.close();
/*	string insertsize = prefix + ".pairsizepvalue";
	ofstream itf( insertsize.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		itf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<",mean_gc_"<<ctg_ve[i].gc<<endl;
		for ( int j = 0; j < (int)ctg_ve[i].base_cov.size(); ++j )
		{
			if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					itf<<"\n";
				itf<<"\t"<<j+1<<"\t--\t";
			} else 
				itf<<"\t";
			if ( ctg_ve[i].base_insertsize_mean.find( (int)j+1 ) != ctg_ve[i].base_insertsize_mean.end() )
				itf<<setprecision(3)<<ctg_ve[i].base_insertsize_mean[(int)j+1];
			else
				itf<<"-";
		}
		itf<<endl;
	}
	itf.close(); */

	string rmprate = prefix + ".rmpvaluerate";
	ofstream rmpf ( rmprate.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_cov.empty() )
			continue;
		rmpf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
		for ( int j = 0; j < (int)ctg_ve[i].base_remarkpvalue_rate.size(); ++j )
		{
			if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					rmpf<<"\n";
				rmpf<<"\t"<<j+1<<"\t--\t";
			} else 
				rmpf<<"\t";
			rmpf<<setprecision(3)<<ctg_ve[i].base_remarkpvalue_rate[j];
		}
		rmpf<<endl;
	}
}

void calculatecovdensity_base( vector<Contig > &ctg_ve, string &output )
{
/*	string tmpf = "basecov";
	ofstream tf( tmpf.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		tf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
		for ( int j = 0; j < (int)ctg_ve[i].base_cov.size(); ++j )
		{
			if ( j % 30 == 0 )
			{
				if ( j / 30 > 0 )
					tf<<"\n";
				tf<<"\t"<<j+1<<"\t--\t";
			} else 
				tf<<"\t";
			tf<<ctg_ve[i].base_cov[j];
		}
		tf<<endl;
	}
	tf.close();
	exit(1); */
	string basecovf = output + ".basecov";
	string basematecovf = output + ".basematecov";
	ofstream bcf( basecovf.data() );
	ofstream bmcf( basematecovf.data() );
	for ( size_t i = 0; i < ctg_ve.size(); ++i )
	{
		if ( ctg_ve[i].base_cov.empty() )
			continue;
		int colomn = 100;
		if ( ctg_ve[i].length < 1000 )
			colomn = ctg_ve[i].length / 10 + 1;

		map< int, int > base_cov_density;
		for ( int j = 0; j < (int)ctg_ve[i].base_cov.size(); ++j )
		{
			int pos = ( j / colomn ) * colomn + 1;
			if ( base_cov_density.find( pos ) == base_cov_density.end() )
			{
				base_cov_density[pos] = ctg_ve[i].base_cov[j];
			} else
				base_cov_density[pos] += ctg_ve[i].base_cov[j];
		}
		for ( map<int, int >::iterator ite = base_cov_density.begin(); ite != base_cov_density.end(); ++ite )
		{
			ite->second = ite->second / colomn;
		}
		// output
		bcf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
		for ( map<int, int >::iterator ite = base_cov_density.begin(); ite != base_cov_density.end(); ++ite )
		{
			if ( (ite->first / colomn) % 10 == 0 )
			{
				if ( (ite->first / colomn) / 10 > 0 )
					bcf<<"\n";
				bcf<<"\t"<<ite->first<<"\t--\t";
			} else 
				bcf<<"\t";
			bcf<<ite->second;
			
		}
		bcf<<endl;

		map<int, int > base_mate_cov_density;
		for ( int j = 0; j < (int)ctg_ve[i].base_mate_cov.size(); ++j )
		{
			int pos = ( j / colomn ) * colomn + 1;
			if ( base_mate_cov_density.find( pos ) == base_mate_cov_density.end() )
			{
				base_mate_cov_density[pos] = ctg_ve[i].base_mate_cov[j];
			} else
				base_mate_cov_density[pos] += ctg_ve[i].base_mate_cov[j];
		}
		for ( map<int, int >::iterator ite = base_mate_cov_density.begin(); ite != base_mate_cov_density.end(); ++ite )
		{
			ite->second = ite->second / colomn;
		}
		bmcf<<">"<<ctg_ve[i].name<<",length_"<<ctg_ve[i].length<<",mean_cov_"<<ctg_ve[i].cov<<endl;
		for ( map<int, int >::iterator ite = base_mate_cov_density.begin(); ite != base_mate_cov_density.end(); ++ite )
		{
			if ( (ite->first / colomn) % 10 == 0 )
			{
				if ( (ite->first / colomn) / 10 > 0 )
					bmcf<<"\n";
				bmcf<<"\t"<<ite->first<<"\t--\t";
			} else 
				bmcf<<"\t";
			bmcf<<ite->second;
			
		}
		bmcf<<endl;
	}
	bcf.close();
	bmcf.close();
}

void exit_with_help( const char c[] )
{
	cout<<c<<endl;
	cerr <<"Usage:	CtgValidate [OPTION1] [VALUE1] [[OPTION2] [VALUE2] ...]" <<endl;
	cerr <<"Options:" <<endl;
	cerr <<"-c[string]		Contig file name" <<endl;
	cerr <<"-b[string]      Comma-seperated bowtie output files"<<endl;
	cerr <<"-o[string]		Output file name" <<endl;
	cerr <<"-l[double]		lowerbound_cov_strain[0]"<<endl;
	cerr <<"-u[double]		upperbound_cov_strain[100000]"<<endl;
	cerr <<"-s[char]        for paired-end fastq reads, the least second character[none]"<<endl;
	cerr <<"-q[double]      minimal alignment quality score[-12]"<<endl;
	exit(1);

}

int main( int argc, char* argv[] )
{
	string ctgfile;
	vector< string > bowtiefile;
	string outfile;
	double minqual = -18;
	double lower_cov = 0;
	double upper_cov = 100000;
	string s;
	
	bool paired = true;
	char spl = '/';
	for(int i=1; i<argc; i++)
	{
		if(argv[i][0] != '-')
			exit_with_help("Options must start with \'-\'.");

		if(argv[i][2] != '\0')
			exit_with_help("The option should be exactly one letter.");
		int option = argv[i][1];

		i++;
		if(i == argc)
			exit_with_help("The last option has no value.");

		switch(option)
		{
	

		case 'c':
			ctgfile = argv[i]; break;
		case 'b':
			s = argv[i];
			{
				string file = "";
				for ( size_t j = 0; j < s.size(); ++j ) {
					if ( s[j] == ',' ) {
						if ( !file.empty() ) {
							bowtiefile.push_back( file );
							file = "";
						}
					} else
						file += s[j];
				}
				if ( !file.empty() )
					bowtiefile.push_back( file );
			}
			break;

		case 'o': 
			outfile = argv[i]; break;
		case 'l':
			lower_cov = atof( argv[i] ); break;
		case 'u':
			upper_cov = atof( argv[i] ); break;
		case 's':
			spl = argv[i][0]; paired = true; break;
		case 'q':
			minqual = atof( argv[i] ); break;
		default:
			exit_with_help( "Unexpected option!" );
		}
	}

	if ( ctgfile.empty() )
		exit_with_help( "No ctg file assigned!");
	if ( bowtiefile.empty() )
		exit_with_help( "No bowtiefile assigned!" );
	if ( outfile.empty() )
		outfile = "out.fa";
	
	
	map< int, Lib > libmap;

	cout<<"read in contigs"<<endl;
	vector< Contig > ctg_ve;
	GetContigFromFile( ctgfile, ctg_ve );
	

	cout<<"read in maps from bowtie file"<<endl;
	map< string, vector<mapping_on_contig > > maps;
	for ( size_t i = 0; i < bowtiefile.size(); ++i )
	{
		readinbowtieout_pairmode( bowtiefile[i], maps, minqual, (int)i+1 );
		Lib lb;
		lb.matepair_numb = 0;
		libmap.insert( make_pair( (int)i+1, lb ) ); 
	}
	cout<<maps.size()<<endl;
	cout<<maps.begin()->first<<endl;

	double repv = 0.01;
	cout<<"CalculateCov"<<endl;
	CalculateCov( ctg_ve, maps, libmap, repv, lower_cov, upper_cov );

	int minunpaircov = 5;
	double minunpairrate = 0.3;
	double maxpvalue = 0.1;
	int minunpair_len = 100;
	int minpvalue_len = 100;
	double minpvaluerate = 0.3;
	cout<<"mark"<<endl;
	
	Mark( ctg_ve, minunpaircov, minunpairrate, minunpair_len, minpvaluerate, minpvalue_len );
	adjustmarked( ctg_ve );
	cout<<"output"<<endl;
	OutputMarked( ctg_ve, ctgfile );
//	cout<<"OutputUnpairAndInsertsize"<<endl;
//	OutputUnpairAndInsertsize( ctg_ve, ctgfile );

	cout<<"getunpairmeanandoutput"<<endl;
	getunpairmeanandoutput( ctg_ve, ctgfile );
	cout<<"end"<<endl;
	return 1;
}

