#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <stdlib.h>

using namespace std;

void process( string infile, string outfile, int minL )
{

	ifstream inf ( infile.data() );
	if ( !inf.good() ) {
		cout<<"could not open file "<<infile<<endl;  exit(1);
	}
	string line;
	string seq;
	string id;
	getline( inf, line );
	
	ofstream outf( outfile.data() );

	while(!inf.eof()){
		line = line.substr(1);
		id = "";
		for ( size_t i = 0; i < line.size(); ++i ) {
			if ( line[i] == ' ')
				break;
			id += line[i];
		}
		getline( inf,line );
		
		seq = "";
		
		while ( line.find(">") == std::string::npos )              
		{
			
			seq+=line;

			if ( inf.eof() )
				break;
			getline( inf, line);
			
		}
		
		if ( (int)seq.size() >= minL )
		{
			outf<<">"<<id<<endl;
			int k;
			for( k = 0; k < (int)seq.size()/65; k++ )
				outf << seq.substr(65*k,65) << endl;
			if ( seq.substr(65*k).size() != 0 )    //有可能最后还有一小段序列
				outf << seq.substr(65*k) << endl;
		}
		
		
	}
	
	inf.close();
	outf.close();
	
}

int main( int argc, char* argv[] )
{
	
	if ( argc != 4 )
	{
		cout<< "Usage: fastatrans contigfile (>=)minlengthofcontig outfile"<<endl;
		exit(1);
	}
	
	string infile = argv[1];
	int minL = atoi(argv[2]);
	string outfile = argv[3];
	
	process( infile, outfile, minL );
	
	return 1;
	
}




