#include <fstream>
#include <iostream>
#include <string>
#include <cstdlib>
using namespace std;

void exitwithhelp()
{
	cout<<"Usage: fastqtofasta infastqfile outfastafile"<<endl;
	exit(1);
}

int main( int argc, char* argv[] )
{

	if ( argc != 3 ) {
		exitwithhelp();
	}

	string infile = argv[1];
	string outfile = argv[2];

	ifstream inf( infile.data() );
	if( !inf.good() ) {
		cout<<"error: can not open file "<<infile<<endl; exit(1);
	}

	ofstream outf( outfile.data() );

	string line;
	getline( inf, line );

	while ( !inf.eof() ) {
		if ( line.empty() )
			break;
		if ( line[0] != '@' ) {
			cout<<"Unexpected head line: "<<endl;
			cout<<line<<endl; 
			exit(1);
		}
		string id = line.substr( 1 );

		getline( inf, line );
		string seq = line;

		getline ( inf, line );
		if ( line[0] != '+' ) {
			cout<<"Unexpected third line: "<<endl;
			cout<<line<<endl; 
			exit(1);
		}

		getline( inf, line );

		////////////output to fasta file////////////////
		outf<<">"<<id<<endl;
		outf<<seq<<endl;

		if ( inf.eof() )
			break;

		getline( inf, line );
		if ( line.empty() )
			break;

	}

	inf.close();
	outf.close();
}


