#include "ana_mapping.h"

void AssignMcoordsToCtg( Ass_Mapping &amo, Assembly_Bank &ass_bank )
{
	for ( size_t i = 0; i < amo.mcoords.size(); ++i )
	{
		string refctg = amo.mcoords[i].refname();
		if ( ass_bank.ass_subject.ctg_name_map.find( refctg ) == ass_bank.ass_subject.ctg_name_map.end() )
		{
			cout<<"error subject no ctg name "<<refctg<<endl; exit(1);
		}
		ass_bank.ass_subject.Contigs[ass_bank.ass_subject.ctg_name_map[refctg]].mapping.insert( make_pair( make_pair( amo.mcoords[i].refstart(), amo.mcoords[i].refend() ), i ) );
		string qryctg = amo.mcoords[i].qryname();
		if ( ass_bank.ass_query.ctg_name_map.find( qryctg ) == ass_bank.ass_query.ctg_name_map.end() )
		{
			cout<<"error subject no ctg name "<<qryctg<<endl; exit(1);
		}
		int start_at_qryctg = min( amo.mcoords[i].qrystart(), amo.mcoords[i].qryend() );
		int end_at_qryctg = max( amo.mcoords[i].qrystart(), amo.mcoords[i].qryend() );
		ass_bank.ass_query.Contigs[ass_bank.ass_query.ctg_name_map[qryctg]].mapping.insert( make_pair( make_pair( start_at_qryctg, end_at_qryctg ), i ) );
	}
}

void SupplementUnmappingSubjectCtg( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector< Coords >& con_mcoove )
{
	map< string, vector< pair<int, int > > > Unmappedrange;
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		vector< pair<int, int > > covered_ve;
		for ( multimap< pair<int, int >, Coords_id >::iterator ite = ass_bank.ass_subject.Contigs[i].mapping.begin();
			ite != ass_bank.ass_subject.Contigs[i].mapping.end(); ++ite )
		{
			covered_ve.push_back( ite->first );
		}
		mergerange( covered_ve );
		vector< pair<int, int > > left_ve;
		getomisrange2( covered_ve, make_pair( 1, ass_bank.ass_subject.Contigs[i].length), left_ve );
		if ( !left_ve.empty() )
			Unmappedrange.insert( make_pair( ass_bank.ass_subject.Contigs[i].name, left_ve ) );
	}

	for ( size_t i = 0; i < con_mcoove.size(); ++i )
	{
		if ( Unmappedrange.find( con_mcoove[i].qryname() ) != Unmappedrange.end() )
		{
			bool sup = false;
			for ( size_t j = 0; j < Unmappedrange[con_mcoove[i].qryname()].size(); ++j )
			{
				if ( pos_overlap( Unmappedrange[con_mcoove[i].qryname()][j], orderrange( make_pair( con_mcoove[i].qrystart(), con_mcoove[i].qryend() ) ) ) )
				{
					sup = true;
					break;
				}
			}
			if ( sup )
			{
				con_mcoove[i].reverse();
				amo.mcoords.push_back( con_mcoove[i] );
				Coords_id cooid = amo.mcoords.size()-1;
				ass_bank.ass_subject.Contigs[ass_bank.ass_subject.ctg_name_map[con_mcoove[i].refname()]].mapping.insert( make_pair( make_pair( con_mcoove[i].refstart(),
					con_mcoove[i].refend() ), cooid ) );
				ass_bank.ass_query.Contigs[ass_bank.ass_query.ctg_name_map[con_mcoove[i].qryname()]].mapping.insert( 
					make_pair( orderrange( make_pair( con_mcoove[i].qrystart(), con_mcoove[i].qryend() ) ), cooid ) );
			//	cout<<"sup:"<<con_mcoove[i].refname()<<","<<con_mcoove[i].refstart()<<","<<con_mcoove[i].refend()<<endl; 
			}
		}
	}
}

void findrepeatCoords( Ass_Mapping &amo, Assembly_Bank &ass_bank )
{
	ofstream logf("findrepeat_Log");
	cout<<"go find subject ctg "<<endl;
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		
	//	cout<<i<<endl;
		logf<<"subjctg"<<i<<" "<<ass_bank.ass_subject.Contigs[i].name<<endl;
		set< pair<int, int > > fdrepeat;
		for ( multimap< pair<int, int >, Coords_id >::iterator ite = ass_bank.ass_subject.Contigs[i].mapping.begin();
			ite != ass_bank.ass_subject.Contigs[i].mapping.end(); ++ite )
		{
			logf<<"@"<<ite->first.first<<","<<ite->first.second<<","<<ite->second<<endl;
			if ( fdrepeat.find( ite->first ) != fdrepeat.end() )
				continue;
			
			bool rp = false;
			vector< multimap< pair<int, int >, Coords_id >::iterator > iteve;
			for ( multimap< pair<int, int >, Coords_id >::iterator secite = ass_bank.ass_subject.Contigs[i].mapping.begin();
				secite != ass_bank.ass_subject.Contigs[i].mapping.end(); ++secite )
			{
				if ( secite == ite )
					continue;
				if ( secite->first == ite->first )
				{
					rp = true;
					iteve.push_back( secite );
					continue;
				} else if ( secite->first.first <= ite->first.first && secite->first.second >= ite->first.second )
				{
					rp = true;
					iteve.push_back( secite );
				}
			}
			if ( rp )
			{
				logf<<"Repeat!"<<endl;
				RepeatRegionCluster rc;
				RepeatRegion refrr;
				
				refrr.cid = i;
				refrr.cooid = ite->second;
				
				refrr.partial = false;
				refrr.rg = ite->first;
				logf<<"refrr:"<<ass_bank.ass_subject.Contigs[i].name<<","<<ite->second<<","<<refrr.partial<<","<<ite->first.first<<","<<ite->first.second<<endl;
				
				RepeatRegion qryrr;
				qryrr.cid = ass_bank.ass_query.ctg_name_map[amo.mcoords[ite->second].qryname()];
				qryrr.cooid = ite->second;
				
				qryrr.partial = false;
				qryrr.rg = orderrange( make_pair(amo.mcoords[ite->second].qrystart(), amo.mcoords[ite->second].qryend() ) );
				logf<<"qryrr:"<<amo.mcoords[ite->second].qryname()<<","<<qryrr.cooid<<","<<qryrr.partial<<","<<qryrr.rg.first<<","<<qryrr.rg.second<<endl;
				rc.qry_ve.push_back( qryrr );
				
				int ref_len = refrr.rg.second-refrr.rg.first+1;
				logf<<"ref_len:"<<ref_len<<endl;
				for ( size_t j = 0; j < iteve.size(); ++j )
				{
					if ( (iteve[j])->first == ite->first )
					{
						RepeatRegion qryrr2;
						qryrr2.cid = ass_bank.ass_query.ctg_name_map[amo.mcoords[(iteve[j])->second].qryname()];
						qryrr2.cooid = (iteve[j])->second;
						
						qryrr2.partial = false;
						qryrr2.rg = orderrange( make_pair(amo.mcoords[(iteve[j])->second].qrystart(), amo.mcoords[(iteve[j])->second].qryend() ) );
						logf<<"add qryrr2:"<<amo.mcoords[(iteve[j])->second].qryname()<<","<<qryrr2.cooid<<","<<qryrr2.partial<<","<<qryrr2.rg.first<<","<<qryrr2.rg.second<<endl;
						rc.qry_ve.push_back( qryrr2 );
					} else
					{
						int this_ref_len = (iteve[j])->first.second-(iteve[j])->first.first+1;
						if ( this_ref_len > ref_len )
						{
							refrr.cooid = (iteve[j])->second;
							refrr.partial = true;
							ref_len = this_ref_len;
							logf<<"replace refrr: ref_len"<<ref_len<<", cooid"<<refrr.cooid<<endl;
						}
						RepeatRegion qryrr2;
						qryrr2.cid = ass_bank.ass_query.ctg_name_map[amo.mcoords[(iteve[j])->second].qryname()];
						qryrr2.cooid = (iteve[j])->second;
						qryrr2.partial = true;
						qryrr2.rg = findcorrespondregion_forqry( amo.mcoords[(iteve[j])->second], ite->first );
						logf<<"add qryrr2:"<<amo.mcoords[(iteve[j])->second].qryname()<<","<<qryrr2.cooid<<","<<qryrr2.partial<<","<<qryrr2.rg.first<<","<<qryrr2.rg.second<<endl;
						rc.qry_ve.push_back( qryrr2 );
					}
				}
				rc.ref_ve.push_back( refrr );
				fdrepeat.insert( ite->first );
				logf<<"Add Repeat"<<endl;
				amo.Repeats.push_back( rc );
				Repeat_id rid = amo.Repeats.size()-1;
				ass_bank.ass_subject.Contigs[i].repeat.insert( make_pair( ite->first , rid ) );
				for ( size_t k = 0; k < rc.qry_ve.size(); ++k )
				{
					ass_bank.ass_query.Contigs[rc.qry_ve[k].cid].repeat.insert( make_pair( rc.qry_ve[k].rg, rid ) );
				}
				logf<<"Add Repeat Complete"<<endl;
			} else
			{
				logf<<"Not repeat!"<<endl;
			}
		}

		
		
	}
	cout<<"go find query ctg "<<endl;
	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
	//	cout<<"i"<<endl;
		logf<<"queryctg"<<i<<" "<<ass_bank.ass_query.Contigs[i].name<<endl;
		
		set< pair<int, int > > fdrepeat;
		
		for ( multimap< pair<int, int >, Coords_id >::iterator ite = ass_bank.ass_query.Contigs[i].mapping.begin();
			ite != ass_bank.ass_query.Contigs[i].mapping.end(); ++ite )
		{
			
			logf<<"@"<<ite->first.first<<","<<ite->first.second<<","<<ite->second<<endl;
			
			if ( fdrepeat.find( ite->first ) != fdrepeat.end() )
				continue;
			bool rp = false;
			vector< multimap< pair<int, int >, Coords_id >::iterator > iteve;
			for ( multimap< pair<int, int >, Coords_id >::iterator secite = ass_bank.ass_query.Contigs[i].mapping.begin();
				secite != ass_bank.ass_query.Contigs[i].mapping.end(); ++secite)
			{
				if ( secite == ite )
					continue;
				if ( secite->first == ite->first )
				{
					rp = true;
					iteve.push_back( secite );
					continue;
				} else if ( secite->first.first <= ite->first.first && secite->first.second >= ite->first.second )
				{
					rp = true;
					iteve.push_back( secite );
				}
			}
			if ( rp )
			{
				logf<<"Repeat!"<<endl;
				int rplen = ite->first.second-ite->first.first + 1;
				// check the repeat be marked by subject.
				bool mk = false;
				Repeat_id mkrid;
				size_t mkqryrepeat_key;
				if ( !ass_bank.ass_query.Contigs[i].repeat.empty() )
				{
					for ( map< pair<int, int >, Repeat_id >::iterator si = ass_bank.ass_query.Contigs[i].repeat.begin(); 
						si != ass_bank.ass_query.Contigs[i].repeat.end(); ++si )
					{
						if ( pos_overlap( ite->first, si->first ) )
						{
							Repeat_id rid = si->second;
							bool fd_r = false;
							for ( size_t k = 0; k < amo.Repeats[rid].qry_ve.size(); ++k )
							{
								if ( amo.Repeats[rid].qry_ve[k].cooid == ite->second )
								{
									fd_r = true;
									mkqryrepeat_key = k;
									break;
								}
							}
							if ( fd_r )
							{
								mk = true;
								mkrid = rid;
								break;
							}
						}
					}
				}
				if ( mk )
				{
					logf<<"Marked! mkrid:"<<mkrid<<endl;
					set< Coords_id > refidset;
					for ( size_t k = 0; k < amo.Repeats[mkrid].ref_ve.size(); ++k )
					{
						refidset.insert( amo.Repeats[mkrid].ref_ve[k].cooid ); 
					}
					for ( size_t j = 0; j < iteve.size(); ++j )
					{
						if ( refidset.find( (iteve[j])->second ) != refidset.end() )
							continue;
						if ( (iteve[j])->first == ite->first )
						{
							RepeatRegion refrr2;
							refrr2.cid = ass_bank.ass_subject.ctg_name_map[amo.mcoords[(iteve[j])->second].refname()];
							refrr2.cooid = (iteve[j])->second;
						
							refrr2.partial = false;
							refrr2.rg = make_pair(amo.mcoords[(iteve[j])->second].refstart(), amo.mcoords[(iteve[j])->second].refend() ) ;
							amo.Repeats[mkrid].ref_ve.push_back( refrr2 );
							logf<<"add refrr2:"<<amo.mcoords[(iteve[j])->second].refname()<<","<<refrr2.cooid<<","<<refrr2.partial<<","<<refrr2.rg.first<<","<<refrr2.rg.second<<endl;
							ass_bank.ass_subject.Contigs[refrr2.cid].repeat.insert( make_pair( refrr2.rg, mkrid ) );
						} else
						{
							int this_ref_len = (iteve[j])->first.second-(iteve[j])->first.first+1;
							if ( this_ref_len > rplen )
							{
								amo.Repeats[mkrid].qry_ve[mkqryrepeat_key].cooid = (iteve[j])->second;
								amo.Repeats[mkrid].qry_ve[mkqryrepeat_key].partial = true;
								rplen = this_ref_len;
								logf<<"replace qryrr: rplen "<<rplen<<", cooid "<<(iteve[j])->second<<endl;
							}
							RepeatRegion refrr2;
							refrr2.cid = ass_bank.ass_subject.ctg_name_map[amo.mcoords[(iteve[j])->second].refname()];
							refrr2.cooid = (iteve[j])->second;
						
							refrr2.partial = true;
							refrr2.rg = findcorrespondregion_forref( amo.mcoords[(iteve[j])->second], ite->first );
							amo.Repeats[mkrid].ref_ve.push_back( refrr2 );
							logf<<"add refrr2:"<<amo.mcoords[(iteve[j])->second].refname()<<","<<refrr2.cooid<<","<<refrr2.partial<<","<<refrr2.rg.first<<","<<refrr2.rg.second<<endl;
							ass_bank.ass_subject.Contigs[refrr2.cid].repeat.insert( make_pair( refrr2.rg, mkrid ) );
						}
					}

					fdrepeat.insert( ite->first );

				} else
				{
					logf<<"Not Marked!"<<endl;
					RepeatRegionCluster rc;
					RepeatRegion qryrr;
				
					qryrr.cid = i;
					qryrr.cooid = ite->second;
					qryrr.partial = false;
					qryrr.rg = ite->first;
					logf<<"qryrr:"<<ass_bank.ass_query.Contigs[qryrr.cid].name<<","<<qryrr.cooid<<","<<qryrr.partial<<","<<qryrr.rg.first<<","<<qryrr.rg.second<<endl;
					RepeatRegion refrr;
					refrr.cid = ass_bank.ass_subject.ctg_name_map[amo.mcoords[ite->second].refname()];
					refrr.cooid = ite->second;
				
					refrr.partial = false;
					refrr.rg = make_pair(amo.mcoords[ite->second].refstart(), amo.mcoords[ite->second].refend() );
					logf<<"refrr:"<<amo.mcoords[ite->second].refname()<<","<<refrr.cooid<<","<<refrr.partial<<","<<refrr.rg.first<<","<<refrr.rg.second<<endl;
					rc.ref_ve.push_back( refrr );
					
					for ( size_t j = 0; j < iteve.size(); ++j )
					{
						if ( (iteve[j])->first == ite->first )
						{
							RepeatRegion refrr2;
							refrr2.cid = ass_bank.ass_subject.ctg_name_map[amo.mcoords[(iteve[j])->second].refname()];
							refrr2.cooid = (iteve[j])->second;
							refrr2.partial = false;
							refrr2.rg = make_pair(amo.mcoords[(iteve[j])->second].refstart(), amo.mcoords[(iteve[j])->second].refend() );
							logf<<"add refrr2:"<<amo.mcoords[(iteve[j])->second].refname()<<","<<refrr2.cooid<<","<<refrr2.partial<<","<<refrr2.rg.first<<","<<refrr2.rg.second<<endl;
							rc.ref_ve.push_back( refrr2 );
						} else
						{
							int this_ref_len = (iteve[j])->first.second-(iteve[j])->first.first+1;
							if ( this_ref_len > rplen )
							{
								qryrr.cooid = (iteve[j])->second;
								qryrr.partial = true;
								rplen = this_ref_len;
								logf<<"replace qryrr: rplen "<<rplen<<", cooid "<<(iteve[j])->second<<endl;
							}
							RepeatRegion refrr2;
							refrr2.cid = ass_bank.ass_subject.ctg_name_map[amo.mcoords[(iteve[j])->second].refname()];
							refrr2.cooid = (iteve[j])->second;
						
							refrr2.partial = true;
							refrr2.rg = findcorrespondregion_forref( amo.mcoords[(iteve[j])->second], ite->first );
							logf<<"add refrr2:"<<amo.mcoords[(iteve[j])->second].refname()<<","<<refrr2.cooid<<","<<refrr2.partial<<","<<refrr2.rg.first<<","<<refrr2.rg.second<<endl;
							rc.ref_ve.push_back( refrr2 );
						}
					}
					logf<<"Add Repeat"<<endl;
					rc.qry_ve.push_back( qryrr );
					fdrepeat.insert( ite->first );

					amo.Repeats.push_back( rc );
					Repeat_id rid = amo.Repeats.size()-1;
					ass_bank.ass_query.Contigs[i].repeat.insert( make_pair( ite->first , rid ) );
					for ( size_t k = 0; k < rc.ref_ve.size(); ++k )
					{
						ass_bank.ass_subject.Contigs[rc.ref_ve[k].cid].repeat.insert( make_pair( rc.ref_ve[k].rg, rid ) );
					}
					logf<<"Add Repeat Complete"<<endl;
				}
			}
		}
	}


	// get repeat region
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		for ( map< pair<int, int >, Repeat_id >::iterator ite = ass_bank.ass_subject.Contigs[i].repeat.begin(); 
			ite != ass_bank.ass_subject.Contigs[i].repeat.end(); ++ite )
		{
			ass_bank.ass_subject.Contigs[i].repeat_region.push_back( ite->first );
		}
		mergerange( ass_bank.ass_subject.Contigs[i].repeat_region );
	}
	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
		for ( map< pair<int, int >, Repeat_id >::iterator ite = ass_bank.ass_query.Contigs[i].repeat.begin(); 
			ite != ass_bank.ass_query.Contigs[i].repeat.end(); ++ite )
		{
			ass_bank.ass_query.Contigs[i].repeat_region.push_back( ite->first );
		}
		mergerange( ass_bank.ass_query.Contigs[i].repeat_region );
	}
}

pair<int, int > findcorrespondregion_forqry( Coords &coo, pair<int, int > refrg )
{
	bool forward = true;
	if ( coo.qryend() < coo.qrystart() )
		forward = false;
	if ( refrg.first < coo.refstart() )
	{
		cout<<"error refrg begin "<<refrg.first<<", "<<coo.refstart()<<endl; exit(1);
	}
	if ( refrg.second > coo.refend() )
	{
		cout<<"error refrg end "<<refrg.second<<", "<<coo.refend()<<endl; exit(1);
	}
	int left_diff = refrg.first - coo.refstart();
	int right_diff = coo.refend() - refrg.second;
	int rstart, rend;
	if ( forward )
	{
		rstart = coo.qrystart() + left_diff;
		rend = coo.qryend() - right_diff;
	} else
	{
		rstart = coo.qryend() + right_diff;
		rend = coo.qrystart() - left_diff;
	}
	return make_pair( rstart, rend );

}

pair<int, int > findcorrespondregion_forref( Coords &coo, pair<int, int > qryrg )
{
	bool forward = true;
	if ( coo.qryend() < coo.qrystart() )
		forward = false;
	int left_diff = qryrg.first - coo.qrystart();
	if ( !forward )
		left_diff = qryrg.first - coo.qryend();
	int right_diff = coo.qryend() - qryrg.second;
	if ( !forward )
		right_diff = coo.qrystart() - qryrg.second;
	int rstart, rend;
	rstart = coo.refstart() + left_diff;
	rend = coo.refend() - right_diff;
	return make_pair( rstart, rend );
}

void outputRepeat( Ass_Mapping& amo, Assembly_Bank &ass_bank )
{
	ofstream rf( "repeat" );
	rf<<"#repeat feature: ctg_id,coords_id,if_partial,region_fisrt,region_second"<<endl;
	for ( size_t i = 0; i < amo.Repeats.size(); ++i )
	{
		rf<<">R"<<i<<endl;
		rf<<"@ref:"<<endl;
		for ( size_t j = 0; j < amo.Repeats[i].ref_ve.size(); ++j )
		{
			rf<<ass_bank.ass_subject.Contigs[amo.Repeats[i].ref_ve[j].cid].name<<","<<amo.Repeats[i].ref_ve[j].cooid<<","<<amo.Repeats[i].ref_ve[j].partial<<","
				<<amo.Repeats[i].ref_ve[j].rg.first<<","<<amo.Repeats[i].ref_ve[j].rg.second<<endl;
		}
		rf<<"@qry:"<<endl;
		for( size_t j = 0; j < amo.Repeats[i].qry_ve.size(); ++j )
		{
			rf<<ass_bank.ass_query.Contigs[amo.Repeats[i].qry_ve[j].cid].name<<","<<amo.Repeats[i].qry_ve[j].cooid<<","<<amo.Repeats[i].qry_ve[j].partial<<","
				<<amo.Repeats[i].qry_ve[j].rg.first<<","<<amo.Repeats[i].qry_ve[j].rg.second<<endl;
		}
	}
	rf.close();
	ofstream rcf( "repeat_on_ctg" );
	rcf<<"**Subject Ass"<<endl;
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		if ( !ass_bank.ass_subject.Contigs[i].repeat.empty() )
		{
			rcf<<">"<<ass_bank.ass_subject.Contigs[i].name<<endl;
			for ( map< pair<int, int >, Repeat_id >::iterator ite = ass_bank.ass_subject.Contigs[i].repeat.begin();
				ite != ass_bank.ass_subject.Contigs[i].repeat.end(); ++ite )
			{
				rcf<<ite->first.first<<","<<ite->first.second<<","<<ite->second<<endl;
			}
		}
	}
	rcf<<"**Query Ass"<<endl;
	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
		if ( !ass_bank.ass_query.Contigs[i].repeat.empty() )
		{
			rcf<<">"<<ass_bank.ass_query.Contigs[i].name<<endl;
			for ( map< pair<int, int >, Repeat_id >::iterator ite = ass_bank.ass_query.Contigs[i].repeat.begin();
				ite != ass_bank.ass_query.Contigs[i].repeat.end(); ++ite )
			{
				rcf<<ite->first.first<<","<<ite->first.second<<","<<ite->second<<endl;
			}
		}
	}
	rcf.close();
}

void uniq_mapping_range_f( Contig &ctg )
{
	set< pair<int, int > > sole_range;
 	for ( multimap< pair<int, int >, Coords_id >::iterator ite = ctg.mapping.begin(); 
		ite != ctg.mapping.end(); ++ite )
	{
		sole_range.insert( ite->first );
	}
	for ( set< pair< int, int > >::iterator si = sole_range.begin(); si != sole_range.end(); ++si )
	{
		if ( ctg.repeat.find( *si ) != ctg.repeat.end() )
		{
			bool incontain = false;;
			for ( set< pair< int, int > >::iterator sec_si = sole_range.begin(); sec_si != sole_range.end(); ++sec_si )
			{
				if ( sec_si == si )
					continue;
				if ( si->first >= sec_si->first && si->second <= sec_si->second )
				{
					incontain = true;
					break;
				}
			}
			if ( incontain )
				continue;
		}

		ctg.uni_mapping_range.push_back( *si );
	}
}

void uniq_mapping_range( Assembly_Bank &ass_bank )
{
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		uniq_mapping_range_f( ass_bank.ass_subject.Contigs[i] );
	}
	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
		uniq_mapping_range_f( ass_bank.ass_query.Contigs[i] );
	}
}

void protect_good_ctg_t( Contig &ctg )
{

	ctg.good_protect = false;
/*	vector< pair< int, int > > mapping_range = ctg.uni_mapping_range;
	mergerange( mapping_range );
	int mapping_len = 0;
	int max_len = 0;
	for ( size_t i = 0; i < ctg.uni_mapping_range.size(); ++i )
	{
		int l = ctg.uni_mapping_range[i].second - ctg.uni_mapping_range[i].first + 1;
		mapping_len += l;
		if ( max_len < l )
			max_len = l;
	}
	if ( ( (double)max_len / ctg.length < 0.1 || (double)mapping_len / ctg.length < 0.5 ) && ctg.length >= 3000 )
	{
		ctg.good_protect = true;
	} else
		ctg.good_protect = false; */
}

void protect_good_ctg( Assembly_Bank &ass_bank )
{
	ofstream outf("goodprotectctg");
	outf<<"*Subject"<<endl;
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		
		protect_good_ctg_t( ass_bank.ass_subject.Contigs[i] );
		if ( ass_bank.ass_subject.Contigs[i].good_protect )
			outf<<ass_bank.ass_subject.Contigs[i].name<<endl;
	}
	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
		protect_good_ctg_t( ass_bank.ass_query.Contigs[i] );
		if ( ass_bank.ass_query.Contigs[i].good_protect )
			outf<<ass_bank.ass_query.Contigs[i].name<<endl;
	}
}

void check_break_by_validat_f( Contig &ctg )
{
	if ( ctg.uni_mapping_range.empty() )
	{
		return;
	}

	////////////////////good proctect means the ctg is good enough to defend the suspicous validation

	// ini
	ctg.unmaplink.clear();
	for ( size_t i = 0; i < ctg.uni_mapping_range.size(); ++i )
	{
		ctg.unmaplink.push_back( make_pair( false, false ) );
	}

	if ( ctg.uni_mapping_range[0].first > 300 )
	{
		int front = max( 1, ctg.uni_mapping_range[0].first - 200 );
		int end = min( ctg.length, ctg.uni_mapping_range[0].first + 200 );
		bool fd_suspicious = false;
		if ( !ctg.good_protect )
		{
			for ( size_t j = 0; j < ctg.suspicious_range.size(); ++j )
			{
				if ( pos_overlap( front-1, end, ctg.suspicious_range[j].first-1, ctg.suspicious_range[j].second ) )
				{
					fd_suspicious = true;
					break;
				}
			}
		}
		if ( !fd_suspicious )
		{
			ctg.unmaplink[0].first = true;
		}
	}


	ctg.break_by_validate.clear();
	for ( size_t i = 0; i < ctg.uni_mapping_range.size()-1; ++i )
	{
		int left_b = ctg.uni_mapping_range[i].second;
		int right_b = ctg.uni_mapping_range[i+1].first;
		bool long_overlap = false;
		bool long_gap = false;
		int long_left_b = max( 1, left_b-100 );
		int long_right_b = min( ctg.length, right_b + 100 );
		if ( ctg.uni_mapping_range[i+1].first - ctg.uni_mapping_range[i].second > 0 )
		{
		//	cout<<"gapped: "<<ctg.name<<", "<<ctg.uni_mapping_range[i].second<<","<<ctg.uni_mapping_range[i+1].first<<endl;
			if ( ctg.uni_mapping_range[i+1].first - ctg.uni_mapping_range[i].second >= 400 )
				long_gap = true;
			left_b = max( 1, left_b-100 );
			right_b = min( ctg.length, right_b + 100 );
		} else
		{
			if ( ctg.uni_mapping_range[i].second - ctg.uni_mapping_range[i+1].first >= 500 )
				long_overlap = true;
			if ( ctg.uni_mapping_range[i].second - ctg.uni_mapping_range[i+1].first < 100 )
			{
				left_b = max( 1, ctg.uni_mapping_range[i].second - 100 );
				right_b = min( ctg.length, ctg.uni_mapping_range[i+1].first + 100 );
			} else
			{
				left_b = ctg.uni_mapping_range[i+1].first;
				right_b = ctg.uni_mapping_range[i].second;
			}
		}
		if ( long_gap )
		{
			ctg.break_by_validate.push_back( true );

			int front = max( 1, ctg.uni_mapping_range[i].second - 200 );
			int end = min( ctg.length, ctg.uni_mapping_range[i].second + 200 );
			bool fd_suspicious = false;
			if ( !ctg.good_protect )
			{
				for ( size_t j = 0; j < ctg.suspicious_range.size(); ++j )
				{
					if ( pos_overlap( front-1, end, ctg.suspicious_range[j].first-1, ctg.suspicious_range[j].second ) )
					{
						fd_suspicious = true;
						break;
					}
				}
			}
			if ( !fd_suspicious )
			{
				ctg.unmaplink[i].second = true;
			}

			front = max( 1, ctg.uni_mapping_range[i+1].first - 200 );
			end = min( ctg.length, ctg.uni_mapping_range[i+1].first + 200 );
			fd_suspicious = false;
			if ( !ctg.good_protect )
			{
				for ( size_t j = 0; j < ctg.suspicious_range.size(); ++j )
				{
					if ( pos_overlap( front-1, end, ctg.suspicious_range[j].first-1, ctg.suspicious_range[j].second ) )
					{
						fd_suspicious = true;
						break;
					}
				}
			}
			if ( !fd_suspicious )
			{
				ctg.unmaplink[i+1].first = true;
			}

			continue;
		}
		pair<int, int > g_range = make_pair( left_b, right_b );
		bool fd_suspicious = false;
		if ( !ctg.good_protect )
		{
			if ( !long_overlap )
			{
				if ( !ctg.suspicious_range.empty() )
				{
				//	cout<<"gr: "<<g_range.first<<","<<g_range.second<<endl;
					for ( size_t j = 0; j < ctg.suspicious_range.size(); ++j )
					{
					
						if ( pos_overlap( g_range.first-1, g_range.second, ctg.suspicious_range[j].first-1, ctg.suspicious_range[j].second ) )
						{
						//	cout<<"gr: "<<g_range.first<<","<<g_range.second<<" break ctg "
						//		<<ctg.name<<" "<<ctg.uni_mapping_range[i].second<<" "<<ctg.uni_mapping_range[i+1].first<<endl;
							fd_suspicious = true;
							break;
						}
					}
				}
				if ( !ctg.repeat_region.empty() )
				{
					for ( size_t j = 0; j < ctg.repeat_region.size(); ++j )
					{
						if ( ctg.repeat_region[j].first <= long_left_b && ctg.repeat_region[j].second >= long_right_b )
						{
						//	cout<<"repeat break: "<<long_left_b<<","<<long_right_b<<" break ctg "
						//		<<ctg.name<<" "<<ctg.uni_mapping_range[i].second<<" "<<ctg.uni_mapping_range[i+1].first<<endl;
							fd_suspicious = true;
							break;
						}
					}
				}
			}
		}
		if ( fd_suspicious )
			ctg.break_by_validate.push_back( true );
		else
			ctg.break_by_validate.push_back( false );
	}

	size_t rs = ctg.uni_mapping_range.size()-1;
	if ( ctg.length - ctg.uni_mapping_range[rs].second >= 300 )
	{
		int front = max( 1, ctg.uni_mapping_range[rs].second - 200 );
		int end = min( ctg.length, ctg.uni_mapping_range[rs].second + 200 );
		bool fd_suspicious = false;
		for ( size_t j = 0; j < ctg.suspicious_range.size(); ++j )
		{
			if ( pos_overlap( front-1, end, ctg.suspicious_range[j].first-1, ctg.suspicious_range[j].second ) )
			{
				fd_suspicious = true;
				break;
			}
		}
		if ( !fd_suspicious )
		{
			ctg.unmaplink[rs].second = true;
		}
	}

}

void check_break_by_validat( Assembly_Bank &ass_bank )
{
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		
		check_break_by_validat_f( ass_bank.ass_subject.Contigs[i] );
	}
	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
		
		check_break_by_validat_f( ass_bank.ass_query.Contigs[i] );
	}
}

double calculateEdgeUprate( Contig &ctg, int pos1_onctg, int pos2_onctg )
{
//	cout<<"ctgname: "<<ctg.name<<", pos1:"<<pos1_onctg<<", pos2:"<<pos2_onctg<<endl;
	int pos_front = min( pos1_onctg, pos2_onctg );
	int pos_back = max( pos1_onctg, pos2_onctg );
	set< double, greater<double > > values;
	int k_front = pos_front / 100;
	int k_back = pos_back / 100;
	int k_start = k_front - 1;
//	cout<<k_start<<","<<k_back<<endl;
	for ( int k = k_start; k < k_back; ++k )
	{
		if ( ctg.fwup_rate_map.find( k ) != ctg.fwup_rate_map.end() )
			values.insert( ctg.fwup_rate_map[k] );
	}
	if ( k_back-1 >= 0 )
	{
		double v_1 = 0;
		if ( ctg.fwup_rate_map.find( k_back-1 ) != ctg.fwup_rate_map.end() )
			v_1 = ctg.fwup_rate_map[k_back-1];
		double v_2 = 0;
		if ( ctg.fwup_rate_map.find( k_back ) != ctg.fwup_rate_map.end() )
			v_2 = ctg.fwup_rate_map[k_back];
		double v = (v_1+v_2) / 2;
		values.insert( v );
	} else
	{
		double v_2 = 0;
		if ( ctg.fwup_rate_map.find( k_back ) != ctg.fwup_rate_map.end() )
			v_2 = ctg.fwup_rate_map[k_back];
		values.insert( v_2 );
	}

	int k_end = k_back+1;
	for ( int k = k_front+1; k < k_end; ++k )
	{
		if ( ctg.rvup_rate_map.find(k ) != ctg.rvup_rate_map.end() )
		{
			values.insert( ctg.rvup_rate_map[k] );
		}
	}
	int maxk = ctg.length / 100;
	if ( k_front < maxk )
	{
		double v_1 = 0;
		if ( ctg.rvup_rate_map.find( k_front ) != ctg.rvup_rate_map.end() )
			v_1 = ctg.rvup_rate_map[k_front];
		double v_2 = 0;
		if ( ctg.rvup_rate_map.find( k_front+1 ) != ctg.rvup_rate_map.end() )
			v_2 = ctg.rvup_rate_map[k_front+1];
		double v = (v_1+v_2) / 2;
		values.insert( v );
	} else
	{
		double v_1 = 0;
		if ( ctg.rvup_rate_map.find( k_front ) != ctg.rvup_rate_map.end() )
			v_1 = ctg.rvup_rate_map[k_front];
		values.insert( v_1 );
	}
	double vv = *values.begin();
//	cout<<vv<<endl;
	return vv;
}

void get_1coord_edge( Ass_Mapping &amo, Assembly_Bank &ass_bank, int s_rank )
{
	ofstream logf("get_1coord_edge_log");
	map< Coords_id, vector<size_t > > coords_in_edge_map;
	map< Coords_id, vector<size_t > > coords_out_edge_map;
	map< Coords_id, pair< bool, Ctg_id > > coords_in_unmap_link;   // < subject, ctg >
	map< Coords_id, pair< bool, Ctg_id > > coords_out_unmap_link;  // < subject, ctg >
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{

		if ( (int)ass_bank.ass_subject.Contigs[i].uni_mapping_range.size() >= 1 )
		{
			// first check _1coordset including nonrepeat and the repeat between the nonrepeats. 
			set< size_t > _1coordset;
			// first nonrepeat
			for ( size_t j = 0; j < ass_bank.ass_subject.Contigs[i].uni_mapping_range.size(); ++j ) 
			{
				pair<int, int > range = ass_bank.ass_subject.Contigs[i].uni_mapping_range[j];
				if ( ass_bank.ass_subject.Contigs[i].repeat.find( range ) == ass_bank.ass_subject.Contigs[i].repeat.end() )
					_1coordset.insert( j );
			}
			// then the repeat between the nonrepeats.
			for ( size_t j = 0; j < ass_bank.ass_subject.Contigs[i].uni_mapping_range.size(); ++j )
			{
				if ( _1coordset.find( j ) == _1coordset.end() )
				{
					bool left_b = false;
					bool right_b = false;
					size_t left_s = j;
					while ( left_s > 0 )
					{
						--left_s;
						if ( ass_bank.ass_subject.Contigs[i].break_by_validate[left_s] )
							break;
						if ( _1coordset.find( left_s ) != _1coordset.end() )
						{
							left_b = true;
							break;
						}
					}
					size_t right_s = j;
					while ( right_s < ass_bank.ass_subject.Contigs[i].uni_mapping_range.size()-1 )
					{
						if ( ass_bank.ass_subject.Contigs[i].break_by_validate[right_s] )
							break;
						++right_s;
						if ( _1coordset.find( right_s ) != _1coordset.end() )
						{
							right_b = true;
							break;
						}
					}
					if ( left_b && right_b )
						_1coordset.insert( j );
				}
			}

			logf<<">ref "<<ass_bank.ass_subject.Contigs[i].name<<endl;
			logf<<"_1coordset: ";
			for ( set< size_t >::iterator ji = _1coordset.begin(); ji != _1coordset.end(); ++ji )
				logf<<" "<<*ji;
			logf<<endl;
			if ( ass_bank.ass_subject.Contigs[i].uni_mapping_range.size() >= 1 )
			{
				for ( size_t j = 0; j < ass_bank.ass_subject.Contigs[i].uni_mapping_range.size(); ++j )
				{
					if ( _1coordset.find( j ) != _1coordset.end() )
					{
						pair<int, int > left_range = ass_bank.ass_subject.Contigs[i].uni_mapping_range[j];
						Coords_id left_coo = ass_bank.ass_subject.Contigs[i].mapping.lower_bound( left_range )->second;
						amo.ref_1coord_set.insert( left_coo );
						logf<<"add "<<left_coo<<endl;
					}
				}
			}

			for ( size_t j = 0; j < ass_bank.ass_subject.Contigs[i].uni_mapping_range.size()-1; ++j )
			{
				if ( ass_bank.ass_subject.Contigs[i].break_by_validate[j] )
					continue;
				pair<int, int > left_range = ass_bank.ass_subject.Contigs[i].uni_mapping_range[j];
				pair< int, int > right_range = ass_bank.ass_subject.Contigs[i].uni_mapping_range[j+1];
				if ( ass_bank.ass_subject.Contigs[i].mapping.lower_bound( left_range ) == ass_bank.ass_subject.Contigs[i].mapping.end() )
				{
					cout<<"error ass_bank.ass_subject.Contigs[i].mapping not find "<<left_range.first<<","<<left_range.second<<endl; exit(1);
				}
				if ( ass_bank.ass_subject.Contigs[i].mapping.lower_bound( right_range ) == ass_bank.ass_subject.Contigs[i].mapping.end() )
				{
					cout<<"error ass_bank.ass_subject.Contigs[i].mapping not find "<<right_range.first<<","<<right_range.second<<endl; exit(1);
				}
				Coords_id left_coo = ass_bank.ass_subject.Contigs[i].mapping.lower_bound( left_range )->second;
				Coords_id right_coo = ass_bank.ass_subject.Contigs[i].mapping.lower_bound( right_range )->second;
				
				Edge edge;
				edge.coo_left = left_coo;
				edge.coo_right = right_coo;
				edge.ctg = i;
				edge.break_point = j;
				edge.subjass = true;
				edge.left_inorout = true;
				edge.right_inorout = false;
				edge.length = right_range.first - left_range.second - 1;
				edge.uprate = calculateEdgeUprate( ass_bank.ass_subject.Contigs[i], left_range.second, right_range.first );
				amo._1coord_edge.push_back( edge );
				size_t eid = amo._1coord_edge.size() - 1;
				if ( _1coordset.find( j ) != _1coordset.end() && _1coordset.find( j + 1 ) != _1coordset.end()  )
				{
				
					coords_in_edge_map[left_coo].push_back( eid );
					coords_out_edge_map[right_coo].push_back( eid );
				} else if ( _1coordset.find( j ) != _1coordset.end() )
				{
				
				
					coords_in_edge_map[left_coo].push_back( eid );
				
				} else if ( _1coordset.find( j+1 ) != _1coordset.end() ) 
				{
				
					coords_out_edge_map[right_coo].push_back( eid );
				
				}
			}

			for ( size_t j = 0; j < ass_bank.ass_subject.Contigs[i].uni_mapping_range.size(); ++j )
			{
				Coords_id coo = ass_bank.ass_subject.Contigs[i].mapping.lower_bound( ass_bank.ass_subject.Contigs[i].uni_mapping_range[j] )->second;
				if ( ass_bank.ass_subject.Contigs[i].unmaplink[j].first )
					coords_out_unmap_link.insert( make_pair( coo, make_pair( true, i ) ) );
				if ( ass_bank.ass_subject.Contigs[i].unmaplink[j].second )
					coords_in_unmap_link.insert( make_pair( coo, make_pair( true, i ) ) );
			}

		}
	}

	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
		if ( (int)ass_bank.ass_query.Contigs[i].uni_mapping_range.size() >= 1 )
		{
			// first check _1coordset including nonrepeat and the repeat between the nonrepeats. 
			set< size_t > _1coordset;
			// first nonrepeat
			for ( size_t j = 0; j < ass_bank.ass_query.Contigs[i].uni_mapping_range.size(); ++j ) 
			{
				pair<int, int > range = ass_bank.ass_query.Contigs[i].uni_mapping_range[j];
				if ( ass_bank.ass_query.Contigs[i].repeat.find( range ) == ass_bank.ass_query.Contigs[i].repeat.end() )
					_1coordset.insert( j );
			}
			
			// then the repeat between the nonrepeats.
			for ( size_t j = 0; j < ass_bank.ass_query.Contigs[i].uni_mapping_range.size(); ++j )
			{
				if ( _1coordset.find( j ) == _1coordset.end() )
				{
					
					bool left_b = false;
					bool right_b = false;
					size_t left_s = j;
					while ( left_s > 0 )
					{
						--left_s;
						
						if ( ass_bank.ass_query.Contigs[i].break_by_validate[left_s] )
						{
							
							break;
						}
						if ( _1coordset.find( left_s ) != _1coordset.end() )
						{
							
							left_b = true;
							break;
						}
					}
					size_t right_s = j;
					while ( right_s < ass_bank.ass_query.Contigs[i].uni_mapping_range.size()-1 )
					{
						
						if ( ass_bank.ass_query.Contigs[i].break_by_validate[right_s] )
						{
							
							break;
						}
						++right_s;
						
						if ( _1coordset.find( right_s ) != _1coordset.end() )
						{
							
							right_b = true;
							break;
						}
					}
					
					if ( left_b && right_b )
						_1coordset.insert( j );
				}
			}
			logf<<">qry "<<ass_bank.ass_query.Contigs[i].name<<endl;
			logf<<"_1coordset: ";
			for ( set< size_t >::iterator ji = _1coordset.begin(); ji != _1coordset.end(); ++ji )
				logf<<" "<<*ji;
			logf<<endl;
			if ( ass_bank.ass_query.Contigs[i].uni_mapping_range.size() >= 1 )
			{
				for ( size_t j = 0; j < ass_bank.ass_query.Contigs[i].uni_mapping_range.size(); ++j )
				{
					if ( _1coordset.find( j ) != _1coordset.end() )
					{
						pair<int, int > left_range = ass_bank.ass_query.Contigs[i].uni_mapping_range[j];
						Coords_id left_coo = ass_bank.ass_query.Contigs[i].mapping.lower_bound( left_range )->second;
						amo.qry_1coord_set.insert( left_coo );
						logf<<"add "<<left_coo<<endl;
					}
				}
			}

			for ( size_t j = 0; j < ass_bank.ass_query.Contigs[i].uni_mapping_range.size()-1; ++j )
			{
				if ( ass_bank.ass_query.Contigs[i].break_by_validate[j] )
					continue;
				pair<int, int > left_range = ass_bank.ass_query.Contigs[i].uni_mapping_range[j];
				pair< int, int > right_range = ass_bank.ass_query.Contigs[i].uni_mapping_range[j+1];
				if ( ass_bank.ass_query.Contigs[i].mapping.lower_bound( left_range ) == ass_bank.ass_query.Contigs[i].mapping.end() )
				{
					cout<<"error ass_bank.ass_query.Contigs[i].mapping not find "<<left_range.first<<","<<left_range.second<<endl; exit(1);
				}
				if ( ass_bank.ass_query.Contigs[i].mapping.lower_bound( right_range ) == ass_bank.ass_query.Contigs[i].mapping.end() )
				{
					cout<<"error ass_bank.ass_query.Contigs[i].mapping not find "<<right_range.first<<","<<right_range.second<<endl; exit(1);
				}
				Coords_id left_coo = ass_bank.ass_query.Contigs[i].mapping.lower_bound( left_range )->second;
				Coords_id right_coo = ass_bank.ass_query.Contigs[i].mapping.lower_bound( right_range )->second;
				
				Edge edge;
				edge.coo_left = left_coo;
				edge.coo_right = right_coo;
				edge.ctg = i;
				edge.break_point = j;
				edge.length = right_range.first - left_range.second - 1;
				edge.subjass = false;
				if ( amo.mcoords[left_coo].qrystart() <= amo.mcoords[left_coo].qryend() )
				{
					edge.left_inorout = true;
						
				}else
				{
					edge.left_inorout = false;
				}
				if ( amo.mcoords[right_coo].qrystart() <= amo.mcoords[right_coo].qryend() )
				{
					edge.right_inorout = false;
				}else
				{
					edge.right_inorout = true;
				}
				edge.uprate = calculateEdgeUprate( ass_bank.ass_query.Contigs[i], left_range.second, right_range.first );
				amo._1coord_edge.push_back( edge );
				size_t eid = amo._1coord_edge.size() - 1;
				if ( _1coordset.find( j ) != _1coordset.end() && _1coordset.find( j + 1 ) != _1coordset.end() )
				{
				
					if ( edge.left_inorout )
						coords_in_edge_map[left_coo].push_back( eid );
					else
						coords_out_edge_map[left_coo].push_back( eid );
					if ( edge.right_inorout )
						coords_in_edge_map[right_coo].push_back( eid );
					else
						coords_out_edge_map[right_coo].push_back( eid );


				} else if ( _1coordset.find( j ) != _1coordset.end() )
				{
				
					if ( edge.left_inorout )
						coords_in_edge_map[left_coo].push_back( eid );
					else
						coords_out_edge_map[left_coo].push_back( eid );
				
				} else if ( _1coordset.find( j+1 ) != _1coordset.end() )
				{
				
					if ( edge.right_inorout )
						coords_in_edge_map[right_coo].push_back( eid );
					else
						coords_out_edge_map[right_coo].push_back( eid );

				

				}

			}

			for ( size_t j = 0; j < ass_bank.ass_query.Contigs[i].uni_mapping_range.size(); ++j )
			{
				Coords_id coo = ass_bank.ass_query.Contigs[i].mapping.lower_bound( ass_bank.ass_query.Contigs[i].uni_mapping_range[j] )->second;
				if ( amo.mcoords[coo].qrystart() <= amo.mcoords[coo].qryend() )
				{
					if ( ass_bank.ass_query.Contigs[i].unmaplink[j].first )
						coords_out_unmap_link.insert( make_pair( coo, make_pair( false, i ) ) );
					if ( ass_bank.ass_query.Contigs[i].unmaplink[j].second )
						coords_in_unmap_link.insert( make_pair( coo, make_pair( false, i ) ) );
				} else
				{
					if ( ass_bank.ass_query.Contigs[i].unmaplink[j].first )
						coords_in_unmap_link.insert( make_pair( coo, make_pair( false, i ) ) );
					if ( ass_bank.ass_query.Contigs[i].unmaplink[j].second )
						coords_out_unmap_link.insert( make_pair( coo, make_pair( false, i ) ) );
				}
			}

		}

	}

	
	for ( map< Coords_id, vector<size_t > >::iterator ite = coords_in_edge_map.begin(); ite != coords_in_edge_map.end(); ++ite )
	{
		if ( (int)ite->second.size() > 2 )
		{
			cout<<"error unexpected degree "<<ite->first<<", "<<ite->second.size()<<endl; exit(1);
		}
		if ( (int)ite->second.size() == 2 )
		{
			logf<<"contr coo "<<ite->first<<","<<amo.mcoords[ite->first].refname()<<","<<amo.mcoords[ite->first].refstart()<<","
				<<amo.mcoords[ite->first].refend()<<","<<amo.mcoords[ite->first].qryname()<<","<<amo.mcoords[ite->first].qrystart()<<","
				<<amo.mcoords[ite->first].qryend()<<endl;  
			Coords_id cooid = ite->first;
			size_t eid_1 = ite->second.front();
			size_t eid_2 = ite->second.back();
			Ctg_id cid_1 = amo._1coord_edge[eid_1].ctg;
			size_t break_point_1 = amo._1coord_edge[eid_1].break_point;
			
			Ctg_id cid_2 = amo._1coord_edge[eid_2].ctg;
			size_t break_point_2 = amo._1coord_edge[eid_2].break_point;

			double uprate_1 = amo._1coord_edge[eid_1].uprate;
			double uprate_2 = amo._1coord_edge[eid_2].uprate;
			logf<<"uprate1:"<<uprate_1<<","<<"uprate2:"<<uprate_2<<endl;
			if ( uprate_1 > uprate_2 )
			{
				if ( amo._1coord_edge[eid_1].subjass )
				{
					ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
				} else
					ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
			} else if ( uprate_2 > uprate_1 )
			{
				if ( amo._1coord_edge[eid_2].subjass )
					ass_bank.ass_subject.Contigs[cid_2].break_by_validate[break_point_2] = true;
				else
					ass_bank.ass_query.Contigs[cid_2].break_by_validate[break_point_2] = true;
			} else
			{

				Coords_id opp_cooid_1, opp_cooid_2;
				if ( amo._1coord_edge[eid_1].coo_left == cooid )
					opp_cooid_1 = amo._1coord_edge[eid_1].coo_right;
				else
					opp_cooid_1 = amo._1coord_edge[eid_1].coo_left;
				if ( amo._1coord_edge[eid_2].coo_left == cooid )
					opp_cooid_2 = amo._1coord_edge[eid_2].coo_right;
				else
					opp_cooid_2 = amo._1coord_edge[eid_2].coo_left;

			
				if ( opp_cooid_1 == opp_cooid_2 )
				{
					if ( amo._1coord_edge[eid_1].length < amo._1coord_edge[eid_2].length )
					{
						if ( amo._1coord_edge[eid_1].subjass )
						{
							ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
						} else
							ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
					} else
					{
						if ( amo._1coord_edge[eid_2].subjass )
							ass_bank.ass_subject.Contigs[cid_2].break_by_validate[break_point_2] = true;
						else
							ass_bank.ass_query.Contigs[cid_2].break_by_validate[break_point_2] = true;
					}
				} else
				{
					if ( s_rank == 0 )
					{
						amo.in_noavail_coo_bycontr.insert( cooid );
						if ( amo._1coord_edge[eid_1].subjass )
						{
							ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
						} else
							ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
						if ( amo._1coord_edge[eid_2].subjass )
							ass_bank.ass_subject.Contigs[cid_2].break_by_validate[break_point_2] = true;
						else
							ass_bank.ass_query.Contigs[cid_2].break_by_validate[break_point_2] = true;
					} else
					{
						int c_result = 0;
						comp_edge_rule1( amo, ass_bank, eid_1, eid_2, cooid, c_result, s_rank );
						logf<<"c_result "<<c_result<<endl;
						if ( c_result == 1 )
						{
							if ( amo._1coord_edge[eid_2].subjass )
								ass_bank.ass_subject.Contigs[cid_2].break_by_validate[break_point_2] = true;
							else
								ass_bank.ass_query.Contigs[cid_2].break_by_validate[break_point_2] = true;
						} else if ( c_result == 2 )
						{
							if ( amo._1coord_edge[eid_1].subjass )
							{
								ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
							} else
								ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
						} else
						{
							amo.in_noavail_coo_bycontr.insert( cooid );
							if ( amo._1coord_edge[eid_1].subjass )
							{
								ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
							} else
								ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
							if ( amo._1coord_edge[eid_2].subjass )
								ass_bank.ass_subject.Contigs[cid_2].break_by_validate[break_point_2] = true;
							else
								ass_bank.ass_query.Contigs[cid_2].break_by_validate[break_point_2] = true;
						}
					}
				}

			}


		} else if ( (int)ite->second.size() == 1 && coords_in_unmap_link.find( ite->first ) != coords_in_unmap_link.end() )
		{
			logf<<"contr coo (include unmaplink) "<<ite->first<<","<<amo.mcoords[ite->first].refname()<<","<<amo.mcoords[ite->first].refstart()<<","
				<<amo.mcoords[ite->first].refend()<<","<<amo.mcoords[ite->first].qryname()<<","<<amo.mcoords[ite->first].qrystart()<<","
				<<amo.mcoords[ite->first].qryend()<<endl;   
			Coords_id cooid = ite->first;
			size_t eid_1 = ite->second.front();
			Ctg_id cid_1 = amo._1coord_edge[eid_1].ctg;
			size_t break_point_1 = amo._1coord_edge[eid_1].break_point;

			if ( s_rank == 0 )
			{
				
				amo.in_noavail_coo_bycontr.insert( cooid );
					
				if ( amo._1coord_edge[eid_1].subjass )
				{
					ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
				} else
					ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
				
			} else
			{
				int c_result = 0;
				comp_edge_rule2( amo, ass_bank, eid_1, coords_in_unmap_link[cooid], true, cooid, c_result, s_rank );
				logf<<"c_result "<<c_result<<endl;
				if ( c_result != 1 )
				{
					if ( amo._1coord_edge[eid_1].subjass )
					{
						ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
					} else
						ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;

					if ( c_result == 0 )
					{
						amo.in_noavail_coo_bycontr.insert( cooid );
					}
				} 
			}
		}
	}
	for ( map< Coords_id, vector<size_t > >::iterator ite = coords_out_edge_map.begin(); ite != coords_out_edge_map.end(); ++ite )
	{
		if ( (int)ite->second.size() > 2 )
		{
			cout<<"error unexpected degree "<<ite->first<<", "<<ite->second.size()<<endl; exit(1);
		}
		if ( (int)ite->second.size() == 2 )
		{
			logf<<"contr coo "<<ite->first<<","<<amo.mcoords[ite->first].refname()<<","<<amo.mcoords[ite->first].refstart()<<","
				<<amo.mcoords[ite->first].refend()<<","<<amo.mcoords[ite->first].qryname()<<","<<amo.mcoords[ite->first].qrystart()<<","
				<<amo.mcoords[ite->first].qryend()<<endl;  
			Coords_id cooid = ite->first;
			size_t eid_1 = ite->second.front();
			size_t eid_2 = ite->second.back();
			Ctg_id cid_1 = amo._1coord_edge[eid_1].ctg;
			size_t break_point_1 = amo._1coord_edge[eid_1].break_point;
			
			Ctg_id cid_2 = amo._1coord_edge[eid_2].ctg;
			size_t break_point_2 = amo._1coord_edge[eid_2].break_point;

			double uprate_1 = amo._1coord_edge[eid_1].uprate;
			double uprate_2 = amo._1coord_edge[eid_2].uprate;
			logf<<"uprate1:"<<uprate_1<<","<<"uprate2:"<<uprate_2<<endl;

			if ( uprate_1 > uprate_2 )
			{
				if ( amo._1coord_edge[eid_1].subjass )
				{
					ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
				} else
					ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
			} else if ( uprate_2 > uprate_1 )
			{
				if ( amo._1coord_edge[eid_2].subjass )
					ass_bank.ass_subject.Contigs[cid_2].break_by_validate[break_point_2] = true;
				else
					ass_bank.ass_query.Contigs[cid_2].break_by_validate[break_point_2] = true;
			} else
			{

				Coords_id opp_cooid_1, opp_cooid_2;
				if ( amo._1coord_edge[eid_1].coo_left == cooid )
					opp_cooid_1 = amo._1coord_edge[eid_1].coo_right;
				else
					opp_cooid_1 = amo._1coord_edge[eid_1].coo_left;
				if ( amo._1coord_edge[eid_2].coo_left == cooid )
					opp_cooid_2 = amo._1coord_edge[eid_2].coo_right;
				else
					opp_cooid_2 = amo._1coord_edge[eid_2].coo_left;

			
				if ( opp_cooid_1 == opp_cooid_2 )
				{
					if ( amo._1coord_edge[eid_1].length < amo._1coord_edge[eid_2].length )
					{
						if ( amo._1coord_edge[eid_1].subjass )
						{
							ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
						} else
							ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
					} else
					{
						if ( amo._1coord_edge[eid_2].subjass )
							ass_bank.ass_subject.Contigs[cid_2].break_by_validate[break_point_2] = true;
						else
							ass_bank.ass_query.Contigs[cid_2].break_by_validate[break_point_2] = true;
					}
				} else
				{
					if ( s_rank == 0 )
					{
						amo.out_noavail_coo_bycontr.insert( cooid );
						if ( amo._1coord_edge[eid_1].subjass )
						{
							ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
						} else
							ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
						if ( amo._1coord_edge[eid_2].subjass )
							ass_bank.ass_subject.Contigs[cid_2].break_by_validate[break_point_2] = true;
						else
							ass_bank.ass_query.Contigs[cid_2].break_by_validate[break_point_2] = true;
					} else
					{
						int c_result = 0;
						comp_edge_rule1( amo, ass_bank, eid_1, eid_2, cooid, c_result, s_rank );
						logf<<"c_result "<<c_result<<endl;
						if ( c_result == 1 )
						{
							if ( amo._1coord_edge[eid_2].subjass )
								ass_bank.ass_subject.Contigs[cid_2].break_by_validate[break_point_2] = true;
							else
								ass_bank.ass_query.Contigs[cid_2].break_by_validate[break_point_2] = true;
						} else if ( c_result == 2 )
						{
							if ( amo._1coord_edge[eid_1].subjass )
							{
								ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
							} else
								ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
						} else
						{
							amo.out_noavail_coo_bycontr.insert( cooid );
							if ( amo._1coord_edge[eid_1].subjass )
							{
								ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
							} else
								ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
							if ( amo._1coord_edge[eid_2].subjass )
								ass_bank.ass_subject.Contigs[cid_2].break_by_validate[break_point_2] = true;
							else
								ass_bank.ass_query.Contigs[cid_2].break_by_validate[break_point_2] = true;
						}
					}
					
				}
			}
		} else if ( (int)ite->second.size() == 1 && coords_out_unmap_link.find( ite->first ) != coords_out_unmap_link.end() )
		{
			logf<<"contr coo (include unmaplink) "<<ite->first<<","<<amo.mcoords[ite->first].refname()<<","<<amo.mcoords[ite->first].refstart()<<","
				<<amo.mcoords[ite->first].refend()<<","<<amo.mcoords[ite->first].qryname()<<","<<amo.mcoords[ite->first].qrystart()<<","
				<<amo.mcoords[ite->first].qryend()<<endl;   
			Coords_id cooid = ite->first;
			size_t eid_1 = ite->second.front();
			Ctg_id cid_1 = amo._1coord_edge[eid_1].ctg;
			size_t break_point_1 = amo._1coord_edge[eid_1].break_point;

			if ( s_rank == 0 )
			{
				amo.in_noavail_coo_bycontr.insert( cooid );
				if ( amo._1coord_edge[eid_1].subjass )
				{
					ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
				} else
					ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;
				
			} else
			{
				int c_result = 0;
				comp_edge_rule2( amo, ass_bank, eid_1, coords_out_unmap_link[cooid], false, cooid, c_result, s_rank );
				logf<<"c_result "<<c_result<<endl;
				if ( c_result != 1 )
				{
					if ( amo._1coord_edge[eid_1].subjass )
					{
						ass_bank.ass_subject.Contigs[cid_1].break_by_validate[break_point_1] = true;
					} else
						ass_bank.ass_query.Contigs[cid_1].break_by_validate[break_point_1] = true;

					if ( c_result == 0 )
						amo.out_noavail_coo_bycontr.insert( cooid );
				} 
			}
		}
	}

	//erase loop link edge
	for ( size_t i = 0; i < amo._1coord_edge.size(); ++i )
	{
		bool subjori = amo._1coord_edge[i].subjass;
		Ctg_id ctg = amo._1coord_edge[i].ctg;
		size_t break_point = amo._1coord_edge[i].break_point;
		Coords_id cooleft = amo._1coord_edge[i].coo_left;
		Coords_id cooright = amo._1coord_edge[i].coo_right;
		int leftseg_pos1, leftseg_pos2, rightseg_pos1, rightseg_pos2;
		if ( subjori )
		{
			if ( ass_bank.ass_subject.Contigs[ctg].break_by_validate[break_point] )
				continue;
			Ctg_id qryctgleft = ass_bank.ass_query.ctg_name_map[amo.mcoords[cooleft].qryname()];
			Ctg_id qryctgright = ass_bank.ass_query.ctg_name_map[amo.mcoords[cooright].qryname()];
			if ( qryctgleft != qryctgright )
				continue;
			if ( amo._1coord_edge[i].left_inorout )
			{
				leftseg_pos1 = amo.mcoords[cooleft].qrystart();
				leftseg_pos2 = amo.mcoords[cooleft].qryend();
			} else
			{
				leftseg_pos1 = amo.mcoords[cooleft].qryend();
				leftseg_pos2 = amo.mcoords[cooleft].qrystart();
			}
			if ( amo._1coord_edge[i].right_inorout )
			{
				rightseg_pos1 = amo.mcoords[cooright].qryend();
				rightseg_pos2 = amo.mcoords[cooright].qrystart();
			} else
			{
				rightseg_pos1 = amo.mcoords[cooright].qrystart();
				rightseg_pos2 = amo.mcoords[cooright].qryend();
			}
			
		} else
		{
			if ( ass_bank.ass_query.Contigs[ctg].break_by_validate[break_point] )
				continue;
			Ctg_id refctgleft = ass_bank.ass_subject.ctg_name_map[amo.mcoords[cooleft].refname()];
			Ctg_id refctgright = ass_bank.ass_subject.ctg_name_map[amo.mcoords[cooright].refname()];
			if ( refctgleft != refctgright )
				continue;
			if ( amo._1coord_edge[i].left_inorout )
			{
				leftseg_pos1 = amo.mcoords[cooleft].refstart();
				leftseg_pos2 = amo.mcoords[cooleft].refend();
			} else
			{
				leftseg_pos1 = amo.mcoords[cooleft].refend();
				leftseg_pos2 = amo.mcoords[cooleft].refstart();
			}
			if ( amo._1coord_edge[i].right_inorout )
			{
				rightseg_pos1 = amo.mcoords[cooright].refend();
				rightseg_pos2 = amo.mcoords[cooright].refstart();
			} else
			{
				rightseg_pos1 = amo.mcoords[cooright].refstart();
				rightseg_pos2 = amo.mcoords[cooright].refend();
			}
		}

		bool loop = false;
		int leftorder = leftseg_pos2 - leftseg_pos1;
		int rightorder = rightseg_pos2 - rightseg_pos1;
		bool sameorder = false;
		if ( leftorder > 0 && rightorder > 0 )
			sameorder = true;
		else if ( leftorder < 0 && rightorder < 0 )
			sameorder = true;
		if ( sameorder )
		{
			int mutualorder = rightseg_pos1 - leftseg_pos1;
			if ( leftorder > 0 && mutualorder < 0 )
				loop = true;
			else if ( leftorder < 0 && mutualorder > 0 )
				loop = true;
		}
		if ( loop )
		{
			if ( subjori )
			{
				ass_bank.ass_subject.Contigs[ctg].break_by_validate[break_point] = true;
			} else
			{
				ass_bank.ass_query.Contigs[ctg].break_by_validate[break_point] = true;
			}
			logf<<"Loop E"<<i<<":"<<amo._1coord_edge[i].subjass<<",";
			if ( amo._1coord_edge[i].subjass )
				logf<<ass_bank.ass_subject.Contigs[amo._1coord_edge[i].ctg].name;
			else
				logf<<ass_bank.ass_query.Contigs[amo._1coord_edge[i].ctg].name;
			logf<<","<<amo._1coord_edge[i].coo_left<<","<<amo._1coord_edge[i].coo_right<<","<<amo._1coord_edge[i].length<<"|";
			logf<<amo._1coord_edge[i].left_inorout<<","<<amo._1coord_edge[i].right_inorout<<endl;
		}
	}

}

void comp_edge_rule1( Ass_Mapping &amo, Assembly_Bank &ass_bank, size_t edge1, size_t edge2, Coords_id coo, int &result, int s_rank )
{
	bool inner_1 = false;
	bool fringe_1 = false;
	bool left_coo_1 = true;
	Coords_id other_coo_1;
	if ( amo._1coord_edge[edge1].coo_left == coo )
	{
		left_coo_1 = true;
		other_coo_1 = amo._1coord_edge[edge1].coo_right;
	} else if ( amo._1coord_edge[edge1].coo_right == coo )
	{
		left_coo_1 = false;
		other_coo_1 = amo._1coord_edge[edge1].coo_left;
	} else
	{
		cout<<"error edge "<<edge1<<" has no coo "<<coo<<endl; exit(1);
	}
	bool subject_1 = amo._1coord_edge[edge1].subjass;
	int pos1_on_e1;
	int pos2_on_e1;
	int oth_pos1_on_e1;
	int oth_pos2_on_e1;
	int len1;
	if ( subject_1 )
	{
		pos1_on_e1 = amo.mcoords[coo].refstart();
		pos2_on_e1 = amo.mcoords[coo].refend();
		oth_pos1_on_e1 = amo.mcoords[other_coo_1].refstart();
		oth_pos2_on_e1 = amo.mcoords[other_coo_1].refend();
		len1 = ass_bank.ass_subject.Contigs[amo._1coord_edge[edge1].ctg].length;
	} else
	{
		pos1_on_e1 = min( amo.mcoords[coo].qrystart(), amo.mcoords[coo].qryend() );
		pos2_on_e1 = max( amo.mcoords[coo].qrystart(), amo.mcoords[coo].qryend() );
		oth_pos1_on_e1 = min( amo.mcoords[other_coo_1].qrystart(), amo.mcoords[other_coo_1].qryend() );
		oth_pos2_on_e1 = max( amo.mcoords[other_coo_1].qrystart(), amo.mcoords[other_coo_1].qryend() );
		len1 = ass_bank.ass_query.Contigs[amo._1coord_edge[edge1].ctg].length;
	}
	int leftside_1 = pos1_on_e1 - 1;
	int rightside_1 = len1 - pos2_on_e1;
	int minside_len_1 = min( leftside_1, rightside_1 );
	int minfringe_len_1 = min( min(pos2_on_e1, len1 - pos1_on_e1), min(oth_pos2_on_e1, len1 - oth_pos1_on_e1 ) );
	if ( leftside_1 > 1000 && rightside_1 > 1000 )
		inner_1 = true;
	if ( !inner_1 )
	{
		if ( pos2_on_e1 < 300 )
		{
			fringe_1 = true;
			
		} else if ( len1 - pos1_on_e1 < 300 )
		{
			fringe_1 = true;
			
		}

		if ( !fringe_1 )
		{
			if ( oth_pos2_on_e1 < 300 )
				fringe_1 = true;
			else if ( len1 - oth_pos1_on_e1 < 300 )
				fringe_1 = true;
		} 
	}

	bool inner_2 = false;
	bool fringe_2 = false;
	bool left_coo_2 = true;
	Coords_id other_coo_2;
	if ( amo._1coord_edge[edge2].coo_left == coo )
	{
		left_coo_2 = true;
		other_coo_2 = amo._1coord_edge[edge2].coo_right;
	} else if ( amo._1coord_edge[edge2].coo_right == coo )
	{
		left_coo_2 = false;
		other_coo_2 = amo._1coord_edge[edge2].coo_left;
	} else
	{
		cout<<"error edge "<<edge2<<" has no coo "<<coo<<endl; exit(1);
	}
	bool subject_2 = amo._1coord_edge[edge2].subjass;
	int pos1_on_e2;
	int pos2_on_e2;
	int oth_pos1_on_e2;
	int oth_pos2_on_e2;
	int len2;
	if ( subject_2 )
	{
		pos1_on_e2 = amo.mcoords[coo].refstart();
		pos2_on_e2 = amo.mcoords[coo].refend();
		oth_pos1_on_e2 = amo.mcoords[other_coo_2].refstart();
		oth_pos2_on_e2 = amo.mcoords[other_coo_2].refend();
		len2 = ass_bank.ass_subject.Contigs[amo._1coord_edge[edge2].ctg].length;
	} else
	{
		pos1_on_e2 = min( amo.mcoords[coo].qrystart(), amo.mcoords[coo].qryend() );
		pos2_on_e2 = max( amo.mcoords[coo].qrystart(), amo.mcoords[coo].qryend() );
		oth_pos1_on_e2 = min( amo.mcoords[other_coo_2].qrystart(), amo.mcoords[other_coo_2].qryend() );
		oth_pos2_on_e2 = max( amo.mcoords[other_coo_2].qrystart(), amo.mcoords[other_coo_2].qryend() );
		len2 = ass_bank.ass_query.Contigs[amo._1coord_edge[edge2].ctg].length;
	}
	int leftside_2 = pos1_on_e2 - 1;
	
	int rightside_2 = len2 - pos2_on_e2;
	int minside_len_2 = min( leftside_2, rightside_2 );
	int minfringe_len_2 = min( min(pos2_on_e2, len2 - pos1_on_e2), min(oth_pos2_on_e2, len2 - oth_pos1_on_e2 ) );
	
	if ( leftside_2 > 1000 && rightside_2 > 1000 )
		inner_2 = true;
	if ( !inner_2 )
	{
		if ( pos2_on_e2 < 300 )
			fringe_2 = true;
		else if ( len2 - pos1_on_e2 < 300 )
			fringe_2 = true;

		if ( !fringe_2 )
		{
			if ( oth_pos2_on_e2 < 300 )
				fringe_2 = true;
			else if ( len2 - oth_pos1_on_e2 < 300 )
				fringe_2 = true;
		} 
	}

	if ( inner_1 && fringe_2 )
	{
		result = 1;
	} else if ( fringe_1 && inner_2 )
	{
		result = 2;
	} else
	{
		if ( s_rank == 0 )
			result = 0;
		else
		{
			if ( minside_len_1 > 1000 && minfringe_len_2 < 1000 && minside_len_1 >= 10 * minfringe_len_2 )
				result = 1;
			else if ( minside_len_2 > 1000 && minfringe_len_1 < 1000 && minside_len_2 >= 10 * minfringe_len_1 )
				result = 2;
			else
				result = 0;
		}
	}
}

void comp_edge_rule2( Ass_Mapping &amo, Assembly_Bank &ass_bank, size_t edge1, pair<bool, Ctg_id > unmap, bool unmap_in, Coords_id coo, int &result, int s_rank )
{

	// check good protect.
	bool subject_1 = amo._1coord_edge[edge1].subjass;
	Ctg_id ctg_1 = amo._1coord_edge[edge1].ctg;
	bool subject_2 = unmap.first;
	Ctg_id ctg_2 = unmap.second;
	if ( subject_1 && !subject_2 )
	{
		if ( ass_bank.ass_subject.Contigs[ctg_1].good_protect && !ass_bank.ass_query.Contigs[ctg_2].good_protect )
		{
			result = 1;
			return;
		} else if ( !ass_bank.ass_subject.Contigs[ctg_1].good_protect && ass_bank.ass_query.Contigs[ctg_2].good_protect )
		{
			result = 2;
			return;
		}
	} else
	{
		if ( ass_bank.ass_query.Contigs[ctg_1].good_protect && !ass_bank.ass_subject.Contigs[ctg_2].good_protect )
		{
			result = 1;
			return;
		} else if ( !ass_bank.ass_query.Contigs[ctg_1].good_protect && ass_bank.ass_subject.Contigs[ctg_2].good_protect )
		{
			result = 2;
			return;
		}
	}

	bool inner_1 = false;
	bool fringe_1 = false;
	bool left_coo_1 = true;
	Coords_id other_coo_1;
	if ( amo._1coord_edge[edge1].coo_left == coo )
	{
		left_coo_1 = true;
		other_coo_1 = amo._1coord_edge[edge1].coo_right;
	} else if ( amo._1coord_edge[edge1].coo_right == coo )
	{
		left_coo_1 = false;
		other_coo_1 = amo._1coord_edge[edge1].coo_left;
	} else
	{
		cout<<"error edge "<<edge1<<" has no coo "<<coo<<endl; exit(1);
	}
//	bool subject_1 = amo._1coord_edge[edge1].subjass;
	int pos1_on_e1;
	int pos2_on_e1;
	int oth_pos1_on_e1;
	int oth_pos2_on_e1;
	int len1;
	if ( subject_1 )
	{
		pos1_on_e1 = amo.mcoords[coo].refstart();
		pos2_on_e1 = amo.mcoords[coo].refend();
		oth_pos1_on_e1 = amo.mcoords[other_coo_1].refstart();
		oth_pos2_on_e1 = amo.mcoords[other_coo_1].refend();
		len1 = ass_bank.ass_subject.Contigs[amo._1coord_edge[edge1].ctg].length;
	} else
	{
		pos1_on_e1 = min( amo.mcoords[coo].qrystart(), amo.mcoords[coo].qryend() );
		pos2_on_e1 = max( amo.mcoords[coo].qrystart(), amo.mcoords[coo].qryend() );
		oth_pos1_on_e1 = min( amo.mcoords[other_coo_1].qrystart(), amo.mcoords[other_coo_1].qryend() );
		oth_pos2_on_e1 = max( amo.mcoords[other_coo_1].qrystart(), amo.mcoords[other_coo_1].qryend() );
		len1 = ass_bank.ass_query.Contigs[amo._1coord_edge[edge1].ctg].length;
	}
	int leftside_1 = pos1_on_e1 - 1;
	int rightside_1 = len1 - pos2_on_e1;
	int minside_len_1 = min( leftside_1, rightside_1 );
	int minfringe_len_1 = min( min(pos2_on_e1, len1 - pos1_on_e1), min(oth_pos2_on_e1, len1 - oth_pos1_on_e1 ) );
	if ( leftside_1 > 1000 && rightside_1 > 1000 )
		inner_1 = true;
	if ( !inner_1 )
	{
		if ( pos2_on_e1 < 300 )
			fringe_1 = true;
		else if ( len1 - pos1_on_e1 < 300 )
			fringe_1 = true;

		if ( !fringe_1 )
		{
			if ( oth_pos2_on_e1 < 300 )
				fringe_1 = true;
			else if ( len1 - oth_pos1_on_e1 < 300 )
				fringe_1 = true;
		} 
	}

	bool inner_2 = false;
	bool fringe_2 = false;
	
//	bool subject_2 = unmap.first;
	int pos1_on_e2;
	int pos2_on_e2;
	int linkpoint;
	int len2;
	
	if ( subject_2 )
	{
		pos1_on_e2 = amo.mcoords[coo].refstart();
		pos2_on_e2 = amo.mcoords[coo].refend();
		len2 = ass_bank.ass_subject.Contigs[unmap.second].length;
	
		if ( unmap_in )
			linkpoint = pos2_on_e2;
		else
			linkpoint = pos1_on_e2;
	} else
	{
		if ( amo.mcoords[coo].qrystart() <= amo.mcoords[coo].qryend() )
		{
			pos1_on_e2 = amo.mcoords[coo].qrystart();
			pos2_on_e2 = amo.mcoords[coo].qryend();
			if ( unmap_in )
				linkpoint = pos2_on_e2;
			else
				linkpoint = pos1_on_e2;
		} else
		{
			pos1_on_e2 = amo.mcoords[coo].qryend();
			pos2_on_e2 = amo.mcoords[coo].qrystart();
			if ( unmap_in )
				linkpoint = pos1_on_e2;
			else
				linkpoint = pos2_on_e2;
		}
		len2 = ass_bank.ass_query.Contigs[unmap.second].length;
	
	}
	int leftside_2 = pos1_on_e2 - 1;
	int rightside_2 = len2 - pos2_on_e2;
	int minside_len_2 = min( leftside_2, rightside_2 );
	int minfringe_len_2 = min(pos2_on_e2, len2 - pos1_on_e2);
	if ( leftside_2 > 1000 && rightside_2 > 1000 )
		inner_2 = true;
	if ( !inner_2 )
	{
		if ( pos2_on_e2 < 300 )
			fringe_2 = true;
		else if ( len2 - pos1_on_e2 < 300 )
			fringe_2 = true;

		if ( !fringe_2 )
		{
			if ( linkpoint == pos1_on_e2 )
			{
				if ( pos1_on_e2 < 300 )
					fringe_2 = true;

				if ( pos1_on_e2 < minfringe_len_2 )
					minfringe_len_2 = pos1_on_e2;
			} else   // linkpoint == pos2_on_e2
			{
				if ( len2 - pos2_on_e2 <= 300 )
					fringe_2 = true;

				if ( len2 - pos2_on_e2 < minfringe_len_2 )
					minfringe_len_2 = len2 - pos2_on_e2;
			}
			
		} 
	}

	if ( inner_1 && fringe_2 )
	{
		result = 1;
	} else if ( fringe_1 && inner_2 )
	{
		result = 2;
	} else
	{
		
		if ( s_rank == 0 )
			result = 0;
		else
		{
			if ( minside_len_1 > 1000 && minfringe_len_2 < 1000 && minside_len_1 >= 10 * minfringe_len_2 )
				result = 1;
			else if ( minside_len_2 > 1000 && minfringe_len_1 < 1000 && minside_len_2 >= 10 * minfringe_len_1 )
				result = 2;
			else
				result = 0;
		}
	}
}

void erase_broken_edge( Ass_Mapping &amo, Assembly_Bank &ass_bank )
{
	
	// erase broken edge
	vector< Edge > remainedge;
	for ( size_t i = 0; i < amo._1coord_edge.size(); ++i )
	{
		Ctg_id ctg = amo._1coord_edge[i].ctg;
		size_t breakpoint = amo._1coord_edge[i].break_point;
		if ( amo._1coord_edge[i].subjass )
		{
			if ( !ass_bank.ass_subject.Contigs[ctg].break_by_validate[breakpoint] )
				remainedge.push_back( amo._1coord_edge[i] );
		} else 
		{
			if ( !ass_bank.ass_query.Contigs[ctg].break_by_validate[breakpoint] )
				remainedge.push_back( amo._1coord_edge[i] );
		}
	}

	amo._1coord_edge = remainedge;

}

void get_path( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector< Path >& path_ve )
{
	ofstream outf("_1coord_set");
	for( set< Coords_id >::iterator ite = amo.ref_1coord_set.begin(); ite != amo.ref_1coord_set.end(); ++ite )
		outf<<"ref"<<*ite<<endl;
	for( set< Coords_id >::iterator ite = amo.qry_1coord_set.begin(); ite != amo.qry_1coord_set.end(); ++ite )
		outf<<"qry"<<*ite<<endl;
	outf.close(); 
	map< Coords_id, size_t > coords_in_edge_map;
	map< Coords_id, size_t > coords_out_edge_map;

	ofstream logf("getpathlog"); 

	for ( size_t i = 0; i < amo._1coord_edge.size(); ++i )
	{
		bool left_1coord = false;
		bool right_1coord = false;
		if ( amo._1coord_edge[i].subjass )
		{
			if ( amo.ref_1coord_set.find( amo._1coord_edge[i].coo_left ) != amo.ref_1coord_set.end() )
				left_1coord = true;
			if ( amo.ref_1coord_set.find( amo._1coord_edge[i].coo_right ) != amo.ref_1coord_set.end() )
				right_1coord = true;
		} else
		{
			if ( amo.qry_1coord_set.find( amo._1coord_edge[i].coo_left ) != amo.qry_1coord_set.end() )
				left_1coord = true;
			if ( amo.qry_1coord_set.find( amo._1coord_edge[i].coo_right ) != amo.qry_1coord_set.end() )
				right_1coord = true;
		}
		if ( !left_1coord && !right_1coord )
		{
			continue;
		} 
		if ( left_1coord  )
		{
			if ( amo._1coord_edge[i].left_inorout )
			{
				if ( coords_in_edge_map.find( amo._1coord_edge[i].coo_left ) != coords_in_edge_map.end() )
				{
					cout<<"error contradict coords_in "<<amo._1coord_edge[i].coo_left<<", "<<coords_in_edge_map[amo._1coord_edge[i].coo_left]<<","<<i<<endl;
					exit(1);
				}
				coords_in_edge_map.insert( make_pair( amo._1coord_edge[i].coo_left, i ) );
			} else
			{
				if ( coords_out_edge_map.find( amo._1coord_edge[i].coo_left ) != coords_out_edge_map.end() )
				{
					cout<<"error contradict coords_out "<<amo._1coord_edge[i].coo_left<<", "<<coords_out_edge_map[amo._1coord_edge[i].coo_left]<<","<<i<<endl;
					exit(1);
				}
				coords_out_edge_map.insert( make_pair( amo._1coord_edge[i].coo_left, i ) );
			}
		}
		if ( right_1coord )
		{
			if ( amo._1coord_edge[i].right_inorout )
			{
				if ( coords_in_edge_map.find( amo._1coord_edge[i].coo_right ) != coords_in_edge_map.end() )
				{
					cout<<"error contradict coords_in "<<amo._1coord_edge[i].coo_right<<", "<<coords_in_edge_map[amo._1coord_edge[i].coo_right]<<","<<i<<endl;
					exit(1);
				}
				coords_in_edge_map.insert( make_pair( amo._1coord_edge[i].coo_right, i ) );
			} else
			{
				if ( coords_out_edge_map.find( amo._1coord_edge[i].coo_right ) != coords_out_edge_map.end() )
				{
					cout<<"error contradict coords_out "<<amo._1coord_edge[i].coo_right<<", "<<coords_out_edge_map[amo._1coord_edge[i].coo_right]<<","<<i<<endl;
					exit(1);
				}
				coords_out_edge_map.insert( make_pair( amo._1coord_edge[i].coo_right, i ) );
			}
		}

	}

	// get path
	
	logf<<"in_edge_coo"<<endl;
	for ( map< Coords_id, size_t >::iterator ite = coords_in_edge_map.begin(); ite != coords_in_edge_map.end(); ++ite )
	{
		logf<<"In:"<<ite->first<<","<<ite->second<<endl;
	}
	logf<<"out_edge_coo"<<endl;
	for ( map< Coords_id, size_t >::iterator ite = coords_out_edge_map.begin(); ite != coords_out_edge_map.end(); ++ite )
	{
		logf<<"Out:"<<ite->first<<","<<ite->second<<endl;
	}
	
	set< Coords_id > used_coo;
	for ( set< Coords_id >::iterator ite = amo.ref_1coord_set.begin(); ite != amo.ref_1coord_set.end(); ++ite )
	{
		if ( amo.qry_1coord_set.find( *ite ) == amo.qry_1coord_set.end() )
			continue;
		if ( used_coo.find( *ite ) != used_coo.end() )
			continue;
		if ( coords_in_edge_map.find( *ite ) == coords_in_edge_map.end() && coords_out_edge_map.find( *ite ) == coords_out_edge_map.end() )
			continue;
		logf<<"begin at coo"<<*ite<<endl;
		Path pth;
		pth.coopath.push_back( *ite );
		used_coo.insert( *ite );
		bool forward_in = true;
		if ( coords_in_edge_map.find( *ite ) != coords_in_edge_map.end() )
			forward_in = true;
		else if ( coords_out_edge_map.find( *ite ) != coords_out_edge_map.end() )
			forward_in = false;
		else
			continue;
		Coords_id last_coo = *ite;
		bool goon_forward = false;
		do {
			logf<<"--> last_coo="<<last_coo<<", forward_in="<<forward_in<<endl;
			goon_forward = false;
			Coords_id next_coo;
			size_t next_edge;
			bool boo = false;
			if ( forward_in )
			{
				if ( coords_in_edge_map.find( last_coo ) != coords_in_edge_map.end() )
				{
					next_edge = coords_in_edge_map[last_coo];
					boo = true;
					logf<<"get nextedge "<<next_edge<<endl;
				} 
			} else
			{
				if ( coords_out_edge_map.find( last_coo ) != coords_out_edge_map.end() )
				{
					next_edge = coords_out_edge_map[last_coo];
					boo = true;
					logf<<"get nextedge "<<next_edge<<endl;
				}
			} 
			if ( boo )
			{
				pth.epath.push_back( next_edge );
				logf<<"add edge "<<next_edge<<endl;
				if ( amo._1coord_edge[next_edge].coo_left == last_coo )
				{
					next_coo = amo._1coord_edge[next_edge].coo_right;
					pth.coopath.push_back( next_coo );
					logf<<"find next_coo "<<next_coo<<" l"<<endl;
					if ( used_coo.find( next_coo ) == used_coo.end() )
					{
						
						used_coo.insert( next_coo );
						if ( amo._1coord_edge[next_edge].right_inorout )
						{
							if ( coords_out_edge_map.find( next_coo ) != coords_out_edge_map.end() )
							{
								logf<<"goon"<<endl;
								goon_forward = true;
								forward_in = false;
								last_coo = next_coo;
							}
						} else
						{
							if ( coords_in_edge_map.find( next_coo ) != coords_in_edge_map.end() )
							{
								logf<<"goon"<<endl;
								goon_forward = true;
								forward_in = true;
								last_coo = next_coo;
							}
						}
					}

					
				} else 
				{
					next_coo = amo._1coord_edge[next_edge].coo_left;
					pth.coopath.push_back( next_coo );
					logf<<"find next_coo "<<next_coo<<" r"<<endl;
					if ( used_coo.find( next_coo ) == used_coo.end() )
					{
						used_coo.insert( next_coo );
						if ( amo._1coord_edge[next_edge].left_inorout )
						{
							if ( coords_out_edge_map.find( next_coo ) != coords_out_edge_map.end() )
							{
								logf<<"goon"<<endl;
								goon_forward = true;
								forward_in = false;
								last_coo = next_coo;
							}
						} else
						{
							if ( coords_in_edge_map.find( next_coo ) != coords_in_edge_map.end() )
							{
								logf<<"goon"<<endl;
								goon_forward = true;
								forward_in = true;
								last_coo = next_coo;
							}
						}
					}
				}
			}
		} while ( goon_forward );

		//
		if ( coords_in_edge_map.find( *ite ) != coords_in_edge_map.end() )
			forward_in = false;
		else
			forward_in = true;
		last_coo = *ite;
		bool goon_reverse = false;
		do {
			logf<<"<-- last_coo="<<last_coo<<", forward_in="<<forward_in<<endl;
			goon_reverse = false;
			Coords_id next_coo;
			size_t next_edge;
			bool boo = false;
			if ( forward_in )
			{
				if ( coords_in_edge_map.find( last_coo ) != coords_in_edge_map.end() )
				{
					next_edge = coords_in_edge_map[last_coo];
					boo = true;
					logf<<"get nextedge "<<next_edge<<endl;
				} 
			} else
			{
				if ( coords_out_edge_map.find( last_coo ) != coords_out_edge_map.end() )
				{
					next_edge = coords_out_edge_map[last_coo];
					boo = true;
					logf<<"get nextedge "<<next_edge<<endl;
				}
			} 
			if ( boo )
			{
				pth.epath.push_front( next_edge );
				logf<<"add edge "<<next_edge<<endl;
				if ( amo._1coord_edge[next_edge].coo_left == last_coo )
				{
					next_coo = amo._1coord_edge[next_edge].coo_right;
					pth.coopath.push_front( next_coo );
					logf<<"find next_coo "<<next_coo<<" l"<<endl;
					if ( used_coo.find( next_coo ) == used_coo.end() )
					{
						used_coo.insert( next_coo );
						if ( amo._1coord_edge[next_edge].right_inorout )
						{
							if ( coords_out_edge_map.find( next_coo ) != coords_out_edge_map.end() )
							{
								logf<<"goon"<<endl;
								goon_reverse = true;
								forward_in = false;
								last_coo = next_coo;
							}
						} else
						{
							if ( coords_in_edge_map.find( next_coo ) != coords_in_edge_map.end() )
							{
								logf<<"goon"<<endl;
								goon_reverse = true;
								forward_in = true;
								last_coo = next_coo;
							}
						}
					}
				} else 
				{
					next_coo = amo._1coord_edge[next_edge].coo_left;
					pth.coopath.push_front( next_coo );
					logf<<"find next_coo "<<next_coo<<" r"<<endl;
					if ( used_coo.find( next_coo ) == used_coo.end() )
					{
						used_coo.insert( next_coo );
						if ( amo._1coord_edge[next_edge].left_inorout )
						{
							if ( coords_out_edge_map.find( next_coo ) != coords_out_edge_map.end() )
							{
								logf<<"goon"<<endl;
								goon_reverse = true;
								forward_in = false;
								last_coo = next_coo;
							}
						} else
						{
							if ( coords_in_edge_map.find( next_coo ) != coords_in_edge_map.end() )
							{
								logf<<"goon"<<endl;
								goon_reverse = true;
								forward_in = true;
								last_coo = next_coo;
							}
						}
					}
				}
			}
		} while ( goon_reverse );

		path_ve.push_back( pth );
	}

	// get sole path
	for ( set< Coords_id >::iterator ite = amo.ref_1coord_set.begin(); ite != amo.ref_1coord_set.end(); ++ite )
	{
		if ( amo.qry_1coord_set.find( *ite ) == amo.qry_1coord_set.end() )
			continue;
		if ( used_coo.find( *ite ) == used_coo.end() )
		{
			Path pth;
			pth.coopath.push_back( *ite );
			path_ve.push_back( pth );
		}
	}


}

void output_edge( Ass_Mapping &amo, Assembly_Bank &ass_bank )
{
	ofstream outf("Edge");
	
	for ( size_t i = 0; i < amo._1coord_edge.size(); ++i )
	{
		
		outf<<"E"<<i<<":"<<amo._1coord_edge[i].subjass<<",";
			if ( amo._1coord_edge[i].subjass )
				outf<<ass_bank.ass_subject.Contigs[amo._1coord_edge[i].ctg].name;
			else
				outf<<ass_bank.ass_query.Contigs[amo._1coord_edge[i].ctg].name;
			outf<<","<<amo._1coord_edge[i].coo_left<<","<<amo._1coord_edge[i].coo_right<<","<<amo._1coord_edge[i].length<<"|";
			outf<<amo._1coord_edge[i].left_inorout<<","<<amo._1coord_edge[i].right_inorout<<"|"<<amo._1coord_edge[i].uprate<<endl;
	}
}

void output_unimap( Assembly_Bank &ass_bank, string & file )
{
	ofstream outf( file.data() );
	outf<<"**Subject"<<endl;
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		outf<<">"<<ass_bank.ass_subject.Contigs[i].name<<",length_"<<ass_bank.ass_subject.Contigs[i].length<<endl;
		vector< pair<int, int > >::iterator subi;
		for ( subi = ass_bank.ass_subject.Contigs[i].uni_mapping_range.begin(); 
			subi != ass_bank.ass_subject.Contigs[i].uni_mapping_range.end(); ++subi )
		{
			outf<<"\t("<<subi->first<<","<<subi->second<<")";
		}
		outf<<endl;
		vector< bool >::iterator bi;
		for ( bi = ass_bank.ass_subject.Contigs[i].break_by_validate.begin(); bi != ass_bank.ass_subject.Contigs[i].break_by_validate.end(); ++bi )
		{
			outf<<"\t"<<*bi;
		}
		outf<<endl;
	}

	outf<<"**Query"<<endl;
	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
		outf<<">"<<ass_bank.ass_query.Contigs[i].name<<",length_"<<ass_bank.ass_query.Contigs[i].length<<endl;
		vector< pair<int, int > >::iterator subi;
		for ( subi = ass_bank.ass_query.Contigs[i].uni_mapping_range.begin(); 
			subi != ass_bank.ass_query.Contigs[i].uni_mapping_range.end(); ++subi )
		{
			outf<<"\t("<<subi->first<<","<<subi->second<<")";
		}
		outf<<endl;
		vector< bool >::iterator bi;
		for ( bi = ass_bank.ass_query.Contigs[i].break_by_validate.begin(); bi != ass_bank.ass_query.Contigs[i].break_by_validate.end(); ++bi )
		{
			outf<<"\t"<<*bi;
		}
		outf<<endl;
	}
}


void trans_path( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector<Path > &path_ve )
{
	for ( size_t i = 0; i < path_ve.size(); ++i )
	{
		
		bool mark = false;
		
		if ( (int)path_ve[i].coopath.size() != (int)path_ve[i].epath.size() + 1 )
		{
			cout<<"error pathve coo and edge size "<<path_ve[i].coopath.size()<<","<<path_ve[i].epath.size()<<endl; exit(1);
		}
		if ( (int)path_ve[i].coopath.size() == 1 )
		{
			iPath ip;
			Coords_id coo = path_ve[i].coopath.front();
			Ctg_id subj_ctg = ass_bank.ass_subject.ctg_name_map[amo.mcoords[coo].refname()];
			int len = amo.mcoords[coo].refend() - amo.mcoords[coo].refstart() + 1;
			ip.seq = ass_bank.ass_subject.Contigs[subj_ctg].seq.substr( amo.mcoords[coo].refstart()-1, len );
			Tile tile;
			tile.ctg = subj_ctg;
			tile.subject_ori = true;
			tile.pos_ctg = make_pair( amo.mcoords[coo].refstart(), amo.mcoords[coo].refend() );
			tile.pos_iPath = make_pair( 1, len );
			tile.match = true;
			tile.coo = coo;
			ip.Tile_list.push_back( tile );
			amo.iPath_ve.push_back( ip );
			continue;
		}
		iPath ip;
		list< Coords_id >::iterator cooi = path_ve[i].coopath.begin();
		list< Edge_id >::iterator ei = path_ve[i].epath.begin();
		for ( ; ei != path_ve[i].epath.end(); ++ei )
		{
			
			list< Coords_id >::iterator next_cooi = cooi;
			++next_cooi;
			if ( next_cooi == path_ve[i].coopath.end() )
			{
				
				break;
			}

			bool Subject_ori = true;
			if ( !amo._1coord_edge[*ei].subjass )
				Subject_ori = false;
			Ctg_id ctg = amo._1coord_edge[*ei].ctg;
			bool left_node = true;
			if ( amo._1coord_edge[*ei].coo_left == *cooi && amo._1coord_edge[*ei].coo_right == *next_cooi )
				left_node = true;
			else if ( amo._1coord_edge[*ei].coo_right == *cooi && amo._1coord_edge[*ei].coo_left == *next_cooi )
				left_node = false;
			else
			{
				cout<<"error edge node "<<*ei<<","<<*cooi<<","<<*next_cooi<<endl; exit(1);
			}
			Tile tile;
			tile.ctg = ctg;
			tile.subject_ori = Subject_ori;
			if ( ei == path_ve[i].epath.begin() )
			{
				bool forward = true;
				if ( left_node )
				{
					if ( amo._1coord_edge[*ei].left_inorout )
					{
						forward = true;
					} else
					{
						forward = false;
					}
				} else 
				{
					if ( amo._1coord_edge[*ei].right_inorout )
						forward = true;
					else
						forward = false;
				}
				
					
				if ( Subject_ori )
				{
					if ( forward )
					{
						
						tile.pos_ctg = make_pair( amo.mcoords[*cooi].refstart(), amo.mcoords[*cooi].refend() );
						int len = amo.mcoords[*cooi].refend() - amo.mcoords[*cooi].refstart() + 1;
						ip.seq = ass_bank.ass_subject.Contigs[ctg].seq.substr( amo.mcoords[*cooi].refstart()-1, len );
						tile.pos_iPath = make_pair( 1, len );
						tile.match = true;
						tile.coo = *cooi;
						ip.Tile_list.push_back( tile );
					} else
					{
						tile.pos_ctg = make_pair( amo.mcoords[*cooi].refend(), amo.mcoords[*cooi].refstart() );
						int len = amo.mcoords[*cooi].refend() - amo.mcoords[*cooi].refstart() + 1;
						string seq = ass_bank.ass_subject.Contigs[ctg].seq.substr( amo.mcoords[*cooi].refstart()-1, len );
						ip.seq = getsuppl_str( seq );
						tile.pos_iPath = make_pair( 1, len );
						tile.match = true;
						tile.coo = *cooi;
						ip.Tile_list.push_back( tile );
					}
				} else
				{
					if ( forward )
					{
						tile.pos_ctg = make_pair( amo.mcoords[*cooi].qrystart(), amo.mcoords[*cooi].qryend() );
			
						if ( amo.mcoords[*cooi].qrystart() < amo.mcoords[*cooi].qryend() )
						{
							int len = amo.mcoords[*cooi].qryend() - amo.mcoords[*cooi].qrystart() + 1;
							ip.seq = ass_bank.ass_query.Contigs[ctg].seq.substr( amo.mcoords[*cooi].qrystart()-1, len );
							tile.pos_iPath = make_pair( 1, len );
						} else
						{
							int len = amo.mcoords[*cooi].qrystart() - amo.mcoords[*cooi].qryend() + 1;
							string seq = ass_bank.ass_query.Contigs[ctg].seq.substr( amo.mcoords[*cooi].qryend()-1, len );
							ip.seq = getsuppl_str( seq );
							tile.pos_iPath = make_pair( 1, len );
						}
						tile.match = true;
						tile.coo = *cooi;
						ip.Tile_list.push_back( tile );
					} else
					{
						tile.pos_ctg = make_pair( amo.mcoords[*cooi].qryend(), amo.mcoords[*cooi].qrystart() );

						if ( amo.mcoords[*cooi].qrystart() < amo.mcoords[*cooi].qryend() )
						{
							int len = amo.mcoords[*cooi].qryend() - amo.mcoords[*cooi].qrystart() + 1;
							string seq = ass_bank.ass_query.Contigs[ctg].seq.substr( amo.mcoords[*cooi].qrystart()-1, len );
							ip.seq = getsuppl_str( seq );
							tile.pos_iPath = make_pair( 1, len );
						} else
						{
							int len = amo.mcoords[*cooi].qrystart() - amo.mcoords[*cooi].qryend() + 1;
							ip.seq = ass_bank.ass_query.Contigs[ctg].seq.substr( amo.mcoords[*cooi].qryend()-1, len );
							tile.pos_iPath = make_pair( 1, len );
						}
						tile.match = true;
						tile.coo = *cooi;
						ip.Tile_list.push_back( tile );
					}
				}
			}

			// add the next node
			Tile next_tile;
			next_tile.subject_ori = Subject_ori;
			next_tile.ctg = ctg;
			bool next_inorout;
			if ( left_node )
			{
				next_inorout = amo._1coord_edge[*ei].right_inorout;
			} else
			{
				next_inorout = amo._1coord_edge[*ei].left_inorout;
			}
		//	cout<<"next "<<Subject_ori<<" "<<next_inorout<<endl;
			if ( Subject_ori )
			{
				if ( next_inorout )
				{
					
					next_tile.pos_ctg = make_pair( amo.mcoords[*next_cooi].refend(), amo.mcoords[*next_cooi].refstart() );
					int len = amo.mcoords[*next_cooi].refend() - amo.mcoords[*next_cooi].refstart() + 1 + amo._1coord_edge[*ei].length;
					string seq = ass_bank.ass_subject.Contigs[ctg].seq.substr( amo.mcoords[*next_cooi].refstart()-1, len );
					string sup_seq = getsuppl_str( seq );
					ip.seq += sup_seq;
					int startpos = (int)ip.seq.size() - (amo.mcoords[*next_cooi].refend() - amo.mcoords[*next_cooi].refstart() + 1) + 1;
					next_tile.pos_iPath = make_pair( startpos, (int)ip.seq.size() );
					next_tile.match = true;
					next_tile.coo = *next_cooi;
					ip.Tile_list.push_back( next_tile );
				} else
				{
					next_tile.pos_ctg = make_pair( amo.mcoords[*next_cooi].refstart(), amo.mcoords[*next_cooi].refend() );
					int len = amo.mcoords[*next_cooi].refend() - amo.mcoords[*next_cooi].refstart() + 1 + amo._1coord_edge[*ei].length;
					int ctgstart = amo.mcoords[*next_cooi].refend() - len + 1;
					string seq = ass_bank.ass_subject.Contigs[ctg].seq.substr( ctgstart-1, len );
					ip.seq += seq;
					int startpos = (int)ip.seq.size() - (amo.mcoords[*next_cooi].refend() - amo.mcoords[*next_cooi].refstart() + 1) + 1;
					next_tile.pos_iPath = make_pair( startpos, (int)ip.seq.size() );
					next_tile.match = true;
					next_tile.coo = *next_cooi;
					ip.Tile_list.push_back( next_tile );
				}
			} else
			{
				if ( next_inorout )
				{
					if ( amo.mcoords[*next_cooi].qrystart() < amo.mcoords[*next_cooi].qryend() )
					{
						next_tile.pos_ctg = make_pair( amo.mcoords[*next_cooi].qryend(), amo.mcoords[*next_cooi].qrystart() );
						int len = amo.mcoords[*next_cooi].qryend() - amo.mcoords[*next_cooi].qrystart() + 1 + amo._1coord_edge[*ei].length;
						string seq = ass_bank.ass_query.Contigs[ctg].seq.substr( amo.mcoords[*next_cooi].qrystart()-1, len );
						string sup_seq = getsuppl_str( seq );
						ip.seq += sup_seq;
						int startpos = (int)ip.seq.size() - (amo.mcoords[*next_cooi].qryend() - amo.mcoords[*next_cooi].qrystart() + 1) + 1;
						next_tile.pos_iPath = make_pair( startpos, (int)ip.seq.size() );
						next_tile.match = true;
						next_tile.coo = *next_cooi;
						ip.Tile_list.push_back( next_tile );
					} else
					{
						next_tile.pos_ctg = make_pair( amo.mcoords[*next_cooi].qryend(), amo.mcoords[*next_cooi].qrystart() );
						int len = amo.mcoords[*next_cooi].qrystart() - amo.mcoords[*next_cooi].qryend() + 1 + amo._1coord_edge[*ei].length;
						int ctgstart = amo.mcoords[*next_cooi].qrystart() - len + 1;
						ip.seq += ass_bank.ass_query.Contigs[ctg].seq.substr( ctgstart-1, len );
						int startpos = (int)ip.seq.size() - (amo.mcoords[*next_cooi].qrystart() - amo.mcoords[*next_cooi].qryend() + 1) + 1;
						next_tile.pos_iPath = make_pair( startpos, (int)ip.seq.size() );
						next_tile.match = true;
						next_tile.coo = *next_cooi;
						ip.Tile_list.push_back( next_tile );
					}
				} else
				{
					
					if ( amo.mcoords[*next_cooi].qrystart() < amo.mcoords[*next_cooi].qryend() )
					{
						next_tile.pos_ctg = make_pair( amo.mcoords[*next_cooi].qrystart(), amo.mcoords[*next_cooi].qryend() );
						int len = amo.mcoords[*next_cooi].qryend() - amo.mcoords[*next_cooi].qrystart() + 1 + amo._1coord_edge[*ei].length;
						
						int ctgstart = amo.mcoords[*next_cooi].qryend() - len + 1;
						
						ip.seq += ass_bank.ass_query.Contigs[ctg].seq.substr( ctgstart-1, len );
						
						int startpos = (int)ip.seq.size() - (amo.mcoords[*next_cooi].qryend() - amo.mcoords[*next_cooi].qrystart() + 1) + 1;
						next_tile.pos_iPath = make_pair( startpos, (int)ip.seq.size() );
						next_tile.match = true;
						next_tile.coo = *next_cooi;
						ip.Tile_list.push_back( next_tile );  
					} else
					{
						next_tile.pos_ctg = make_pair( amo.mcoords[*next_cooi].qrystart(), amo.mcoords[*next_cooi].qryend() );
						int len = amo.mcoords[*next_cooi].qrystart() - amo.mcoords[*next_cooi].qryend() + 1 + amo._1coord_edge[*ei].length;
						
						string seq = ass_bank.ass_query.Contigs[ctg].seq.substr( amo.mcoords[*next_cooi].qryend()-1, len );
						string sup_seq = getsuppl_str( seq );
						ip.seq += sup_seq;
						
						
						int startpos = (int)ip.seq.size() - (amo.mcoords[*next_cooi].qrystart() - amo.mcoords[*next_cooi].qryend() + 1) + 1;
						next_tile.pos_iPath = make_pair( startpos, (int)ip.seq.size() );
						next_tile.match = true;
						next_tile.coo = *next_cooi;
						ip.Tile_list.push_back( next_tile );  
					}
				}
			}

			++cooi;
		}

		amo.iPath_ve.push_back( ip );
	}
}




void merge_fea_range( Assembly_Bank &ass_bank )
{
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		merge_fea_range_f( ass_bank.ass_subject.Contigs[i] );
	}
	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
		merge_fea_range_f( ass_bank.ass_query.Contigs[i] );
	}
}

void merge_fea_range_f( Contig &ctg )
{
	if ( !ctg.suspicious_range.empty() )
	{
		mergerange( ctg.suspicious_range );
	}
}

void output_fea( Assembly_Bank &ass_bank )
{
	ofstream outf( "fea" );
	outf<<"**Subject"<<endl;
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		outf<<">"<<ass_bank.ass_subject.Contigs[i].name<<endl;
		
		for ( size_t j = 0; j < ass_bank.ass_subject.Contigs[i].suspicious_range.size(); ++j )
		{
			outf<<ass_bank.ass_subject.Contigs[i].suspicious_range[j].first<<","<<ass_bank.ass_subject.Contigs[i].suspicious_range[j].second<<endl;
		}
		
	}

	outf<<"**Query"<<endl;
	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
		outf<<">"<<ass_bank.ass_query.Contigs[i].name<<endl;
		
		for ( size_t j = 0; j < ass_bank.ass_query.Contigs[i].suspicious_range.size(); ++j )
		{
			outf<<ass_bank.ass_query.Contigs[i].suspicious_range[j].first<<","<<ass_bank.ass_query.Contigs[i].suspicious_range[j].second<<endl;
		}
		
	}
}

void output_coo(Ass_Mapping &amo, Assembly_Bank &ass_bank  )
{
	ofstream outf( "coo" );
	for ( size_t i = 0; i < amo.mcoords.size(); ++i )
	{
		outf<<"C"<<i<<":"<<amo.mcoords[i].refname()<<","<<amo.mcoords[i].refstart()<<","<<amo.mcoords[i].refend()
			<<","<<amo.mcoords[i].qryname()<<","<<amo.mcoords[i].qrystart()<<","<<amo.mcoords[i].qryend()<<endl;
	}
}

void output_path( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector<Path > &path_ve, string &file )
{
	ofstream outf(file.data() );

	for ( size_t i = 0; i < path_ve.size(); ++i )
	{
		outf<<">Path"<<i<<endl;
		list< Coords_id >::iterator cooi = path_ve[i].coopath.begin();
		outf<<"C"<<*cooi<<":"<<amo.mcoords[*cooi].refname()<<","<<amo.mcoords[*cooi].refstart()<<","<<amo.mcoords[*cooi].refend()
			<<","<<amo.mcoords[*cooi].qryname()<<","<<amo.mcoords[*cooi].qrystart()<<","<<amo.mcoords[*cooi].qryend()<<endl;
		list< Edge_id >::iterator ei = path_ve[i].epath.begin();
		for ( ; ei != path_ve[i].epath.end(); ++ei )
		{
			list< Coords_id >::iterator next_cooi = cooi;
			++next_cooi;
			

			outf<<"E"<<*ei<<":"<<amo._1coord_edge[*ei].subjass<<",";
			if ( amo._1coord_edge[*ei].subjass )
				outf<<ass_bank.ass_subject.Contigs[amo._1coord_edge[*ei].ctg].name;
			else
				outf<<ass_bank.ass_query.Contigs[amo._1coord_edge[*ei].ctg].name;
			outf<<","<<amo._1coord_edge[*ei].coo_left<<","<<amo._1coord_edge[*ei].coo_right<<","<<amo._1coord_edge[*ei].length<<"|";
			outf<<amo._1coord_edge[*ei].left_inorout<<","<<amo._1coord_edge[*ei].right_inorout<<endl;

			outf<<"C"<<*next_cooi<<":"<<amo.mcoords[*next_cooi].refname()<<","<<amo.mcoords[*next_cooi].refstart()<<","<<amo.mcoords[*next_cooi].refend()
				<<","<<amo.mcoords[*next_cooi].qryname()<<","<<amo.mcoords[*next_cooi].qrystart()<<","<<amo.mcoords[*next_cooi].qryend()<<endl;
			++cooi;
		}
	}
	outf.close();
}

void output_ipath( Ass_Mapping &amo, Assembly_Bank &ass_bank, string &outprefix )
{
	string seqfile = outprefix + ".fa";
	string tilefile = outprefix + ".tile";
	ofstream seqf( seqfile.data() );
	ofstream tilef( tilefile.data() );
	for ( size_t i = 0; i < amo.iPath_ve.size(); ++i )
	{
		if ( amo.iPath_ve[i].seq.empty() )
			continue;
		seqf<<">"<<i+1<<endl;
		tilef<<">"<<i+1<<endl;
		string seq = amo.iPath_ve[i].seq;
		int k;
		for( k = 0; k < (int)seq.size()/65; k++ )
			seqf << seq.substr(65*k,65) << endl;
		if ( seq.substr(65*k).size() != 0 )    //пһС
			seqf << seq.substr(65*k) << endl;

		list< Tile >::iterator ite = amo.iPath_ve[i].Tile_list.begin();
		for ( ; ite != amo.iPath_ve[i].Tile_list.end(); ++ite )
		{
			tilef<<ite->pos_iPath.first<<","<<ite->pos_iPath.second;
			tilef<<"\t"<<ite->subject_ori;
			if ( ite->subject_ori )
				tilef<<","<<ass_bank.ass_subject.Contigs[ite->ctg].name;
			else
				tilef<<","<<ass_bank.ass_query.Contigs[ite->ctg].name;
			tilef<<","<<ite->pos_ctg.first<<","<<ite->pos_ctg.second;
			if ( !ite->match )
				tilef<<endl;
			else
			{
				tilef<<"\t"<<!ite->subject_ori;
				if ( ite->subject_ori )
				{
					tilef<<","<<amo.mcoords[ite->coo].qryname();
					if ( ite->pos_ctg.first == amo.mcoords[ite->coo].refstart() )   // means same direct
					{
						tilef<<","<<amo.mcoords[ite->coo].qrystart()<<","<<amo.mcoords[ite->coo].qryend();
					} else if ( ite->pos_ctg.first == amo.mcoords[ite->coo].refend() )
					{
						tilef<<","<<amo.mcoords[ite->coo].qryend()<<","<<amo.mcoords[ite->coo].qrystart();
					} else
					{
						cout<<"error coo tile "<<ite->pos_ctg.first<<","<<amo.mcoords[ite->coo].refstart()<<","<<amo.mcoords[ite->coo].refend()<<" "<<ite->coo<<endl;
						exit(1);
					}
					tilef<<endl;
				} else
				{
					tilef<<","<<amo.mcoords[ite->coo].refname();
					if ( ite->pos_ctg.first == amo.mcoords[ite->coo].qrystart() )   // means same direct
					{
						tilef<<","<<amo.mcoords[ite->coo].refstart()<<","<<amo.mcoords[ite->coo].refend();
					} else if ( ite->pos_ctg.first == amo.mcoords[ite->coo].qryend() )
					{
						tilef<<","<<amo.mcoords[ite->coo].refend()<<","<<amo.mcoords[ite->coo].refstart();
					} else
					{
						cout<<"error coo tile "<<ite->pos_ctg.first<<","<<amo.mcoords[ite->coo].qrystart()<<","<<amo.mcoords[ite->coo].qryend()<<" "<<ite->coo<<endl;
						exit(1);
					}
					tilef<<endl;
				}
			}
		}
	}
	seqf.close();
	tilef.close();
}

void output_ipathtile( Ass_Mapping &amo, Assembly_Bank &ass_bank, string &tilefile )
{
	
	ofstream tilef( tilefile.data() );
	for ( size_t i = 0; i < amo.iPath_ve.size(); ++i )
	{
		if ( amo.iPath_ve[i].seq.empty() )
			continue;
		
		tilef<<">"<<i+1<<endl;
		

		list< Tile >::iterator ite = amo.iPath_ve[i].Tile_list.begin();
		for ( ; ite != amo.iPath_ve[i].Tile_list.end(); ++ite )
		{
			tilef<<ite->pos_iPath.first<<","<<ite->pos_iPath.second;
			tilef<<"\t"<<ite->subject_ori;
			if ( ite->subject_ori )
				tilef<<","<<ass_bank.ass_subject.Contigs[ite->ctg].name;
			else
				tilef<<","<<ass_bank.ass_query.Contigs[ite->ctg].name;
			tilef<<","<<ite->pos_ctg.first<<","<<ite->pos_ctg.second;
			if ( !ite->match )
				tilef<<endl;
			else
			{
				tilef<<"\t"<<!ite->subject_ori;
				if ( ite->subject_ori )
				{
					tilef<<","<<amo.mcoords[ite->coo].qryname();
					if ( ite->pos_ctg.first == amo.mcoords[ite->coo].refstart() )   // means same direct
					{
						tilef<<","<<amo.mcoords[ite->coo].qrystart()<<","<<amo.mcoords[ite->coo].qryend();
					} else if ( ite->pos_ctg.first == amo.mcoords[ite->coo].refend() )
					{
						tilef<<","<<amo.mcoords[ite->coo].qryend()<<","<<amo.mcoords[ite->coo].qrystart();
					} else
					{
						cout<<"error coo tile "<<ite->pos_ctg.first<<","<<amo.mcoords[ite->coo].refstart()<<","<<amo.mcoords[ite->coo].refend()<<" "<<ite->coo<<endl;
						exit(1);
					}
					tilef<<endl;
				} else
				{
					tilef<<","<<amo.mcoords[ite->coo].refname();
					if ( ite->pos_ctg.first == amo.mcoords[ite->coo].qrystart() )   // means same direct
					{
						tilef<<","<<amo.mcoords[ite->coo].refstart()<<","<<amo.mcoords[ite->coo].refend();
					} else if ( ite->pos_ctg.first == amo.mcoords[ite->coo].qryend() )
					{
						tilef<<","<<amo.mcoords[ite->coo].refend()<<","<<amo.mcoords[ite->coo].refstart();
					} else
					{
						cout<<"error coo tile "<<ite->pos_ctg.first<<","<<amo.mcoords[ite->coo].qrystart()<<","<<amo.mcoords[ite->coo].qryend()<<" "<<ite->coo<<endl;
						exit(1);
					}
					tilef<<endl;
				}
			}
		}
	}
	
	tilef.close();
}

void gorepeat( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector<Path > &path_ve )
{
	ofstream logf("gorepeat.log");
	set< Coords_id > repeat_coo_set;
	set< size_t > remain_repeat;
	for ( size_t i = 0; i < amo.Repeats.size(); ++i )
	{
		logf<<"@R"<<i<<endl;
		set< Coords_id > ref_partial;
		set< Coords_id > ref_repeat;
		for ( size_t j = 0; j < amo.Repeats[i].ref_ve.size(); ++j )
		{
			if ( amo.Repeats[i].ref_ve[j].partial )
				ref_partial.insert( amo.Repeats[i].ref_ve[j].cooid );
			else
				ref_repeat.insert( amo.Repeats[i].ref_ve[j].cooid );
		}
		set< Coords_id > qry_partial;
		set< Coords_id > qry_repeat;
		for ( size_t j = 0; j < amo.Repeats[i].qry_ve.size(); ++j )
		{
			if ( amo.Repeats[i].qry_ve[j].partial )
				qry_partial.insert( amo.Repeats[i].qry_ve[j].cooid );
			else
				qry_repeat.insert( amo.Repeats[i].qry_ve[j].cooid );
		}
		logf<<"ref_p:"<<ref_partial.size()<<",ref_r:"<<ref_repeat.size()<<",qry_p:"<<qry_partial.size()<<",qry_r:"<<qry_repeat.size()<<endl;
		if ( !ref_partial.empty() || !qry_partial.empty() )
		{
			logf<<"Partial!"<<endl;
			for ( size_t k = 0; k < path_ve.size(); ++k )
			{
				if ( !path_ve[k].coopath.empty() )
				{
					if ( ref_repeat.find( path_ve[k].coopath.front() ) != ref_repeat.end() ||
						qry_repeat.find( path_ve[k].coopath.front() ) != qry_repeat.end() )
					{
						logf<<"pop front path "<<k<<", coo "<<path_ve[k].coopath.front()<<endl;
						path_ve[k].coopath.pop_front();
						if ( !path_ve[k].epath.empty() )
							path_ve[k].epath.pop_front();
					}
					
				}
				if ( !path_ve[k].coopath.empty() )
				{
					if ( ref_repeat.find( path_ve[k].coopath.back() ) != ref_repeat.end() ||
						qry_repeat.find( path_ve[k].coopath.back() ) != qry_repeat.end() )
					{
						logf<<"pop front path "<<k<<", coo "<<path_ve[k].coopath.back()<<endl;
						path_ve[k].coopath.pop_back();
						if ( !path_ve[k].epath.empty() )
							path_ve[k].epath.pop_back();
					}
				}
			}
		} else
		{
			logf<<"Remain"<<endl;
			remain_repeat.insert( i );
			repeat_coo_set.insert( ref_repeat.begin(), ref_repeat.end() );
			repeat_coo_set.insert( qry_repeat.begin(), qry_repeat.end() );
		}


	}

	map< Coords_id, pair< size_t, int > > reflk_map;    // <path, front_or_back >
	map< Coords_id, pair< size_t, int > > qrflk_map;    // <path, front_or_back >
	map< Coords_id, double > ref_upr_map;
	map< Coords_id, double > qry_upr_map;
	map< Coords_id, int > sole_rp;
	set< Coords_id > middle_rp;
	
	for ( size_t i = 0; i < path_ve.size(); ++i )
	{
		if ( !path_ve[i].coopath.empty() )
		{
			if ( (int)path_ve[i].coopath.size() == 1 )
			{
				if ( repeat_coo_set.find( path_ve[i].coopath.front() ) != repeat_coo_set.end() )
					sole_rp.insert( make_pair( path_ve[i].coopath.front(), i ) );
			} else
			{
				list< Coords_id >::iterator ci = path_ve[i].coopath.begin();
				list< Coords_id >::iterator endci = path_ve[i].coopath.end();
				--endci;
				++ci;
				for ( ; ci != endci; ++ci )
				{
					if ( ci == path_ve[i].coopath.end() )
					{
						cout<<"error 0881"<<endl; exit(1);
					}
					if ( repeat_coo_set.find( *ci ) != repeat_coo_set.end() )
						middle_rp.insert( *ci );
				}
				if ( repeat_coo_set.find( path_ve[i].coopath.front() ) != repeat_coo_set.end()  )
				{
					if ( amo._1coord_edge[path_ve[i].epath.front()].subjass )
					{
						reflk_map.insert( make_pair( path_ve[i].coopath.front(), make_pair( i, 1 ) ) );
						ref_upr_map.insert( make_pair( path_ve[i].coopath.front(), amo._1coord_edge[path_ve[i].epath.front()].uprate ) );
					} else
					{
						qrflk_map.insert( make_pair( path_ve[i].coopath.front(), make_pair( i, 1 ) ) );
						qry_upr_map.insert( make_pair( path_ve[i].coopath.front(), amo._1coord_edge[path_ve[i].epath.front()].uprate ) );
					}
					
				}
				if ( repeat_coo_set.find( path_ve[i].coopath.back() ) != repeat_coo_set.end() )
				{
					if ( amo._1coord_edge[path_ve[i].epath.back()].subjass )
					{
						reflk_map.insert( make_pair( path_ve[i].coopath.back(), make_pair( i, 0 ) ) );
						ref_upr_map.insert( make_pair( path_ve[i].coopath.back(), amo._1coord_edge[path_ve[i].epath.back()].uprate ) );
					} else
					{
						qrflk_map.insert( make_pair( path_ve[i].coopath.back(), make_pair( i, 0 ) ) );
						qry_upr_map.insert( make_pair( path_ve[i].coopath.back(), amo._1coord_edge[path_ve[i].epath.back()].uprate ) );
					}
				}
			}
		}
	}

	logf<<endl;
	// log
	logf<<"ref linked repeat coo"<<endl;
	for ( map< Coords_id, pair< size_t, int > >::iterator ite = reflk_map.begin(); ite != reflk_map.end(); ++ite )
	{
		logf<<">refcoo"<<ite->first<<", path"<<ite->second.first<<", "<<ite->second.second<<", uprate:"<<ref_upr_map[ite->first]<<endl;
	}
	logf<<"qry linked repeat coo"<<endl;
	for ( map< Coords_id, pair< size_t, int > >::iterator ite = qrflk_map.begin(); ite != qrflk_map.end(); ++ite )
	{
		logf<<">qrycoo"<<ite->first<<", path"<<ite->second.first<<", "<<ite->second.second<<", uprate:"<<qry_upr_map[ite->first]<<endl;
	}
	logf<<"sole repeat coo"<<endl;
	for ( map< Coords_id, int >::iterator ite = sole_rp.begin(); ite != sole_rp.end(); ++ite )
	{
		logf<<">solecoo"<<ite->first<<", path"<<ite->second<<endl;
	}
	
	logf<<"middle repeat coo"<<endl;
	for ( set< Coords_id >::iterator ite = middle_rp.begin(); ite != middle_rp.end(); ++ite )
	{
		logf<<">middlecoo"<<*ite<<endl;
	}
	logf<<endl;

	for ( set<size_t >::iterator ite = remain_repeat.begin(); ite != remain_repeat.end(); ++ite )
	{
		logf<<"GR"<<*ite<<endl;
		set< pair<Coords_id, int > > goodlk_repeat;
		set< pair<Coords_id, int > > badlk_repeat;
		set< Coords_id > sole_repeat;
		set< Coords_id > middle_repeat;
		set< Coords_id > repeat_coo;
		for ( size_t i = 0; i < amo.Repeats[*ite].ref_ve.size(); ++i )
		{
			repeat_coo.insert( amo.Repeats[*ite].ref_ve[i].cooid );
		}
		for ( size_t i = 0; i < amo.Repeats[*ite].qry_ve.size(); ++i )
		{
			repeat_coo.insert( amo.Repeats[*ite].qry_ve[i].cooid );
		}
		if ( repeat_coo.empty() )
		{
			logf<<"repeat empty"<<endl;
			continue;
		}
		for ( set< Coords_id >::iterator ri = repeat_coo.begin(); ri != repeat_coo.end(); ++ri )
		{

			if ( ref_upr_map.find( *ri ) != ref_upr_map.end() )
			{
				if ( ref_upr_map[*ri] < 0.05 )
					goodlk_repeat.insert( make_pair( *ri, 1 ) );
				else
					badlk_repeat.insert( make_pair( *ri, 1 ) );
			}
			if ( qry_upr_map.find( *ri ) != qry_upr_map.end() )
			{
				if ( qry_upr_map[*ri] < 0.05 )
					goodlk_repeat.insert( make_pair( *ri, 0 ) );
				else
					badlk_repeat.insert( make_pair( *ri, 0 ) );
			}
			if ( sole_rp.find( *ri ) != sole_rp.end() )
				sole_repeat.insert( *ri );
			if ( middle_rp.find( *ri ) != middle_rp.end() )
				middle_repeat.insert( *ri );
		}

		//log
		logf<<"goodlk_repeat:";
		for ( set< pair<Coords_id, int > >::iterator gi = goodlk_repeat.begin(); gi != goodlk_repeat.end(); ++gi )
		{
			logf<<" "<<gi->first<<",";
			if ( gi->second == 1 )
				logf<<"ref";
			else
				logf<<"qry";
		}
		logf<<endl;
		logf<<"badlk_repeat:";
		for ( set< pair<Coords_id, int > >::iterator gi = badlk_repeat.begin(); gi != badlk_repeat.end(); ++gi )
		{
			logf<<" "<<gi->first<<",";
			if ( gi->second == 1 )
				logf<<"ref";
			else
				logf<<"qry";
		}
		logf<<endl;
		logf<<"sole:"<<endl;
		for ( set< Coords_id >::iterator gi = sole_repeat.begin(); gi != sole_repeat.end(); ++gi )
			logf<<" "<<*gi;
		logf<<endl;
		logf<<"middle:"<<endl;
		for ( set< Coords_id >::iterator gi = middle_repeat.begin(); gi != middle_repeat.end(); ++gi )
			logf<<" "<<*gi;
		logf<<endl;

		if ( !middle_repeat.empty() )
		{
			logf<<"middle exist, erase all link and sole repeats"<<endl;
			if ( !badlk_repeat.empty() )
			{
				erase_repeat_lk( badlk_repeat, path_ve, reflk_map, qrflk_map );
			}
			if ( !goodlk_repeat.empty() )
			{
				erase_repeat_lk( goodlk_repeat, path_ve, reflk_map, qrflk_map );
			}
			for ( set< Coords_id >::iterator si = sole_repeat.begin(); si != sole_repeat.end(); ++si )
			{
				size_t pth = sole_rp[*si];
				if ( !path_ve[pth].coopath.empty() )
				{
					path_ve[pth].coopath.clear();
				}
			}
		} else if ( (int)goodlk_repeat.size() == 1 )
		{
			logf<<"only one goodlk_repeat, reserve good repeat"<<endl;
			if ( !badlk_repeat.empty() )
			{
				erase_repeat_lk( badlk_repeat, path_ve, reflk_map, qrflk_map );
			}

			for ( set< Coords_id >::iterator si = sole_repeat.begin(); si != sole_repeat.end(); ++si )
			{
				size_t pth = sole_rp[*si];
				if ( !path_ve[pth].coopath.empty() )
				{
					path_ve[pth].coopath.clear();
				}
			}
		} else
		{
			logf<<"erase all link"<<endl;
			if ( !badlk_repeat.empty() )
			{
				erase_repeat_lk( badlk_repeat, path_ve, reflk_map, qrflk_map );
			}
			if ( !goodlk_repeat.empty() )
			{
				erase_repeat_lk( goodlk_repeat, path_ve, reflk_map, qrflk_map );
			}

			if ( !sole_repeat.empty() )
			{
				logf<<"reserve one sole"<<endl;
				set< Coords_id >::iterator si = sole_repeat.begin();
				++si;
				for ( ; si != sole_repeat.end(); ++si )
				{
					size_t pth = sole_rp[*si];
					if ( !path_ve[pth].coopath.empty() )
					{
						path_ve[pth].coopath.clear();
					}
				}
			} else
			{
				logf<<"add one sole"<<endl;
				Path p;
				p.coopath.push_back( *repeat_coo.begin() );
				path_ve.push_back( p );
			}
		}
	}
}

void erase_repeat_lk( set< pair<Coords_id, int > >& repeat_lk,
	vector<Path > &path_ve,
	map< Coords_id, pair< size_t, int > > reflk_map,
	map< Coords_id, pair< size_t, int > > qrflk_map )
{
	for ( set< pair<Coords_id, int > >::iterator bi = repeat_lk.begin(); bi != repeat_lk.end(); ++bi )
	{
		size_t pth;
		int forb;
		if ( bi->second ==  1 )
		{
			if ( reflk_map.find( bi->first ) == reflk_map.end() )
			{
				cout<<"error reflk_map no find "<<bi->first<<endl; exit(1);
			}
			pth = reflk_map[bi->first].first;
			forb = reflk_map[bi->first].second;
					
		} else
		{
			if ( qrflk_map.find( bi->first ) == qrflk_map.end() )
			{
				cout<<"error qrflk_map no find "<<bi->first<<endl; exit(1);
			}
			pth = qrflk_map[bi->first].first;
			forb = qrflk_map[bi->first].second;
		}
		if ( forb == 1 )
		{
			if ( !path_ve[pth].coopath.empty() )
			{
				if ( path_ve[pth].coopath.front() == bi->first )
				{
					path_ve[pth].coopath.pop_front();
					if ( !path_ve[pth].epath.empty() )
						path_ve[pth].epath.pop_front();
				}
			}
		} else
		{
			if ( !path_ve[pth].coopath.empty() )
			{
				if ( path_ve[pth].coopath.back() == bi->first )
				{
					path_ve[pth].coopath.pop_back();
					if ( !path_ve[pth].epath.empty() )
						path_ve[pth].epath.pop_back();
				}
			}
		}
	}
}

void traceback( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector<Path > &path_ve )
{
	for ( size_t i = 0; i < path_ve.size(); ++i )
	{
		if ( path_ve[i].coopath.empty() )
			continue;

		list< Coords_id >::iterator cooi = path_ve[i].coopath.begin();
		Ctg_id refctg = ass_bank.ass_subject.ctg_name_map[amo.mcoords[*cooi].refname()];
		Ctg_id qryctg = ass_bank.ass_query.ctg_name_map[amo.mcoords[*cooi].qryname()];
		pair< int, int > refrg = make_pair( amo.mcoords[*cooi].refstart(), amo.mcoords[*cooi].refend() );
		pair< int, int > qryrg = orderrange( make_pair( amo.mcoords[*cooi].qrystart(), amo.mcoords[*cooi].qryend() ) );
		ass_bank.ass_subject.Contigs[refctg].uni_mapping_coo.insert( make_pair( refrg, *cooi ) );
		ass_bank.ass_query.Contigs[qryctg].uni_mapping_coo.insert( make_pair( qryrg, *cooi ) );

		if ( path_ve[i].epath.empty() )
		{
			if ( amo.in_noavail_coo_bycontr.find( *cooi ) == amo.in_noavail_coo_bycontr.end() )
				amo.in_avail_coo.insert( make_pair( *cooi, make_pair( i, 0 ) ) );
			if ( amo.out_noavail_coo_bycontr.find( *cooi ) == amo.out_noavail_coo_bycontr.end() )
				amo.out_avail_coo.insert( make_pair( *cooi, make_pair( i, 1 ) ) );
		} else
		{
			list< Edge_id >::iterator ei = path_ve[i].epath.begin(); 
			bool left_coo;
			if ( amo._1coord_edge[*ei].coo_left == *cooi )
				left_coo = true;
			else if ( amo._1coord_edge[*ei].coo_right == *cooi )
				left_coo = false;
			else
			{
				cout<<"error wrong coo "<<*cooi<<" in edge "<<*ei<<endl; exit(1);
			}
			if ( left_coo )
			{
				if ( amo._1coord_edge[*ei].left_inorout )
				{
					if ( amo.out_noavail_coo_bycontr.find( *cooi ) == amo.out_noavail_coo_bycontr.end() )
						amo.out_avail_coo.insert( make_pair( *cooi, make_pair( i, 1 ) ) );
				} else
				{
					if ( amo.in_noavail_coo_bycontr.find( *cooi ) == amo.in_noavail_coo_bycontr.end() )
						amo.in_avail_coo.insert( make_pair( *cooi, make_pair( i, 1 ) ) );
				}
			} else
			{
				if ( amo._1coord_edge[*ei].right_inorout )
				{
					if ( amo.out_noavail_coo_bycontr.find( *cooi ) == amo.out_noavail_coo_bycontr.end() )
						amo.out_avail_coo.insert( make_pair( *cooi, make_pair( i, 1 ) ) );
				} else
				{
					if ( amo.in_noavail_coo_bycontr.find( *cooi ) == amo.in_noavail_coo_bycontr.end() )
						amo.in_avail_coo.insert( make_pair( *cooi, make_pair( i, 1 ) ) );
				}
			}

			list< Coords_id >::reverse_iterator rcooi = path_ve[i].coopath.rbegin();
			list< Edge_id >::reverse_iterator rei = path_ve[i].epath.rbegin();
			if ( amo._1coord_edge[*rei].coo_left == *rcooi )
				left_coo = true;
			else if ( amo._1coord_edge[*rei].coo_right == *rcooi )
				left_coo = false;
			else
			{
				cout<<"error wrong coo "<<*rcooi<<" in edge "<<*rei<<endl; exit(1);
			}
			if ( left_coo )
			{
				if ( amo._1coord_edge[*rei].left_inorout )
				{
					if ( amo.out_noavail_coo_bycontr.find( *rcooi ) == amo.out_noavail_coo_bycontr.end() )
						amo.out_avail_coo.insert( make_pair( *rcooi, make_pair( i, 0 ) ) );
				} else
				{
					if ( amo.in_noavail_coo_bycontr.find( *rcooi ) == amo.in_noavail_coo_bycontr.end() )
						amo.in_avail_coo.insert( make_pair( *rcooi, make_pair( i, 0 ) ) );
				}
			} else
			{
				if ( amo._1coord_edge[*rei].right_inorout )
				{
					if ( amo.out_noavail_coo_bycontr.find( *rcooi ) == amo.out_noavail_coo_bycontr.end() )	
						amo.out_avail_coo.insert( make_pair( *rcooi, make_pair( i, 0 ) ) );
				} else
				{
					if ( amo.in_noavail_coo_bycontr.find( *rcooi ) == amo.in_noavail_coo_bycontr.end() )
						amo.in_avail_coo.insert( make_pair( *rcooi, make_pair( i, 0 ) ) );
				}
			}
		}

		list< Edge_id >::iterator ei = path_ve[i].epath.begin(); 
		for ( ; ei != path_ve[i].epath.end(); ++ei )
		{
			list< Coords_id >::iterator next_cooi = cooi;
			++next_cooi;
			refctg = ass_bank.ass_subject.ctg_name_map[amo.mcoords[*next_cooi].refname()];
			qryctg = ass_bank.ass_query.ctg_name_map[amo.mcoords[*next_cooi].qryname()];
			refrg = make_pair( amo.mcoords[*next_cooi].refstart(), amo.mcoords[*next_cooi].refend() );
			qryrg = orderrange( make_pair( amo.mcoords[*next_cooi].qrystart(), amo.mcoords[*next_cooi].qryend() ) );
			ass_bank.ass_subject.Contigs[refctg].uni_mapping_coo.insert( make_pair( refrg, *next_cooi ) );
			ass_bank.ass_query.Contigs[qryctg].uni_mapping_coo.insert( make_pair( qryrg, *next_cooi ) );

			if ( amo._1coord_edge[*ei].length > 0 )
			{
				if ( amo._1coord_edge[*ei].subjass )
				{
					Ctg_id ctg = amo._1coord_edge[*ei].ctg;
					pair< int, int > gaprg;
					if ( amo.mcoords[*next_cooi].refstart() > amo.mcoords[*cooi].refstart() )
					{
						gaprg = make_pair( amo.mcoords[*cooi].refend()+1, amo.mcoords[*next_cooi].refstart()-1 );
					} else
					{
						gaprg = make_pair( amo.mcoords[*next_cooi].refend() + 1, amo.mcoords[*cooi].refstart()-1 );
					}
					ass_bank.ass_subject.Contigs[ctg].gap_on_path.insert( gaprg );
				} else
				{
					Ctg_id ctg = amo._1coord_edge[*ei].ctg;
					pair< int, int > gaprg;
					if ( amo.mcoords[*next_cooi].qrystart() > amo.mcoords[*cooi].qrystart() )
					{
						int pos1 = max( amo.mcoords[*cooi].qrystart(), amo.mcoords[*cooi].qryend() );
						int pos2 = min( amo.mcoords[*next_cooi].qrystart(), amo.mcoords[*next_cooi].qryend() );
						gaprg = make_pair( pos1, pos2 );
					} else
					{
						int pos1 = max( amo.mcoords[*next_cooi].qrystart(), amo.mcoords[*next_cooi].qryend() );
						int pos2 = min( amo.mcoords[*cooi].qrystart(), amo.mcoords[*next_cooi].qryend() );
						gaprg = make_pair( pos1, pos2 );
					}
					ass_bank.ass_query.Contigs[ctg].gap_on_path.insert( gaprg );
				}
			}

			++cooi;
		}
	}

	ofstream outf( "uni_mapping_coo" );
	outf<<"**Subject"<<endl;
	for ( size_t i = 0; i < ass_bank.ass_subject.Contigs.size(); ++i )
	{
		outf<<">"<<ass_bank.ass_subject.Contigs[i].name<<endl;
		map< pair<int, int >, Coords_id >::iterator subi;
		for ( subi = ass_bank.ass_subject.Contigs[i].uni_mapping_coo.begin(); 
			subi != ass_bank.ass_subject.Contigs[i].uni_mapping_coo.end(); ++subi )
		{
			outf<<"\t("<<subi->first.first<<","<<subi->first.second<<","<<subi->second<<")";
		}
		outf<<endl;
		
	}

	outf<<"**Query"<<endl;
	for ( size_t i = 0; i < ass_bank.ass_query.Contigs.size(); ++i )
	{
		outf<<">"<<ass_bank.ass_query.Contigs[i].name<<endl;
		map< pair<int, int >, Coords_id >::iterator subi;
		for ( subi = ass_bank.ass_query.Contigs[i].uni_mapping_coo.begin(); 
			subi != ass_bank.ass_query.Contigs[i].uni_mapping_coo.end(); ++subi )
		{
			outf<<"\t("<<subi->first.first<<","<<subi->first.second<<","<<subi->second<<")";
		}
		outf<<endl;
		
	}
}

void output_avail_coo( Ass_Mapping &amo )
{
	ofstream outf("avail_coo");
	for ( map< Coords_id, pair< size_t, int > >::iterator ite = amo.in_avail_coo.begin(); ite != amo.in_avail_coo.end(); ++ite )
	{
		outf<<"in "<<ite->first<<","<<ite->second.first<<","<<ite->second.second<<endl;
	}
	for ( map< Coords_id, pair< size_t, int > >::iterator ite = amo.out_avail_coo.begin(); ite != amo.out_avail_coo.end(); ++ite )
	{
		outf<<"out "<<ite->first<<","<<ite->second.first<<","<<ite->second.second<<endl;
	}
	outf.close();
}

