#ifndef ANA_MAPPING_H
#define ANA_MAPPING_H

#include "bank.h"
#include "flib.h"

void AssignMcoordsToCtg( Ass_Mapping &amo, Assembly_Bank &ass_bank );

void findrepeatCoords( Ass_Mapping &amo, Assembly_Bank &ass_bank );

pair<int, int > findcorrespondregion_forqry( Coords &coo, pair<int, int > refrg );
pair<int, int > findcorrespondregion_forref( Coords &coo, pair<int, int > qryrg );

void outputRepeat( Ass_Mapping& amo, Assembly_Bank &ass_bank );

void SupplementUnmappingSubjectCtg( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector< Coords >& con_mcoove );


// get uniq_mapping range
void uniq_mapping_range( Assembly_Bank &ass_bank );
void uniq_mapping_range_f( Contig &ctg );

void protect_good_ctg_t( Contig &ctg );
void protect_good_ctg( Assembly_Bank &ass_bank );

void check_break_by_validat( Assembly_Bank &ass_bank );
void check_break_by_validat_f( Contig &ctg );

double calculateEdgeUprate( Contig &ctg, int pos1_onctg, int pos2_onctg );

void get_1coord_edge( Ass_Mapping &amo, Assembly_Bank &ass_bank, int s_rank );

void comp_edge_rule1( Ass_Mapping &amo, Assembly_Bank &ass_bank, size_t edge1, size_t edge2, Coords_id coo, int &result, int s_rank );
void comp_edge_rule2( Ass_Mapping &amo, Assembly_Bank &ass_bank, size_t edge1, pair<bool, Ctg_id > unmap, bool unmap_in, Coords_id coo, int &result, int s_rank );

void erase_broken_edge( Ass_Mapping &amo, Assembly_Bank &ass_bank );

void get_path( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector< Path >& path_ve  );

void trans_path( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector<Path > &path_ve );


void merge_fea_range( Assembly_Bank &ass_bank );
void merge_fea_range_f( Contig &ctg );
//
void output_fea( Assembly_Bank &ass_bank );
void output_edge( Ass_Mapping &amo, Assembly_Bank &ass_bank );

void output_unimap( Assembly_Bank &ass_bank, string & file  );

void output_path( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector<Path > &path_ve, string &file );

void output_ipath( Ass_Mapping &amo, Assembly_Bank &ass_bank, string &outprefix );

void output_ipathtile( Ass_Mapping &amo, Assembly_Bank &ass_bank, string &tilefile );

void gorepeat( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector<Path > &path_ve );

void erase_repeat_lk( set< pair<Coords_id, int > >& repeat_lk,
	vector<Path > &path_ve,
	map< Coords_id, pair< size_t, int > > reflk_map,
	map< Coords_id, pair< size_t, int > > qrflk_map );

void output_coo(Ass_Mapping &amo, Assembly_Bank &ass_bank  );

void traceback( Ass_Mapping &amo, Assembly_Bank &ass_bank, vector<Path > &path_ve );

void output_avail_coo( Ass_Mapping &amo );

#endif
