#ifndef BANK_H
#define BANK_H
//#include "contig_matches.h"
#include "contig_matches2.h"
#include <map>
#include <set>
#include <vector>
#include <string>
#include <list>
#include <iostream>
#include <fstream>
//#include "flib.h"
#include <cstdlib>
using namespace std;

typedef int Ctg_id;
typedef size_t Coords_id;
typedef size_t Repeat_id;
class Contig
{
public:
	string name;
	int length;
	string seq;

	multimap< pair<int, int >, Coords_id > mapping;
	map< pair<int, int >, Repeat_id > repeat;
	vector< pair<int, int > > repeat_region;

	vector< pair<int, int > > uni_mapping_range;
	vector< bool > break_by_validate;
	vector< pair<bool, bool > > unmaplink;   // <left_link, right_link>
	map< pair<int, int >, Coords_id > uni_mapping_coo;
	set< pair<int, int > > gap_on_path;
	bool good_protect;

	vector< pair<int, int > > suspicious_range;
	map< int, double > fwup_rate_map;
	map< int, double > rvup_rate_map;
};

class Assembly
{
public:
	string name;
	map< string, Ctg_id > ctg_name_map;
	vector< Contig > Contigs;
//	vector< Scaffold > Scafs;

//	map< Ctg_id, Scaffold_link > gena_scf_link( Scf_id & );
};

class Assembly_Bank
{
public:
	Assembly ass_subject;
	Assembly ass_query;
	
};

class RepeatRegion
{
public:
	Ctg_id cid;
	pair<int, int > rg;
	Coords_id cooid;
	bool partial;            //the repeat region is partial of the coord region. otherwise equal to. 
	
};



class RepeatRegionCluster
{
public:
	vector< RepeatRegion > ref_ve;
	vector< RepeatRegion > qry_ve;
};





typedef vector< Coords >::iterator Coo_ite;

typedef vector< Feature > Ctg_Features;

class Edge
{
public:
	Coords_id coo_left;
	bool left_inorout;    // true in, else out
	Coords_id coo_right;
	bool right_inorout;
	bool subjass;   // or query ass
	Ctg_id ctg;
	size_t break_point;
	int length;

	double uprate;  // get maximal
	
};

typedef size_t Edge_id;

class Path
{
public:
	list< Edge_id > epath;
	list< Coords_id > coopath;
};

class Tile
{
public:
	bool subject_ori;
	Ctg_id ctg;
	pair< int, int > pos_iPath;
	pair< int, int > pos_ctg;
	bool match;
	Coords_id coo;
};

class iPath
{
public:
	string seq;
	list< Tile > Tile_list; 
	
};

class Seg
{
public:
	Ctg_id ctg;
	int start;
	int end;
	bool subject;
};

typedef size_t Seg_id;

class Ass_Mapping
{
public:

	string qry_assembly_name;
	string ref_assembly_name;

	vector< Coords > mcoords;
/*	map< Ctg_id, map< Ctg_id, vector< Coords > > > temp;

	map< Ctg_id, map< Ctg_id, vector< Coords > > > R_Q_1coo_map;
	map< Ctg_id, map< Ctg_id, vector< Coords > > > Q_R_1coo_map;
	map< Ctg_id, map< Ctg_id, vector< Coords > > > Q_R_dcoo_map;
	map< Ctg_id, map< Ctg_id, vector< Coords > > > R_Q_dcoo_map;

	map< Ctg_id, Ctg_Features > R_Features_map;
	map< Ctg_id, Ctg_Features > Q_Features_map;

	set< Ctg_id > unalign_ref;
	set< Ctg_id > unalign_qry; */

//	map< Coords_id, set<Coords_id > > Repeats_map;
//	set< Coords_id > Repeats;
	vector<RepeatRegionCluster > Repeats;
	
	set< Coords_id > fringe_repeat;

//	set< Coords_id > _1coord_set;
	set< Coords_id > ref_1coord_set;
	set< Coords_id > qry_1coord_set;

	vector< Edge > _1coord_edge;

	vector< iPath > iPath_ve;

	vector< Seg > ref_unmapseg;
	vector< Seg > qry_unmapseg;

	set< Coords_id > in_noavail_coo_bycontr;   // caused by contradict links
	set< Coords_id > out_noavail_coo_bycontr;

	map< Coords_id, pair< size_t, int > > in_avail_coo;   // <pathid, front_or_back>  0 back, 1 front
	map< Coords_id, pair< size_t, int > > out_avail_coo;   // <pathid, front_or_back>


};

class ctgfrg
{
public:
	bool subject_ori;
	Ctg_id ctg;
	int start;
	int end;
	vector< pair<int, int > > unoverlap_rg;
	vector< int > unoverlap_tile;
	int first_occupy_tile;
	int last_occupy_tile;
	bool direct;  // same or not
	
	int total_len;
	int left_fringe_overlap_len;
	int right_fringe_overlap_len;
};

/*
/////////////////////////////////////////////////////
class Ass_Map_Bank
{
public:

	map< string, size_t > ass_name_map;    // 

	vector< Ass_Mapping > pa_ass_mapping;

	map< size_t, map< size_t, size_t > > pa_map;    // < ass_id, < ass_id, match_bank_key > >

	
};


class Alignment
{
public:
	size_t subject_ass_id;
	size_t query_ass_id;
	Ctg_id subject_ctg_id;
	Ctg_id query_ctg_id;

	vector< int > coordinate;

	vector< int > offset;

	Alignment( size_t id1, size_t id2, Ctg_id cid1, Ctg_id cid2 )
	{
		subject_ass_id = id1;
		query_ass_id = id2;
		subject_ctg_id = cid1;
		query_ctg_id = cid2;
	};

	int get_subj_start();
	int get_subj_end();
	int get_qury_start();
	int get_qury_end();

	int get_subj_start_from_ctg();
	int get_subj_end_from_ctg();
	int get_qury_start_from_ctg();
	int get_qury_end_from_ctg();
	int get_align_len();
	bool qury_fw();
	pair<bool, bool> self_trim();
};




class Alignment_Bank
{
public:
	vector< Alignment > AlignmentVe;
	vector< vector< map< pair< int, int >, vector<size_t> > > > cor_align_map;
	map< size_t, map< Ctg_id, map< pair< int, int >, vector<size_t> > > > align_trim_index_map;
	void ini_bank( Assembly_Bank &ass_bank );
};


class Single_Segment
{
public:
	size_t ass_id;
	Ctg_id ctg_id;
	int start;        // start can either be front of end or be back of end
	int end;
	map< size_t, pair< int, int > > bone_seg;       // the bone seg of single_segment, the key indicates the ref ass which it aligned.
	set< size_t > DUP;   // DUP compare with ass size_t.
	bool fw();
	bool single_base();
	double getDUPscore();
};

class Shared_Segment
{
public:
	bool uni;        // 
	bool rep;        // 
	bool dup;
	bool bootless;   //
	map< size_t, Single_Segment > subord_seg;
	vector< pair< size_t, bool > > subord_uni_seg;

	map< size_t, Single_Segment > mapped_subord_seg;
	map< size_t, pair<int,int > > unmapped_gap;

	Shared_Segment()
	{
		uni = true;
		rep = false;
		dup = false;
		bootless = false;
	}

	int get_subord_seg_start( size_t subord_ass );
	int get_subord_seg_end( size_t subord_ass );
	Ctg_id get_subord_seg_ctgid( size_t subord_ass );
	bool get_subord_seg_fw( size_t subord_ass );

	int getsubordnumber();
	int getlength();
	double getDUPscore();
	
};

typedef size_t S_seg_id;

class Cnct_type
{
public:
	int type;    // 0, 
};

class Partial_Bubbles
{
public:
	vector< size_t > assve;
	vector< Ctg_id > ctgve;
	vector< int > fwve;   // 1 forward, 0 backward.
	vector< list<S_seg_id > > seglistve;
	vector< list< pair<int, int > > > segposve;
	int fulsize;

};

class Segment_Chain
{
public:
	size_t ord_ass;
	list< S_seg_id > S_seg_list;
	map< S_seg_id, Cnct_type > fw_seg_cnct_map;
	map< S_seg_id, Cnct_type > rev_seg_cnct_map;

};

class Rep_Segment
{
public:
	size_t ass;
	Ctg_id ctg;
	pair<int, int > range; // front can be smaller than end

};

class Segment_Bank
{
public:
	vector< Shared_Segment > S_seg;

	map< size_t, map< Ctg_id, Segment_Chain > > ass_ord_seg_chain;

	int get_seg_begin( S_seg_id, size_t );     // get Shared_segment's subordinate single_segment start < S_seg_id, subord_ass_id >
	int get_seg_end( S_seg_id, size_t );
	int get_seg_begin_from_ctg( S_seg_id, size_t );
	int get_seg_end_from_ctg( S_seg_id, size_t );
	int get_seg_ctg_id( S_seg_id, size_t ); 
	bool get_seg_fw( S_seg_id, size_t );

	void get_cover_chain( size_t, Ctg_id, pair<int, int>, list< pair<int, int> >&, list< S_seg_id >& );
	//                   <ass_id, Ctg_id, ctg_range     , cut range list         , cover_S_seg_id list>
	bool fringe( S_seg_id, size_t, int );
	bool begin_fringe_from_ctg( S_seg_id, size_t, int );
	bool end_fringe_from_ctg( S_seg_id, size_t, int );

	///////////////////////
	//repeat region
	vector< Shared_Segment > Dup_seg;
	vector< Shared_Segment > Cmpr_seg;
	vector< Shared_Segment > Rep_seg;

};

void showseg( Shared_Segment &seg, ofstream& outf);
*/
#endif
