#include "flib.h"


bool pos_overlap( int begin_a, int end_a, int begin_b, int end_b )
{
	if ( begin_a < begin_b ) {
		if ( begin_b < end_a )
			return true;
		else
			return false;
	} else {
		if ( begin_a < end_b )
			return true;
		else
			return false;
	}
}

bool pos_overlap( pair<int, int> range, vector< pair<int, int> > & cover_v )
	// require: each range in the cover_v must not be containd in the range. range.first < range.second.
{
	int len = range.second - range.first + 1;
	pair< int, int > left_range = range;
	for ( vector<pair<int, int> >::iterator ci = cover_v.begin(); ci != cover_v.end(); ++ci )
	{
		if ( left_range.first > ci->second || left_range.second < ci->first )
			continue;
		if ( left_range.first <= ci->second && left_range.first >= ci->first )
		{
			if ( left_range.second <= ci->second )
				return true;
			else
			{
				left_range.first = ci->second+1;
			}
		} else if ( left_range.second <= ci->second && left_range.second >= ci->first )
		{
			if ( left_range.first >= ci->first )
				return true;
			else
				left_range.second = ci->second-1;
		}
	}
	int left_len = left_range.second - left_range.first + 1;
	double ov = double( len - left_len ) / len;
	if ( ov >= 0.95 )
		return true;
	else
		return false;
}

bool pos_overlap( pair<int, int> a, pair<int, int > b )
{
	if ( a.second - a.first < b.second - b.first )
	{
		if ( a.second >= b.first && a.second <= b.second )
		{
			if ( a.first >= b.first )
				return true;
			else
			{
				int ov = a.second - b.first + 1;
				int alen = a.second - a.first + 1;
				if ( (double)ov / alen >= 0.8 )
					return true;
				else
					return false;
			}
		} else if ( a.first >= b.first && a.first <= b.second )
		{
			if ( a.second <= b.second )
				return true;
			else
			{
				int ov = b.second - a.first + 1;
				int alen = a.second - a.first + 1;
				if ( (double)ov / alen >= 0.8 )
					return true;
				else
					return false;
			}
		} else
			return false;
	} else
	{
		if ( b.second >= a.first && b.second <= a.second )
		{
			if ( b.first >= a.first )
				return true;
			else
			{
				int ov = b.second - a.first +1;
				int blen = b.second - b.first + 1;
				if ( (double)ov / blen >= 0.8 )
					return true;
				else
					return false;
			}
		} else if ( b.first >= a.first && b.first <= a.second )
		{
			if ( b.second <= a.second )
				return true;
			else
			{
				int ov = a.second - b.first + 1;
				int blen = b.second - b.first + 1;
				if ( (double)ov / blen >= 0.8 )
					return true;
				else
					return false;
			}
		} else
			return false;
	}

	return false;

	
}

bool pos_overlap_both( pair<int, int> a, pair<int, int > b )   // if the overlap occupies larger than 90% of each seg, return true
{
	if ( a.second < a.first )
		a = make_pair( a.second, a.first );
	if ( b.second < b.first )
		b = make_pair( b.second, b.first );
	if ( a.second < b.first || b.second < a.first )
		return false;

	int overlap = min( a.second, b.second ) - max( a.first, b.first )+1;
	int alen = a.second-a.first+1;
	int blen = b.second-b.first+1;
	if ( (double)overlap / alen >= 0.8 && (double)overlap/blen >= 0.8 )
		return true;
	else
		return false;
	
}

bool getminusrange( pair<int, int> range, vector< pair<int, int> > & cover_v, pair<int, int> &left_range )    // if empty, return false. 
{
	if ( range.second < range.first )
		range = make_pair( range.second, range.first ); 
	left_range = range;
	for ( vector<pair<int, int> >::iterator ci = cover_v.begin(); ci != cover_v.end(); ++ci )
	{
		if ( left_range.first > ci->second || left_range.second < ci->first )
			return false;
		if ( left_range.first <= ci->second && left_range.first >= ci->first )
		{
			if ( left_range.second <= ci->second )
				return false;
			else
			{
				left_range.first = ci->second+1;
			}
		} else if ( left_range.second <= ci->second && left_range.second >= ci->first )
		{
			if ( left_range.first >= ci->first )
				return false;
			else
				left_range.second = ci->second-1;
		}
	}

	return true;
}

bool getrangegap(  pair<int, int> range, vector< pair<int, int> > & cover_v, pair<int, int> &gap )
{
	vector<pair<int, int > > cover = cover_v;
	mergerange( cover );

	vector<pair<int, int > > left_range;
	getomisrange2( cover, range, left_range );
	if ( left_range.empty() )
		return false;
	else
	{
		gap.first = left_range.front().first;
		gap.second = left_range.back().second;
		return true;
	}
}

void mergerange( vector<pair<int, int > >& cover )
{
	set< pair< int, int > > range_seg;
	for ( vector<pair<int, int> >::iterator ci = cover.begin(); ci != cover.end(); ++ci )
	{
		range_seg.insert( *ci );
	}

	vector< pair<int, int > > renew_cover;
	for ( set<pair<int, int > >::iterator rsi = range_seg.begin(); rsi != range_seg.end(); ++rsi )
	{
		if ( renew_cover.empty() )
		{
			renew_cover.push_back( *rsi );
			continue;
		}
		if ( rsi->first > renew_cover.back().second + 1 )
		{
			renew_cover.push_back( *rsi );
			continue;

		} else
		{
			if ( rsi->second > renew_cover.back().second )
				renew_cover.back().second = rsi->second;
		}
	}

	cover = renew_cover;
}

void getminusrange_wholectg( vector<pair<int, int > >& separate_cover, int ctglen, vector<pair<int, int > > &left_range )
{
	if ( separate_cover.empty() )
	{
		left_range.push_back( make_pair( 1, ctglen ) );
		return;
	}

	if ( separate_cover.back().second  > ctglen )
	{
		cout<<"error cover range exceeds the ctglen "<<separate_cover.back().second <<" "<< ctglen<<endl; exit(1);
	}
	for ( size_t i = 0; i < separate_cover.size(); ++i )
	{
		if ( i == 0 )
		{
			if ( separate_cover[i].first > 1 )
				left_range.push_back( make_pair(1, separate_cover[i].first-1 ) );
					
		} else
		{
			left_range.push_back( make_pair( separate_cover[i-1].second+1, separate_cover[i].first-1 ) );
		}
		if ( i == separate_cover.size() -1 )
		{
			if ( separate_cover[i].second < ctglen )
				left_range.push_back( make_pair( separate_cover[i].second + 1, ctglen ) );
		}
	}
}

void getomisrange2( vector<pair<int, int > >& separate_cover, pair<int, int> total_range, vector<pair<int, int > > &left_range )
{
	if ( total_range.first > total_range.second )
		total_range = make_pair( total_range.second, total_range.first );

	if ( separate_cover.empty() )
	{
		left_range.push_back( total_range );
		return;
	}
	int stat = 0;
	for ( size_t i = 0; i < separate_cover.size(); ++i )
	{
		if ( stat == 0 )
		{
			if ( separate_cover[i].second >= total_range.first )
			{
				stat = 1;
				
				if ( separate_cover[i].first > total_range.first )
					left_range.push_back( make_pair(total_range.first, min( separate_cover[i].first-1, total_range.second ) ) );
				if ( separate_cover[i].second >= total_range.second )
					break;
			}
		} else if ( stat == 1 )
		{
			left_range.push_back( make_pair( separate_cover[i-1].second+1, min(separate_cover[i].first-1, total_range.second ) ) );
			if ( separate_cover[i].second >= total_range.second )
				break;
		}
	}

	if ( separate_cover.back().second < total_range.second )
		left_range.push_back( make_pair( separate_cover.back().second + 1, total_range.second ) );
}

void getomisrange( vector<pair<int, int > >& separate_cover, pair<int, int> total_range, vector<pair<int, int > > &left_range )
{
	if ( total_range.first > total_range.second )
		total_range = make_pair( total_range.second, total_range.first );

	if ( separate_cover.empty() )
	{
		left_range.push_back( total_range );
		return;
	}

	if ( separate_cover.back().second  > total_range.second || separate_cover.front().first < total_range.first )
	{
		cout<<"error cover range exceeds the totalrange "<<separate_cover.front().first<<","<<separate_cover.back().second
			<<total_range.first<<","<<total_range.second<<endl; exit(1);
	}
	
	
	for ( size_t i = 0; i < separate_cover.size(); ++i )
	{
		
		if ( i == 0 )
		{
			if ( separate_cover[i].first > total_range.first )
				left_range.push_back( make_pair(total_range.first, separate_cover[i].first-1 ) );
					
		} else
		{
			left_range.push_back( make_pair( separate_cover[i-1].second+1, separate_cover[i].first-1 ) );
		}
		if ( i == separate_cover.size() -1 )
		{
			if ( separate_cover[i].second < total_range.second )
				left_range.push_back( make_pair( separate_cover[i].second + 1, total_range.second ) );
		}
	}
}

bool pos_contain( pair<int, int> a, pair<int, int> b )
{
	int mina = min( a.first, a.second );
	int minb = min( b.first, b.second );
	int maxa = max( a.first, a.second );
	int maxb = max( b.first, b.second );
	if ( minb >= mina && maxb <= maxa )
		return true;
	else
		return false;
}

pair< int, double > getoverratio( pair<int, int > a, pair<int, int > b )
{
	if ( a.first > a.second )
	{
		int c = a.first;
		a.first = a.second;
		a.second = c;
	}
	if ( b.first > b.second )
	{
		int c = b.first;
		b.first = b.second;
		b.second = c;
	}

	int over = 0;
	if ( a.first < b.first )
	{
		if ( a.second > b.first )
		{
			over = min( b.second, a.second ) - b.first + 1;
		}
	} else if ( a.first <= b.second )
	{
		over = min( a.second, b.second ) - a.first + 1;
	}

	double ratio = (double) over / (b.second - b.first + 1);
	return make_pair( over, ratio );
}


pair< int, int > orderrange( pair<int, int > p )
{
	if ( p.first <= p.second )
		return p;
	else 
		return make_pair( p.second, p.first ); 
}

char getsuppl_base( char c )
{
	
	switch( c )
	{
	case 'A' : case 'a' : return 'T';
	case 'T' : case 't' : return 'A';
	case 'C' : case 'c' : return 'G';
	case 'G' : case 'g' : return 'C';
	default:
		return c;
	};

}

string getsuppl_str( string &s )
{
	string revs = s;
	reverse( revs.begin(), revs.end() );
	string t = "";
	for ( size_t i = 0; i < revs.size(); ++i )
	{
		t += getsuppl_base( revs[i] );
	}
	return t;
}

