#include <iostream>
#include <fstream>
#include <vector>
#include "bank.h"
#include "readincontig.h"
#include "readmappings.h"
#include "readvalidate.h"
#include "ana_mapping.h"
#include "dealunmap.h"
#include "anamergeoverlap.h"
using namespace std;

void exit_with_help()
{
	cerr <<"Usage:	mergeassembly [OPTION1] [VALUE1] [[OPTION2] [VALUE2] ...]" <<endl;
	cerr <<"Options:" <<endl;
	cerr <<"-s		Subject Contig name" <<endl;
	cerr <<"-o		Output file prefix" <<endl;
	cerr <<"-q      Query Contig name"<<endl;
	cerr <<"-i		minIdentiy" <<endl;
	cerr <<"-r		stringent rank[0]" <<endl;
	cerr <<"			rank: 0 highest stringent; 1 low stringent"<<endl;
	exit(1);
}

void exit_with_help(const char error[])
{
	cerr <<"Error:	" <<error <<endl;
	exit_with_help();
}

int main( int argc, char* argv[] )
{
	if ( argc == 1)
		exit_with_help();

	string output = "out";
	vector< string > ctg_file;
	double minIdentity = 0.95;
	
	string query;
	string subject;

	string stringent_rank;

	string s;
	for(int i=1; i<argc; i++)
	{
		if(argv[i][0] != '-')
			exit_with_help("Options must start with \'-\'.");

		if(argv[i][2] != '\0')
			exit_with_help("The option should be exactly one letter.");
		int option = argv[i][1];

		i++;
		if(i == argc)
			exit_with_help("The last option has no value.");

		switch(option)
		{
	

		case 'q':
		
			query = argv[i];

			break;

		case 'o':
			output = argv[i];
			break;
		
		case 'i':
			minIdentity = atof(argv[i]);
			break;

			break;
		case 's':
			subject = argv[i];
			break;
		case 'r':
			stringent_rank = argv[i];
			break;

		default:
			exit_with_help("Undefined option.");
		}
	}

	int s_rank = 0;
	if ( !stringent_rank.empty() )
	{
		s_rank = atoi( stringent_rank.c_str() );
	}

	Assembly_Bank ass_bank;
	
	string subjectctg = subject + ".ctg.fa";
	string queryctg = query + ".ctg.fa";
	ini_Assembly_bank( queryctg, subjectctg, ass_bank, query, subject );
	//	string outnf = ctg_file[i] + ".ctgname";
	//	outputcontigname( outnf, ass_bank.ass_ve[i] );
		
	cout<<"readinvalidate"<<endl;
	readinvalidate( subjectctg, queryctg, ass_bank );

	cout<<"readmcoordfile"<<endl;
	Ass_Mapping map_o ;
	vector< Coords > con_mcoove;
	readmcoordfile( subject, query, map_o, con_mcoove );

	cout<<"AssignMcoordsToCtg"<<endl;
	AssignMcoordsToCtg( map_o, ass_bank );

	cout<<"SupplementUnmappingSubjectCtg"<<endl;
	SupplementUnmappingSubjectCtg( map_o, ass_bank, con_mcoove );

	output_coo( map_o, ass_bank );
	cout<<"findrepeatCoords"<<endl;
	findrepeatCoords( map_o, ass_bank );

	cout<<"outputRepeat"<<endl;
	outputRepeat( map_o, ass_bank );

	cout<<"getuniqmappingrange"<<endl;
	uniq_mapping_range( ass_bank );

	cout<<"merge fea range"<<endl;
	merge_fea_range( ass_bank );

	cout<<"outputfea"<<endl;
	output_fea( ass_bank );

	cout<<"pick up protected ctg"<<endl;
	protect_good_ctg( ass_bank );

	cout<<"check_break_by_validat"<<endl;
	check_break_by_validat( ass_bank );

	string unimapfile_i = "uni_mapping_i";
	output_unimap( ass_bank, unimapfile_i );

	cout<<"get_1coord_edge"<<endl;
	get_1coord_edge( map_o, ass_bank, s_rank );

	output_edge( map_o, ass_bank );
	string unimapfile = "uni_mapping";
	output_unimap( ass_bank, unimapfile );

	erase_broken_edge( map_o, ass_bank );

	cout<<"getpath"<<endl;
	vector< Path > path_ve;
	get_path( map_o, ass_bank, path_ve );

	string path0f = "path_ve0";
	output_path( map_o, ass_bank, path_ve, path0f );
	cout<<"gorepeat"<<endl;
	gorepeat( map_o, ass_bank, path_ve );

	string pathf = "path_ve";
	output_path( map_o, ass_bank, path_ve, pathf );

	cout<<"transpath"<<endl;
	trans_path( map_o, ass_bank, path_ve );

	

	cout<<"traceback"<<endl;
	traceback( map_o, ass_bank, path_ve );

	cout<<"findunmap"<<endl;
	findunmap( map_o, ass_bank, path_ve );
	output_avail_coo( map_o );

	string _1_tilefile = "ini_tile";
	output_ipathtile( map_o, ass_bank, _1_tilefile );

	cout<<"anaoverlap"<<endl;
	anaoverlap( map_o, ass_bank );

	output_ipath( map_o, ass_bank, output );

	cout<<"ana unmerged"<<endl;
	anaunmerged( map_o, ass_bank );

	return 1;
}

