#include "readmappings.h"

void readmcoordfile( string refname, string qryname, Ass_Mapping &map_o, vector< Coords >& con_mcoove )
{
	string mcoofile = refname + "_" + qryname + ".mcoords";
	cout<<"reading file "<<mcoofile<<endl;
	readcoords( mcoofile, map_o.mcoords );
	string con_mcoofile = qryname + "_" + refname + ".mcoords";
	cout<<"reading file "<<con_mcoofile<<endl;
	readcoords( con_mcoofile, con_mcoove );
}

void readcoords( string filename, vector< Coords >& coo_ve )
{
	ifstream inf( filename.data() );
	if ( !inf.good() ) {
		cout<<"error can not open file "<<filename<<endl; exit(1);
	}

	while( !inf.eof() )
	{
		Coords coo;

		bool emp = false;
		for ( int i = 1; i <= 13; ++i ) {
			string a1;
			inf >> a1;
			if ( a1.empty() ) {
				emp = true;
				break;
			}
			if ( i != 10 && i != 11 )
				coo.val.push_back( a1 );
		}

		
		
		if ( emp )
			break;
		coo_ve.push_back( coo );

	}

	

	inf.close();
}

/*
void readmummerfiles( string refname, string qryname, Ass_Map_Bank &map_bank, Assembly_Bank &ass_bank, Alignment_Bank &ali_bank )
{
	cout<<"reading files "<<refname<<" "<<qryname<<endl;
	Ass_Mapping map_o;

	map_o.ref_assembly_name = refname;
	map_o.qry_assembly_name = qryname;

	string mcoofile = refname + "_" + qryname + ".mcoords";

	vector< Coords > mcoords;
	
	readcoords( mcoofile, mcoords );

	
	string _1coofile = refname + "_" + qryname + ".1coords";

	vector< Coords > _1coo_ve;

	readcoords( _1coofile, _1coo_ve );

	cout<<_1coo_ve.size()<<endl;
	
	get_1coo( ass_bank.ass_ve[ass_bank.ass_name_map[refname]], ass_bank.ass_ve[ass_bank.ass_name_map[qryname]], map_o, mcoords, _1coo_ve );

	string refdifffile = refname + "_" + qryname + ".rdiff";
	readFeature( refdifffile, ass_bank.ass_ve[ass_bank.ass_name_map[refname]], map_o.R_Features_map );

	string qrydifffile = refname + "_" + qryname + ".qdiff";
	readFeature( qrydifffile, ass_bank.ass_ve[ass_bank.ass_name_map[qryname]], map_o.Q_Features_map );

	
	string unreffile = refname + "_" + qryname + ".unref";
	readunalign( unreffile, ass_bank.ass_ve[ass_bank.ass_name_map[refname]], map_o.unalign_ref );

	string unqryfile = refname + "_" + qryname + ".unqry";
	readunalign( unqryfile, ass_bank.ass_ve[ass_bank.ass_name_map[qryname]], map_o.unalign_qry );


	map_bank.pa_ass_mapping.push_back( map_o );
	size_t map_id = map_bank.pa_ass_mapping.size() - 1;
	map_bank.pa_map[map_bank.ass_name_map[refname]][map_bank.ass_name_map[qryname]] = map_id;
	map_bank.pa_map[map_bank.ass_name_map[qryname]][map_bank.ass_name_map[refname]] = map_id;


//	string deltafile = refname + "_" + qryname + ".1delta";
//	readDelta( deltafile, ass_bank, ali_bank, refname, qryname );
	
	
	
	

}



void get_1coo( Assembly &refass, Assembly &qryass, Ass_Mapping& map_o, vector< Coords > &mcoords, vector< Coords > & _1coo_ve )
{
	map< Ctg_id, map< Ctg_id, vector< Coo_ite > > > R_Q_1coo_map;
	map< Ctg_id, map< Ctg_id, vector< Coo_ite > > > Q_R_1coo_map;
	map< Ctg_id, map< Ctg_id, vector< Coo_ite > > > Q_R_dcoo_map;
	map< Ctg_id, map< Ctg_id, vector< Coo_ite > > > R_Q_dcoo_map;

	
	Coo_ite ini = mcoords.begin();
	
	for ( Coo_ite ci = _1coo_ve.begin(); ci != _1coo_ve.end(); ++ci ) {
		
		if ( refass.ctg_name_map.find( (*ci).refname() ) == refass.ctg_name_map.end() ) {
			cout<<"error no refass ctgname "<<(*ci).refname()<<endl; exit(1);
		}
		if ( qryass.ctg_name_map.find( (*ci).qryname() ) == qryass.ctg_name_map.end() ) {
			cout<<"error no qryass ctgname "<<(*ci).qryname()<<endl; exit(1);
		}
		Ctg_id ref_ctg_id = refass.ctg_name_map[(*ci).refname()];
		Ctg_id qry_ctg_id = qryass.ctg_name_map[(*ci).qryname()];

	
		bool fi = false;
		
		Coo_ite fi_cooi = ini;
		for ( Coo_ite cooi = ini; cooi != mcoords.end(); ++cooi ) {
		
			if ( equalcoord( (*ci), (*cooi) ) ) {
				
				R_Q_1coo_map[ref_ctg_id][qry_ctg_id].push_back( cooi );
				Q_R_1coo_map[qry_ctg_id][ref_ctg_id].push_back( cooi );
				fi = true;
				fi_cooi = cooi;
				
				break;
			} else {
				Ctg_id d_ref_ctg_id = refass.ctg_name_map[(*cooi).refname()];
				Ctg_id d_qry_ctg_id = qryass.ctg_name_map[(*cooi).qryname()];

				R_Q_dcoo_map[d_ref_ctg_id][d_qry_ctg_id].push_back( cooi );
				Q_R_dcoo_map[d_qry_ctg_id][d_ref_ctg_id].push_back( cooi );

			}
		}
		
		if ( !fi ) {
			cout<<"error not find _1coord in mcoord"<<endl; exit(1);
		}

		
		ini = fi_cooi;
		++ini;

	}

	if ( ini != mcoords.end() )
	{
		for ( Coo_ite cooi = ini; cooi != mcoords.end(); ++cooi ) {
			Ctg_id d_ref_ctg_id = refass.ctg_name_map[(*cooi).refname()];
			Ctg_id d_qry_ctg_id = qryass.ctg_name_map[(*cooi).qryname()];

			R_Q_dcoo_map[d_ref_ctg_id][d_qry_ctg_id].push_back( cooi );
			Q_R_dcoo_map[d_qry_ctg_id][d_ref_ctg_id].push_back( cooi );
		}
	}

	// adjust order of qury coord.
	for ( map< Ctg_id, map< Ctg_id, vector< Coo_ite > > >::iterator qri = Q_R_1coo_map.begin();
		qri != Q_R_1coo_map.end(); ++qri )
	{
		for ( map< Ctg_id, vector< Coo_ite > >::iterator ri = (*qri).second.begin(); ri != (*qri).second.end(); ++ri )
		{
		//	sort( (*ri).second.begin(), (*ri).second.end(), cmpCoordqry() );
			sortCoordqry( (*ri).second );
		}
	}

	for ( map< Ctg_id, map< Ctg_id, vector< Coo_ite > > >::iterator qri = Q_R_dcoo_map.begin();
		qri != Q_R_dcoo_map.end(); ++qri )
	{
		for ( map< Ctg_id, vector< Coo_ite > >::iterator ri = (*qri).second.begin(); ri != (*qri).second.end(); ++ri )
		{
		//	sort( (*ri).second.begin(), (*ri).second.end(), cmpCoordqry() );
			sortCoordqry( (*ri).second );
		}
	}

	
	transcoord( R_Q_1coo_map, map_o.R_Q_1coo_map, mcoords );
	transcoord( R_Q_dcoo_map, map_o.R_Q_dcoo_map, mcoords );
	transcoord( Q_R_1coo_map, map_o.Q_R_1coo_map, mcoords );
	transcoord( Q_R_dcoo_map, map_o.Q_R_dcoo_map, mcoords );

	ofstream outf( "tmpcoo");
	for ( map< Ctg_id, map< Ctg_id, vector< Coo_ite > > >::iterator qri = Q_R_1coo_map.begin();
		qri != Q_R_1coo_map.end(); ++qri )
	{
		outf<<">>Qctg "<<qri->first<<endl;
		for ( map< Ctg_id, vector< Coo_ite > >::iterator ri = (*qri).second.begin(); ri != (*qri).second.end(); ++ri )
		{
			outf<<"Rctg "<<ri->first<<endl;
			for ( size_t i = 0; i < ri->second.size(); ++i )
			{
				outputcoord( *(ri->second[i]), outf );
			}
		}
	}

	
//	exit(1);

	
}

void sortCoordqry( vector< Coo_ite >& cooriteve )
{
	vector< Coo_ite > nve;
	map< int, size_t > rk;
	for ( size_t i = 0; i < cooriteve.size(); ++i )
	{
		int p = min( cooriteve[i]->qrystart(), cooriteve[i]->qryend() );
		rk.insert( make_pair( p, i ) );
	}
	for ( map<int, size_t >::iterator ri = rk.begin(); ri != rk.end(); ++ri )
	{
		nve.push_back( cooriteve[ri->second] );
	}
	cooriteve = nve;
}

void transcoord( map< Ctg_id, map< Ctg_id, vector< Coo_ite > > > &mapa, map< Ctg_id, map< Ctg_id, vector< Coords > > > &mapb, vector< Coords > &ve )
{
	for ( map< Ctg_id, map< Ctg_id, vector< Coo_ite > > >::iterator cci = mapa.begin(); cci != mapa.end(); ++cci )
	{
		for ( map< Ctg_id, vector< Coo_ite > >::iterator ci = cci->second.begin(); ci != cci->second.end(); ++ci )
		{
			for ( vector< Coo_ite >::iterator i = ci->second.begin(); i != ci->second.end(); ++i )
			{
				Coords coo;
				coo.val = (*i)->val;
				mapb[cci->first][ci->first].push_back( coo );
			}
		}
	}
}

bool equalcoord( Coords &coo_a, Coords &coo_b )
{
	
	for ( size_t i = 0; i < coo_a.val.size(); ++i ) {
		if ( coo_a.val[i] != coo_b.val[i] )
			return false;
	}
	return true;
}

void readFeature( string& filename, Assembly &ass, map< Ctg_id, Ctg_Features > &fea )
{

	ifstream inf( filename.data() );

	vector< Feature > fea_ve;
	
	if ( !inf.good() ) {
		cout<<"error can not open file "<<filename<<endl; exit(1);
	}

	while ( !inf.eof() ) {

		Feature f_o;
		string a1;
		inf >> a1;
		if ( a1.empty() )
			break;
		f_o.val.push_back( a1 );

		string a2;
		inf >> a2;
		f_o.val.push_back( a2 ); 
		int num = 3;
		if ( a2 == "SEQ" || a2 == "GAP" )
			num = 5;

		for ( int i = 1; i <= num; ++i ) {
			string aa;
			inf >> aa;
			f_o.val.push_back( aa );
		}

		fea_ve.push_back( f_o );

	}

	if ( fea_ve.empty() )
		return ;

	string name = fea_ve[0].ctgname();
	Ctg_Features fea_t;

	for ( size_t i = 0; i < fea_ve.size(); ++i ) {
		if ( fea_ve[i].ctgname() != name ) {
			if ( ass.ctg_name_map.find( name ) == ass.ctg_name_map.end() ) {
				cout<<"error not find ctg name "<<name<<endl; exit(1);
			}
			fea.insert( make_pair( ass.ctg_name_map[name], fea_t ) );
			fea_t.clear();
			fea_t.push_back( fea_ve[i] );
			name = fea_ve[i].ctgname();
		} else {
			fea_t.push_back( fea_ve[i] );
		}

	}

	if ( ass.ctg_name_map.find( name ) == ass.ctg_name_map.end() ) {
		cout<<"error not find ctg name "<<name<<endl; exit(1);
	}
	fea.insert( make_pair( ass.ctg_name_map[name], fea_t ) );

	inf.close();

}

void readunalign( string &filename, Assembly &ass, set<Ctg_id>& unalin )
{

	ifstream inf( filename.data() );

	
	if ( !inf.good() ) {
		return ;
	}

	while ( !inf.eof() )
	{
		string aa;
		inf >> aa;
		if ( aa.empty() )
			break;

		if ( ass.ctg_name_map.find( aa ) == ass.ctg_name_map.end() ) {
			cout<<"error not find ctg name "<<aa<<endl; exit(1);
		}

		Ctg_id cid = ass.ctg_name_map[aa];
		unalin.insert( cid );

		for ( int i = 1; i <= 4; ++i ) {
			string a;
			inf >> a;
		}
	}

	inf.close();

}

void showcoord( Ctg_id id_a, Ctg_id id_b, map< Ctg_id, map< Ctg_id, vector< Coords > > > &coomap )
{
	cout<<"gg"<<endl;
	if ( coomap.find( id_a ) == coomap.end() ) {
		cout<<"error coomap not find "<<id_a<<endl; exit(1);
	}
	if ( coomap[id_a].find( id_b ) == coomap[id_a].end() ) {
		cout<<"error coomap["<<id_a<<"] not find "<<id_b<<endl; exit(1);
	}

	cout<<coomap[id_a][id_b].size()<<endl;
	for ( vector< Coords >::iterator ci = coomap[id_a][id_b].begin(); ci != coomap[id_a][id_b].end(); ++ci ) {
		cout<<(*ci).refstart()<<" "<<(*ci).refend()<<" "<<(*ci).qrystart()<<" "<<(*ci).qryend()<<" "<<(*ci).refalen()<<" "<<(*ci).qryalen()
			<<" "<<(*ci).identity()<<" "<<(*ci).reflen()<<" "<<(*ci).qrylen()<<" "<<(*ci).refname()<<" "<<(*ci).qryname()<<endl;
	}
}

void showcoord( Coords &coo )
{
	cout<<coo.refstart()<<" "<<coo.refend()<<" "<<coo.qrystart()<<" "<<coo.qryend()<<" "<<coo.refalen()<<" "<<coo.qryalen()
			<<" "<<coo.identity()<<" "<<coo.reflen()<<" "<<coo.qrylen()<<" "<<coo.refname()<<" "<<coo.qryname()<<endl;
}

void outputcoord( Coords &coo, ofstream &outf )
{
	outf<<coo.refstart()<<" "<<coo.refend()<<" "<<coo.qrystart()<<" "<<coo.qryend()<<" "<<coo.refalen()<<" "<<coo.qryalen()
			<<" "<<coo.identity()<<" "<<coo.reflen()<<" "<<coo.qrylen()<<" "<<coo.refname()<<" "<<coo.qryname()<<endl;
}

*/

