#include "readvalidate.h"

void readinfea( string &infile, Assembly &ass )
{
	ifstream inf( infile.data() );
	if ( !inf.good() )
	{
		return;
	//	cout<<"error can not open file "<<infile<<endl; exit(1);
	}
	
	string line;
	getline( inf, line );
	while ( !inf.eof() )
	{
		if ( line.empty() )
			break;
		if ( line[0] != '>' )
		{
			cout<<"error not ctg head line "<<line<<endl; exit(1);
		}
		string id = line.substr(1);
		if ( ass.ctg_name_map.find( id ) == ass.ctg_name_map.end() )
		{
			cout<<"error can not find ctg name "<<id<<endl; exit(1);
		}
		Ctg_id ctg = ass.ctg_name_map[id];
		getline( inf, line );
		while ( line.find( '>' ) == line.npos )
		{
			if ( line.empty() )
				break;
			string fea = "";
			size_t i=0;
			for ( ; i < line.size(); ++i )
			{
				if ( line[i] == ' ' || line[i] == '\t' )
					break;
				fea += line[i];
			}
			string pos_first = "";
			++i;
			for ( ; i < line.size(); ++i )
			{
				if ( line[i] == ' ' || line[i] == '\t' )
					break;
				pos_first += line[i];
			}
			string pos_second;
			++i;
			for ( ; i < line.size(); ++i )
			{
				pos_second += line[i];
			}
			if ( pos_first.empty() || pos_second.empty() )
			{
				cout<<"error pos_first empty "<<line<<endl; exit(1);
			}
			int pos_1 = atoi( pos_first.c_str() );
			int pos_2 = atoi( pos_second.c_str() );
			ass.Contigs[ctg].suspicious_range.push_back( make_pair( pos_1, pos_2 ) );
			
			if ( inf.eof() )
				break;
			getline( inf, line );
			
		}

		
		
	}

	inf.close();
}


void readin_100rupfw( string &infile, Assembly &ass )
{
	ifstream inf( infile.data() );
	if ( !inf.good() )
	{
		return;
	//	cout<<"error can not open file "<<infile<<endl; exit(1);
	}
	
	string line;
	getline( inf, line );
	while ( !inf.eof() )
	{
		if ( line.empty() )
			break;
		if ( line[0] != '>' )
		{
			cout<<"error not ctg head line "<<line<<endl; exit(1);
		}
		string id = line.substr(1);
		if ( ass.ctg_name_map.find( id ) == ass.ctg_name_map.end() )
		{
			cout<<"error can not find ctg name "<<id<<endl; exit(1);
		}
		Ctg_id ctg = ass.ctg_name_map[id];
		getline( inf, line );
		while ( line.find( '>' ) == line.npos )
		{
			if ( line.empty() )
				break;
			string key, value;
			size_t j = 0;
			for ( ; j < line.size(); ++j )		
			{
				if ( line[j] == ' ' || line[j] == '\t' )
					break;
				key += line[j];
			}
			++j;
			for ( ; j < line.size(); ++j )
			{
				if ( line[j] == ' ' || line[j] == '\t' )
				{
					break;
				}
				value += line[j];
			}
			int key_i = atoi( key.c_str() );
			double value_f = atof( value.c_str() );
			ass.Contigs[ctg].fwup_rate_map.insert( make_pair( key_i, value_f ) );
		//	cout<<"id"<<id<<",k"<<key_i<<",v"<<value_f<<endl;
			if ( inf.eof() )
				break;
			getline( inf, line );
		}
	}

	inf.close();
}

void readin_100ruprv( string &infile, Assembly &ass )
{
	ifstream inf( infile.data() );
	if ( !inf.good() )
	{
		return ;
	//	cout<<"error can not open file "<<infile<<endl; exit(1);
	}
	
	string line;
	getline( inf, line );
	while ( !inf.eof() )
	{
		if ( line.empty() )
			break;
		if ( line[0] != '>' )
		{
			cout<<"error not ctg head line "<<line<<endl; exit(1);
		}
		string id = line.substr(1);
		if ( ass.ctg_name_map.find( id ) == ass.ctg_name_map.end() )
		{
			cout<<"error can not find ctg name "<<id<<endl; exit(1);
		}
		Ctg_id ctg = ass.ctg_name_map[id];
		getline( inf, line );
		while ( line.find( '>' ) == line.npos )
		{
			if ( line.empty() )
				break;
			string key, value;
			size_t j = 0;
			for ( ; j < line.size(); ++j )		
			{
				if ( line[j] == ' ' || line[j] == '\t' )
					break;
				key += line[j];
			}
			++j;
			for ( ; j < line.size(); ++j )
			{
				if ( line[j] == ' ' || line[j] == '\t' )
				{
					break;
				}
				value += line[j];
			}
			int key_i = atoi( key.c_str() );
			int value_i = atoi( value.c_str() );
			ass.Contigs[ctg].rvup_rate_map.insert( make_pair( key_i, value_i ) );

			if ( inf.eof() )
				break;
			getline( inf, line );
		}
	}

	inf.close();
}


void readinvalidate( string subject, string query, Assembly_Bank &ass_bank )
{
	string subj_feafile = subject + ".fea";
	readinfea( subj_feafile, ass_bank.ass_subject );

	string qury_feafile = query + ".fea";
	readinfea( qury_feafile, ass_bank.ass_query );

	string subj_fwupfile = subject + "._100rgunpairforwardrate";
	readin_100rupfw( subj_fwupfile, ass_bank.ass_subject );

	string qury_fwupfile = query + "._100rgunpairforwardrate";
	readin_100rupfw( qury_fwupfile, ass_bank.ass_query );

	string subj_rvupfile = subject + "._100rgunpairreverserate";
	readin_100ruprv( subj_rvupfile, ass_bank.ass_subject );

	string qury_rvupfile = query + "._100rgunpairreverserate";
	readin_100ruprv( qury_rvupfile, ass_bank.ass_query );
}

