#include <string>
#include <fstream>
#include <iostream>
#include <cstdlib>
using namespace std;

string getid( string &line )
{
    
        if ( line[0] != '@' )
        {
            cerr << "unexpected fastq head "<<line<<endl; exit(1);
        }
    
        
        string id = line.substr(1);
        
            bool goon = false;
            do {
                goon = false;
                if ( (int)id.size() < 2 )
                {
                    cerr <<"unexpected fastq head "<<line<<endl;  exit(1);
                }
                bool trim = false;
                if ( !( id[id.size()-1] == '1' || id[id.size()-1] == '2' ) )
                    trim = true;
                else 
                {
                    if ( !( id[id.size()-2] == '/' || id[id.size()-2] == '.' ) )
                        trim = true;

                }
                if ( trim )
                {
                    goon = true;
                    id.erase( id.size()-1, 1 );
                }
            } while ( goon );

            id = id.substr( 0, id.size()-2 );
            return id;
        
}

int main( int argc, char* argv[] )
{
    if ( argc != 4 )
    {
        cout<<"Usage: merge separate mate pair files into one file, with paired reads intersect"<<endl;
        cout<<"mergefastq-p infile1 infile2 outprefix"<<endl;
        exit(1);
    }

    string infile1 = argv[1];
    string infile2 = argv[2];
    string outfile = argv[3];
    outfile += ".fastq";

    ifstream inf1 ( infile1.data() );
    ifstream inf2 ( infile2.data() );
    if ( !inf1.good() )
    {
        cout<<"error can not open file "<<infile1<<endl;
        exit(1);
    }
    if ( !inf2.good () )
    {
        cout<<"error can not open file "<<infile2<<endl; exit(1);
    }

    ofstream outf( outfile.data() );
    
    while ( !inf1.eof() && !inf2.eof() )
    {
        string line1;
        getline( inf1, line1 );
        string line2;
        getline( inf2, line2 );
        if ( line1.empty() || line2.empty() )
        {
            break;
        }
        
        string id1 = getid( line1 );
        string id2 = getid( line2 );
        if ( id1 != id2 )
        {
            cout<<"error unexpected mate pair reads "<<line1<<", "<<line2<<endl; exit(1);
        }
        outf<<line1<<endl;
        getline( inf1, line1 );
        outf<<line1<<endl;
        getline( inf1, line1 );
        outf<<line1<<endl;
        getline( inf1, line1 );
        outf<<line1<<endl;

        outf<<line2<<endl;
        getline( inf2, line2 );
        outf<<line2<<endl;
        getline( inf2, line2 );
        outf<<line2<<endl;
        getline( inf2, line2 );
        outf<<line2<<endl;
    }
        
    inf1.close();
    inf2.close();
    outf.close();

    return 1;
}


