#include <string>
#include <fstream>
#include <iostream>
#include <set>
#include <map>
#include <cstdlib>
using namespace std;

int main(int argc, char* argv[] )
{
	if ( argc != 3 )
		{
			cout<<"usage: refine the header"<<endl;
			cout<<"refineheader infile outputprefix"<<endl;
			exit(1);
		}
		
		string infile1 = argv[1];
		
		string pref = argv[2];
		string outfile = pref + "_rfh.fastq";
		
                set< char > splset;
                splset.insert( '/' );
                splset.insert( '.' );
                splset.insert( '-' );

                set< char > sufset;
                sufset.insert( '1' );
                sufset.insert( '2' );
                sufset.insert( 'a' );
                sufset.insert( 'b' );
		ifstream inf1( infile1.data() );
		if ( !inf1.good() )
		{
			cout<<"error can not read "<<infile1<<endl; exit(1);
		}
		ofstream outf ( outfile.data() );
	
		while ( !inf1.eof() )
		{
			string line;
			getline( inf1, line );
			if (line.empty())
				break;
			if ( line[0] != '@' )
				{
					cout<<"unexpected line: "<<line<<endl; exit(1);
				}
			string h = line;
			string rfh = "";

                        bool goontrim = false;
                        do {
                            goontrim = false;
                            if ( h.find(" ") != h.npos || h.find("\t") != h.npos )
                            {
                                char a = h[h.size()-1];
                                char b = h[h.size()-2];
                                
                                if ( !( sufset.find(a) != sufset.end() && splset.find( b ) != splset.end() ) )
                                    goontrim = true;
                            }
                            if ( goontrim )
                            {
                                
                                
                                while ( !h.empty() )
                                {
                                    char ba = h[h.size()-1];
                                    h.erase( h.size()-1, 1 );
                                    if ( ba == ' ' || ba == '\t' )
                                        break;
                                }
                                while ( h[h.size()-1] == ' ' || h[h.size()-1] == '\t' )
                                    h.erase( h.size()-1, 1 );
                                
                                
                            } 
                            
                        } while ( goontrim );

                        while ( h[h.size()-1] == ' ' || h[h.size()-1] == '\t' )
                        {
                            h.erase( h.size()-1, 1 );
                        }

			for ( size_t i = 0; i < h.size(); ++i )
			{
				if ( h[i] != ' ' )
					rfh += h[i];
				else
					rfh += '_';
			}
			outf<<rfh<<endl;
			getline( inf1, line );
			outf<<line<<endl;
			getline( inf1, line );
			outf<<"+"<<endl;
			getline( inf1, line );
			outf<<line<<endl;
		}
		inf1.close();
		
		
}
