# -*- coding: utf-8 -*-
"""
Created on Wed Jun  6 23:03:58 2018

@author: linda
"""

import sys
from sklearn.metrics import roc_auc_score, roc_curve, precision_recall_curve
from sklearn.metrics import accuracy_score
from sklearn.metrics import average_precision_score
import matplotlib.pyplot as plt
#import getopt
import os
#from subprocess import call
import lightgbm as lgb
import numpy as np
import pandas as pd
pwd = sys.path[0]
data=np.array(pd.read_csv("F:/Project/Project9-DiseasesDiscrimination/testdata/test2.csv", sep = ',',header=None))

y_test=data[:,0]

a=data[:,1:]

model1 = os.path.join(pwd, 'F:/Project/Project9-DiseasesDiscrimination/step3WGS-01/WGS-01-model.txt') 
model = lgb.Booster(model_file=model1)
p = model.predict(a)
p=pd.DataFrame(p)
p.to_csv('F:/Project/Project9-DiseasesDiscrimination/testdata/p2.csv',index=False,header=None)

auc=roc_auc_score(y_test, p)
ap=average_precision_score(y_test, p)

accuracy_score(y_test,p>1.0-343.0/369)

fpr, tpr, thresholds  =  roc_curve(y_test, p)
plt.plot(fpr, tpr)
plt.show()

precision, recall, thresholds  =  precision_recall_curve(y_test, p)
plt.plot(recall, precision)
plt.show()