#include "Con_Qual.h"

void ctg_qual( map< int, Contig > &IdConMap, MP_bank &mp_bank )
{

	map< int, Contig >::iterator Ite;
	for ( Ite = IdConMap.begin(); Ite != IdConMap.end(); ++Ite ) {
		cal_mate_cover_ctg( Ite->second, mp_bank );
	}
}

void ctg_qual( Assembly_bank &ass_bank, MP_bank &mp_bank )
{
	map< Contig_id, Contig_bank >::iterator Ite;
	for ( Ite = ass_bank.Contig_map.begin(); Ite != ass_bank.Contig_map.end(); ++Ite ) {

		cal_mate_cover_ctg( Ite->second.contig, mp_bank );

	}
}

void cal_mate_cover_ctg( Contig &ctg, MP_bank &mp_bank )
{

	list< int >::iterator Iter = ctg.ReadidList.begin();
	list< int >::iterator Itef = ctg.ForbList.begin();
	list< pair< int, int > >::iterator Itep = ctg.RelposList.begin();
	for ( ; Iter != ctg.ReadidList.end(); ++Iter ) {

	//	cout<<">"<<*Iter<<", "<<Itep->first<<" "<<Itep->second<<endl;

		if ( mp_bank.Paired_mp_map.find( *Iter ) == mp_bank.Paired_mp_map.end() ) {

			++Itef;
			++Itep;
		//	cout<<"no pair"<<endl;
			continue;
		}

		int p_id = mp_bank.Paired_mp_map[*Iter].first;
		
		if ( ctg.ReadidSet.find( p_id ) == ctg.ReadidSet.end() ) {
			++Itef;
			++Itep;
		//	cout<<"p_id not in contig"<<endl;
			continue;
		}
		
		Mp_id mp_id = mp_bank.Paired_mp_map[*Iter].second;

		bool t_mate_check = false;
		pair< int, int > p_pos = make_pair( 0, 0 );
		if ( ctg.read_forbMap.find( p_id ) != ctg.read_forbMap.end() && ctg.read_relposMap.find( p_id ) != ctg.read_relposMap.end() ) {
			if ( ctg.read_relposMap[p_id].first > Itep->second ) {
				if ( mate_check_t( *Iter, p_id, make_pair( *Itep, *Itef ), make_pair( ctg.read_relposMap[p_id], ctg.read_forbMap[p_id] ), mp_bank.Mp_map[mp_id] ) ) {
					t_mate_check = true;
					p_pos = ctg.read_relposMap[p_id];
				//	cout<<"mate_check_true: "<<p_id<<", "<<p_pos.first<<", "<<p_pos.second<<endl;
				}
			}
		}
		if ( !t_mate_check ) {
			if ( ctg.MultiReadMap.find( p_id ) != ctg.MultiReadMap.end() ) {
				set<pair<pair<int, int>, int > >::iterator Ites;
				for ( Ites = ctg.MultiReadMap[p_id].begin(); Ites != ctg.MultiReadMap[p_id].end(); ++Ites ) {
					if ( Ites->first.first > Itep->second ) {
						if ( mate_check_t( *Iter, p_id, make_pair( *Itep, *Itef ), *Ites, mp_bank.Mp_map[mp_id] ) ) {
							t_mate_check = true;
							p_pos = Ites->first;
						//	cout<<"mate_check_true: "<<p_id<<", "<<p_pos.first<<", "<<p_pos.second<<endl;
							break;
						}
					}
				}
			}
		}

		if ( t_mate_check ) {
			add_cover_area( ctg.mate_cover_area, *Itep, p_pos );
		}

		/*//////////display////////////////////////////
		for ( size_t i = 0; i < ctg.mate_cover_area.size(); ++i ) {
			cout << "\t^"<<ctg.mate_cover_area[i].first.first<<" "<<ctg.mate_cover_area[i].first.second<<"\n\t\t^^";
			for ( size_t j = 0; j < ctg.mate_cover_area[i].second.size(); ++j ) {
				cout <<ctg.mate_cover_area[i].second[j].first<<" "<<ctg.mate_cover_area[i].second[j].second;
				if ( j < ctg.mate_cover_area[i].second.size() - 1 )
					cout << "; ";
				else
					cout <<endl;
			}
		}
		*////////////////////display//////////////////////

		++Itef;
		++Itep;
	}

	

//	exit(1);


}

bool mate_check_t( int ida, int idb, pair< pair< int, int >, int > infoa, pair< pair< int, int >, int > infob, MP &mp )
{

	int length = 0;
	bool ida_left = false;
	if ( infoa.first.first < infob.first.second ) {
		length = infob.first.second - infoa.first.first;
		ida_left = true;
	} else {
		length = infoa.first.second - infob.first.first;
	}

	if ( !mate_length_check( length, mp ) )
		return false;

	bool ida_small = false;
	if ( ida < idb )
		ida_small = true;

	int drct = -1;
	if ( infoa.second == 0 && infob.second == 0 ) 
		drct = 1;
	else if ( infoa.second == 0 && infob.second == 1 )
		drct = 2;
	else if ( infoa.second == 1 && infob.second == 0 )
		drct = 3;
	else if ( infoa.second == 1 && infob.second == 1 )
		drct = 4;
	else {
		cerr << "Warning in mate_check_t: unexpected drct type! "<<endl;
		return false;
	}

	if ( !ida_small && ida_left || ida_small && !ida_left ) {
		drct = drct_type_rev( drct );
	} 
	if ( drct != mp.drct_type )
		return false;

	return true;


}

bool mate_length_check( int length, MP &mp )
{
	if ( length <= mp.exlen_upb && length >= mp.exlen_lowb )
		return true;
	else
		return false;
	
}

void add_cover_area( vector<pair< pair< int, int >, vector< pair< int, int > > > > &cover_area, pair< int, int > ara, pair< int, int > arb )
{
	int leftb = min( ara.first, arb.first );
	int rightb = max( ara.second, arb.second );
	vector< pair< int, int > > nve;
	add_sub_cover_area( nve, ara );
	add_sub_cover_area( nve, arb );

	if ( cover_area.empty() ) {
		
		vector< pair< int, int > > nve;
		add_sub_cover_area( nve, ara );
		add_sub_cover_area( nve, arb );
		cover_area.push_back( make_pair( make_pair( leftb, rightb), nve ) );
	} else {
		if ( leftb > cover_area.back().first.second || rightb < cover_area.back().first.first ) {
			vector< pair< int, int > > nve;
			add_sub_cover_area( nve, ara );
			add_sub_cover_area( nve, arb );
			cover_area.push_back( make_pair( make_pair( leftb, rightb), nve ) );
			
		} else {
			set< pair< int, int > > pset;
			vector<pair< pair< int, int >, vector< pair< int, int > > > >::iterator Ite;
			vector<pair< pair< int, int >, vector< pair< int, int > > > > new_area;
			map< pair< int, int >, vector< pair< int, int > > > area_map;
			for ( Ite = cover_area.begin(); Ite != cover_area.end(); ++Ite ) {
				pset.insert( Ite->first );
				area_map.insert( make_pair( Ite->first, Ite->second ) );
			}
			pset.insert( make_pair( leftb, rightb ) );
			area_map.insert( make_pair( make_pair( leftb, rightb ), nve ) );
			set< pair< int, int > >::iterator Itepset;
			for ( Itepset = pset.begin(); Itepset != pset.end(); ++Itepset ) {
				addleft_cover_area( new_area, *Itepset, area_map[*Itepset] );
			}
			cover_area = new_area;

		}
	}
}

void add_sub_cover_area( vector< pair< int, int > > &cover_area, pair< int, int > add_pos )
{
	if ( cover_area.empty() )
		cover_area.push_back( add_pos );
	else {
		if ( add_pos.first > cover_area[ cover_area.size() - 1 ].second ) {
			cover_area.push_back( add_pos );
		} else {
		
			set< pair< int, int > > areaset;
			size_t vesize = cover_area.size();
			for ( size_t i = 0; i < vesize; ++i ) {
				areaset.insert( cover_area[i] );
			}
			areaset.insert( add_pos );

			vector< pair< int, int > > new_ve;
			set< pair< int, int > >::iterator Ite = areaset.begin();
			pair< int, int > lastp = *Ite;
			++Ite;
			for ( ; Ite != areaset.end(); ++Ite ) {
				if ( Ite->first > lastp.second ) {
					new_ve.push_back( lastp );
					lastp = *Ite;
				} else {
					lastp.second = max( Ite->second, lastp.second );
				}
			}
			new_ve.push_back( lastp );
			cover_area = new_ve;
			
		} 
		
	}
}

void addleft_cover_area( vector<pair< pair< int, int >, vector< pair< int, int > > > > &cover_area, pair< int, int > addb, vector< pair< int, int > > &addve )
{
	if ( cover_area.empty() )
		cover_area.push_back( make_pair( addb, addve ) );
	else {
		if ( addb.first > cover_area.back().first.second )
			cover_area.push_back( make_pair( addb, addve ) );
		else {
			cover_area.back().first.second = max( addb.second, cover_area.back().first.second );
			for ( size_t i = 0; i < addve.size(); ++i ) {
				add_sub_cover_area( cover_area.back().second, addve[i] );
			}
			
		}
	}
}

void trans_mate_pair( map<int, pair<int, pair<int, int> > > &Pairs, MP_bank &mp_bank )
{
	map< int, pair<int, pair<int, int> > >::iterator Ite;
	for ( Ite = Pairs.begin(); Ite != Pairs.end(); ++Ite ) {
		if ( Ite->first < Ite->second.first ) {
			MP mp;
			mp.ida = Ite->first;
			mp.idb = Ite->second.first;
			mp.drct_type = 2;
			mp.exlen_exp = Ite->second.second.first;
			mp.exlen_var = Ite->second.second.second;
			mp.exlen_lowb = Ite->second.second.first - 4 * Ite->second.second.second;
			mp.exlen_upb = Ite->second.second.first + 4 * Ite->second.second.second;
			Mp_id n_id = 0;
			if ( mp_bank.Mp_map.empty() )
				n_id = 1;
			else 
				n_id = mp_bank.Mp_map.rbegin()->first;
			mp_bank.Mp_map.insert( make_pair( n_id, mp ) );
			mp_bank.Paired_mp_map.insert( make_pair( Ite->first, make_pair( Ite->second.first, n_id ) ) );
			mp_bank.Paired_mp_map.insert( make_pair( Ite->second.first, make_pair( Ite->first, n_id ) ) );
		}
	}
}

