#include "Cons_Aln_Refn.h"

void Seg_Aln_Refine( map< Read_id, Segmented_Read > &Read_Map, Seg_Aln_Graph & graph, Cons_Bank & bank )
{

	Cut_site_initiate( Read_Map, graph, bank );



	map< Read_id, Segmented_Read >::iterator Ite;
	for( Ite = Read_Map.begin(); Ite != Read_Map.end(); ++Ite ){
		set< Cut_site > boundary_site_set = Ite->second.Read_Cut_site;
		set< Cut_site >::iterator Iteset;
		for ( Iteset = boundary_site_set.begin(); Iteset != boundary_site_set.end(); ++Iteset ) {
		
			Cut_site_find_recursion( Ite->first, *Iteset, Read_Map, graph, bank );
		
		}
	}

	for( Ite = Read_Map.begin(); Ite != Read_Map.end(); ++Ite ){
		Ite->second.Seg_Interval_Map.clear();
	}

	reconstruct_Aln_Graph( Read_Map, graph, bank );
	

}

void Cut_site_initiate( map< Read_id, Segmented_Read > &Read_Map, Seg_Aln_Graph & graph, Cons_Bank & bank )
{
	int seg_size = (int) graph.Seg_Ve.size();
	for ( int i = 0; i < seg_size; ++i ) {
		Read_id id = graph.Seg_Ve[i].first;

		Cut_site front_cut_site = bank.Seg_Map[graph.Seg_Ve[i]].bgn - 1;
		Cut_site end_cut_site = bank.Seg_Map[graph.Seg_Ve[i]].bgn + bank.Seg_Map[graph.Seg_Ve[i]].len - 1;
		Read_Map[id].Read_Cut_site.insert( front_cut_site );
		Read_Map[id].Read_Cut_site.insert( end_cut_site );

		Read_Map[id].Seg_Interval_Map.insert( make_pair( make_pair( front_cut_site, end_cut_site ), graph.Seg_Ve[i] ) );

	}



	// compute the contain relationship of cut_sites and segments.
	map< Read_id, Segmented_Read >::iterator IteR;
	for ( IteR = Read_Map.begin(); IteR != Read_Map.end(); ++IteR ) {

		Cut_site start_finding_site  = *IteR->second.Read_Cut_site.begin();
		map< pair< Cut_site, Cut_site >, pair< Read_id, Seg_sub_id > >::iterator seg_ite_I = IteR->second.Seg_Interval_Map.begin();
		for( ; seg_ite_I != IteR->second.Seg_Interval_Map.end(); ++seg_ite_I ) {
			set< Cut_site >::iterator cutsite_ite = IteR->second.Read_Cut_site.find( start_finding_site );
			//state indicate the finding state in the circle. if state == 0, start state or the cut_site is still off the left side of the interval;
			//if state  == 1, the cut_site is bigger than the left boundary. The first cut_site that shift state from 0 to 1 is assigned to new start_finding_site, 
			//from which the cut_site starts in the next sircle. furthermore, if the cutsite is smaller than the right boundary, the cut_site is contained in 
			//that interval, else the cutsite is off the right side of the interval, terminate the circle.
			//
			int state = 0;
			for( ; cutsite_ite != IteR->second.Read_Cut_site.end(); ++cutsite_ite ) {
				if( state == 0 ) {
					if( *cutsite_ite > seg_ite_I->first.first ) {
						
						state = 1;
						start_finding_site = *cutsite_ite;
					}
				}
				if( state == 1 ){
					if( *cutsite_ite < seg_ite_I->first.second ) {
						IteR->second.Read_Seg_Cut_site_contn_Map[*cutsite_ite].insert( seg_ite_I->second );
						
					}else{
						break;
					}
				}
			}
		}

		

	}
}

void Cut_site_find_recursion( Read_id read_i, 
							 Cut_site w, 
							 map< Read_id, Segmented_Read > &Read_Map, 
							 Seg_Aln_Graph & graph, 
							 Cons_Bank & bank )
{
	set< pair< Read_id, Seg_sub_id > >::iterator Itecon;

	for ( Itecon = Read_Map[read_i].Read_Seg_Cut_site_contn_Map[w].begin(); Itecon != Read_Map[read_i].Read_Seg_Cut_site_contn_Map[w].end(); ++Itecon ) {
		pair< Read_id, Seg_sub_id > sega = *Itecon;

		if ( graph.Match_pair_Map.find(sega) != graph.Match_pair_Map.end() ){
			map<pair<Read_id, Seg_sub_id>, Seg_Match_id>::iterator Iter;
			for ( Iter = graph.Match_pair_Map[sega].begin(); Iter != graph.Match_pair_Map[sega].end(); ++Iter ) {
				Cut_site v = projected_site_c( w, sega, Iter->first, bank.Seg_Map );

				//To check wheather the projected site v is already contained in the Cut_site Set of read_j.
				//if false (not contained), insert v into the Cut_site Set of read_j, connect the contained relationship
				// between v and segb (Iter->first) , and recurse this function using v.
				Read_id read_j = Iter->first.first;
			
				Add_cut_site_contn( Read_Map[read_j], v );
				if( Read_Map[read_j].Read_Cut_site.find(v) == Read_Map[read_j].Read_Cut_site.end() ) {
					Read_Map[read_j].Read_Cut_site.insert(v);
					Cut_site_find_recursion ( read_j, v, Read_Map, graph, bank );
				}

			}
		}
	}
}

void Add_cut_site_contn( Segmented_Read & seg_read, Cut_site v )
{
	map< pair< Cut_site, Cut_site >, pair< Read_id, Seg_sub_id > >::iterator Ite;
	for ( Ite = seg_read.Seg_Interval_Map.begin(); Ite != seg_read.Seg_Interval_Map.end(); ++Ite ) {
		if ( Ite->first.second <= v )
			continue;
		if ( Ite->first.first >= v )
			break;

		seg_read.Read_Seg_Cut_site_contn_Map[v].insert( Ite->second );
	}

}

Cut_site projected_site_c( Cut_site w, 
							 pair<Read_id, Seg_sub_id > Sega, 
							 pair<Read_id, Seg_sub_id > Segb, 
							 map< pair< Read_id, Seg_sub_id >, Segment > & Seg_Map )
{
	return Seg_Map[Segb].bgn + ( w - Seg_Map[Sega].bgn );
}
						
// the Cons_Bank.Seg_Map also update: before the update, the key of the Seg_Map, which is also the id of one segment, its second id, e.g. seg_sub_id, just 
// present by its index of the segment of the read that it belongs to. Two segments may have the same bgn and read_id. after the update, since only one 
// segment correspond to one pair < read_id, bgn > tag, so use bgn site of that segment as its second id, e.g. seg_sub_id. 
void reconstruct_Aln_Graph( map< Read_id, Segmented_Read > &Read_Map, Seg_Aln_Graph & graph, Cons_Bank & bank )
{

	map< Read_id, Segmented_Read >::iterator Item;
	for( Item = Read_Map.begin(); Item != Read_Map.end(); ++Item ) {
	
		map< Cut_site, set< pair< Read_id, Seg_sub_id > > >::iterator Itect;
		for( Itect = Item->second.Read_Seg_Cut_site_contn_Map.begin(); Itect != Item->second.Read_Seg_Cut_site_contn_Map.end(); ++Itect ){

			set< pair< Read_id, Seg_sub_id > >::iterator Ites;
			for ( Ites = Itect->second.begin(); Ites != Itect->second.end(); ++Ites ) {
			
				Item->second.Read_Seg_Cut_site_rvcontn_Map[*Ites].insert( Itect->first );
			}
		}

		//clear Read_Seg_Cut_site_contn_Map
		Item->second.Read_Seg_Cut_site_contn_Map.clear();
		

	}



	map< pair< Read_id, Seg_sub_id >, Segment > new_seg_map;
	map<pair<Read_id, Seg_sub_id>, map<pair<Read_id, Seg_sub_id>, Seg_Match_id> > new_match_pair_map;
	map<Seg_Match_id, Seg_Match> new_match_map;
	set< Read_id > used_read_set;

	int seg_size = (int)graph.Seg_Ve.size();

	set< pair<Read_id, Seg_sub_id> > n_seg_set;

	for( int i = 0; i < seg_size; ++i ) {

		Read_id rda = graph.Seg_Ve[i].first;
		used_read_set.insert( rda );
		if( ! Read_Map[rda].Read_Seg_Cut_site_rvcontn_Map[graph.Seg_Ve[i]].empty() ) {
		
			int cut_size = (int)Read_Map[rda].Read_Seg_Cut_site_rvcontn_Map[graph.Seg_Ve[i]].size();

			vector< Segment > nsegve;

			set< Cut_site >::iterator Ites = Read_Map[rda].Read_Seg_Cut_site_rvcontn_Map[graph.Seg_Ve[i]].begin();
			Cut_site site1 = bank.Seg_Map[graph.Seg_Ve[i]].bgn - 1;
			
			for( ; Ites != Read_Map[rda].Read_Seg_Cut_site_rvcontn_Map[graph.Seg_Ve[i]].end(); ++Ites ) {
				Cut_site site2 = *Ites;
				Segment nseg;
				nseg.bgn = site1 + 1;
				nseg.id = rda;
				nseg.len = site2 - site1;
				new_seg_map.insert( make_pair( make_pair( rda, nseg.bgn ), nseg ) );
				Read_Map[rda].Seg_Interval_Map.insert( make_pair( make_pair( site1, site2 ), make_pair( rda, nseg.bgn ) ) );
				n_seg_set.insert( make_pair( rda, nseg.bgn ) );
				nsegve.push_back( nseg );
				site1 = *Ites;
			}

			Cut_site site2 = bank.Seg_Map[graph.Seg_Ve[i]].bgn + bank.Seg_Map[graph.Seg_Ve[i]].len - 1;
			Segment nseg;
			nseg.bgn = site1 + 1;
			nseg.id = rda;
			nseg.len = site2 - site1;
			new_seg_map.insert( make_pair( make_pair( rda, nseg.bgn ), nseg ) );
			Read_Map[rda].Seg_Interval_Map.insert( make_pair( make_pair( site1, site2 ), make_pair( rda, nseg.bgn ) ) );
			n_seg_set.insert( make_pair( rda, nseg.bgn ) );
			nsegve.push_back( nseg );
		

			// create new Seg_Match:
			if( graph.Match_pair_Map.find( graph.Seg_Ve[i] ) != graph.Match_pair_Map.end() ) {
				map<pair<Read_id, Seg_sub_id>, Seg_Match_id>::iterator Itempm;
				for( Itempm = graph.Match_pair_Map[graph.Seg_Ve[i]].begin(); Itempm != graph.Match_pair_Map[graph.Seg_Ve[i]].end(); ++Itempm ) {
					Read_id rdb = Itempm->first.first;
					if( used_read_set.find( rdb ) == used_read_set.end() ) {    //the match has not been created before.
						if( (int)Read_Map[rdb].Read_Seg_Cut_site_rvcontn_Map[Itempm->first].size() != cut_size ) {
							cerr << "error: cut_size of two matched segments do not equal " <<endl;
						}else{
							split_match( new_match_pair_map, new_match_map, graph.Seg_Match_Map[Itempm->second], nsegve, bank );
						
						}
					}
				}

			
			}
		}else {   // also need to update the sub_seg_id.
		
			Cut_site site1 = bank.Seg_Map[graph.Seg_Ve[i]].bgn - 1;
			Cut_site site2 = site1 + bank.Seg_Map[graph.Seg_Ve[i]].len;
			n_seg_set.insert( make_pair( rda, bank.Seg_Map[graph.Seg_Ve[i]].bgn ) );
			new_seg_map.insert( make_pair( make_pair( rda, bank.Seg_Map[graph.Seg_Ve[i]].bgn ), bank.Seg_Map[graph.Seg_Ve[i]] ) );
			Read_Map[rda].Seg_Interval_Map.insert( make_pair( make_pair( site1, site2 ), make_pair( rda, site1 + 1 ) ) );

			
			if( graph.Match_pair_Map.find( graph.Seg_Ve[i] ) != graph.Match_pair_Map.end() ) {
				map<pair<Read_id, Seg_sub_id>, Seg_Match_id>::iterator Itempm;
				for( Itempm = graph.Match_pair_Map[graph.Seg_Ve[i]].begin(); Itempm != graph.Match_pair_Map[graph.Seg_Ve[i]].end(); ++Itempm ) {
					Read_id rdb = Itempm->first.first;
					if( used_read_set.find( rdb ) == used_read_set.end() ) {    //the match has not updated before.
						update_match( new_match_pair_map, new_match_map, graph.Seg_Match_Map[Itempm->second], bank );
					}
				}
			}
		}

	}
	

	graph.Seg_Set = n_seg_set;
	graph.Match_pair_Map = new_match_pair_map;
	graph.Seg_Match_Map = new_match_map;
	bank.Seg_Map = new_seg_map;
}


void split_match( map<pair<Read_id, Seg_sub_id>, map<pair<Read_id, Seg_sub_id>, Seg_Match_id> > & new_match_pair_map,
				 map<Seg_Match_id, Seg_Match> & match_map,
				 Seg_Match &fmatch, 
				 vector< Segment > &segve, 
				 Cons_Bank & bank )
{

	Read_id rda = segve[0].id;
	Read_id rdb = 0;
	int rda_bgn = segve[0].bgn;
	int rdb_bgn = 0;
	int len = 0;

	if( fmatch.Sega.first == rda ){
		
		rdb = fmatch.Segb.first;

		rdb_bgn = bank.Seg_Map[fmatch.Segb].bgn;
		len = bank.Seg_Map[fmatch.Segb].len;
	}else {
		
		rdb = fmatch.Sega.first;

		rdb_bgn = bank.Seg_Map[fmatch.Sega].bgn;
		len = bank.Seg_Map[fmatch.Sega].len;
	}

	size_t vesize = segve.size();
	int addlen = 0;
	for( size_t i = 0; i < vesize; ++i ) {
		Seg_Match seg_match_y;
		seg_match_y.Sega = make_pair( rda, segve[i].bgn );
		int d = segve[i].bgn - rda_bgn;
		seg_match_y.Segb = make_pair( rdb, rdb_bgn + d );
		seg_match_y.len = segve[i].len;

		seg_match_y.score = fmatch.score * ( double( seg_match_y.len ) / fmatch.len );
		Seg_Match_id nmid;
		if( !match_map.empty() )
			nmid = match_map.rbegin()->first + 1;
		else
			nmid = 1;

		match_map.insert( make_pair( nmid, seg_match_y ) );
		new_match_pair_map[seg_match_y.Sega][seg_match_y.Segb] = nmid;
		new_match_pair_map[seg_match_y.Segb][seg_match_y.Sega] = nmid;

		addlen += seg_match_y.len;
	}

	

	if( addlen != len ){
		cerr << "error in split match "<<endl;
	}

}


void update_match( map<pair<Read_id, Seg_sub_id>, map<pair<Read_id, Seg_sub_id>, Seg_Match_id> > & new_match_pair_map,
				 map<Seg_Match_id, Seg_Match> & match_map, 
				 Seg_Match &fmatch, 
				 Cons_Bank & bank )
{
	Seg_Match new_seg_match;
	new_seg_match.len = fmatch.len;
	new_seg_match.score = fmatch.score;
	pair< Read_id, Seg_sub_id > sega;
	pair< Read_id, Seg_sub_id > segb;
	sega = make_pair( fmatch.Sega.first, bank.Seg_Map[fmatch.Sega].bgn );
	segb = make_pair( fmatch.Segb.first, bank.Seg_Map[fmatch.Segb].bgn );
	new_seg_match.Sega = sega;
	new_seg_match.Segb = segb;

	Seg_Match_id nmid;
	if( !match_map.empty() )
		nmid = match_map.rbegin()->first + 1;
	else
		nmid = 1;
	match_map.insert( make_pair( nmid, new_seg_match ) );
	new_match_pair_map[sega][segb] = nmid;
	new_match_pair_map[segb][sega] = nmid;

}
