#ifndef CONS_ALI_REFN_H
#define CONS_ALI_REFN_H


//refine the segment match aligment

#include "Cons_Seg_Graph.h"



void Seg_Aln_Refine( map< Read_id, Segmented_Read > &Read_Map, Seg_Aln_Graph & graph, Cons_Bank & bank );

//In the beginning, initiate the Cut_site with the boundary sites of each matched segments
//     
//      Seg:        ATGCATGC
//                 ||      |
//                  x  ..  y
//                 |       |
//      cut_site: (x-1) .. y
// that is, if the cut site are u and v, then the segment's interval is (u, v], left open and right close interval.        
void Cut_site_initiate( map< Read_id, Segmented_Read > &Read_Map, Seg_Aln_Graph & graph, Cons_Bank & bank );

void Cut_site_find_recursion( Read_id read_i, Cut_site w, map< Read_id, Segmented_Read > &Read_Map, Seg_Aln_Graph & graph, Cons_Bank & bank );

//Sega and Segb match each other, and Sega contains w. Compute the projected position on read_j to w:
//                                  bgn_u     w
//								      |       |   
//         Sega:         read_i       XXXXXXXXXXXXXXXXX                                  
//                                    |||||||||||||||||
//                                    |||||||||||||||||
//         Segb:         read_j       YYYYYYYYYYYYYYYYY  
//                                    |       |
//                                   bgnx     ?
Cut_site projected_site_c( Cut_site w, pair<Read_id, Seg_sub_id > Sega, pair<Read_id, Seg_sub_id > Segb, map< pair< Read_id, Seg_sub_id >, Segment > & Seg_Map );

void Add_cut_site_contn( Segmented_Read & seg_read, Cut_site v );

void reconstruct_Aln_Graph( map< Read_id, Segmented_Read > &Read_Map, Seg_Aln_Graph & graph, Cons_Bank & bank );

void split_match( map<pair<Read_id, Seg_sub_id>, map<pair<Read_id, Seg_sub_id>, Seg_Match_id> > & new_match_pair_map,
				 map<Seg_Match_id, Seg_Match> & match_map,
				 Seg_Match &fmatch,
				 vector< Segment > &segve,
				 Cons_Bank & bank );

void update_match( map<pair<Read_id, Seg_sub_id>, map<pair<Read_id, Seg_sub_id>, Seg_Match_id> > & new_match_pair_map,
				 map<Seg_Match_id, Seg_Match> & match_map, 
				 Seg_Match &fmatch, 
				 Cons_Bank & bank );


#endif
