#include "Cons_Ctg_Cons.h"

void Trans_seg_alnmt_To_alnmt( Seg_Mul_Alnmt & seg_alnmt, Mul_Alnmt & alnmt, Cons_Bank & bank )
{
	
	set< Read_id > active_read_set;
	size_t sa_size = seg_alnmt.size();
	for ( size_t i = 0; i < sa_size; ++i ) {
	
		
		vector< Read_id > deactive_read_set;
		map< Read_id, Seg_sub_id >::iterator Ite = seg_alnmt[i].begin();
		int len = bank.Seg_Map[make_pair( Ite->first, Ite->second )].len;
		
		vector< Mul_Aln_Site > new_aln_site(len);
		for ( ; Ite != seg_alnmt[i].end(); ++Ite ) {
			
			if( active_read_set.find( Ite->first ) == active_read_set.end() )
				active_read_set.insert( Ite->first );
			
			for ( int j = 0; j < len; ++j ) {
				char base = bank.Read_Str_Map[Ite->first][Ite->second + j - 1];
				int sc = bank.Read_Sc_Map[Ite->first][Ite->second + j - 1];
				new_aln_site[j].insert( make_pair( Ite->first, make_pair( base, sc ) ) );
			}
			if( Ite->second - 1 + len == (int)bank.Read_Str_Map[Ite->first].size() )
				deactive_read_set.push_back(Ite->first);
		}

		
		//indels exist in some sequences at some segment sphere.
		if( (int)active_read_set.size() > (int)seg_alnmt[i].size() ) {
			
			set< Read_id >::iterator Iteset;
			for ( Iteset = active_read_set.begin(); Iteset != active_read_set.end(); ++Iteset ) {
				
				if ( seg_alnmt[i].find ( *Iteset ) == seg_alnmt[i].end() ) {
					
					for ( int j = 0; j < len; ++j ) {
						
						new_aln_site[j].insert( make_pair ( *Iteset, make_pair ( '-', 20 ) ) );
						
					}
				}
			}
		}

		
		//deavtivate read which end at this segment.
		if( ! deactive_read_set.empty() ) {
			for ( size_t k = 0; k < deactive_read_set.size(); ++k ) {
				active_read_set.erase( deactive_read_set[k] );
			}
			deactive_read_set.clear();
		}

		alnmt.insert( alnmt.end(), new_aln_site.begin(), new_aln_site.end() );

	}

	//complete_indelqc
	complete_indelqc( alnmt );
	
}

void complete_indelqc( Mul_Alnmt &alnmt )
{
	for ( size_t i = 0; i < alnmt.size(); ++i ) {
		Mul_Aln_Site::iterator Ite;
		for ( Ite = alnmt[i].begin(); Ite != alnmt[i].end(); ++Ite ) {
			if ( Ite->second.first == '-' ) {
				Read_id rid = Ite->first;

				int k = (int)i + 1;
				int qc_f = -1;
				while ( k < (int)alnmt.size() ) {
					if ( alnmt[k].find( rid ) != alnmt[k].end() ) {
						if ( alnmt[k][rid].first != '-' ) {
							qc_f = alnmt[k][rid].second;
							break;
						} else {
							++k;
							continue;
						}
					} else {
						break;
					}
				}

				k = (int)i - 1;
				int qc_b = -1;
				while ( k >= 0 ) {
					if ( alnmt[k].find(rid) != alnmt[k].end() ) {
						if ( alnmt[k][rid].first != '-' ) {
							qc_b = alnmt[k][rid].second;
							break;
						} else {
							--k;
							continue;
						}
					} else {
						break;
					}
				}

				if ( qc_f != -1 && qc_b != -1 ) {
					int qc = min( qc_f , qc_b );
					Ite->second.second = qc;
				} else if ( qc_f != -1 ) {
					Ite->second.second = qc_f;
				} else if ( qc_b != -1 ) {
					Ite->second.second = qc_b;
				} else {
					cout<<"error no qc for indel's nerbour "<<endl; system("pause");
					
				}
			}
		}
	}
}

void Trans_seg_alnmt_To_lay( Seg_Mul_Alnmt & seg_alnmt, Layout & lay, Cons_Bank & bank )
{

	size_t sa_size = seg_alnmt.size();
	int site_index = 1;
	for ( size_t i = 0; i < sa_size; ++i ) {
		map< Read_id, Seg_sub_id >::iterator Ite = seg_alnmt[i].begin();
		int len = bank.Seg_Map[make_pair( Ite->first, Ite->second )].len;
		for ( ; Ite != seg_alnmt[i].end(); ++Ite ) {
			if ( Ite->second == 1 ) {   //read starts
				lay.Read_List.push_back( Ite->first );
				lay.Read_Pos_Map[Ite->first].first = site_index;
			}
			if( Ite->second - 1 + len == (int)bank.Read_Str_Map[Ite->first].size() ) {    //read ends
				lay.Read_Pos_Map[Ite->first].second = site_index + len -1;
			}
		}
		site_index += len;
	}
}

pair< char, int > singlesitecomp( Mul_Aln_Site & site )
{
	
	map<char, pair<int, int> > bmap;
	Mul_Aln_Site::iterator Ite_site;
	for ( Ite_site = site.begin(); Ite_site != site.end(); ++Ite_site ) {
		if(bmap.find( Ite_site->second.first ) == bmap.end()){
			bmap.insert( make_pair( Ite_site->second.first, make_pair( 1, Ite_site->second.second ) ) );
		}else{
			bmap[Ite_site->second.first].first += 1;
			if( bmap[Ite_site->second.first].second < Ite_site->second.second )
				bmap[Ite_site->second.first].second = Ite_site->second.second;
		}
	}

	char opt = bmap.begin()->first;
	
	pair<int, int> opp = bmap.begin()->second;
	map<char, pair<int, int> >::iterator ite = bmap.begin();
	++ite;
	for(; ite != bmap.end(); ++ite){
		if ( ite->first == 'N' )
			continue;
		if ( opt == 'N' && ite->first != 'N' ) {
			opt = ite->first;
			opp = ite->second;
			continue;
		} 
		if(ite->second.first > opp.first){
			opt = ite->first;
			opp = ite->second;
		}else if(ite->second.first == opp.first){
			if(ite->second.second > opp.second){
				opt = ite->first;
				opp = ite->second;
			}else if(ite->second.second == opp.second){
				if(opt == '-'){
					opt = ite->first;
					opp = ite->second;
				}
			}
		}
			
	}

	int optsc = opp.second;

	return make_pair ( opt, optsc );
}

pair< char, int > singlesitecomp( Mul_Aln_Site & site, vector< bool > &snp )
{
	map<char, pair<int, int> > bmap;
	Mul_Aln_Site::iterator Ite_site;
	for ( Ite_site = site.begin(); Ite_site != site.end(); ++Ite_site ) {
		if(bmap.find( Ite_site->second.first ) == bmap.end()){
			bmap.insert( make_pair( Ite_site->second.first, make_pair( 1, Ite_site->second.second ) ) );
		}else{
			bmap[Ite_site->second.first].first += 1;
			if( bmap[Ite_site->second.first].second < Ite_site->second.second )
				bmap[Ite_site->second.first].second = Ite_site->second.second;
		}
	}

	if ( (int)bmap.size() > 1 )
		snp.push_back(true);
	else 
		snp.push_back(false);

	char opt = bmap.begin()->first;
	
	pair<int, int> opp = bmap.begin()->second;
	map<char, pair<int, int> >::iterator ite = bmap.begin();
	++ite;
	for(; ite != bmap.end(); ++ite){
		if ( ite->first == 'N' )
			continue;
		if ( opt == 'N' && ite->first != 'N' ) {
			opt = ite->first;
			opp = ite->second;
			continue;
		} 
		if(ite->second.first > opp.first){
			opt = ite->first;
			opp = ite->second;
		}else if(ite->second.first == opp.first){
			if(ite->second.second > opp.second){
				opt = ite->first;
				opp = ite->second;
			}else if(ite->second.second == opp.second){
				if(opt == '-'){
					opt = ite->first;
					opp = ite->second;
				}
			}
		}
			
	}

	int optsc = opp.second;

	return make_pair ( opt, optsc );
}

void mul_alnmt_consense( Mul_Alnmt & alnmt, string & ctg, vector< int > & sc_ve, vector< int > &cvgve )
{
	size_t size = alnmt.size();
	for ( size_t i = 0; i < size; ++i ) {
		
		pair< char, int > opt = singlesitecomp( alnmt[i] );
	
		ctg += opt.first;
		sc_ve.push_back( opt.second );
		cvgve.push_back( (int)alnmt[i].size() );

	}
	
}

void mul_alnmt_consense( Mul_Alnmt & alnmt, string & ctg, vector< int > & sc_ve, vector< int > &cvgve, map< int, Mul_Aln_Site > &snp)
{
	size_t size = alnmt.size();
	for ( size_t i = 0; i < size; ++i ) {
		vector<bool> snpf;
		pair< char, int > opt = singlesitecomp( alnmt[i], snpf );
		if ( !snpf.empty() ) {
			if ( snpf[0] ) {
				snp.insert( make_pair( (int)i+1, alnmt[i] ) );
			
			}
		}
		
		ctg += opt.first;
		sc_ve.push_back( opt.second );
		cvgve.push_back( (int)alnmt[i].size() );
	}

	
}

