#include "Cons_Nod_Aln.h"

void Read_Pair_Seg_Aln::score_compute()
{
	score = 0;
	map< Seg_sub_id, map< Seg_sub_id, double > >::iterator Iter;
	map< Seg_sub_id, double > Segb_score_map;
	for( Iter = match_score_map.begin(); Iter !=  match_score_map.end(); ++Iter ) {
		double lsc = -100;
		Seg_sub_id sub_id_b = 0;

		map< Seg_sub_id, double >::iterator subiter;
		for ( subiter = Iter->second.begin(); subiter != Iter->second.end(); ++ subiter ) {
			if( subiter->second > lsc ){
				lsc = subiter->second;
				sub_id_b = subiter->first;
			}
		}

		if ( Segb_score_map.find( sub_id_b ) == Segb_score_map.end() ) {
			Segb_score_map[sub_id_b] = lsc;
		} else {
			if ( lsc > Segb_score_map[sub_id_b] ) {
				Segb_score_map[sub_id_b] = lsc;
			}
		}
		
	}

	map< Seg_sub_id, double >::iterator Ite_smap;
	for ( Ite_smap = Segb_score_map.begin(); Ite_smap != Segb_score_map.end(); ++Ite_smap ) {
		score += Ite_smap->second;
	}
}

bool Cons_Gud_Tree::opt_node_pair_get()
{

	double maxsc = -100;
	int tag = 0;
	map< int, map< int, double > >::iterator Iter;
	for( Iter = aln_score_map.begin(); Iter != aln_score_map.end(); ++Iter ) {
		map< int, double >::iterator subiter;
		for( subiter = Iter->second.begin(); subiter != Iter->second.end(); ++ subiter ) {
			
			if( subiter->second > maxsc ) {
				maxsc = subiter->second;
				opt_node_pair = make_pair( Iter->first, subiter->first );
				tag = 1;
				
			}

		}
	}
	if( tag == 1 )
		return true;
	else 
		return false;
}

void Cons_Multaln::initiate( map< Read_id, Segmented_Read > &Read_Map, Seg_Aln_Graph & graph )
{

	map< Read_id, int > Read_index_map;
	map< Read_id, Segmented_Read >::iterator Ite_read;
	int idx = 0;
	for ( Ite_read = Read_Map.begin(); Ite_read != Read_Map.end(); ++Ite_read ) {
		Seg_Mul_Alnmt n_alnmt;
		map< pair< Cut_site, Cut_site >, pair< Read_id, Seg_sub_id > >::iterator Ite_intv;
		for ( Ite_intv = Ite_read->second.Seg_Interval_Map.begin(); Ite_intv != Ite_read->second.Seg_Interval_Map.end(); ++Ite_intv ) {
			Seg_Mul_Aln_Node n_node;
			n_node.insert( make_pair( Ite_intv->second.first, Ite_intv->second.second ) );
			n_alnmt.push_back( n_node );
		}
		idx += 1;
		Seg_mamap.insert( make_pair( idx, n_alnmt ) );
		Read_index_map.insert( make_pair( Ite_read->first, idx ) );
	}

	map<pair<Read_id, Seg_sub_id>, map<pair<Read_id, Seg_sub_id>, Seg_Match_id> >::iterator Ite_mp;
	for( Ite_mp = graph.Match_pair_Map.begin(); Ite_mp != graph.Match_pair_Map.end(); ++Ite_mp ) {
		Read_id read_a = Ite_mp->first.first;
		Seg_sub_id sub_id_a = Ite_mp->first.second;
		map<pair<Read_id, Seg_sub_id>, Seg_Match_id>::iterator sub_ite_mp;
		for ( sub_ite_mp = Ite_mp->second.begin(); sub_ite_mp != Ite_mp->second.end(); ++sub_ite_mp ) {
			Read_id read_b = sub_ite_mp->first.first;
			if ( read_a < read_b ) {
				Seg_sub_id sub_id_b = sub_ite_mp->first.second;
				if ( Pair_Aln_Map[read_a].find( read_b ) == Pair_Aln_Map[read_a].end() ) {

					Read_Pair_Seg_Aln obj;
					obj.rda = read_a;
					obj.rdb = read_b;
					Read_Pair_Seg_Aln_Ve.push_back( obj );

					Read_Pair_Seg_Aln_id nid = (int)Read_Pair_Seg_Aln_Ve.size() - 1;
					Pair_Aln_Map[read_a][read_b] = nid;
					Pair_Aln_Map[read_b][read_a] = nid;
				}

				Read_Pair_Seg_Aln_id aln_id = Pair_Aln_Map[read_a][read_b];

				double score = graph.extended_Seg_Match_Map[sub_ite_mp->second].score;
				Read_Pair_Seg_Aln_Ve[aln_id].match_score_map[sub_id_a][sub_id_b] = score;
				Read_Pair_Seg_Aln_Ve[aln_id].match_score_map_II[sub_id_b][sub_id_a] = score;

			}
		}
	}

	int asize = (int)Read_Pair_Seg_Aln_Ve.size();
	for( int i = 0; i < asize; ++i ) {
		Read_Pair_Seg_Aln_Ve[i].score_compute();
		Read_id read_a = Read_Pair_Seg_Aln_Ve[i].rda;
		Read_id read_b = Read_Pair_Seg_Aln_Ve[i].rdb;
		tree.aln_score_map[Read_index_map[read_a]][Read_index_map[read_b]] = Read_Pair_Seg_Aln_Ve[i].score;
		tree.aln_score_map[Read_index_map[read_b]][Read_index_map[read_a]] = Read_Pair_Seg_Aln_Ve[i].score;
	}
}

void Cons_Multaln::update_guide_tree( Cons_Bank & bank )
{

	Seg_Mul_Alnmt alna = Seg_mamap[tree.opt_node_pair.first];
	Seg_Mul_Alnmt alnb = Seg_mamap[tree.opt_node_pair.second];

	Seg_Mul_Alnmt alnc;
	alndp( alna, alnb, alnc, bank );


	int newindex = Seg_mamap.rbegin()->first + 1;
	Seg_mamap.erase( tree.opt_node_pair.first );
	Seg_mamap.erase( tree.opt_node_pair.second );
	Seg_mamap.insert( make_pair( newindex, alnc ) );


	// To update the tree, we just need to caculate the distances between the new node and other linking nodes.
	// the linking nodes are confined in the node set in which the node links to the last two opt-pair-node.
	// For each linking node c, the new distance is assigned the average of the two distances of opt-pair-node (a and b) and c, 
	// the distances can be read from last aln_score_map.
	// Because the case may be that only one opt-pair-node a links to the node c, and the other opt-pair-node b does 
	// does not links to c, thus we assign new distance the right distance of a and c.
	map< int, double >::iterator Item = tree.aln_score_map[tree.opt_node_pair.first].begin();
	for( ; Item != tree.aln_score_map[tree.opt_node_pair.first].end(); ++Item ) {
		if( Item->first == tree.opt_node_pair.second )
			continue;
		double d = Item->second;
		if ( tree.aln_score_map[tree.opt_node_pair.second].find( Item->first ) != tree.aln_score_map[tree.opt_node_pair.second].end() ) {
			d += tree.aln_score_map[tree.opt_node_pair.second][Item->first];
			d = d / 2;
		}
		tree.aln_score_map[newindex][Item->first] = d;
		tree.aln_score_map[Item->first][newindex] = d;

		tree.aln_score_map[Item->first].erase( tree.opt_node_pair.first );
	}
	Item = tree.aln_score_map[tree.opt_node_pair.second].begin(); 
	for( ; Item != tree.aln_score_map[tree.opt_node_pair.second].end(); ++Item ) {
		if( Item->first == tree.opt_node_pair.first )
			continue;
		if( tree.aln_score_map[tree.opt_node_pair.first].find( Item->first ) == tree.aln_score_map[tree.opt_node_pair.first].end() ) {
			tree.aln_score_map[newindex][Item->first] = Item->second;
			tree.aln_score_map[Item->first][newindex] = Item->second;
		}

		tree.aln_score_map[Item->first].erase( tree.opt_node_pair.second );
	}

	tree.aln_score_map.erase( tree.opt_node_pair.first );
	tree.aln_score_map.erase( tree.opt_node_pair.second );

}

//To determine the score of each pair of segments from Mulmt a and b, if the pair matches in the seg_aln_graph,
//assign the right score from the graph, otherwise no score is assigned to that pair.
void Cons_Multaln::scoring_f( Seg_Mul_Alnmt & alna, Seg_Mul_Alnmt & alnb, map< int, map< int, double > > &score_matrice )
{

	set< Read_id > Read_id_in_alnb;
	map< pair< Read_id, Seg_sub_id >, int > Seg_index_in_alnb;

	for( int i = 0; i < (int)alnb.size(); ++i ) {
		Seg_Mul_Aln_Node::iterator Iter_node;
		for( Iter_node = alnb[i].begin(); Iter_node != alnb[i].end(); ++Iter_node ) {
			Read_id_in_alnb.insert( Iter_node->first );
			Seg_index_in_alnb.insert( make_pair( make_pair( Iter_node->first, Iter_node->second ), i ) );
		}
	}

	map< int, map< int, vector< double > > > score_ve_map;

	for( int i = 0; i < (int)alna.size(); ++i ) {
		Seg_Mul_Aln_Node::iterator Iter_node;
		for( Iter_node = alna[i].begin(); Iter_node != alna[i].end(); ++Iter_node ) {
			Read_id rdx = Iter_node->first;
			map< Read_id, Read_Pair_Seg_Aln_id >::iterator itemm;
			int tag = 0;
			for ( itemm = Pair_Aln_Map[rdx].begin(); itemm != Pair_Aln_Map[rdx].end(); ++itemm ) {
				Read_id rdy = itemm->first;

				if ( Read_id_in_alnb.find( rdy ) == Read_id_in_alnb.end() )
					continue;

				//because the rda of the obj Read_Pair_Seg_Aln may be either rdx or rdy, both of the cases
				//need to be considered. 
				if ( Read_Pair_Seg_Aln_Ve[itemm->second].rda == rdx ) {
					Seg_sub_id sub_id_a = Iter_node->second;
					if ( Read_Pair_Seg_Aln_Ve[itemm->second].match_score_map.find( sub_id_a ) == Read_Pair_Seg_Aln_Ve[itemm->second].match_score_map.end() )
						continue;

					

					map< Seg_sub_id, double >::iterator Iter_seg_sc;
					for ( Iter_seg_sc = Read_Pair_Seg_Aln_Ve[itemm->second].match_score_map[sub_id_a].begin(); Iter_seg_sc != Read_Pair_Seg_Aln_Ve[itemm->second].match_score_map[sub_id_a].end(); ++Iter_seg_sc ) {
						Seg_sub_id sub_id_b = Iter_seg_sc->first;
						if( Seg_index_in_alnb.find( make_pair( rdy, sub_id_b ) ) != Seg_index_in_alnb.end() ) {
							
							int j = Seg_index_in_alnb[make_pair( rdy, sub_id_b )];
							
						
							score_ve_map[i][j].push_back( Iter_seg_sc->second );
						}
					}
				} else if ( Read_Pair_Seg_Aln_Ve[itemm->second].rda == rdy ) {

					Seg_sub_id sub_id_b = Iter_node->second;
					if ( Read_Pair_Seg_Aln_Ve[itemm->second].match_score_map_II.find( sub_id_b ) == Read_Pair_Seg_Aln_Ve[itemm->second].match_score_map_II.end() )
						continue;
					

					map< Seg_sub_id, double >::iterator Iter_seg_sc;
					for ( Iter_seg_sc = Read_Pair_Seg_Aln_Ve[itemm->second].match_score_map_II[sub_id_b].begin(); Iter_seg_sc != Read_Pair_Seg_Aln_Ve[itemm->second].match_score_map_II[sub_id_b].end(); ++Iter_seg_sc ) {
						Seg_sub_id sub_id_a = Iter_seg_sc->first;
						if( Seg_index_in_alnb.find( make_pair( rdy, sub_id_a ) ) != Seg_index_in_alnb.end() ) {
							
							int j = Seg_index_in_alnb[make_pair( rdy, sub_id_a )];
							
						
							score_ve_map[i][j].push_back( Iter_seg_sc->second );
						}
					}
				}

			}
		}
	}

	map< int, map< int, vector< double > > >::iterator Ite_sc_ve;
	for ( Ite_sc_ve = score_ve_map.begin(); Ite_sc_ve != score_ve_map.end(); ++Ite_sc_ve ) {
		map< int, vector< double > >::iterator sub_ite;
		for ( sub_ite = Ite_sc_ve->second.begin(); sub_ite != Ite_sc_ve->second.end(); ++sub_ite ) {
			double av = 0;
			for ( size_t k = 0; k < sub_ite->second.size(); ++k ) {
				av += sub_ite->second[k];
			}
			av = av / (double)sub_ite->second.size();
			score_matrice[Ite_sc_ve->first][sub_ite->first] = av;
		
		}
	}


}

//the penalty score of the indel, which are generated from each seg_mul_almnt. the penalty depends on its length: 
void Cons_Multaln::indel_penal_f( Seg_Mul_Alnmt & alna,
								 Seg_Mul_Alnmt & alnb,
								 vector< double > &ind_pel_a,
								 vector< double > & ind_pel_b,
								 Cons_Bank & bank )
{
	int size_a = (int)alna.size();
	int size_b = (int)alnb.size();
	
	for ( int i = 0; i < size_a; ++i ) {

		int len = bank.Seg_Map[ make_pair( alna[i].begin()->first, alna[i].begin()->second ) ].len;
		ind_pel_a.push_back ( pel_st + ( len - 1 ) * pel_ex );
	}

	for ( int j = 0; j < size_b; ++j ) {
		int len = bank.Seg_Map[ make_pair( alnb[j].begin()->first, alnb[j].begin()->second ) ].len;
		ind_pel_b.push_back ( pel_st + ( len - 1 ) * pel_ex );
	}

}

// dynamic program method calculate the alignment of the two Seg_Mul_ALnmt.
void Cons_Multaln::alndp( Seg_Mul_Alnmt & alna, Seg_Mul_Alnmt & alnb, Seg_Mul_Alnmt & alnc, Cons_Bank & bank )
{

	map< int, map< int, double > > score_matrice;
	scoring_f( alna, alnb, score_matrice );
	vector< double > ind_pel_a;
	vector< double > ind_pel_b;
	indel_penal_f( alna, alnb, ind_pel_a, ind_pel_b, bank );

	int a_size = (int)alna.size();
	int b_size = (int)alnb.size();

	vector<vector<double> > num_v;
	vector<vector<int> > tag_v; 
	vector<double> num;
	vector<int> tag;

	multimap< double, pair<int,int>, greater<double> > endvalue_i_j;
	
	for( int i = 0; i <= a_size; ++i ) {
		
	
		num.push_back(0);
		tag.push_back(0);
		

		if(i==0){
			for( int j = 1; j <= b_size; ++j ) {
				num.push_back(0);
				tag.push_back(0);
			}

		} else {
			multimap< double, int, greater<double> > maxloc;
			multimap< double, int, greater<double> > ::iterator iter;

			for( int j = 1; j <= b_size; ++j){
				

				if( score_matrice.find( i-1 ) != score_matrice.end() ){
					if( score_matrice[ i-1 ].find( j-1 ) != score_matrice[i-1].end() )
						maxloc.insert( make_pair( num_v[i-1][j-1] + score_matrice[i-1][j-1], 0 ) );
				}

				maxloc.insert( make_pair( num[j-1] + ind_pel_b[j-1] , -1 ) );
				maxloc.insert( make_pair( num_v[i-1][j] + ind_pel_a[i-1], 1 ) );

				num.push_back(maxloc.begin()->first);
				tag.push_back(maxloc.begin()->second);

				if( ( i == a_size || j == b_size ) ){
					endvalue_i_j.insert( make_pair( maxloc.begin()->first, make_pair(i,j) ) );
				

				}

				maxloc.clear();				
			}
		}

		num_v.push_back(num);
		tag_v.push_back(tag);
		num.clear();
		tag.clear();
	}



	int dex_i = endvalue_i_j.begin()->second.first;
	int dex_j = endvalue_i_j.begin()->second.second;

	if ( dex_j == b_size ) {
		for ( int ii = dex_i; ii < a_size; ++ii ) {
			alnc.push_back ( alna[ii] );
		}
	} else if ( dex_i == a_size ) { 
		for ( int jj = dex_j; jj < b_size; ++jj ) {
			alnc.push_back ( alnb[jj] );
		}

	}

	while( dex_i != 0 && dex_j != 0 ) {
			
		Seg_Mul_Aln_Node new_node;

		if( tag_v[dex_i][dex_j] == 0 ) {

		
			new_node.insert( alna[dex_i-1].begin(), alna[dex_i-1].end() );
			new_node.insert( alnb[dex_j-1].begin(), alnb[dex_j-1].end() );
			dex_i--;
			dex_j--;
			
		} else if ( tag_v[dex_i][dex_j] == -1 ) {

			new_node = alnb[dex_j-1];
			dex_j--;
		} else if ( tag_v[dex_i][dex_j] == 1 ) {
			new_node = alna[dex_i-1];
			dex_i--;
		} 

		alnc.insert( alnc.begin(), new_node );
		
	}

	if( dex_i == 0 ) {
		while ( dex_j > 0 ) {
			alnc.insert( alnc.begin(), alnb[dex_j-1] );
			dex_j--;
		}
	} else {    // dex_j == 0
		while ( dex_i > 0 ) {
			alnc.insert( alnc.begin(), alna[dex_i-1] );
			dex_i--;
		}
	}

}

void Cons_Multaln::alnproc(std::map<Read_id,Segmented_Read> &Read_Map, Seg_Aln_Graph &graph, Cons_Bank &bank)
{
	
	initiate( Read_Map, graph );

	while ( tree.opt_node_pair_get() ) {
	
		update_guide_tree ( bank );
	
	}
}

void Cons_Multaln::display_tree( )
{
	cout << "display tree : score_map: "<<endl;
	map< int, map< int, double > >::iterator Ite;
	for ( Ite = tree.aln_score_map.begin(); Ite != tree.aln_score_map.end(); ++Ite ) {
		cout <<Ite->first <<": ";
		map< int, double >::iterator subite;
		for ( subite = Ite->second.begin(); subite != Ite->second.end(); ++subite ) {
			cout << subite->first<<" "<<subite->second<<", ";
		}
		cout <<endl;
	}
}

void Cons_Multaln::display_pair_aln( map< Read_id, map< Read_id, Read_Pair_Seg_Aln_id > > & pair_aln )
{
	cout<<"display Pair_Aln_Map "<<endl;
	map< Read_id, map< Read_id, Read_Pair_Seg_Aln_id > >::iterator Ite;
	for ( Ite = pair_aln.begin(); Ite != pair_aln.end(); ++Ite ) {
		cout <<Ite->first<<": ";
		map<  Read_id, Read_Pair_Seg_Aln_id >::iterator subite;
		for ( subite = Ite->second.begin(); subite != Ite->second.end(); ++subite ) {
			cout <<subite->first<<" "<<subite->second<<", ";
		}
		cout <<endl; 
	}

	for ( int i = 0; i < (int)Read_Pair_Seg_Aln_Ve.size(); ++i ) {
		cout <<"@@pair_aln_id "<< i<< ": ";
		cout <<"rda = "<<Read_Pair_Seg_Aln_Ve[i].rda<<", rdb = "<<Read_Pair_Seg_Aln_Ve[i].rdb<<endl;;
		map< Seg_sub_id, map< Seg_sub_id, double > >::iterator Ite_sc;
		cout <<"@@match_score_map: "<<endl;
		for ( Ite_sc = Read_Pair_Seg_Aln_Ve[i].match_score_map.begin(); Ite_sc != Read_Pair_Seg_Aln_Ve[i].match_score_map.end(); ++Ite_sc ) {
			cout <<"@@"<<Ite_sc->first<<" : ";
			map< Seg_sub_id, double >::iterator sub_ite;
			for ( sub_ite = Ite_sc->second.begin(); sub_ite != Ite_sc->second.end(); ++sub_ite ) {
				cout << sub_ite->first<<" "<<sub_ite->second<<", ";
			}
			cout <<endl;
		}
		cout <<"@@match_score_map_II: "<<endl;;
		for ( Ite_sc = Read_Pair_Seg_Aln_Ve[i].match_score_map_II.begin(); Ite_sc != Read_Pair_Seg_Aln_Ve[i].match_score_map_II.end(); ++Ite_sc ) {
			cout <<"@@"<<Ite_sc->first<<" : ";
			map< Seg_sub_id, double >::iterator sub_ite;
			for ( sub_ite = Ite_sc->second.begin(); sub_ite != Ite_sc->second.end(); ++sub_ite ) {
				cout << sub_ite->first<<" "<<sub_ite->second<<", ";
			}
			cout <<endl;
		}
	}

}

void Cons_Multaln::display_pair_aln( map< Read_id, map< Read_id, Read_Pair_Seg_Aln_id > > & pair_aln, char* filename )
{
	ofstream ff( filename );

	ff<<"display Pair_Aln_Map "<<endl;
	map< Read_id, map< Read_id, Read_Pair_Seg_Aln_id > >::iterator Ite;
	for ( Ite = pair_aln.begin(); Ite != pair_aln.end(); ++Ite ) {
		ff <<Ite->first<<": ";
		map<  Read_id, Read_Pair_Seg_Aln_id >::iterator subite;
		for ( subite = Ite->second.begin(); subite != Ite->second.end(); ++subite ) {
			ff <<subite->first<<" "<<subite->second<<", ";
		}
		ff <<endl; 
	}

	for ( int i = 0; i < (int)Read_Pair_Seg_Aln_Ve.size(); ++i ) {
		ff <<"@@pair_aln_id "<< i<< ": ";
		ff <<"rda = "<<Read_Pair_Seg_Aln_Ve[i].rda<<", rdb = "<<Read_Pair_Seg_Aln_Ve[i].rdb<<endl;;
		map< Seg_sub_id, map< Seg_sub_id, double > >::iterator Ite_sc;
		ff <<"@@match_score_map: "<<endl;
		for ( Ite_sc = Read_Pair_Seg_Aln_Ve[i].match_score_map.begin(); Ite_sc != Read_Pair_Seg_Aln_Ve[i].match_score_map.end(); ++Ite_sc ) {
			ff <<"@@"<<Ite_sc->first<<" : ";
			map< Seg_sub_id, double >::iterator sub_ite;
			for ( sub_ite = Ite_sc->second.begin(); sub_ite != Ite_sc->second.end(); ++sub_ite ) {
				ff << sub_ite->first<<" "<<sub_ite->second<<", ";
			}
			ff <<endl;
		}
		ff <<"@@match_score_map_II: "<<endl;;
		for ( Ite_sc = Read_Pair_Seg_Aln_Ve[i].match_score_map_II.begin(); Ite_sc != Read_Pair_Seg_Aln_Ve[i].match_score_map_II.end(); ++Ite_sc ) {
			ff <<"@@"<<Ite_sc->first<<" : ";
			map< Seg_sub_id, double >::iterator sub_ite;
			for ( sub_ite = Ite_sc->second.begin(); sub_ite != Ite_sc->second.end(); ++sub_ite ) {
				ff << sub_ite->first<<" "<<sub_ite->second<<", ";
			}
			ff <<endl;
		}
	}

}

void Cons_Multaln::display_seg_mul_alnmt(Seg_Mul_Alnmt & alnmt)
{
	cout<< "display Seg_Mul_Alnmt: "<<endl;
	size_t size = alnmt.size();
	for( size_t i = 0; i < size; ++i ) {
		map< Read_id, Seg_sub_id >::iterator Ite;
		for ( Ite = alnmt[i].begin(); Ite != alnmt[i].end(); ++Ite ) {
			cout<<Ite->first<<" "<<Ite->second<<", ";
		}
		cout<<endl;
	}
}
