#ifndef CONS_NOD_ALN_H
#define CONS_NOD_ALN_H

#include "Cons_Seg_Graph.h"
#include "fstream"

const double pel_st = -9;
const double pel_ex = -5;

class Read_Pair_Seg_Aln
{
public:
	Read_id rda;
	Read_id rdb;   // here rda < rdb
	double score;  // the score evaluate the whole alignment of rda and rdb.

//	vector< pair< Read_id, Seg_sub_id > > rda_seg_ve;
//	vector< pair< Read_id, Seg_sub_id > > rdb_seg_ve;

	
	map< Seg_sub_id, map< Seg_sub_id, double > > match_score_map; 
	
	map< Seg_sub_id, map< Seg_sub_id, double > > match_score_map_II; 
	void score_compute();

	
};

class Cons_Gud_Tree
{
public:

	// map< index_x, map< index_y , aln_score > >
	// At the beginning, the index indecate the node_vector's, each node is one read.
	// As alignment progressing, the biggest index adds 1 indecating the newly produced
	// alignment. And the aln_score_map updates meanwhile. The aln_score_map stores 
	// the distance matrix, from which next optional node pair can be calculated, guiding
	// the next round of alignment.
	map< int, map< int, double > > aln_score_map;
	pair< int, int > opt_node_pair;

	bool opt_node_pair_get();
	
};

typedef int Read_Pair_Seg_Aln_id;

class Cons_Multaln
{
public:
	map< Read_id, map< Read_id, Read_Pair_Seg_Aln_id > > Pair_Aln_Map;
	vector< Read_Pair_Seg_Aln > Read_Pair_Seg_Aln_Ve;
	Cons_Gud_Tree tree;
	map< int, Seg_Mul_Alnmt > Seg_mamap;


	void initiate( map< Read_id, Segmented_Read > &Read_Map, Seg_Aln_Graph & graph );
	void update_guide_tree( Cons_Bank & bank );
	void alndp( Seg_Mul_Alnmt & alna, Seg_Mul_Alnmt & alnb, Seg_Mul_Alnmt & alnc, Cons_Bank & bank );
	void scoring_f( Seg_Mul_Alnmt & alna, Seg_Mul_Alnmt & alnb, map< int, map< int, double > > &score_matrice );
	void indel_penal_f( Seg_Mul_Alnmt & alna, Seg_Mul_Alnmt & alnb, vector< double > &ind_pel_a, vector< double > & ind_pel_b, Cons_Bank & bank );
	void alnproc( map< Read_id, Segmented_Read > &Read_Map, Seg_Aln_Graph & graph, Cons_Bank & bank );

	void display_tree( );

	void display_pair_aln( map< Read_id, map< Read_id, Read_Pair_Seg_Aln_id > > & pair_aln );

	void display_pair_aln( map< Read_id, map< Read_id, Read_Pair_Seg_Aln_id > > & pair_aln, char* filename );
	
	void display_seg_mul_alnmt(Seg_Mul_Alnmt & alnmt);

	
};



#endif

