#include "Cons_Seg_Graph.h"


void Seg_Aln_Graph::seg_match_extend( Cons_Bank &bank )
{

	extended_Seg_Match_Map = Seg_Match_Map;

	set< pair<Read_id, Seg_sub_id> >::iterator Ite_Seg_Set;
	for ( Ite_Seg_Set = Seg_Set.begin(); Ite_Seg_Set != Seg_Set.end(); ++Ite_Seg_Set ) { 

		Read_id read_id_a = Ite_Seg_Set->first;
	

		if( Match_pair_Map.find( *Ite_Seg_Set ) == Match_pair_Map.end() )
			continue;

		vector< pair< Read_id,Seg_sub_id > > sub_seg_ve;
		map< pair< Read_id, Seg_sub_id >, Seg_Match_id >::iterator subiter;
		for( subiter = Match_pair_Map[*Ite_Seg_Set ].begin(); subiter != Match_pair_Map[*Ite_Seg_Set ].end(); ++subiter ){
			
			sub_seg_ve.push_back( subiter->first );
		}

		int sub_seg_ve_size = (int)sub_seg_ve.size();
		for( int j = 0; j < sub_seg_ve_size; ++j ){
			for( int k = j+1; k < sub_seg_ve_size; ++k ){
				if( sub_seg_ve[j].first == sub_seg_ve[k].first )
					continue;
			
				if( seg_match_find( sub_seg_ve[j], sub_seg_ve[k] ) ){
				
					seg_match_extend_addweight( Match_pair_Map[*Ite_Seg_Set ][sub_seg_ve[j]], Match_pair_Map[*Ite_Seg_Set ][sub_seg_ve[k]], Match_pair_Map[sub_seg_ve[j]][sub_seg_ve[k]]);
				}else{
				
					Seg_Match_id nid = seg_match_extend_add( sub_seg_ve[j], sub_seg_ve[k], Match_pair_Map[*Ite_Seg_Set ][sub_seg_ve[j]], Match_pair_Map[*Ite_Seg_Set ][sub_seg_ve[k]], bank );

					set< pair<Read_id,Seg_sub_id> > marked_seg;
					if( sub_seg_ve[j].first < sub_seg_ve[k].first ){
						seg_match_extend_ite( sub_seg_ve[j], sub_seg_ve[k], nid, read_id_a, marked_seg, bank );
					}else
						seg_match_extend_ite( sub_seg_ve[k], sub_seg_ve[j], nid, read_id_a, marked_seg, bank );
				}
			}
		}
	}
}

int Seg_Aln_Graph::seg_match_extend_ite(std::pair<Read_id,Seg_sub_id> Sega, 
										std::pair<Read_id,Seg_sub_id> Segb, 
										Seg_Match_id nid, 
										Read_id upbounded_id, 
										set< pair<Read_id,Seg_sub_id> > marked_seg,
										Cons_Bank &bank )
{

	if( Sega.first >= upbounded_id )
		return 1;

	marked_seg.insert(Sega);
	
	vector< pair< Read_id, Seg_sub_id > > this_seg_ve;
	map< pair< Read_id, Seg_sub_id >, Seg_Match_id >::iterator ite;
	for( ite = Match_pair_Map[Sega].begin(); ite != Match_pair_Map[Sega].end(); ++ite ){
		if( ite->first.first == Segb.first )
			continue;
		if( marked_seg.find(ite->first) != marked_seg.end() )
			continue;

		this_seg_ve.push_back(ite->first);
	}

	int vsize = (int)this_seg_ve.size();
	for(int i = 0; i < vsize; ++i){
		if( ! seg_match_find( this_seg_ve[i], Segb ) ){
			Seg_Match_id cr_id = seg_match_extend_add( Segb, this_seg_ve[i], nid, Match_pair_Map[Sega][this_seg_ve[i]], bank );
			
			// iterating
			seg_match_extend_ite( this_seg_ve[i], Segb, cr_id, upbounded_id, marked_seg, bank );
		}
	}

	return 1;

}

Seg_Match_id Seg_Aln_Graph::seg_match_extend_add(std::pair<Read_id,Seg_sub_id> Sega, 
												 std::pair<Read_id,Seg_sub_id> Segb, 
												 Seg_Match_id sid1, 
												 Seg_Match_id sid2,
												 Cons_Bank &bank )
{

	Seg_Match segmatch3;

	double sc1, sc2;
	if( Seg_Match_Map.find(sid1) != Seg_Match_Map.end() ) {
		sc1 = Seg_Match_Map[sid1].score;
		segmatch3.len = Seg_Match_Map[sid1].len;
	} else
		sc1 = 0;

	if( Seg_Match_Map.find(sid2) != Seg_Match_Map.end() ) {
		sc2 = Seg_Match_Map[sid2].score;
		segmatch3.len = Seg_Match_Map[sid2].len;
	} else
		sc2 = 0;
	
	segmatch3.score = min( sc1, sc2 );
	if ( segmatch3.score == 0 )
		segmatch3.len = bank.Seg_Map[Sega].len;
	segmatch3.Sega = Sega;
	segmatch3.Segb = Segb;


	Seg_Match_id nid = (int)extended_Seg_Match_Map.size() + 1;
	extended_Seg_Match_Map.insert(make_pair(nid, segmatch3));

	Match_pair_Map[Sega][Segb] = nid;
	Match_pair_Map[Segb][Sega] = nid;

	return nid;

}

int Seg_Aln_Graph::seg_match_extend_addweight( Seg_Match_id sid1, Seg_Match_id sid2, Seg_Match_id sid3 )
{
	double sc1, sc2;

	if( Seg_Match_Map.find(sid1) != Seg_Match_Map.end() )
		sc1 = Seg_Match_Map[sid1].score;
	else
		sc1 = 0;

	if( Seg_Match_Map.find(sid2) != Seg_Match_Map.end() )
		sc2 = Seg_Match_Map[sid2].score;
	else
		sc2 = 0;

	extended_Seg_Match_Map[sid3].score += min( sc1, sc2 );

	return 1;
}

bool Seg_Aln_Graph::seg_match_find(std::pair<Read_id,Seg_sub_id> Sega, std::pair<Read_id,Seg_sub_id> Segb)
{
	if( Match_pair_Map.find(Sega) != Match_pair_Map.end() ){
		if( Match_pair_Map[Sega].find(Segb) != Match_pair_Map[Sega].end() ){
			return true;
		}
	}

	return false;
}

