#ifndef GRAPH_BANK_H
#define GRAPH_BANK_H

#include <map>
#include "link.h"
#include "poperate.h"
#include <vector>
#include <set>
#include <list>
#include <iostream>
#include <fstream>

using namespace std;

typedef int Tig_id;
typedef int Forb;
typedef int Mate_gap_id;

class Tig
{
public:
	int len;
};

class Mate_Gap
{
public:
	Tig_id ida;           // paired id of tig a and b                for conventions, idb > ida
	Tig_id idb;
//	pair<int, int> drct;  // direction of tig a and b:  ( 0,0 ) == ( -->, --> ); ( 0,1 ) == ( -->, <-- ); ( 1,0 ) == ( <--, --> ); ( 1,1 ) == ( <--, <-- )
	int drct_type;        //                                  type 1                    type 2                  type 3                     type 4
	int lowb;             // lower bound of the gap length
	int upb;              // upper bound of the gap length
	int mean;             // mean value of the gap length
	double conf;          // confidance score
	vector< int > len_ve; // this contains all the componant mate pairs' length contributed scaffold gap. In the beginning, it has one element.
};

class Tig_Edge_Link
{
public:
	set<pair<Tig_id, Forb> > head_links;
	set<pair<Tig_id, Forb> > tail_links;
	map<pair<Tig_id, Forb>, int > Head_Id_Ov_Ma;
	map<pair<Tig_id, Forb>, int > Tail_Id_Ov_Ma;
//	map<pair<Tig_id, Forb>, pair<int, int> > inner_links;       // first->id, second->de, de == 0 same, 1 trans
//	map<pair<Tig_id, Forb>, pair<int, int> > outer_links;
};

class Graph_bank
{
public:
	map< Tig_id, map< Tig_id, vector< Mate_gap_id > > > Pair_mates;
	map< Mate_gap_id, Mate_Gap > Mate_gap_map;
	set< Tig_id > tigset;
	map< Tig_id, Tig_Edge_Link > edge_map;
	map< Tig_id, Tig > tigmap;

	int tig_len;

};


#endif

