#include "Graph_Scf_rpl.h"

void suptig_scf_replace( Supertig_id n_id, Supertig & n_tig, Supertig_bank &tig_bank )
{

	map< Supertig_id, vector< Scaffold_Gap > > sca_map;
	size_t se_size = n_tig.Tig_Ve.size();
	for ( size_t i = 0; i < se_size; ++i ) {
		size_t para_size = n_tig.Tig_Ve[i].size(); 
		for ( size_t j = 0; j < para_size; ++j ) {
			scf_create( n_tig.Tig_Ve[i][j], n_tig.Tig_F_Ve[i][j], n_tig.Tig_P_Ve[i][j], n_tig, n_tig.length, sca_map, tig_bank );
		}
	}

	map< Supertig_id, vector< Scaffold_Gap > >::iterator Ite;
	for ( Ite = sca_map.begin(); Ite != sca_map.end(); ++Ite ) {
		vector< Scaffold_Gap > c_scf_ve;
		vector< Scaffold_Gap > p_scf_ve = Ite->second;
		if ( (int)p_scf_ve.size() > 1 ) {
			int p_ve_size = 0;
			int c_ve_size = 0;
			do {
				p_ve_size = (int)p_scf_ve.size();
				scf_merge( p_scf_ve, c_scf_ve );
				c_ve_size = (int)c_scf_ve.size();

				p_scf_ve = c_scf_ve;
				c_scf_ve.clear();

			} while ( p_ve_size != c_ve_size && c_ve_size > 1 );
		}

		add_scf( Ite->first, n_id, p_scf_ve, tig_bank );
	}
}

void suptig_scf_replace_for_Structed( Supertig_id n_id, Supertig & n_tig, Supertig_bank &tig_bank )
{

	map< Supertig_id, vector< Scaffold_Gap > > sca_map;
	size_t se_size = n_tig.Tig_Ve.size();
	for ( size_t i = 0; i < se_size; ++i ) {
		if ( n_tig.Tig_Ve[i][0] != -1 ) {
			scf_create( n_tig.Tig_Ve[i][0], n_tig.Tig_F_Ve[i][0], n_tig.Tig_P_Ve[i][0], n_tig, n_tig.length, sca_map, tig_bank );
		} else {
			map< pair< Supertig_id, Forb >, Bridge >::iterator Ite;
			for ( Ite = n_tig.bulbmap[i].begin(); Ite != n_tig.bulbmap[i].end(); ++Ite ) {
				scf_create( Ite->first.first, Ite->first.second, n_tig.Tig_P_Ve[i][0], n_tig, n_tig.length, sca_map, tig_bank );
			}
		}
		
	}

	map< Supertig_id, vector< Scaffold_Gap > >::iterator Ite;
	for ( Ite = sca_map.begin(); Ite != sca_map.end(); ++Ite ) {
		vector< Scaffold_Gap > c_scf_ve;
		vector< Scaffold_Gap > p_scf_ve = Ite->second;
		if ( (int)p_scf_ve.size() > 1 ) {
			int p_ve_size = 0;
			int c_ve_size = 0;
			do {
				p_ve_size = (int)p_scf_ve.size();
				scf_merge( p_scf_ve, c_scf_ve );
				c_ve_size = (int)c_scf_ve.size();

				p_scf_ve = c_scf_ve;
				c_scf_ve.clear();

			} while ( p_ve_size != c_ve_size && c_ve_size > 1 );
		}

		add_scf( Ite->first, n_id, p_scf_ve, tig_bank );
	}
}

void scf_create( Supertig_id tig_id, 
				Forb f, 
				pair<int, int> pos, 
				Supertig & n_tig, 
				int suptig_len, 
				map< Supertig_id, vector< Scaffold_Gap > > &sca_map,
				Supertig_bank &tig_bank )
{
	if ( tig_bank.Pair_Scaffold_map.find( tig_id ) == tig_bank.Pair_Scaffold_map.end() )
		return;

	map< Supertig_id, vector< Scaffold_gap_id > >::iterator Ite;
	for ( Ite = tig_bank.Pair_Scaffold_map[tig_id].begin(); Ite != tig_bank.Pair_Scaffold_map[tig_id].end(); ++Ite ) {
		size_t vesize = Ite->second.size();
		for ( size_t i = 0; i < vesize; ++i ) {
			Scaffold_gap_id gap_id = Ite->second[i];
			if ( tig_bank.Scaffold_map.find( gap_id ) == tig_bank.Scaffold_map.end() ) {
				cerr << "Warning in func scf_creadte: scaffold not found!"<<endl;
				continue;
			}
			
			Scaffold_Gap c_scf;
			if ( scf_create_t( tig_id, f, pos, n_tig, suptig_len, tig_bank.Scaffold_map[gap_id], c_scf, tig_bank ) ) {
				sca_map[Ite->first].push_back( c_scf );
				
			}
		}
	}

}

bool scf_create_t( Supertig_id tig_id, 
				  Forb f, 
				  pair<int, int> pos, 
				  Supertig & n_tig, 
				  int suptig_len, 
				  Scaffold_Gap &p_scf, 
				  Scaffold_Gap &c_scf,
				  Supertig_bank &tig_bank )
{

	int minus_dis = 0;

	if ( tig_id == p_scf.ida ) {
	
		if ( n_tig.tigfind( p_scf.idb ) )
			return false;
		
		if ( tig_bank.Supertig_Overlap_Link_Map.find( p_scf.idb ) == tig_bank.Supertig_Overlap_Link_Map.end() && tig_bank.inner_active_tig.find( p_scf.idb ) == tig_bank.inner_active_tig.end() ) {
			
			return false;
		}

		int i_d_t = drc_type_rev(  p_scf.drct_type );
		if ( f == 0 ) {
			c_scf.drct_type = i_d_t;		
			
		} else { 
			c_scf.drct_type = drc_type_righttig_rev( i_d_t );		

		}
	
	

	} else {  // tig_id == p.scf.idb
	
		if ( n_tig.tigfind( p_scf.ida ) )
			return false;
		
		if ( tig_bank.Supertig_Overlap_Link_Map.find( p_scf.ida ) == tig_bank.Supertig_Overlap_Link_Map.end() && tig_bank.inner_active_tig.find( p_scf.ida ) == tig_bank.inner_active_tig.end() ) {
		
			return false;
		}

		int i_d_t = drc_type_rev(  p_scf.drct_type );
		if ( f == 0 ) {
			c_scf.drct_type = p_scf.drct_type;	

		} else {
			c_scf.drct_type = drc_type_righttig_rev( p_scf.drct_type );

		}	
		
	
	}

	if ( c_scf.drct_type == 2 || c_scf.drct_type == 4 ) {			
		minus_dis = suptig_len - pos.second;			
	} else {
		minus_dis = pos.first - 1;
	}

	c_scf.lowb = p_scf.lowb - minus_dis;
	c_scf.upb = p_scf.upb - minus_dis;
	if ( c_scf.upb <= -1000 )    // upper bounded gap less than 0, fail
		return false;
	c_scf.mean = p_scf.mean - minus_dis;
	ve_int_minus( p_scf.len_ve, c_scf.len_ve, minus_dis );

	c_scf.calculate_conf();
	

	return true;

}

void scf_merge( vector< Scaffold_Gap > & p_scf_ve, vector< Scaffold_Gap > & c_scf_ve )
{
	size_t pve_size = p_scf_ve.size();
	for ( size_t i = 0; i < pve_size; ++i ) {
		scf_merge_t( p_scf_ve[i], c_scf_ve );
	}
}

void scf_merge_t( Scaffold_Gap & p_scf, vector< Scaffold_Gap > & c_scf_ve )
{
	if ( c_scf_ve.empty() ) {
		c_scf_ve.push_back( p_scf );
		return;
	} else {
		int state = 0;
		for ( size_t i = 0; i < c_scf_ve.size(); ++i ) {
			if ( two_scf_merge( p_scf, c_scf_ve[i] ) ) {
				state = 1;
				break;
			}
		}
		if ( state == 0 ) {    // failed merging, create new scaffold
			c_scf_ve.push_back( p_scf );
		}
	}
}

bool two_scf_merge( Scaffold_Gap & p_scf, Scaffold_Gap & c_scf )
{
	if ( p_scf.drct_type != c_scf.drct_type )
		return false;

	if ( min( p_scf.upb, c_scf.upb ) < max( p_scf.lowb, c_scf.lowb ) )
		return false;

	c_scf.upb = max ( p_scf.upb, c_scf.upb );
	c_scf.lowb = min ( p_scf.lowb, c_scf.lowb );

	c_scf.len_ve.insert( c_scf.len_ve.end(), p_scf.len_ve.begin(), p_scf.len_ve.end() );

	c_scf.mean = (int)ve_int_getmean( c_scf.len_ve );
    
    // reduce redundant
    set<int > len_set;
    for ( size_t i = 0; i < c_scf.len_ve.size(); ++i ) {
        len_set.insert( c_scf.len_ve[i] );
    }
    c_scf.len_ve.clear();
    for ( set<int>::iterator ite = len_set.begin(); ite != len_set.end(); ++ite )
    {
        c_scf.len_ve.push_back( *ite );
    }

	c_scf.calculate_conf();
	return true;
}

void add_scf( Supertig_id ida, Supertig_id idb, vector< Scaffold_Gap > &scf_ve, Supertig_bank &tig_bank )
{
	for ( size_t i = 0; i < scf_ve.size(); ++i ) {
		Scaffold_gap_id n_id;
		if ( tig_bank.Scaffold_map.empty() )
			n_id = 1;
		else
			n_id = tig_bank.Scaffold_map.rbegin()->first + 1;
		if ( tig_bank.Scaffold_map.find( n_id ) != tig_bank.Scaffold_map.end() ) {
			cerr << "error in add_scf: can't create new scaffold gap because of the id error " <<endl;
			continue;
		}
		scf_ve[i].ida = ida;
		scf_ve[i].idb = idb;
		tig_bank.Scaffold_map.insert( make_pair( n_id, scf_ve[i] ) );
		tig_bank.Pair_Scaffold_map[ida][idb].push_back( n_id );
		tig_bank.Pair_Scaffold_map[idb][ida].push_back( n_id );
	}
}

void ve_int_minus( vector< int > &ve_a, vector< int > &ve_b, int minus_int )
{
	ve_b.clear();
	for ( size_t i = 0; i < ve_a.size(); ++i ) {
		ve_b.push_back( ve_a[i] - minus_int );
	}
}

double ve_int_getmean( vector< int > &ve )
{
	double va = 0;
	for ( size_t i = 0; i < ve.size(); ++i ) {
		va = double( va * i + ve[i] ) / ( i + 1 );
	}
	return va;
}

int drc_type_rev( int type )
{
	switch( type ) {
		case 1:
			return 4;
		case 2:
			return 2;
		case 3:
			return 3;
		case 4:
			return 1;
		default:
			cerr << "error: unexpected drc_type"<<endl;
			exit(1);
	}
}

int drc_type_lefttig_rev( int type )
{
	switch( type ) {
		case 1:
			return 3;
		case 2:
			return 4;
		case 3:
			return 1;
		case 4:
			return 2;
		default:
			cerr << "error: unexpected drc_type"<<endl;
			exit(1);
	}
}

int drc_type_righttig_rev( int type )
{
	switch( type ) {
		case 1:
			return 2;
		case 2:
			return 1;
		case 3:
			return 4;
		case 4:
			return 3;
		default:
			cerr << "error: unexpected drc_type"<<endl;
			exit(1);
	}
}

void scf_replace_spe( Supertig_id n_id, Supertig_id p_id, Supertig_bank &tig_bank )
{
	if ( tig_bank.Pair_Scaffold_map.find( p_id ) == tig_bank.Pair_Scaffold_map.end() ) {
		return;
	}
	map< Supertig_id, vector< Scaffold_gap_id > >::iterator Ite;
	for ( Ite = tig_bank.Pair_Scaffold_map[p_id].begin(); Ite != tig_bank.Pair_Scaffold_map[p_id].end(); ++Ite ) {
		vector< Scaffold_Gap > scf_ve;
		scf_replace_spe_t( n_id, p_id, Ite->second, scf_ve, tig_bank );
		add_scf( Ite->first, n_id, scf_ve, tig_bank );
	}
}

void scf_replace_spe_t( Supertig_id n_id,
					   Supertig_id p_id, 
					   vector< Scaffold_gap_id > &p_scf_ve, 
					   vector< Scaffold_Gap > &c_scf_ve,
					   Supertig_bank &tig_bank )
{
	for ( size_t i = 0; i < p_scf_ve.size(); ++i ) {
		Scaffold_Gap c_scf;
		scf_create_spe( n_id, p_id, tig_bank.Scaffold_map[p_scf_ve[i]], c_scf );
		c_scf_ve.push_back( c_scf );
		
	}
}

void scf_create_spe( Supertig_id n_id, Supertig_id p_id, Scaffold_Gap &p_scf, Scaffold_Gap &c_scf )
{
	c_scf = p_scf;
	if ( p_scf.ida == p_id ) {
		c_scf.drct_type = drc_type_rev( p_scf.drct_type );
		c_scf.ida = p_scf.idb;
		c_scf.idb = n_id;
	} else {
		c_scf.idb = n_id;
	}
}

bool scf_check( pair< Supertig_id, Forb > lefttig, pair < Supertig_id, Forb > righttig, Supertig_bank &tig_bank )
{
	if ( tig_bank.Pair_Scaffold_map.find( lefttig.first ) == tig_bank.Pair_Scaffold_map.end() ) 
		return false;
	if ( tig_bank.Pair_Scaffold_map[lefttig.first].find( righttig.first ) == tig_bank.Pair_Scaffold_map[lefttig.first].end() )
		return false;
	vector< Scaffold_gap_id > scfve = tig_bank.Pair_Scaffold_map[lefttig.first][righttig.first];
	for ( size_t i = 0; i < scfve.size(); ++i ) {
	
		if ( scf_check_t ( lefttig, righttig, tig_bank.Scaffold_map[scfve[i]] ) )
			return true;
	}
	return false;
}

bool scf_check( pair< Supertig_id, Forb > lefttig, pair < Supertig_id, Forb > righttig, int gap, Supertig_bank &tig_bank )
{
	if ( tig_bank.Pair_Scaffold_map.find( lefttig.first ) == tig_bank.Pair_Scaffold_map.end() ) 
		return false;
	if ( tig_bank.Pair_Scaffold_map[lefttig.first].find( righttig.first ) == tig_bank.Pair_Scaffold_map[lefttig.first].end() )
		return false;
	vector< Scaffold_gap_id > scfve = tig_bank.Pair_Scaffold_map[lefttig.first][righttig.first];
	for ( size_t i = 0; i < scfve.size(); ++i ) {
	
		if ( scf_check_t ( lefttig, righttig, gap, tig_bank.Scaffold_map[scfve[i]] ) )
			return true;
	}
	return false;
}

bool scf_check( pair< Supertig_id, Forb > lefttig, pair < Supertig_id, Forb > righttig, int gap, Supertig_bank &tig_bank, Scaffold_Gap &scf )
{
	if ( tig_bank.Pair_Scaffold_map.find( lefttig.first ) == tig_bank.Pair_Scaffold_map.end() ) 
		return false;
	if ( tig_bank.Pair_Scaffold_map[lefttig.first].find( righttig.first ) == tig_bank.Pair_Scaffold_map[lefttig.first].end() )
		return false;
	vector< Scaffold_gap_id > scfve = tig_bank.Pair_Scaffold_map[lefttig.first][righttig.first];
	for ( size_t i = 0; i < scfve.size(); ++i ) {
	
		if ( scf_check_t ( lefttig, righttig, gap, tig_bank.Scaffold_map[scfve[i]] ) ) {
			scf = tig_bank.Scaffold_map[scfve[i]];
			return true;
		}
	}
	return false;
}

bool scf_check_t( pair< Supertig_id, Forb > lefttig, pair < Supertig_id, Forb > righttig, Scaffold_Gap &scf )
{
	int drt = -1;
	
	if ( lefttig.second == 0 && righttig.second == 0 ) 
		drt = 1;
	else if ( lefttig.second == 0 && righttig.second == 1 )
		drt = 2;
	else if ( lefttig.second == 1 && righttig.second == 0 )
		drt = 3;
	else if ( lefttig.second == 1 && righttig.second == 1 )
		drt = 4;
	
	if ( lefttig.first == scf.idb ) {
		drt = drc_type_rev( drt );
	}

	if ( scf.drct_type == drt )
		return true;
	else 
		return false;
}

bool scf_check_t( pair< Supertig_id, Forb > lefttig, pair < Supertig_id, Forb > righttig, int gap, Scaffold_Gap &scf )
{
	int drt = -1;
	
	if ( lefttig.second == 0 && righttig.second == 0 ) 
		drt = 1;
	else if ( lefttig.second == 0 && righttig.second == 1 )
		drt = 2;
	else if ( lefttig.second == 1 && righttig.second == 0 )
		drt = 3;
	else if ( lefttig.second == 1 && righttig.second == 1 )
		drt = 4;
	
	if ( lefttig.first == scf.idb ) {
		drt = drc_type_rev( drt );
	}

	if ( scf.drct_type != drt )
		return false;

	if ( gap < scf.lowb || gap > scf.upb )
		return false;

	return true;
}

bool scf_conflict_check( int leftlen, int rightlen, pair< Supertig_id, Forb > tig, Supertig_bank &tig_bank )
{
	if ( tig_bank.Pair_Scaffold_map.find( tig.first ) == tig_bank.Pair_Scaffold_map.end() )
		return false;
	map< Supertig_id, vector< Scaffold_gap_id > >::iterator Ite;
	for ( Ite = tig_bank.Pair_Scaffold_map[tig.first].begin(); Ite != tig_bank.Pair_Scaffold_map[tig.first].end(); ++Ite ) {
		vector< Scaffold_gap_id > scfve = Ite->second;
		for ( size_t i = 0 ; i < scfve.size(); ++i ) {
			if ( !scf_conflict_check_t( leftlen, rightlen, tig, tig_bank.Scaffold_map[scfve[i]] ) )
				return false;
		}
	}
	return true;
}

bool scf_conflict_check_t( int leftlen, int rightlen, pair< Supertig_id, Forb > tig, Scaffold_Gap &scf )
{

	if ( scf.ida == tig.first ) {
		if ( tig.second == 0 ) {
			if ( scf.drct_type == 1 || scf.drct_type == 2 ) {
				if ( rightlen > scf.upb )
					return true;
				else 
					return false;
			} else {
				if ( leftlen > scf.upb )
					return true;
				else 
					return false;
			}
			
		} else { 
			if ( scf.drct_type == 3 || scf.drct_type == 4 ) {
				if ( rightlen > scf.upb )
					return true;
				else 
					return false;
			} else {
				if ( leftlen > scf.upb )
					return true;
				else 
					return false;
			}

			
		}
	} else {
		if ( tig.second == 0 ) {
			if ( scf.drct_type == 1 || scf.drct_type == 3 ) {
				if ( leftlen > scf.upb )
					return true;
				else
					return false;
			} else {
				if ( rightlen > scf.upb )
					return true;
				else
					return false;
			}
		} else {
			if ( scf.drct_type == 2 || scf.drct_type == 4 ) {
				if ( leftlen > scf.upb )
					return true;
				else
					return false;
			} else {
				if ( rightlen > scf.upb )
					return true;
				else
					return false;
			}
		}
	}
	return false;
}

bool scf_check_u2s( pair< Supertig_id, Forb > ultratig, pair< Supertig_id, Forb > singletig, Supertig_bank &tig_bank )
{
	return scf_check_s2u( reversepht( singletig ), reversepht( ultratig ), tig_bank );
}

bool scf_check_s2u( pair< Supertig_id, Forb > singletig, pair< Supertig_id, Forb > ultratig, Supertig_bank &tig_bank )
{

	if ( !tig_bank.Supertig_Map[ultratig.first].series && !tig_bank.Supertig_Map[ultratig.first].single_tig ) {
		if ( !tig_bank.Supertig_Map[ultratig.first].Structed ) {
			cerr<<"Warning in scf_check_s2u: ultratig is not series type! "<<endl;
			return false;
		}
	}
	
	if ( tig_bank.Pair_Scaffold_map.find( singletig.first ) == tig_bank.Pair_Scaffold_map.end() ) {
		return false;
	}
	int maxgap = tig_bank.mate_len;

	if ( ultratig.second == 0 ) {
		for ( size_t i = 0; i < tig_bank.Supertig_Map[ultratig.first].Tig_Ve.size(); ++i ) {
		
			if ( tig_bank.Supertig_Map[ultratig.first].Tig_P_Ve[i][0].first > maxgap )
				break;
			if ( scf_check( singletig, make_pair( tig_bank.Supertig_Map[ultratig.first].Tig_Ve[i][0], tig_bank.Supertig_Map[ultratig.first].Tig_F_Ve[i][0] ), tig_bank ) ) {
			
				return true;
			}
		}
		return false;
	} else {
		for ( int i = (int)tig_bank.Supertig_Map[ultratig.first].Tig_Ve.size() - 1; i >= 0; --i ) {
			
			if ( tig_bank.Supertig_Map[ultratig.first].length - tig_bank.Supertig_Map[ultratig.first].Tig_P_Ve[i][0].second > maxgap )
				break;
			if ( scf_check( singletig, reversepht( make_pair( tig_bank.Supertig_Map[ultratig.first].Tig_Ve[i][0], tig_bank.Supertig_Map[ultratig.first].Tig_F_Ve[i][0] ) ), tig_bank ) )
				return true;
		}
		return false;
	}

}

