#ifndef GRAPH_SCF_RPL_H
#define GRAPH_SCF_RPL_H

#include "Graph_subgraph.h"

using namespace std;
/////////////////////////////////////////////////////////////////////////////
// The new assembled supertigs inherits the scaffolds from its components.
// First, for each component, calculate the scaffolds with other supertigs.
// Then, the scaffolds with the same other supertig caculated from different 
// components are merged if they are consistent. Inconsistent scaffolds may
// occur meanwhile due to the misassebly of the components, then they are 
// all reserved.
/////////////////////////////////////////////////////////////////////////////
void suptig_scf_replace( Supertig_id n_id, Supertig & n_tig, Supertig_bank &tig_bank );

void suptig_scf_replace( Supertig_id n_id, Supertig & n_tig, Supertig_bank &tig_bank );

void suptig_scf_replace_for_Structed( Supertig_id n_id, Supertig & n_tig, Supertig_bank &tig_bank );

void scf_create( Supertig_id tig_id, 
				Forb f, 
				pair<int, int> pos, 
				Supertig & n_tig, 
				int suptig_len, 
				map< Supertig_id, vector< Scaffold_Gap > > &sca_map,
				Supertig_bank &tig_bank );

bool scf_create_t( Supertig_id tig_id, 
				  Forb f, 
				  pair<int, int> pos, 
				  Supertig & n_tig, 
				  int suptig_len, 
				  Scaffold_Gap &p_scf, 
				  Scaffold_Gap &c_scf,
				  Supertig_bank &tig_bank );


void scf_merge( vector< Scaffold_Gap > & p_scf_ve, vector< Scaffold_Gap > & c_scf_ve );

void scf_merge_t( Scaffold_Gap & p_scf, vector< Scaffold_Gap > & c_scf_ve );

bool two_scf_merge( Scaffold_Gap & p_scf, Scaffold_Gap & c_scf );

void add_scf( Supertig_id ida, Supertig_id idb, vector< Scaffold_Gap > &scf_ve, Supertig_bank &tig_bank );

void ve_int_minus( vector< int > &ve_a, vector< int > &ve_b, int minus_int );
double ve_int_getmean( vector< int > &ve );

int drc_type_rev( int type );
int drc_type_lefttig_rev( int type );
int drc_type_righttig_rev( int type );

void scf_replace_spe( Supertig_id n_id, Supertig_id p_id, Supertig_bank &tig_bank );
void scf_replace_spe_t( Supertig_id n_id,
					   Supertig_id p_id, 
					   vector< Scaffold_gap_id > &p_scf_ve, 
					   vector< Scaffold_Gap > &c_scf_ve,
					   Supertig_bank &tig_bank );
void scf_create_spe(  Supertig_id n_id, Supertig_id p_id, Scaffold_Gap &p_scf, Scaffold_Gap &c_scf );

bool scf_check( pair< Supertig_id, Forb > lefttig, pair < Supertig_id, Forb > righttig, Supertig_bank &tig_bank );

bool scf_check_t( pair< Supertig_id, Forb > lefttig, pair < Supertig_id, Forb > righttig, Scaffold_Gap &scf );

bool scf_check( pair< Supertig_id, Forb > lefttig, pair < Supertig_id, Forb > righttig, int gap, Supertig_bank &tig_bank );
bool scf_check( pair< Supertig_id, Forb > lefttig, pair < Supertig_id, Forb > righttig, int gap, Supertig_bank &tig_bank, Scaffold_Gap &scf );

bool scf_check_t( pair< Supertig_id, Forb > lefttig, pair < Supertig_id, Forb > righttig, int gap, Scaffold_Gap &scf );

bool scf_conflict_check( int leftlen, int rightlen, pair< Supertig_id, Forb > tig, Supertig_bank &tig_bank );

bool scf_conflict_check_t( int leftlen, int rightlen, pair< Supertig_id, Forb > tig, Scaffold_Gap &scf );

bool scf_check_u2s( pair< Supertig_id, Forb > ultratig, pair< Supertig_id, Forb > singletig, Supertig_bank &tig_bank );

bool scf_check_s2u( pair< Supertig_id, Forb > singletig, pair< Supertig_id, Forb > ultratig, Supertig_bank &tig_bank );

#endif
