#include "Graph_Suptig_Assbl.h"

void supertig_assble( Supertig_id n_id,
					 Supertig & n_tig, 
					 subgraph &graph_t, 
					 Supertig_bank &tig_bank )
{
	size_t psize = n_tig.Tig_Ve.size();
	vector< Supertig_id > left_para_tigs = n_tig.Tig_Ve[0];
	vector< Supertig_id > right_para_tigs = n_tig.Tig_Ve[psize-1];
	vector< Forb > left_para_forb = n_tig.Tig_F_Ve[0];
	vector< Forb > right_para_forb = n_tig.Tig_F_Ve[psize-1];

}

Supertig_id supertig_in_para_ass( vector< Supertig_id > & bubble, subgraph &graph_t, Supertig_bank &tig_bank )
{
	Supertig n_tig;
	n_tig.Tig_Ve.push_back( bubble );



	n_tig.bubble = true;

	vector< Forb > Forb_ve;
	vector< pair< int, int > > Pos_ve;

	map< Supertig_id, int > left_ovlen_map_1;
	int max_left_ovlen_1 = 0;

	vector< pair< pair< Supertig_id, Forb >, int > > left_linked_nodes;

	set< pair< Supertig_id, Forb > > selfrevlinkednode;
	set< pair< Supertig_id, Forb > >::iterator Itehs;
	for ( Itehs = graph_t.Supertig_Overlap_Link_Map[bubble[0]].tail_links.begin(); Itehs != graph_t.Supertig_Overlap_Link_Map[bubble[0]].tail_links.end(); ++Itehs ) {
		if ( graph_t.Supertig_Overlap_Link_Map[bubble[0]].head_links.find( *Itehs ) != graph_t.Supertig_Overlap_Link_Map[bubble[0]].head_links.end() ) {
			selfrevlinkednode.insert( *Itehs );
			
		}
	}
	


	set< pair< Supertig_id, Forb > >::iterator Iteh;
	for ( Iteh = graph_t.Supertig_Overlap_Link_Map[bubble[0]].tail_links.begin(); Iteh != graph_t.Supertig_Overlap_Link_Map[bubble[0]].tail_links.end(); ++Iteh ) {
		map< Supertig_id, int > ovlen_map;
		if ( bubble.size() == 1 && !selfrevlinkednode.empty() ) {
			int ovlen = graph_t.Supertig_Overlap_Link_Map[bubble[0]].Tail_Id_Ov_Ma[*Iteh];
		
			if ( Iteh == graph_t.Supertig_Overlap_Link_Map[bubble[0]].tail_links.begin() ) {
				if ( !side_link_check_rev_bb( *Iteh, ovlen, bubble, Forb_ve, ovlen_map, graph_t ) )
					return -1;
				left_ovlen_map_1 = ovlen_map;
			} else {
				if ( !side_link_check_bb( *Iteh, bubble, ovlen_map, graph_t ) )
					return -1;
			}
		} else {
			
			
			if ( Iteh == graph_t.Supertig_Overlap_Link_Map[bubble[0]].tail_links.begin() ) {
				if ( !side_link_check_bb( *Iteh, bubble, Forb_ve, ovlen_map, graph_t ) )
					return -1;
				left_ovlen_map_1 = ovlen_map;
			} else {
				if ( !side_link_check_bb( *Iteh, bubble, ovlen_map, graph_t ) )
					return -1;
			}
		}
			

		int max_left_ovlen = 0;
		for ( size_t i = 0; i < bubble.size(); ++i ) {
			
			if ( ovlen_map[bubble[i]] > max_left_ovlen ) {
				max_left_ovlen = ovlen_map[bubble[i]];
			}
			
		}
		
		left_linked_nodes.push_back( make_pair( *Iteh, max_left_ovlen ) );

		if ( Iteh == graph_t.Supertig_Overlap_Link_Map[bubble[0]].tail_links.begin() ) {
			max_left_ovlen_1 = max_left_ovlen;
		}
		
		
	}

	map< Supertig_id, int > right_ovlen_map_1;

	int max_right_ovlen_1 = 0;
	vector< pair< pair< Supertig_id, Forb >, int > > right_linked_nodes;

	set< pair< Supertig_id, Forb > >::iterator Itet;
	for ( Itet = graph_t.Supertig_Overlap_Link_Map[bubble[0]].head_links.begin(); Itet != graph_t.Supertig_Overlap_Link_Map[bubble[0]].head_links.end(); ++Itet ) {
		
		map< Supertig_id, int > ovlen_map;

		if ( bubble.size() == 1 && !selfrevlinkednode.empty() ) {
			int ovlen = graph_t.Supertig_Overlap_Link_Map[bubble[0]].Head_Id_Ov_Ma[*Itet];
			if ( !side_link_check_rev_bb( *Itet, ovlen, bubble, ovlen_map, graph_t ) )
				return -1;
		} else {
			if ( !side_link_check_bb( *Itet, bubble, ovlen_map, graph_t ) )
				return -1;
		}

		int max_right_ovlen = 0;
		for ( size_t i = 0; i < bubble.size(); ++i ) {
			
			if ( ovlen_map[bubble[i]] > max_right_ovlen ) {
				max_right_ovlen = ovlen_map[bubble[i]];
			}
			
		}
		
		right_linked_nodes.push_back( make_pair( *Itet, max_right_ovlen ) );

		if ( Itet == graph_t.Supertig_Overlap_Link_Map[bubble[0]].head_links.begin() ) {
			right_ovlen_map_1 = ovlen_map;
			max_right_ovlen_1 = max_right_ovlen;
		}
		
	}


	double body_len = 0;
	

	for ( size_t i = 0; i < bubble.size(); ++i ) {
		int this_body_len = tig_bank.Supertig_Map[bubble[i]].length - left_ovlen_map_1[bubble[i]] - right_ovlen_map_1[bubble[i]];
		body_len =  double( i * body_len + this_body_len ) / ( i + 1 );
		
	}
	
	int body_len_i = (int)body_len;
	n_tig.length = max_left_ovlen_1 + body_len_i + max_right_ovlen_1;
	for ( size_t i = 0; i < bubble.size(); ++i ) {
		Pos_ve.push_back( make_pair( max_left_ovlen_1 - left_ovlen_map_1[bubble[i]] + 1, n_tig.length - ( max_right_ovlen_1 - right_ovlen_map_1[bubble[i]] ) ) );
	}
	
	n_tig.Tig_F_Ve.push_back( Forb_ve );
	n_tig.Tig_P_Ve.push_back( Pos_ve );

	Supertig_id n_id = tig_bank.Supertig_Map.rbegin()->first + 1;
	if( tig_bank.Supertig_Map.find( n_id ) != tig_bank.Supertig_Map.end() ) {
		cerr << "Warning in  func supertig_in_para_ass: n_id already exist in tig_bank.Supertig_Map " <<endl;
		return -1;
	}
	


	//erase merged tig from active_tig set, add the n_tig in the active_tig set.
	for ( size_t i = 0; i < bubble.size(); ++i ) {
		if ( graph_t.active_tig.find( bubble[i] ) != graph_t.active_tig.end() )
			graph_t.active_tig.erase( bubble[i] );
	}
	graph_t.active_tig.insert( n_id );
	///////////////////////////////////////////////////////


	tig_bank.Supertig_Map.insert( make_pair ( n_id, n_tig ) );


	ov_link_replace( n_id, n_tig, graph_t, tig_bank, left_linked_nodes, right_linked_nodes );


	suptig_scf_replace( n_id, n_tig, tig_bank );


	return n_id;
}

Supertig_id supertig_in_seri_ass( vector< pair< Supertig_id, Forb >  > & series, subgraph &graph_t, Supertig_bank &tig_bank )
{
	size_t tig_size = series.size();

	vector< pair< pair< Supertig_id, Forb >, int > > left_linked_nodes;
	vector< pair< pair< Supertig_id, Forb >, int > > right_linked_nodes;

	side_link_check_se( reversepht( series[0] ), left_linked_nodes, graph_t );
	side_link_check_se( series[tig_size-1], right_linked_nodes, graph_t );


	Supertig n_tig;

	n_tig.series = true;

	if ( !supertig_in_seri_form( n_tig, series, graph_t, tig_bank ) ) {
		return -1;
	}

	Supertig_id n_id = tig_bank.Supertig_Map.rbegin()->first + 1;
	if( tig_bank.Supertig_Map.find( n_id ) != tig_bank.Supertig_Map.end() ) {
		cerr << "Warning in  func simple_bubble_assbl: n_id already exist in tig_bank.Supertig_Map " <<endl;
		return -1;
	}

	//erase merged tig from active_tig set, add the n_tig in the active_tig set.
	for ( size_t i = 0; i < series.size(); ++i ) {
		if ( graph_t.active_tig.find( series[i].first ) != graph_t.active_tig.end() )
			graph_t.active_tig.erase( series[i].first );
	}
	graph_t.active_tig.insert( n_id );
	////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////////////////////
	// the linked node may be assembled into the n_id itself, so 
	// replace it if it is the case.
	for ( size_t i = 0; i < left_linked_nodes.size(); ++i ) {
		if ( left_linked_nodes[i].first.first == series[0].first ) {
			if ( left_linked_nodes[i].first.second == series[0].second ) {
				cerr <<"Warning in supertig_in_seri_ass: the snake eat its tails! "<<endl;  system("pause");
			} else {
				left_linked_nodes[i].first = make_pair( n_id, 1 );
			}
		} else if ( left_linked_nodes[i].first.first == series[series.size() - 1 ].first ) {
			if ( left_linked_nodes[i].first.second != series[series.size()-1].second ) {
				cerr <<"Warning in supertig_in_seri_ass: the snake eat its tails! "<<endl;  system("pause");
			} else {
				left_linked_nodes[i].first = make_pair( n_id, 0 );
			}
		}
	}
	for ( size_t i = 0; i < right_linked_nodes.size(); ++i ) {
		if ( right_linked_nodes[i].first.first == series[0].first ) {
			if ( right_linked_nodes[i].first.second == series[0].second ) {
				cerr <<"Warning in supertig_in_seri_ass: the snake eat its tails! "<<endl;  system("pause");
			} else {
				right_linked_nodes[i].first = make_pair( n_id, 1 );
			}
		} else if ( right_linked_nodes[i].first.first == series[series.size() - 1 ].first ) {
			if ( right_linked_nodes[i].first.second != series[series.size()-1].second ) {
				cerr <<"Warning in supertig_in_seri_ass: the snake eat its tails! "<<endl;  system("pause");
			} else {
				right_linked_nodes[i].first = make_pair( n_id, 0 );
			}
		}
	}
	////////////////////////////////////////////////////////////////////////////////////////////////

	tig_bank.Supertig_Map.insert( make_pair ( n_id, n_tig ) );

	ov_link_replace( n_id, n_tig, graph_t, tig_bank, left_linked_nodes, right_linked_nodes );

	suptig_scf_replace( n_id, n_tig, tig_bank );
	return n_id;
}



Supertig_id supertig_in_seri_ass( list< pair< Supertig_id, Forb >  > & series, subgraph &graph_t, Supertig_bank &tig_bank )
{
	size_t tig_size = series.size();
	

	vector< pair< pair< Supertig_id, Forb >, int > > left_linked_nodes;
	vector< pair< pair< Supertig_id, Forb >, int > > right_linked_nodes;

	side_link_check_se( reversepht( series.front() ), left_linked_nodes, graph_t );
	side_link_check_se( series.back(), right_linked_nodes, graph_t );

	vector< pair< pair< Supertig_id, Forb >, int > > al_left_linked_nodes;
	vector< pair< pair< Supertig_id, Forb >, int > > al_right_linked_nodes;
	for ( size_t i = 0; i < left_linked_nodes.size(); ++i ) {
		if ( find( series.begin(), series.end(), make_pair( left_linked_nodes[i].first.first, 0 ) ) != series.end() 
			|| find( series.begin(), series.end(), make_pair( left_linked_nodes[i].first.first, 1 ) ) != series.end() ) {
				continue;
		} else {
			al_left_linked_nodes.push_back( left_linked_nodes[i] );
		}
	}
	for ( size_t i = 0; i < right_linked_nodes.size(); ++i ) {
		if ( find( series.begin(), series.end(), make_pair( right_linked_nodes[i].first.first, 0 ) ) != series.end() 
			|| find( series.begin(), series.end(), make_pair( right_linked_nodes[i].first.first, 1 ) ) != series.end() ) {
				continue;
		} else {
			al_right_linked_nodes.push_back( right_linked_nodes[i] );
		}
	}
	left_linked_nodes = al_left_linked_nodes;
	right_linked_nodes = al_right_linked_nodes;

	vector< pair< Supertig_id, Forb >  > series_ve;
	list< pair< Supertig_id, Forb >  >::iterator Iteli;
	for ( Iteli = series.begin(); Iteli != series.end(); ++Iteli ) {
		series_ve.push_back( *Iteli );
	}

	Supertig n_tig;

	n_tig.series = true;

	if ( !supertig_in_seri_form( n_tig, series_ve, graph_t, tig_bank ) ) {
		return -1;
	}

	Supertig_id n_id = tig_bank.Supertig_Map.rbegin()->first + 1;
	if( tig_bank.Supertig_Map.find( n_id ) != tig_bank.Supertig_Map.end() ) {
		cerr << "Warning in  func simple_bubble_assbl: n_id already exist in tig_bank.Supertig_Map " <<endl;
		return -1;
	}

	//erase merged tig from active_tig set, add the n_tig in the active_tig set.
	for ( size_t i = 0; i < series_ve.size(); ++i ) {
		if ( graph_t.active_tig.find( series_ve[i].first ) != graph_t.active_tig.end() )
			graph_t.active_tig.erase( series_ve[i].first );
	}
	graph_t.active_tig.insert( n_id );
	////////////////////////////////////////////////////////////

	tig_bank.Supertig_Map.insert( make_pair ( n_id, n_tig ) );

	ov_link_replace( n_id, n_tig, graph_t, tig_bank, left_linked_nodes, right_linked_nodes );

	suptig_scf_replace( n_id, n_tig, tig_bank );
	return n_id;
}

bool side_link_check_rev_bb( pair< Supertig_id, Forb > link_node,
							int ovlen,
						 vector< Supertig_id > & bubble, 
						 vector< Forb > &Forb_ve, 
						 map< Supertig_id, int > &ovlen_map,
						 subgraph &graph_t )
{
	if ( (int)bubble.size() > 1)
		return false;
	if( link_node.second == 0 ) {
		bool ok = false;
		pair< Supertig_id, Forb > p = make_pair( bubble[0], 0 );
		if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.end() ) {
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] == ovlen ) {
				Forb_ve.push_back( 1 );
				ovlen_map.insert( make_pair( bubble[0], graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] ) );
				ok = true;
			}
		} 
		if ( !ok ) {
			p = make_pair( bubble[0], 1 );
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.end() ) {
				if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] == ovlen ) {
					Forb_ve.push_back( 0 );
					ovlen_map.insert( make_pair( bubble[0], graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] ) );
					ok = true;
				}
			} else {
				cerr << "Warning in func side_link_check: the tig bubble[i] not found in linked node " <<link_node.first<<","<<link_node.second<<","<<p.first<<","<<p.second<<endl;
				return false;
			}
		}
		if (!ok) {
			cout<<"error in side_link_check_rev_bb"<<endl;  exit(1);
		}
	

	} else {
		bool ok = false;
		pair< Supertig_id, Forb > p = make_pair( bubble[0], 0 );
		if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.end() ) {
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] == ovlen ) {
				ok = true;
				Forb_ve.push_back( 1 );
				ovlen_map.insert( make_pair( bubble[0], graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] ) );
			}
		} 
		if ( !ok ){
			p = make_pair( bubble[0], 1 );
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.end() ) {
				if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] == ovlen ) {
					ok = true;
					Forb_ve.push_back( 0 );
					ovlen_map.insert( make_pair( bubble[0], graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] ) );
				}
			} else {
				cerr << "Warning in func side_link_check: the tig bubble[i] not found in head linked edge " <<link_node.first<<","<<link_node.second<<","<<p.first<<","<<p.second<<endl;
				return false;
			}
		}
		if (!ok) {
			cout<<"error in side_link_check_rev_bb"<<endl;  exit(1);
		}
		
	}

	return true;
}

bool side_link_check_rev_bb( pair< Supertig_id, Forb > link_node,
							int ovlen,
						 vector< Supertig_id > & bubble, 
						 map< Supertig_id, int > &ovlen_map,
						 subgraph &graph_t )
{
	if ( (int)bubble.size() > 1)
		return false;
	if( link_node.second == 0 ) {
		bool ok = false;
		pair< Supertig_id, Forb > p = make_pair( bubble[0], 0 );
		if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.end() ) {
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] == ovlen ) {
			
				ovlen_map.insert( make_pair( bubble[0], graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] ) );
				ok = true;
			}
		} 
		if ( !ok ) {
			p = make_pair( bubble[0], 1 );
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.end() ) {
				if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] == ovlen ) {
					
					ovlen_map.insert( make_pair( bubble[0], graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] ) );
					ok = true;
				}
			} else {
				cerr << "Warning in func side_link_check: the tig bubble[i] not found in linked node " <<link_node.first<<","<<link_node.second<<","<<p.first<<","<<p.second<<endl;
				return false;
			}
		}
		if (!ok) {
			cout<<"error in side_link_check_rev_bb"<<endl;  exit(1);
		}
	

	} else {
		bool ok = false;
		pair< Supertig_id, Forb > p = make_pair( bubble[0], 0 );
		if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.end() ) {
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] == ovlen ) {
				ok = true;
				
				ovlen_map.insert( make_pair( bubble[0], graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] ) );
			}
		} 
		if ( !ok ){
			p = make_pair( bubble[0], 1 );
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.end() ) {
				if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] == ovlen ) {
					ok = true;
					
					ovlen_map.insert( make_pair( bubble[0], graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] ) );
				}
			} else {
				cerr << "Warning in func side_link_check: the tig bubble[i] not found in head linked edge " <<link_node.first<<","<<link_node.second<<","<<p.first<<","<<p.second<<endl;
				return false;
			}
		}
		if (!ok) {
			cout<<"error in side_link_check_rev_bb"<<endl;  exit(1);
		}
		
	}

	return true;
}

bool side_link_check_bb( pair< Supertig_id, Forb > link_node,
						 vector< Supertig_id > & bubble,
						 map< Supertig_id, int > &ovlen_map,
						 subgraph &graph_t )
{
	if( link_node.second == 0 ) {
		for ( size_t i = 0; i < bubble.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bubble[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.end() ) {
				
				ovlen_map.insert( make_pair( bubble[i], graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] ) );
			} else {
				p = make_pair( bubble[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.end() ) {
					
					ovlen_map.insert( make_pair( bubble[i], graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] ) );
				} else {
					cerr << "Warning in func side_link_check: the tig bubble[i] not found in linked node " <<link_node.first<<","<<link_node.second<<","<<p.first<<","<<p.second<<endl;
					return false;
				}
			}
		}

	} else {
		for ( size_t i = 0; i < bubble.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bubble[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.end() ) {
				
				ovlen_map.insert( make_pair( bubble[i], graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] ) );
			} else {
				p = make_pair( bubble[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.end() ) {
					
					ovlen_map.insert( make_pair( bubble[i], graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] ) );
				} else {
					cerr << "Warning in func side_link_check: the tig bubble[i] not found in linked node " <<link_node.first<<","<<link_node.second<<","<<p.first<<","<<p.second<<endl;
					return false;
				}
			}
		}
	}

	return true;
}

bool side_link_check_bb( pair< Supertig_id, Forb > link_node,
						 vector< Supertig_id > & bubble, 
						 vector< Forb > &Forb_ve, 
						 map< Supertig_id, int > &ovlen_map,
						 subgraph &graph_t )
{
	if( link_node.second == 0 ) {
		for ( size_t i = 0; i < bubble.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bubble[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.end() ) {
				Forb_ve.push_back( 1 );
				ovlen_map.insert( make_pair( bubble[i], graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] ) );
			} else {
				p = make_pair( bubble[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].head_links.end() ) {
					Forb_ve.push_back( 0 );
					ovlen_map.insert( make_pair( bubble[i], graph_t.Supertig_Overlap_Link_Map[link_node.first].Head_Id_Ov_Ma[p] ) );
				} else {
					cerr << "Warning in func side_link_check: the tig bubble[i] not found in linked node " <<link_node.first<<","<<link_node.second<<","<<p.first<<","<<p.second<<endl;
					return false;
				}
			}
		}

	} else {
		for ( size_t i = 0; i < bubble.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bubble[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.end() ) {
				Forb_ve.push_back( 1 );
				ovlen_map.insert( make_pair( bubble[i], graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] ) );
			} else {
				p = make_pair( bubble[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[link_node.first].tail_links.end() ) {
					Forb_ve.push_back( 0 );
					ovlen_map.insert( make_pair( bubble[i], graph_t.Supertig_Overlap_Link_Map[link_node.first].Tail_Id_Ov_Ma[p] ) );
				} else {
					cerr << "Warning in func side_link_check: the tig bubble[i] not found in head linked edge " <<link_node.first<<","<<link_node.second<<","<<p.first<<","<<p.second<<endl;
					return false;
				}
			}
		}
	}

	return true;
}




void side_link_check_se( pair< Supertig_id, Forb > se_brink_node,
						 vector< pair< pair< Supertig_id, Forb >, int > > &linked_nodes,
						 subgraph &graph_t )
{

	if ( se_brink_node.second == 0 ) {
		map< pair< Supertig_id, Forb >, int >::iterator Iteh;
		for ( Iteh = graph_t.Supertig_Overlap_Link_Map[se_brink_node.first].Head_Id_Ov_Ma.begin(); Iteh != graph_t.Supertig_Overlap_Link_Map[se_brink_node.first].Head_Id_Ov_Ma.end(); ++Iteh ) {
			linked_nodes.push_back( make_pair( Iteh->first, Iteh->second ) );	
		}
	} else {
		map< pair< Supertig_id, Forb >, int >::iterator Itet;
		for ( Itet = graph_t.Supertig_Overlap_Link_Map[se_brink_node.first].Tail_Id_Ov_Ma.begin(); Itet != graph_t.Supertig_Overlap_Link_Map[se_brink_node.first].Tail_Id_Ov_Ma.end(); ++Itet ) {

			linked_nodes.push_back( make_pair( Itet->first, Itet->second ) );
		}
	}
}

bool supertig_in_seri_form( Supertig &n_tig, vector< pair< Supertig_id, Forb > > & series, subgraph &graph_t, Supertig_bank &tig_bank )
{
	size_t se_size = series.size();

	int this_pos = 0;
	vector< pair< int, int > > single_pos_ve_1;
	single_pos_ve_1.push_back( make_pair( 1, tig_bank.Supertig_Map[series[0].first].length ) );
	n_tig.Tig_P_Ve.push_back( single_pos_ve_1 );
	this_pos = tig_bank.Supertig_Map[series[0].first].length;
	for ( size_t i = 0; i < se_size; ++i ) {
		
		vector< Supertig_id > single_tig_ve;
		single_tig_ve.push_back( series[i].first );
		n_tig.Tig_Ve.push_back( single_tig_ve );
		vector< Forb > single_tig_f_ve;
		single_tig_f_ve.push_back( series[i].second );
		n_tig.Tig_F_Ve.push_back( single_tig_f_ve );

		size_t j = i + 1;
		if ( j >= se_size )
			break;
		
		
		int ovlen = get_ovlen_fr_cnct_nodes( series[i], reversepht( series[j] ), graph_t );
		if ( ovlen == -1000 ) {
			ovlen = get_ovlen_fr_cnct_nodes( series[i], reversepht( series[j] ), tig_bank.fdm_ovlkmap );
			if ( ovlen == -1000 ) {
				cout<<"warning in supertig_in_seri_form ov = -1000"<<endl;
				return false;
			}
		}
		

		vector< pair< int, int > > single_pos_ve;
		int fpos = this_pos - ovlen + 1;
		int bpos = fpos + tig_bank.Supertig_Map[series[j].first].length - 1;
		single_pos_ve.push_back( make_pair( fpos, bpos ) );

		n_tig.Tig_P_Ve.push_back( single_pos_ve );

		this_pos = bpos;

	}

	n_tig.length = this_pos;

	return true;

}

bool supertig_in_seri_form( Supertig &n_tig, vector< pair< Supertig_id, Forb > > & series, map< Supertig_id, Supertig_Overlap_Link > &ovlkmap, Supertig_bank &tig_bank )
{
	size_t se_size = series.size();

	n_tig.series = true;

	int this_pos = 0;
	vector< pair< int, int > > single_pos_ve_1;
	single_pos_ve_1.push_back( make_pair( 1, tig_bank.Supertig_Map[series[0].first].length ) );
	n_tig.Tig_P_Ve.push_back( single_pos_ve_1 );
	this_pos = tig_bank.Supertig_Map[series[0].first].length;
	for ( size_t i = 0; i < se_size; ++i ) {
		
		vector< Supertig_id > single_tig_ve;
		single_tig_ve.push_back( series[i].first );
		n_tig.Tig_Ve.push_back( single_tig_ve );
		vector< Forb > single_tig_f_ve;
		single_tig_f_ve.push_back( series[i].second );
		n_tig.Tig_F_Ve.push_back( single_tig_f_ve );

		size_t j = i + 1;
		if ( j >= se_size )
			break;

		vector< pair< int, int > > single_pos_ve;
		int fpos = 0;
		int bpos = 0;
		int ovlen = get_ovlen_fr_cnct_nodes( series[i], reversepht( series[j] ), ovlkmap );
		if ( ovlen == -1000 ) {
			if ( !tig_bank.newly_transfered_tig.empty() ) {
				set< Supertig_id >::iterator Iten;
				int tag = 0;
				for ( Iten = tig_bank.newly_transfered_tig.begin(); Iten != tig_bank.newly_transfered_tig.end(); ++Iten ) {
					Supertig_id nnid = *Iten;
					pair< int, int > relpos;
					if ( tig_bank.Supertig_Map[nnid].getrelposfromtig( series[i].first, series[j].first, series[i].second, series[j].second, relpos ) ) {
						
						fpos = this_pos + relpos.first;
						bpos = this_pos + relpos.second;
						tag = 1;
						
						break;
					}
				}
				if ( tag == 0 )
					return false;
			} else
				return false;
		} else {
		
			fpos = this_pos - ovlen + 1;
			bpos = fpos + tig_bank.Supertig_Map[series[j].first].length - 1;
		}

		single_pos_ve.push_back( make_pair( fpos, bpos ) );

		n_tig.Tig_P_Ve.push_back( single_pos_ve );

		this_pos = bpos;

	}

	n_tig.length = this_pos;

	return true;

}

bool supertig_in_seri_form_II( Supertig &n_tig, vector< pair< Supertig_id, Forb > > & series, vector< int > &ovlenve, map< size_t, int > &bulblen, Supertig_bank &tig_bank )
{
	size_t se_size = series.size();

	n_tig.series = true;

	int this_pos = 0;
	int length = 0;
	if ( series[0].first == -1 ) {
		n_tig.Structed = true;
		if ( bulblen.find( 0 ) == bulblen.end() ) {
			cerr << "Warning in supertig_in_seri_form_II: bulblen wrong "<<endl;
			return false;
		}
		length = bulblen[0];

	} else {
		length = tig_bank.Supertig_Map[series[0].first].length;
	}

	vector< pair< int, int > > single_pos_ve_1;
	single_pos_ve_1.push_back( make_pair( 1, length ) );
	n_tig.Tig_P_Ve.push_back( single_pos_ve_1 );
	this_pos = length;
	for ( size_t i = 0; i < se_size; ++i ) {
		
		vector< Supertig_id > single_tig_ve;
		single_tig_ve.push_back( series[i].first );
		n_tig.Tig_Ve.push_back( single_tig_ve );
		vector< Forb > single_tig_f_ve;
		single_tig_f_ve.push_back( series[i].second );
		n_tig.Tig_F_Ve.push_back( single_tig_f_ve );

		size_t j = i + 1;
		if ( j >= se_size )
			break;

		if ( i >= ovlenve.size() ) {
			cerr << "Warning in supertig_in_seri_form_II: no ovlen "<<endl;
			return false;
		}
		int ovlen = ovlenve[i];

		length = 0;
		if ( series[j].first == -1 ) {
			n_tig.Structed = true;
			if ( bulblen.find( j ) == bulblen.end() ) {
				cerr << "Warning in supertig_in_seri_form_II: bulblen wrong "<<endl;
				return false;
			}
			length = bulblen[j];

		} else {
			length = tig_bank.Supertig_Map[series[j].first].length;
		}


		vector< pair< int, int > > single_pos_ve;
		int fpos = this_pos - ovlen + 1;
		int bpos = fpos + length - 1;
		single_pos_ve.push_back( make_pair( fpos, bpos ) );

		n_tig.Tig_P_Ve.push_back( single_pos_ve );

		this_pos = bpos;

	}

	n_tig.length = this_pos;

	return true;
}

int get_ovlen_fr_cnct_nodes( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, subgraph &graph_t )
{
	if ( pa.second == 0 ) {
		if ( graph_t.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma.find( pb ) == graph_t.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma.end() ) {
			
			cerr << "Warning in func get_ovlen_fr_cnct_nodes: no ovlen of pb linked to pa "<<pa.first<<","<<pa.second<<","<<pb.first<<","<<pb.second<<endl;  system("pause");
			return -1000;
		}
		return graph_t.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma[pb];
	} else {
		if ( graph_t.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma.find( pb ) == graph_t.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma.end() ) {
			
			cerr << "Warning in func get_ovlen_fr_cnct_nodes: no ovlen of pb linked to pa "<<pa.first<<","<<pa.second<<","<<pb.first<<","<<pb.second<<endl;  system("pause");
			return -1000;
		}
		return graph_t.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma[pb];
	}

}

int get_ovlen_fr_cnct_nodes( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, map< Supertig_id, Supertig_Overlap_Link > &ovlkmap )
{
	if ( pa.second == 0 ) {
		if ( ovlkmap[pa.first].Head_Id_Ov_Ma.find( pb ) == ovlkmap[pa.first].Head_Id_Ov_Ma.end() ) {
		//	cerr << "Warning in func get_ovlen_fr_cnct_nodes: no ovlen of pb linked to pa "<<pa.first<<","<<pa.second<<","<<pb.first<<","<<pb.second<<endl;  // system("pause");
			return -1000;
		}
		return ovlkmap[pa.first].Head_Id_Ov_Ma[pb];
	} else {
		if ( ovlkmap[pa.first].Tail_Id_Ov_Ma.find( pb ) == ovlkmap[pa.first].Tail_Id_Ov_Ma.end() ) {
		//	cerr << "Warning in func get_ovlen_fr_cnct_nodes: no ovlen of pb linked to pa "<<pa.first<<","<<pa.second<<","<<pb.first<<","<<pb.second<<endl; //  system("pause");
			return -1000;
		}
		return ovlkmap[pa.first].Tail_Id_Ov_Ma[pb];
	}

}

int get_ovlen_from_lk_tig( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, Supertig_bank &tig_bank )
{
	vector< pair< Supertig_id, Forb > > pa_t_ve;
	vector< pair< Supertig_id, Forb > > pb_t_ve;
	pair< Supertig_id, Forb > pa_t;
	pair< Supertig_id, Forb > pb_t;
	bool structed = false;
	if ( pa.second == 0 ) {
		if ( tig_bank.Supertig_Map[pa.first].bubble ) {
			for ( size_t i = 0; i < tig_bank.Supertig_Map[pa.first].Tig_Ve[0].size(); ++i ) {
				pa_t_ve.push_back( make_pair( tig_bank.Supertig_Map[pa.first].Tig_Ve[0][i], tig_bank.Supertig_Map[pa.first].Tig_F_Ve[0][i] ) );
			}
		} else {
			pa_t = make_pair( tig_bank.Supertig_Map[pa.first].getbackid(), tig_bank.Supertig_Map[pa.first].getbackforb() );
			if ( pa_t.first == -1 ) {
				structed = true;
				if ( tig_bank.Supertig_Map[pa.first].bulbmap.find(tig_bank.Supertig_Map[pa.first].Tig_Ve.size()-1) == tig_bank.Supertig_Map[pa.first].bulbmap.end() ) {
					cout<<"Warning in get_ovlen_from_lk_tig: bulb error"<<endl;  return -1000;
				} 
				map< pair< Supertig_id, Forb >, Bridge >::iterator Iteb;
				for ( Iteb = tig_bank.Supertig_Map[pa.first].bulbmap[tig_bank.Supertig_Map[pa.first].Tig_Ve.size()-1].begin(); Iteb != tig_bank.Supertig_Map[pa.first].bulbmap[tig_bank.Supertig_Map[pa.first].Tig_Ve.size()-1].end(); ++Iteb ) {
					if ( pa_t.second == 0 ) {
						pa_t_ve.push_back( Iteb->first );
					} else {
						pa_t_ve.push_back( reversepht( Iteb->first ) );
					}
				}
			} else
				pa_t_ve.push_back( pa_t );
		}
		
	} else {
		if ( tig_bank.Supertig_Map[pa.first].bubble ) {
			for ( size_t i = 0; i < tig_bank.Supertig_Map[pa.first].Tig_Ve[0].size(); ++i ) {
				pa_t_ve.push_back( make_pair( tig_bank.Supertig_Map[pa.first].Tig_Ve[0][i], reverseforb( tig_bank.Supertig_Map[pa.first].Tig_F_Ve[0][i] ) ) );
			}
		} else {
			pa_t = make_pair( tig_bank.Supertig_Map[pa.first].getfrontid(), reverseforb( tig_bank.Supertig_Map[pa.first].getfrontforb() ) );
			if ( pa_t.first == -1 ) {
				structed = true;
				if ( tig_bank.Supertig_Map[pa.first].bulbmap.find(0) == tig_bank.Supertig_Map[pa.first].bulbmap.end() ) {
					cout<<"Warning in get_ovlen_from_lk_tig: bulb error"<<endl;  return -1000;
				} 
				map< pair< Supertig_id, Forb >, Bridge >::iterator Iteb;
				for ( Iteb = tig_bank.Supertig_Map[pa.first].bulbmap[0].begin(); Iteb != tig_bank.Supertig_Map[pa.first].bulbmap[0].end(); ++Iteb ) {
					if ( pa_t.second == 0 ) {
						pa_t_ve.push_back( Iteb->first );
					} else {
						pa_t_ve.push_back( reversepht( Iteb->first ) );
					}
				}
			} else
				pa_t_ve.push_back( pa_t );
		}
	}

	if ( pb.second == 0 ) {
		if ( tig_bank.Supertig_Map[pb.first].bubble ) {
			for ( size_t i = 0; i < tig_bank.Supertig_Map[pb.first].Tig_Ve[0].size(); ++i ) {
				pb_t_ve.push_back( make_pair( tig_bank.Supertig_Map[pb.first].Tig_Ve[0][i], tig_bank.Supertig_Map[pb.first].Tig_F_Ve[0][i] ) );
			}
		} else {
			pb_t = make_pair( tig_bank.Supertig_Map[pb.first].getbackid(), tig_bank.Supertig_Map[pb.first].getbackforb() );
			if ( pb_t.first == -1 ) {
				structed = true;
				if ( tig_bank.Supertig_Map[pb.first].bulbmap.find(tig_bank.Supertig_Map[pb.first].Tig_Ve.size()-1) == tig_bank.Supertig_Map[pb.first].bulbmap.end() ) {
					cout<<"Warning in get_ovlen_from_lk_tig: bulb error"<<endl;  return -1000;
				} 
				map< pair< Supertig_id, Forb >, Bridge >::iterator Iteb;
				for ( Iteb = tig_bank.Supertig_Map[pb.first].bulbmap[tig_bank.Supertig_Map[pb.first].Tig_Ve.size()-1].begin(); Iteb != tig_bank.Supertig_Map[pb.first].bulbmap[tig_bank.Supertig_Map[pb.first].Tig_Ve.size()-1].end(); ++Iteb ) {
					if ( pb_t.second == 0 ) {
						pb_t_ve.push_back( Iteb->first );
					} else {
						pb_t_ve.push_back( reversepht( Iteb->first ) );
					}
				}
			} else
				pb_t_ve.push_back( pb_t );
		}
	} else {
		if ( tig_bank.Supertig_Map[pb.first].bubble ) {
			for ( size_t i = 0; i < tig_bank.Supertig_Map[pb.first].Tig_Ve[0].size(); ++i ) {
				pb_t_ve.push_back( make_pair( tig_bank.Supertig_Map[pb.first].Tig_Ve[0][i], reverseforb( tig_bank.Supertig_Map[pb.first].Tig_F_Ve[0][i] ) ) );
			}
		} else {
			pb_t = make_pair( tig_bank.Supertig_Map[pb.first].getfrontid(), reverseforb( tig_bank.Supertig_Map[pb.first].getfrontforb() ) );
			if ( pb_t.first == -1 ) {
				structed = true;
				if ( tig_bank.Supertig_Map[pb.first].bulbmap.find(0) == tig_bank.Supertig_Map[pb.first].bulbmap.end() ) {
					cout<<"Warning in get_ovlen_from_lk_tig: bulb error"<<endl;  return -1000;
				} 
				map< pair< Supertig_id, Forb >, Bridge >::iterator Iteb;
				for ( Iteb = tig_bank.Supertig_Map[pb.first].bulbmap[0].begin(); Iteb != tig_bank.Supertig_Map[pb.first].bulbmap[0].end(); ++Iteb ) {
					if ( pb_t.second == 0 ) {
						pb_t_ve.push_back( Iteb->first );
					} else {
						pb_t_ve.push_back( reversepht( Iteb->first ) );
					}
				}
			} else
				pb_t_ve.push_back( pb_t );
		}
	}

	int maxval = -1000;
	for ( size_t i = 0; i < pa_t_ve.size(); ++i ) {
		for ( size_t j = 0; j < pb_t_ve.size(); ++j ) {
			int val = -1000;
			if ( tig_bank.Basic_tig_set.find( pa_t_ve[i].first ) != tig_bank.Basic_tig_set.end() && tig_bank.Basic_tig_set.find( pb_t_ve[j].first ) != tig_bank.Basic_tig_set.end() ) {
				val = get_ovlen_fr_cnct_nodes( pa_t_ve[i], pb_t_ve[j], tig_bank.fdm_ovlkmap );
				
			} else {
				val = get_ovlen_from_lk_tig( pa_t_ve[i], pb_t_ve[j], tig_bank );
			}
			if ( val > maxval )
				maxval = val;
		}
	}

	return maxval;



}

int get_ovlen_via_basic_tig( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, Supertig_bank &tig_bank )
{
	pair< Supertig_id, Forb > pa_t;
	pair< Supertig_id, Forb > pb_t;
	if ( pa.second == 0 ) {
		if ( !get_back_basic_tig( pa.first, tig_bank, pa_t ) ) {
			return -1000;
		}
	} else {
		if ( !get_front_basic_tig( pa.first, tig_bank, pa_t ) ) {
			return -1000;
		} else {
			pa_t = reversepht( pa_t );
		}
	}
	if ( pb.second == 0 ) {
		if ( !get_back_basic_tig( pb.first, tig_bank, pb_t ) ) {
			return -1000;
		}
	} else {
		if ( !get_front_basic_tig( pb.first, tig_bank, pb_t ) ) {
			return -1000;
		} else {
			pb_t = reversepht( pb_t );
		}
	}

	return get_ovlen_fr_cnct_nodes( pa_t, pb_t, tig_bank.fdm_ovlkmap );
}

void get_path_fr_ovlk( vector< list< pair< Supertig_id, Forb > > > &ve, subgraph &graph_t, Supertig_id id )
{
	if ( graph_t.Supertig_Overlap_Link_Map.find( id ) == graph_t.Supertig_Overlap_Link_Map.end() ) {
		return;
	}
	set< pair< Supertig_id, Forb > >::iterator Iteh;
	for ( Iteh = graph_t.Supertig_Overlap_Link_Map[id].head_links.begin(); Iteh != graph_t.Supertig_Overlap_Link_Map[id].head_links.end(); ++Iteh ) {
		list< pair< Supertig_id, Forb > > pl;
		pl.push_back( make_pair( id, 0 ) );
		pl.push_back( reversepht( *Iteh ) );
		ve.push_back( pl );
	}
	set< pair< Supertig_id, Forb > >::iterator Itet;
	for ( Itet = graph_t.Supertig_Overlap_Link_Map[id].tail_links.begin(); Itet != graph_t.Supertig_Overlap_Link_Map[id].tail_links.end(); ++Itet ) {
		list< pair< Supertig_id, Forb > > pl;
		pl.push_back( *Itet );
		pl.push_back( make_pair( id, 0 ) );
		ve.push_back( pl );
	}

}

int path_elen_get( list< pair< Supertig_id, Forb > > &path, subgraph &graph_t, Supertig_bank &tig_bank )
{
	int elen = 0;
	list< pair< Supertig_id, Forb > >::iterator Ite = path.begin();
	pair< Supertig_id, Forb > prep = *Ite;
	++Ite;
	for (; Ite != path.end(); ++Ite ) {
		pair< Supertig_id, Forb > tp = *Ite;
		elen -= get_ovlen_fr_cnct_nodes( prep, reversepht( tp ), graph_t );
		elen += tig_bank.Supertig_Map[tp.first].length;
		prep = tp;
	}

	return elen;
}

int path_elengap_get( list< pair< Supertig_id, Forb > > &path, subgraph &graph_t, Supertig_bank &tig_bank )
{
	int elen = 0;
	list< pair< Supertig_id, Forb > >::iterator Ite = path.begin();
	pair< Supertig_id, Forb > prep = *Ite;
	++Ite;
	for (; Ite != path.end(); ++Ite ) {
		pair< Supertig_id, Forb > tp = *Ite;
		elen -= get_ovlen_fr_cnct_nodes( prep, reversepht( tp ), graph_t );
		elen += tig_bank.Supertig_Map[tp.first].length;
		prep = tp;
	}
	
	elen -= tig_bank.Supertig_Map[path.back().first].length;

	return elen;
}

void path_replace_in_para( vector< pair< Supertig_id, Forb > > &bubble, vector< list< pair< Supertig_id, Forb > > > &pathve, Supertig_id id )
{

	for ( size_t i = 0; i < pathve.size(); ++i ) {
		for ( size_t j = 0; j < bubble.size(); ++j ) {

			path_replace_single_t( bubble[j], pathve[i], id );
		}
	}
}


void path_replace_single_t( pair< Supertig_id, Forb > prep, list< pair< Supertig_id, Forb > > &npl, Supertig_id id )
{

	list< pair< Supertig_id, Forb > >::iterator Iteli;
	Iteli = find( npl.begin(), npl.end(), prep );
	list< pair< Supertig_id, Forb > > al_npl;
	while ( Iteli != npl.end() ) {
		al_npl.insert( al_npl.end(), npl.begin(), Iteli );
		al_npl.push_back( make_pair( id, 0 ) );
		++Iteli;
		if(Iteli != npl.end())
			al_npl.insert( al_npl.end(), Iteli, npl.end() );

		npl = al_npl;
		al_npl.clear();
		Iteli = find( npl.begin(), npl.end(), prep );
	}

	pair< Supertig_id, Forb > rp = reversepht( prep );
	list< pair< Supertig_id, Forb > >::reverse_iterator Riteli;
	Riteli = find( npl.rbegin(), npl.rend(), rp );
	while( Riteli != npl.rend() ) {

		al_npl.insert( al_npl.end(), npl.rbegin(), Riteli );
		al_npl.push_back( make_pair( id, 1 ) );
		++Riteli;
		if ( Riteli != npl.rend() )
			al_npl.insert(al_npl.end(), Riteli, npl.rend());

		al_npl.reverse();
		npl = al_npl;
		al_npl.clear();
		Riteli = find( npl.rbegin(), npl.rend(), rp );
	}

}

void path_replace_spe( pair< Supertig_id, Forb > tp, vector< list< pair< Supertig_id, Forb > > > &path, Supertig_id id, pair< Supertig_id, Forb > fp )
{
	size_t size = path.size();
	for ( size_t i = 0; i < size; ++i ) {
		path_replace_spe_t( tp, path[i], id, fp );
	}
	
}

void path_replace_spe_t( pair< Supertig_id, Forb > tp, list< pair< Supertig_id, Forb > > &npl, Supertig_id id, pair< Supertig_id, Forb > fp )
{
	list< pair< Supertig_id, Forb > >::iterator Iteli;
	Iteli = find( npl.begin(), npl.end(), fp );
	list< pair< Supertig_id, Forb > > al_npl;
	while ( Iteli != npl.end() ) {
		++Iteli;
		if ( Iteli == npl.end() )
			break;
		if ( *Iteli != tp ) {
			list< pair< Supertig_id, Forb > >::iterator alite = Iteli;
			Iteli = find( alite, npl.end(), fp );
			
		} else {
			al_npl.insert( al_npl.end(), npl.begin(), Iteli );
			al_npl.push_back( make_pair( id, tp.second ) );
			++Iteli;
			if(Iteli != npl.end())
				al_npl.insert( al_npl.end(), Iteli, npl.end() );

			npl = al_npl;
			al_npl.clear();
			Iteli = find( npl.begin(), npl.end(), fp );
		}
	}

	list< pair< Supertig_id, Forb > >::reverse_iterator Riteli;
	Riteli = find( npl.rbegin(), npl.rend(), reversepht( fp ) );

	while( Riteli != npl.rend() ) {
		++Riteli;
		if ( Riteli == npl.rend() )
			break;
		if ( *Riteli != reversepht( tp ) ) {
			list< pair< Supertig_id, Forb > >::reverse_iterator alrite = Riteli;
			Riteli = find( Riteli, npl.rend(), reversepht( fp ) );
		} else {
			al_npl.insert( al_npl.end(), npl.rbegin(), Riteli );
			al_npl.push_back( make_pair( id, reverseforb( tp.second ) ) );
			++Riteli;
			if ( Riteli != npl.rend() )
				al_npl.insert(al_npl.end(), Riteli, npl.rend());

			al_npl.reverse();
			npl = al_npl;
			al_npl.clear();
			Riteli = find( npl.rbegin(), npl.rend(), reversepht( fp ) );
		}
	}

}

void path_replace_subpath( vector< list< pair< Supertig_id, Forb > > > &pl, list< pair< Supertig_id, Forb > > &subpath, Supertig_id id )
{
	size_t vesize = pl.size();
	for ( size_t i = 0; i < pl.size(); ++i ) {
		path_replace_subpath_t( pl[i], subpath, id );
	}
}

void path_replace_subpath_t( list< pair< Supertig_id, Forb > > &npl, list< pair< Supertig_id, Forb > > &subpath, Supertig_id id )
{

	pair< Supertig_id, Forb > fp = subpath.front();
	list< pair< Supertig_id, Forb > >::iterator Iteli;
	Iteli = find( npl.begin(), npl.end(), fp );
	list< pair< Supertig_id, Forb > > al_npl;
	while ( Iteli != npl.end() ) {
	
		list< pair< Supertig_id, Forb > >::iterator markite = Iteli;
		list< pair< Supertig_id, Forb > >::iterator subite;
		int tag = 0;
		for ( subite = subpath.begin(); subite != subpath.end(); ++subite ) {
			if ( Iteli == npl.end() ) {
			
				break;
			}
			if ( *Iteli != *subite ) {
				tag = 1;
				break;
			}
			++Iteli;
			
		}
		
	
		if ( tag == 0 ) {

			al_npl.insert( al_npl.end(), npl.begin(), markite );
			
			al_npl.push_back( make_pair( id, 0 ) );
		
			if(Iteli != npl.end())
				al_npl.insert( al_npl.end(), Iteli, npl.end() );

			npl = al_npl;
		
			al_npl.clear();
			Iteli = find( npl.begin(), npl.end(), fp );
		} else {
			Iteli = find( Iteli, npl.end(), fp );  
			
		}
		
	}

	pair< Supertig_id, Forb > bp = subpath.back();
	Iteli = find( npl.begin(), npl.end(), reversepht( bp ) );

	while ( Iteli != npl.end() ) {
	
		list< pair< Supertig_id, Forb > >::iterator markite = Iteli;
		list< pair< Supertig_id, Forb > >::reverse_iterator subite;
		int tag = 0;
		for ( subite = subpath.rbegin(); subite != subpath.rend(); ++subite ) {
			if ( Iteli == npl.end() ) {
			
				break;
			}
			if ( *Iteli != reversepht( *subite ) ) {
				tag = 1;
				break;
			}
			++Iteli;
			
		}
	

		if ( tag == 0 ) {
			al_npl.insert( al_npl.end(), npl.begin(), markite );
			al_npl.push_back( make_pair( id, 1 ) );
			
			if(Iteli != npl.end())
				al_npl.insert( al_npl.end(), Iteli, npl.end() );

			npl = al_npl;
			al_npl.clear();
			Iteli = find( npl.begin(), npl.end(), reversepht( bp ) );
		} else {
			Iteli = find( Iteli, npl.end(), reversepht( bp ) );
		}
		
	}

	///////////////////////////substract the front part of pathve, may be identical to the part of subpath////////////////
	fp = npl.front();
	Iteli = find( subpath.begin(), subpath.end(), fp );
	if ( Iteli != subpath.end() ) {
		al_npl.push_back( make_pair( id, 0 ) );
		list< pair< Supertig_id, Forb > >::iterator subite;
		int tag = 0;
		for ( subite = npl.begin(); subite != npl.end(); ++subite ) {

			if ( Iteli == subpath.end() )
				break;

			if ( *Iteli != *subite ) {
				tag = 1;
				break;
			}

			++Iteli;

		}

		if ( tag == 0 ) {
			if ( subite != npl.end() ) {
				al_npl.insert( al_npl.end(), subite, npl.end() );
			}
			npl = al_npl;
			al_npl.clear();
		}
	}

	fp = reversepht( fp );
	list< pair< Supertig_id, Forb > >::reverse_iterator rite;
	rite = find( subpath.rbegin(), subpath.rend(), fp );
	if ( rite != subpath.rend() ) {
		al_npl.push_back( make_pair( id, 1 ) );
		list< pair< Supertig_id, Forb > >::iterator subite;
		int tag = 0;
		for ( subite = npl.begin(); subite != npl.end(); ++subite ) {

			if ( rite == subpath.rend() )
				break;

			if ( reversepht(*rite) != *subite ) {
				tag = 1;
				break;
			}

			++rite;

		}

		if ( tag == 0 ) {
			if ( subite != npl.end() ) {
				al_npl.insert( al_npl.end(), subite, npl.end() );
			}
			npl = al_npl;
			al_npl.clear();
		}
	}


}

void path_replace_tig( vector< list< pair< Supertig_id, Forb > > > &pl, Supertig_id id, list< pair< Supertig_id, Forb > > &subpath )
{
	size_t vesize = pl.size();
	for ( size_t i = 0; i < pl.size(); ++i ) {
		path_replace_tig_t( pl[i], id, subpath );
	}
}

bool path_replace_tig_t( list< pair< Supertig_id, Forb > > &npl, Supertig_id id, list< pair< Supertig_id, Forb > > &subpath )
{

	int tag = 0;
	pair< Supertig_id, Forb > fp = make_pair( id, 0 );
	list< pair< Supertig_id, Forb > >::iterator Iteli;
	Iteli = find( npl.begin(), npl.end(), fp );
	list< pair< Supertig_id, Forb > > al_npl;
	while ( Iteli != npl.end() ) {
		al_npl.insert( al_npl.end(), npl.begin(), Iteli );
		
		al_npl.insert( al_npl.end(), subpath.begin(), subpath.end() );
		tag = 1;

		++Iteli;
		
		if(Iteli != npl.end())
			al_npl.insert( al_npl.end(), Iteli, npl.end() );

		npl = al_npl;
		al_npl.clear();
		Iteli = find( npl.begin(), npl.end(), fp );
		
	}

	fp = make_pair( id, 1 );
	Iteli = find( npl.begin(), npl.end(), fp );
	list< pair< Supertig_id, Forb > > revsubpath = reverseplist( subpath );
	
	while ( Iteli != npl.end() ) {
		al_npl.insert( al_npl.end(), npl.begin(), Iteli );
		
		al_npl.insert( al_npl.end(), revsubpath.begin(), revsubpath.end() );
		tag = 1;

		++Iteli;
		
		if(Iteli != npl.end())
			al_npl.insert( al_npl.end(), Iteli, npl.end() );

		npl = al_npl;
		al_npl.clear();
		Iteli = find( npl.begin(), npl.end(), fp );
		
	}

	if ( tag == 1 )
		return true;
	else
		return false;
}

void path_replace_break_tiglist( vector< list< pair< Supertig_id, Forb > > > &pl, Supertig_id id, list< pair< Supertig_id, Forb > > &subpath )
{
	size_t vesize = pl.size();
	vector< list< pair< Supertig_id, Forb > > > al_pl;
	for ( size_t i = 0; i < vesize; ++i ) {
		vector< list< pair< Supertig_id, Forb > > > tplve;
		if ( path_replace_break_tiglist_t( pl[i], id, subpath, tplve ) ) {
			al_pl.insert( al_pl.end(), tplve.begin(), tplve.end() );
		} else {
			al_pl.push_back( pl[i] );
		}
	}
}

bool path_replace_break_tiglist_t( list< pair< Supertig_id, Forb > > &npl, Supertig_id id, list< pair< Supertig_id, Forb > > &subpath, vector< list< pair< Supertig_id, Forb > > > &plve )
{
	if ( (int)subpath.size() == 1 ) {
		path_replace_tig_t( npl, id, subpath );
		return false;
	}

	if ( path_replace_tig_t( npl, id, subpath ) ) {
		vector< list< pair< Supertig_id, Forb > > > tplve;
		path_replace_break_tiglist_t_t( npl, subpath, tplve );

		list< pair< Supertig_id, Forb > > revsubpath = reverseplist( subpath );
		for ( size_t i = 0; i < tplve.size(); ++i ) {
			vector< list< pair< Supertig_id, Forb > > > al_tplve;
			path_replace_break_tiglist_t_t( tplve[i], revsubpath, al_tplve );
			plve.insert( plve.end(), al_tplve.begin(), al_tplve.end() );
		}
		return true;
	} else
		return false;
}

bool path_replace_break_tiglist_t_t( list< pair< Supertig_id, Forb > > &npl, list< pair< Supertig_id, Forb > > &subpath, vector< list< pair< Supertig_id, Forb > > > &plve )
{

	list< pair< Supertig_id, Forb > >::iterator Iteli;
	list< pair< Supertig_id, Forb > >::iterator start_ite = npl.begin();
	Iteli = find( npl.begin(), npl.end(), subpath.front() );
	while ( Iteli != npl.end() ) {
		++Iteli;
		list< pair< Supertig_id, Forb > > alpl;
		alpl.insert( alpl.end(), start_ite, Iteli );
		plve.push_back( alpl );
		alpl.clear();

		if ( Iteli == npl.end() ) {
			cerr << "Error in path_replace_break_tiglist_t" <<endl;
			break;
		}
		while ( *Iteli != subpath.back() ) {
			++Iteli;
			if ( Iteli == npl.end() ) {
				cerr << "Error in path_replace_break_tiglist_t" <<endl;
				break;
			}
		}
		if ( Iteli == npl.end() ) {
			cerr << "Error in path_replace_break_tiglist_t" <<endl;
			break;
		}
		start_ite = Iteli;
		Iteli = find( Iteli, npl.end(), subpath.front() );
	}
	list< pair< Supertig_id, Forb > > alpl;
	alpl.insert( alpl.end(), start_ite, npl.end() );
	plve.push_back( alpl );

	if ( (int)plve.size() > 1 )
		return true;
	else 
		return false;
}

void trans_bulb_to_series( Supertig_id id, subgraph &graph_t, Supertig_bank &tig_bank )
{
	if ( !tig_bank.Supertig_Map[id].bubble )
		return;

	
	multimap< pair< int, int >, size_t > pos_map;
	for ( size_t i = 0; i < tig_bank.Supertig_Map[id].Tig_Ve[0].size(); ++i ) {
		
		pos_map.insert( make_pair( tig_bank.Supertig_Map[id].Tig_P_Ve[0][i], i ) );
		
	}

	Supertig n_tig;
	n_tig = tig_bank.Supertig_Map[id];
	n_tig.bubble = false;
	n_tig.series = true;
	n_tig.Tig_F_Ve.clear();
	n_tig.Tig_P_Ve.clear();
	n_tig.Tig_Ve.clear();
	multimap< pair< int, int >, size_t >::iterator Ite;
	for ( Ite = pos_map.begin(); Ite != pos_map.end(); ++Ite ) {
		vector< Supertig_id > singleidve;
		vector< Forb > singlefbve;
		Supertig_id tid = tig_bank.Supertig_Map[id].Tig_Ve[0][Ite->second];
		Forb tfb = tig_bank.Supertig_Map[id].Tig_F_Ve[0][Ite->second];
		if ( tig_bank.Basic_tig_set.find( tid ) != tig_bank.Basic_tig_set.end() ) {
			singleidve.push_back( tid );
			singlefbve.push_back( tfb );
		} else {
			tid = tig_bank.Supertig_Map[tid].Tig_Ve[0][0];
			singleidve.push_back( tid );
			if ( tfb == 0 )
				tfb = tig_bank.Supertig_Map[tid].Tig_F_Ve[0][0];
			else
				tfb = reverseforb( tig_bank.Supertig_Map[tid].Tig_F_Ve[0][0] );
			singlefbve.push_back( tfb );
		}
		n_tig.Tig_Ve.push_back( singleidve );
		n_tig.Tig_F_Ve.push_back( singlefbve );
		vector< pair< int, int > > singleposve;
		singleposve.push_back( Ite->first );
		n_tig.Tig_P_Ve.push_back( singleposve );

	}
	
	tig_bank.Supertig_Map[id] = n_tig;

	tig_bank.newly_transfered_tig.insert( id );
}

