#ifndef GRAPH_SUPTIG_ASSBL_H
#define GRAPH_SUPTIG_ASSBL_H

#include "Graph_subgraph.h"
#include "Graph_ovlk_rpl.h"
#include "poperate.h"
#include "Graph_Scf_rpl.h"


void supertig_assble(Supertig_id n_id,
					 Supertig & n_tig, 
					 subgraph &graph_t, 
					 Supertig_bank &tig_bank );

// assemble the supertig in parallel, i.e. bubble
Supertig_id supertig_in_para_ass( vector< Supertig_id > & bubble, subgraph &graph_t, Supertig_bank &tig_bank );

// assemble the supertig in series
Supertig_id supertig_in_seri_ass(  vector< pair< Supertig_id, Forb > > & series, subgraph &graph_t, Supertig_bank &tig_bank );

Supertig_id supertig_in_seri_ass(  list< pair< Supertig_id, Forb > > & series, subgraph &graph_t, Supertig_bank &tig_bank );

bool side_link_check_bb( pair< Supertig_id, Forb > link_node,
						 vector< Supertig_id > & bubble, 
						 vector< Forb > &Forb_ve, 
						 map< Supertig_id, int > &ovlen_map,
						 subgraph &graph_t );

bool side_link_check_bb( pair< Supertig_id, Forb > link_node,
						 vector< Supertig_id > & bubble,
						 map< Supertig_id, int > &ovlen_map,
						 subgraph &graph_t );

bool side_link_check_rev_bb( pair< Supertig_id, Forb > link_node,
						 int ovlen,
						 vector< Supertig_id > & bubble, 
						 vector< Forb > &Forb_ve, 
						 map< Supertig_id, int > &ovlen_map,
						 subgraph &graph_t );

bool side_link_check_rev_bb( pair< Supertig_id, Forb > link_node,
							int ovlen,
						 vector< Supertig_id > & bubble, 
						 map< Supertig_id, int > &ovlen_map,
						 subgraph &graph_t );

void side_link_check_se( pair< Supertig_id, Forb > se_brink_node,
						 vector< pair< pair< Supertig_id, Forb >, int > > &linked_nodes,
						 subgraph &graph_t );

bool supertig_in_seri_form( Supertig &n_tig, vector< pair< Supertig_id, Forb > > & series, subgraph &graph_t, Supertig_bank &tig_bank );
bool supertig_in_seri_form( Supertig &n_tig, vector< pair< Supertig_id, Forb > > & series, map< Supertig_id, Supertig_Overlap_Link > &ovlkmap, Supertig_bank &tig_bank );
// here subtig can be -1 i.e. bulb tig contained in Structed tig.
bool supertig_in_seri_form_II( Supertig &n_tig, vector< pair< Supertig_id, Forb > > & series, vector< int > &ovlen, map< size_t, int > &bulblen, Supertig_bank &tig_bank );

int get_ovlen_fr_cnct_nodes( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, subgraph &graph_t );
int get_ovlen_fr_cnct_nodes( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, map< Supertig_id, Supertig_Overlap_Link > &ovlkmap );

void get_path_fr_ovlk( vector< list< pair< Supertig_id, Forb > > > &ve, subgraph &graph_t, Supertig_id id );

int path_elen_get( list< pair< Supertig_id, Forb > > &path, subgraph &graph_t, Supertig_bank &tig_bank );

int path_elengap_get( list< pair< Supertig_id, Forb > > &path, subgraph &graph_t, Supertig_bank &tig_bank );

void path_replace_in_para( vector< pair< Supertig_id, Forb > > &bubble, vector< list< pair< Supertig_id, Forb > > > &path, Supertig_id id );

void path_replace_single_t( pair< Supertig_id, Forb > tp, list< pair< Supertig_id, Forb > > &path, Supertig_id id );

void path_replace_spe( pair< Supertig_id, Forb > tp, vector< list< pair< Supertig_id, Forb > > > &path, Supertig_id id, pair< Supertig_id, Forb > fp );

void path_replace_spe_t( pair< Supertig_id, Forb > tp, list< pair< Supertig_id, Forb > > &path, Supertig_id id, pair< Supertig_id, Forb > fp );

// replace the subpath of the path with a new node i.e. new tig
void path_replace_subpath( vector< list< pair< Supertig_id, Forb > > > &pl, list< pair< Supertig_id, Forb > > &subpath, Supertig_id id );

void path_replace_subpath_t( list< pair< Supertig_id, Forb > > &pl, list< pair< Supertig_id, Forb > > &subpath, Supertig_id id );

// replace the node of the path with a subpath.
void path_replace_tig( vector< list< pair< Supertig_id, Forb > > > &pl, Supertig_id id, list< pair< Supertig_id, Forb > > &subpath );

bool path_replace_tig_t( list< pair< Supertig_id, Forb > > &pl, Supertig_id id, list< pair< Supertig_id, Forb > > &subpath );

void path_replace_break_tiglist( vector< list< pair< Supertig_id, Forb > > > &pl, Supertig_id id, list< pair< Supertig_id, Forb > > &subpath );
bool path_replace_break_tiglist_t( list< pair< Supertig_id, Forb > > &pl, Supertig_id id, list< pair< Supertig_id, Forb > > &subpath, vector< list< pair< Supertig_id, Forb > > > &plve );
bool path_replace_break_tiglist_t_t( list< pair< Supertig_id, Forb > > &pl, list< pair< Supertig_id, Forb > > &subpath, vector< list< pair< Supertig_id, Forb > > > &plve );

//  get the ovlen indirectly via getting their subtigs' over link length.
int get_ovlen_from_lk_tig( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, Supertig_bank &tig_bank );
int get_ovlen_via_basic_tig( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, Supertig_bank &tig_bank );

void trans_bulb_to_series( Supertig_id n_id, subgraph &graph_t, Supertig_bank &tig_bank );

#endif
