#include "Graph_bestmatepath.h"

void getbestmatepath( subgraph &graph_t, Supertig_bank &tig_bank )
{
	set< Supertig_id > formeractive = graph_t.active_tig;
	set< Supertig_id >::iterator Ite;
	for ( Ite = formeractive.begin(); Ite != formeractive.end(); ++Ite ) {
	
		if ( tig_bank.Supertig_Map[*Ite].single_tig ) {

			continue;
		}
		unpack_tig( *Ite, graph_t, tig_bank );
	}

	
	
	set< Supertig_id > single_series;
	exact_single_allseries( single_series, graph_t.active_tig, graph_t.scf_s.superpath, tig_bank );

	
	set< Supertig_id > used_basetig;
	exact_used_basetig( graph_t.active_tig, used_basetig, graph_t, tig_bank );


	
	map< int, Supertig_id > seed_rank;
	set< Supertig_id > non_contra;
	getMateseedrankAndNoncontra( graph_t.active_tig, single_series, seed_rank, non_contra, tig_bank );


	vector< list< pair< Supertig_id, Forb > > > bestpath;
	bestpath_1r( seed_rank, graph_t.scf_s.superpath, bestpath, non_contra, tig_bank, graph_t );

	
	cn_ov_path( bestpath );

	
	
	vector< list< pair< Supertig_id, Forb > > > remainpath;

	getremainpath( bestpath, graph_t.scf_s.superpath, remainpath, single_series );

	

	if ( !remainpath.empty() ) {
		
		vector< list< pair< Supertig_id, Forb > > > simpath;
		getspfrp( remainpath, simpath, graph_t, tig_bank, single_series );


		bestpath.insert( bestpath.end(), simpath.begin(), simpath.end() );
	}

	
	getbestpath2( bestpath, used_basetig, tig_bank );


	set< Supertig_id > single_allseries;
	
	if ( !single_series.empty() ) {
		
		vector< list< pair< Supertig_id, Forb > > > selectpve;
		unpack_left_single( single_series, single_allseries, selectpve, used_basetig, tig_bank );

		

		if ( !selectpve.empty() ) {
			bestpath.insert( bestpath.end(), selectpve.begin(), selectpve.end() );
		}
	}

	vector< list< pair< Supertig_id, Forb > > > bestpath_2;
	bestpath_2 = bestpath;
	bestpath.clear();

	if ( !single_allseries.empty() ){

		vector< list< pair< Supertig_id, Forb > > > pathfromseries;
		getpathfromseries( pathfromseries, single_allseries, tig_bank );

		bestpath_2.insert( bestpath_2.end(), pathfromseries.begin(), pathfromseries.end() );
		reduceredunpl_t( bestpath_2 );


	}
	cn_ov_path( bestpath_2 );

	
	vector< list< double > > mate_cover_in_path;
	get_mcip( bestpath_2, mate_cover_in_path, tig_bank );

	
	map< Supertig_id, int > repeat;
	getrepeat( bestpath_2, repeat );
	
	
	
	int popsize = 0;
	
	popsize = check_week_link_side( bestpath_2, mate_cover_in_path, repeat );

	

	mate_cover_in_path.clear();
	get_mcip( bestpath_2, mate_cover_in_path, tig_bank );


	
	

	repeat.clear();
	getrepeat( bestpath_2, repeat );
	


	while ( popsize > 0 ) {
		

		
		popsize = check_week_link_side( bestpath_2, mate_cover_in_path, repeat );

		

		mate_cover_in_path.clear();
		get_mcip( bestpath_2, mate_cover_in_path, tig_bank );



		repeat.clear();
		getrepeat( bestpath_2, repeat );

		if ( repeat.empty() ) {
			
			break;
		}
	}

	
	mate_cover_in_path.clear();
	get_mcip_2( bestpath_2, mate_cover_in_path, tig_bank );
	

	
	vector< list< pair< Supertig_id, Forb > > > con_pathve;
	vector< vector< list< pair< Supertig_id, Forb > > > > broken_pathve;
	vector< vector< pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > > > broken_p_ve;
	vector< vector< int > > broken_gap_ve;
	check_week_link_middle( bestpath_2, mate_cover_in_path, repeat, con_pathve, broken_pathve, broken_p_ve, broken_gap_ve, tig_bank );


	set< Supertig_id > single_bs;
	getsingle_bs( bestpath_2, single_bs, tig_bank );

	
	finalpath( con_pathve, broken_pathve, broken_p_ve, broken_gap_ve, single_bs, tig_bank );



}

void unpack_tig( Supertig_id tig_id, subgraph &graph_t, Supertig_bank &tig_bank )
{

	list< pair< Supertig_id, Forb > > path;
	if ( !unpack_series_t( tig_id, 0, tig_bank, path ) ) {
	//	return false;
	}

	vector< pair< Supertig_id, Forb > > tig_path;
	if ( !unp_merge_subpath( tig_id, path, tig_path, graph_t, tig_bank ) ) {
	
		recons_suptig( tig_id, graph_t, tig_bank, path );
	
	} 


}

void exact_single_allseries( set< Supertig_id > &single_s, 
							set< Supertig_id > &active_id,
							vector< list< pair< Supertig_id, Forb > > > superpath,
							Supertig_bank &tig_bank )
{
	set< Supertig_id > all_id;
	for ( size_t i = 0; i < superpath.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Itel;
		for ( Itel = superpath[i].begin(); Itel != superpath[i].end(); ++Itel ) {
			all_id.insert( Itel->first );
		}
	}
	set< Supertig_id >::iterator Ites;
	for ( Ites = active_id.begin(); Ites != active_id.end(); ++Ites ) {
		if ( all_id.find( *Ites ) == all_id.end() ) {
			if ( !tig_bank.Supertig_Map[*Ites].single_tig )
				single_s.insert( *Ites );
		}
	}
}


void exact_used_basetig( set< Supertig_id > &active_id, set< Supertig_id > &used_basetig, subgraph &graph_t, Supertig_bank &tig_bank )
{
	set< Supertig_id >::iterator Ite;
	for ( Ite = active_id.begin(); Ite != active_id.end(); ++Ite ) {
	
		if ( tig_bank.Supertig_Map[*Ite].single_tig || tig_bank.Supertig_Map[*Ite].allseries ) {
		
			set< Supertig_id > nset;
			tig_bank.Supertig_Map[*Ite].gettigset( nset );
			used_basetig.insert( nset.begin(), nset.end() );
		} else {
			if ( tig_bank.Supertig_Map[*Ite].series && tig_bank.Supertig_Map[*Ite].bulbin ) {
				for ( size_t i = 0; i < tig_bank.Supertig_Map[*Ite].Tig_Ve.size(); ++i ) {
					Supertig_id tid = tig_bank.Supertig_Map[*Ite].Tig_Ve[i][0];
					if ( !tig_bank.Supertig_Map[tid].bubble ) {
					
						set< Supertig_id > nset;
						tig_bank.Supertig_Map[tid].gettigset( nset );
						used_basetig.insert( nset.begin(), nset.end() );
					}
				}
			}
		}
	}
}

void getnoncontra( set< Supertig_id > &activeid, set< Supertig_id > &non_contra, Supertig_bank &tig_bank )
{
	set< Supertig_id >::iterator Ite;
	for ( Ite = activeid.begin(); Ite != activeid.end(); ++Ite ) {
		if ( tig_bank.Supertig_Map[*Ite].allseries ) {
			non_contra.insert( *Ite );
			continue;
		}
		if ( tig_bank.Supertig_Map[*Ite].single_tig ) {
		
				non_contra.insert( *Ite );

		}
	}
}

void getmateseedrank( set< Supertig_id > &active_id, 
					 set< Supertig_id > &single_series,                // not in the super path, i.e. a separate node.
					 map< double, multimap< int, Supertig_id, greater<int> >, greater< double > > &seed_rank,
					 Supertig_bank &tig_bank )
{
	set< Supertig_id >::iterator Ite;
	for ( Ite = active_id.begin(); Ite != active_id.end(); ++Ite ) {
		if ( single_series.find ( *Ite ) != single_series.end() )
			continue;

		if ( tig_bank.Supertig_Map[*Ite].allseries || tig_bank.Supertig_Map[*Ite].single_tig ) {
			double conf = calculate_rd_mate_conf( *Ite, tig_bank );
			if ( conf > 0 ) {
				int length = tig_bank.Supertig_Map[*Ite].length;
				seed_rank[conf].insert( make_pair( length, *Ite ) );
			}
		}
	}
}

void getMateseedrankAndNoncontra( set< Supertig_id > &active_id, 
								set< Supertig_id > &single_series,                // not in the super path, i.e. a separate node.
								map< int, Supertig_id > &seed_rank,
								set< Supertig_id > &non_contra,
								Supertig_bank &tig_bank )
{
	
	set< Supertig_id >::iterator Ite;
	multimap< double, Supertig_id > conf_tig_map;
	map< Supertig_id, double > tig_conf_map;
	multimap< int, Supertig_id > len_tig_map;
	set< double, greater<double> > conf_rank;
	set< int, greater<int> > len_rank;
	set< Supertig_id > cid;
	for ( Ite = active_id.begin(); Ite != active_id.end(); ++Ite ) {
		if ( single_series.find ( *Ite ) != single_series.end() )
			continue;
		
		double conf = calculate_rd_mate_conf( *Ite, tig_bank );
		if ( conf > 0 ) {
			conf_tig_map.insert( make_pair( conf, *Ite ) );
			conf_rank.insert( conf );
			int length = tig_bank.Supertig_Map[*Ite].length;
			len_tig_map.insert( make_pair( length, *Ite ) );
			len_rank.insert( length );
			cid.insert( *Ite );
			tig_conf_map.insert( make_pair( *Ite, conf ) );
			
		} else {
			non_contra.insert( *Ite );
		}
		

	
	}

	map< Supertig_id, int > tig_conf_rank;
	map< Supertig_id, int > tig_len_rank;

	set< double, greater<double> >::iterator Itecr;
	int rank = 1;
	for ( Itecr = conf_rank.begin(); Itecr != conf_rank.end(); ++Itecr ) {
		int nn = 0;
		double conf = *Itecr;
		multimap< double, Supertig_id >::iterator Item;
		for ( Item = conf_tig_map.lower_bound(conf); Item != conf_tig_map.upper_bound(conf); ++Item ) {
			tig_conf_rank.insert( make_pair( Item->second, rank ) );
			nn += 1;
		}
		rank += nn;
	}
	set< int, greater<int> >::iterator Itelr;
	rank = 1;
	for ( Itelr = len_rank.begin(); Itelr != len_rank.end(); ++Itelr ) {
		int len = *Itelr;
		int nn = 0;
		multimap< int, Supertig_id >::iterator Item;
		for ( Item = len_tig_map.lower_bound(len); Item != len_tig_map.upper_bound(len); ++Item ) {
			tig_len_rank.insert( make_pair( Item->second, rank ) );
			nn += 1;
		}
		rank += nn;
	}

	
	int idsize = (int)cid.size();
	set< Supertig_id >::iterator Iteid;
	map< int, multimap< pair< double, double >, Supertig_id > > rank1st_map;        //   < rank(rank_conf+rank_len), < pair<rank_conf(%), rank_len(%)>, id > > 
	for ( Iteid = cid.begin(); Iteid != cid.end(); ++Iteid ) {
		int trank = tig_conf_rank[*Iteid] + tig_len_rank[*Iteid];
		double t_conf_rank = (double)tig_conf_rank[*Iteid] / idsize;
		double t_len_rank = (double)tig_len_rank[*Iteid] / idsize;
		rank1st_map[trank].insert( make_pair( make_pair( t_conf_rank, t_len_rank ), *Iteid  ) );
		
	}

	
	map< int, multimap< pair< double, double >, Supertig_id > >::iterator Iter1;
	rank = 1;
	for ( Iter1 = rank1st_map.begin(); Iter1 != rank1st_map.end(); ++Iter1 ) {
		multimap< pair< double, double >, Supertig_id >::iterator Item; 
		for ( Item = Iter1->second.begin(); Item != Iter1->second.end(); ++Item ) {
			
			if ( !tig_bank.Supertig_Map[Item->second].allseries && !tig_bank.Supertig_Map[Item->second].single_tig ) {
				if ( checkbigbulb( Item->second, tig_bank ) ) {
					
					continue;
				}
			}
			if ( Item->first.first < 0.1 && tig_conf_map[Item->second] >= 10 && tig_bank.Supertig_Map[Item->second].length < 1.5*tig_bank.tig_len ) {
				
			} else {
				seed_rank.insert( make_pair( rank, Item->second ) );
				non_contra.insert( Item->second );
				rank += 1;
			}
		}
	}



	
}

bool checkbigbulb( Supertig_id tig_id, Supertig_bank &tig_bank ) 
{
	if ( tig_bank.Supertig_Map[tig_id].bubble )
		return true;
	if ( tig_bank.Supertig_Map[tig_id].bulbin ) {
		int bulblen = 0;
		int serilen = 0;
		for ( size_t i = 0; i < tig_bank.Supertig_Map[tig_id].Tig_Ve.size(); ++i ) {
			Supertig_id nid = tig_bank.Supertig_Map[tig_id].Tig_Ve[i][0];
			if ( tig_bank.Supertig_Map[nid].bubble ) {
				bulblen += ( tig_bank.Supertig_Map[nid].length );
			} else
				serilen += ( tig_bank.Supertig_Map[nid].length );
		}
		if ( serilen < 2 * tig_bank.tig_len || serilen < bulblen )
			return true;
	}

	return false;
}

double calculate_rd_mate_conf( Supertig_id tig_id, Supertig_bank &tig_bank )
{
	if ( tig_bank.Pair_Scaffold_map.find( tig_id ) == tig_bank.Pair_Scaffold_map.end() )
		return 0;

	double conf_t= 0;
	map< Supertig_id, vector< Scaffold_gap_id > >::iterator Ite;
	for ( Ite = tig_bank.Pair_Scaffold_map[tig_id].begin(); Ite != tig_bank.Pair_Scaffold_map[tig_id].end(); ++Ite ) {
		if ( tig_bank.Basic_tig_set.find( Ite->first ) == tig_bank.Basic_tig_set.end() )
			break;

		for ( size_t i = 0; i < Ite->second.size(); ++i ) {
			conf_t += tig_bank.Scaffold_map[Ite->second[i]].conf;
		}
	}

	return conf_t;

}

void bestpath_1r( map< int, Supertig_id > &seed_rank,
				 vector< list< pair< Supertig_id, Forb > > > &superpath,
				 vector< list< pair< Supertig_id, Forb > > > &bestpath,
				 set< Supertig_id > &non_contra,
				 Supertig_bank &tig_bank,
				 subgraph &graph_t )
{
	map< int, Supertig_id >::iterator Ite;

	map< Supertig_id, size_t > id_bepath_map;
	map< Supertig_id, vector< size_t > > id_supath_map;

	for ( size_t i = 0; i < graph_t.scf_s.superpath.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Itel;
		for ( Itel = graph_t.scf_s.superpath[i].begin(); Itel != graph_t.scf_s.superpath[i].end(); ++Itel ) {
			Supertig_id tid = Itel->first;
		
				id_supath_map[tid].push_back( i );
		
		}
	}

	for ( Ite = seed_rank.begin(); Ite != seed_rank.end(); ++Ite ) {
	
			if ( id_bepath_map.find( Ite->second ) == id_bepath_map.end() ) {
				//  start a new best path.
			

				if ( id_supath_map.find( Ite->second ) != id_supath_map.end() ) {
				
					list< pair< Supertig_id, Forb > > sudopath;
					PathIter iter_bepath = sudopath.end();
					
					list< pair< Supertig_id, Forb > > addpath;

					getbestpath1( make_pair( Ite->second, 0 ), iter_bepath, sudopath, id_supath_map[Ite->second], graph_t.scf_s.superpath, addpath, id_bepath_map, bestpath, tig_bank );

					list< pair< Supertig_id, Forb > > addpath_2;
					getbestpath1( make_pair( Ite->second, 1 ), iter_bepath, sudopath, id_supath_map[Ite->second], graph_t.scf_s.superpath, addpath_2, id_bepath_map, bestpath, tig_bank );
					
					if ( !addpath.empty() ) {
					
						addpath.push_front( make_pair( Ite->second, 0 ) );
						pair< Supertig_id, Forb > lasp = addpath.back();
						if ( id_bepath_map.find( lasp.first ) != id_bepath_map.end() ) {
							size_t h = id_bepath_map[lasp.first];
							PathIter beiter = find( bestpath[h].begin(), bestpath[h].end(), lasp );
							if ( beiter != bestpath[h].end() ) {
								++beiter;
								addpath.insert( addpath.end(), beiter, bestpath[h].end() );
							} else {
								list< pair< Supertig_id, Forb > > revbepath = reverseplist( bestpath[h] );
								beiter = find( revbepath.begin(), revbepath.end(), lasp );
								if ( beiter != revbepath.end() ) {
									++beiter;
									addpath.insert( addpath.end(), beiter, revbepath.end() );
								} else {
									cout<<"error why 2"<<endl;   exit(0);
								}
							}
						}
					
						if ( !addpath_2.empty() ) {
							addpath_2 = reverseplist( addpath_2 );
						
							addpath.insert( addpath.begin(), addpath_2.begin(), addpath_2.end() );
							pair< Supertig_id, Forb > lasp = addpath.front();
							if ( id_bepath_map.find( lasp.first ) != id_bepath_map.end() ) {
								size_t h = id_bepath_map[lasp.first];
								PathIter beiter = find( bestpath[h].begin(), bestpath[h].end(), lasp );
								if ( beiter != bestpath[h].end() ) {
									
									addpath.insert( addpath.begin(), bestpath[h].begin(), beiter );
								} else {
									list< pair< Supertig_id, Forb > > revbepath2 = reverseplist( bestpath[h] );
									beiter = find( revbepath2.begin(), revbepath2.end(), lasp );
									if ( beiter != revbepath2.end() ) {
										
										addpath.insert( addpath.begin(), revbepath2.begin(), beiter );
									} else {
										cout<<"error why 2"<<endl;   exit(0);
									}
								}
							}
						
						}
						bestpath.push_back( addpath );
						size_t besize = bestpath.size();
						PathIter tite = addpath.begin();
						for ( ; tite != addpath.end(); ++tite ) {
						
							if ( non_contra.find( tite->first ) != non_contra.end() )
								id_bepath_map[tite->first] = besize-1;
						}
					} else if ( !addpath_2.empty() ) {
					
						addpath_2.push_front( make_pair( Ite->second, 1 ) );
						pair< Supertig_id, Forb > lasp = addpath_2.back();
						if ( id_bepath_map.find( lasp.first ) != id_bepath_map.end() ) {
							size_t h = id_bepath_map[lasp.first];
							PathIter beiter = find( bestpath[h].begin(), bestpath[h].end(), lasp );
							if ( beiter != bestpath[h].end() ) {
								++beiter;
								addpath_2.insert( addpath_2.end(), beiter, bestpath[h].end() );
							} else {
								list< pair< Supertig_id, Forb > > revbepath = reverseplist( bestpath[h] );
								beiter = find( revbepath.begin(), revbepath.end(), lasp );
								if ( beiter != revbepath.end() ) {
									++beiter;
									addpath_2.insert( addpath_2.end(), beiter, revbepath.end() );
								} else {
									cout<<"error why 2"<<endl;   exit(0);
								}
							}
						}
					
						bestpath.push_back( addpath_2 );
						size_t besize = bestpath.size();
						PathIter tite = addpath_2.begin();
						for ( ; tite != addpath_2.end(); ++tite ) {
							if ( non_contra.find( tite->first ) != non_contra.end() )
						
								id_bepath_map[tite->first] = besize-1;
						}
					}

					
				}


			} else {
				//////id_bepath_map.find( Ite->second ) != id_bepath_map.end()
			
				if ( id_supath_map.find( Ite->second ) != id_supath_map.end() ) {
					
					size_t k = id_bepath_map[Ite->second];
				
					PathIter iter_bepath = find( bestpath[k].begin(), bestpath[k].end(), make_pair( Ite->second, 0 ) ); 
					if ( iter_bepath != bestpath[k].end() ) {
						list< pair< Supertig_id, Forb > > addpath;

					
						getbestpath1( make_pair( Ite->second, 0 ), iter_bepath, bestpath[k], id_supath_map[Ite->second], graph_t.scf_s.superpath, addpath, id_bepath_map, bestpath, tig_bank );
						
						bool tg = false;
						if ( !addpath.empty() ) {
						
							tg = true;
						
							bestpath[k].insert( bestpath[k].end(), addpath.begin(), addpath.end() );
							pair< Supertig_id, Forb > lasp = bestpath[k].back();
							if ( id_bepath_map.find( lasp.first ) != id_bepath_map.end() ) {
								size_t h = id_bepath_map[lasp.first];
								PathIter beiter = find( bestpath[h].begin(), bestpath[h].end(), lasp );
								if ( beiter != bestpath[h].end() ) {
									++beiter;
									bestpath[k].insert( bestpath[k].end(), beiter, bestpath[h].end() );
								} else {
									list< pair< Supertig_id, Forb > > revbepath = reverseplist( bestpath[h] );
									beiter = find( revbepath.begin(), revbepath.end(), lasp );
									if ( beiter != revbepath.end() ) {
										++beiter;
										bestpath[k].insert( bestpath[k].end(), beiter, revbepath.end() );
									} else {
										cout<<"error why 2"<<endl;   exit(0);
									}
								}
							}
						
						
							
						}

						addpath.clear();
						list< pair< Supertig_id, Forb > > revbepath = reverseplist( bestpath[k] );
						iter_bepath= find( revbepath.begin(), revbepath.end(), make_pair( Ite->second, 1 ) );
						if ( iter_bepath == revbepath.end() ) {
							cout<<"error 3 whiy4 "<<endl;  exit(1);
						}

						
						getbestpath1( make_pair( Ite->second, 1 ), iter_bepath, revbepath, id_supath_map[Ite->second], graph_t.scf_s.superpath, addpath, id_bepath_map, bestpath, tig_bank );
						if ( !addpath.empty() ) {
							tg = true;
							addpath = reverseplist( addpath );
						
							bestpath[k].insert( bestpath[k].begin(), addpath.begin(), addpath.end() );
							pair< Supertig_id, Forb > lasp = bestpath[k].front();
							if ( id_bepath_map.find( lasp.first ) != id_bepath_map.end() ) {
								size_t h = id_bepath_map[lasp.first];
								PathIter beiter = find( bestpath[h].begin(), bestpath[h].end(), lasp );
								if ( beiter != bestpath[h].end() ) {
									
									bestpath[k].insert( bestpath[k].begin(), bestpath[h].begin(), beiter );
								} else {
									list< pair< Supertig_id, Forb > > revbepath2 = reverseplist( bestpath[h] );
									beiter = find( revbepath2.begin(), revbepath2.end(), lasp );
									if ( beiter != revbepath2.end() ) {
										
										bestpath[k].insert( bestpath[k].begin(), revbepath2.begin(), beiter );
									} else {
										cout<<"error why 2"<<endl;   exit(0);
									}
								}
							}
						
						}

						if ( tg ) {
							PathIter tite = bestpath[k].begin();
							for ( ; tite != bestpath[k].end(); ++tite ) {
								if ( non_contra.find( tite->first ) != non_contra.end() )
							
									id_bepath_map[tite->first] = k;
							}
						}

					} else {
						iter_bepath = find( bestpath[k].begin(), bestpath[k].end(), make_pair( Ite->second, 1 ) );
						if ( iter_bepath == bestpath[k].end() ) {
							cout<<"error 333 "<<endl; exit(1);
						}

						list< pair< Supertig_id, Forb > > addpath;

						getbestpath1( make_pair( Ite->second, 1 ), iter_bepath, bestpath[k], id_supath_map[Ite->second], graph_t.scf_s.superpath, addpath, id_bepath_map, bestpath, tig_bank );


						bool tg = false;
						if ( !addpath.empty() ) {
						
							tg = true;
						
							bestpath[k].insert( bestpath[k].end(), addpath.begin(), addpath.end() );
							pair< Supertig_id, Forb > lasp = bestpath[k].back();
							if ( id_bepath_map.find( lasp.first ) != id_bepath_map.end() ) {
								size_t h = id_bepath_map[lasp.first];
								PathIter beiter = find( bestpath[h].begin(), bestpath[h].end(), lasp );
								if ( beiter != bestpath[h].end() ) {
									++beiter;
									bestpath[k].insert( bestpath[k].end(), beiter, bestpath[h].end() );
								} else {
									list< pair< Supertig_id, Forb > > revbepath = reverseplist( bestpath[h] );
									beiter = find( revbepath.begin(), revbepath.end(), lasp );
									if ( beiter != revbepath.end() ) {
										++beiter;
										bestpath[k].insert( bestpath[k].end(), beiter, revbepath.end() );
									} else {
										cout<<"error why 4"<<endl;   exit(0);
									}
								}
							}
						
						
							
						}

						addpath.clear();
						list< pair< Supertig_id, Forb > > revbepath = reverseplist( bestpath[k] );
						iter_bepath= find( revbepath.begin(), revbepath.end(), make_pair( Ite->second, 0 ) );
						if ( iter_bepath == revbepath.end() ) {
							cout<<"error 3 whiy4 "<<endl;  exit(1);
						}

						getbestpath1( make_pair( Ite->second, 0 ), iter_bepath, revbepath, id_supath_map[Ite->second], graph_t.scf_s.superpath, addpath, id_bepath_map, bestpath, tig_bank );
						if ( !addpath.empty() ) {
							tg = true;
							addpath = reverseplist( addpath );
						
							bestpath[k].insert( bestpath[k].begin(), addpath.begin(), addpath.end() );
							pair< Supertig_id, Forb > lasp = bestpath[k].front();
							if ( id_bepath_map.find( lasp.first ) != id_bepath_map.end() ) {
								size_t h = id_bepath_map[lasp.first];
								PathIter beiter = find( bestpath[h].begin(), bestpath[h].end(), lasp );
								if ( beiter != bestpath[h].end() ) {
									
									bestpath[k].insert( bestpath[k].begin(), bestpath[h].begin(), beiter );
								} else {
									list< pair< Supertig_id, Forb > > revbepath2 = reverseplist( bestpath[h] );
									beiter = find( revbepath2.begin(), revbepath2.end(), lasp );
									if ( beiter != revbepath2.end() ) {
										
										bestpath[k].insert( bestpath[k].begin(), revbepath2.begin(), beiter );
									} else {
										cout<<"error why 2"<<endl;   exit(0);
									}
								}
							}
						
						}

						if ( tg ) {
							PathIter tite = bestpath[k].begin();
							for ( ; tite != bestpath[k].end(); ++tite ) {
								if ( non_contra.find( tite->first ) != non_contra.end() )
							
									id_bepath_map[tite->first] = k;
							}
						}

					}
				}


			}

		
		
	}

}

void getbestpath1( pair< Supertig_id, Forb> seed_p,
				 PathIter &iter_bepath,
				 list< pair< Supertig_id, Forb > > &bepath,
				 vector< size_t > id_supath,
				 vector<list< pair< Supertig_id, Forb > > > &superpath,
				 list< pair< Supertig_id, Forb > > &addpath,
				 map< Supertig_id, size_t > &id_bepath_map,
				 vector< list< pair< Supertig_id, Forb > > > &bestpath,
				 Supertig_bank &tig_bank )
{
	double maxconf = 0;

	for ( size_t i = 0; i < id_supath.size(); ++i ) {
		size_t k = id_supath[i];
	
		list< pair< Supertig_id, Forb > >::iterator Itel = find( superpath[k].begin(), superpath[k].end(), seed_p );
		if ( Itel != superpath[k].end() ) {
			++Itel;
			list< pair< Supertig_id, Forb > > thisaddpath;
			PathIter this_iter_bepath = iter_bepath;
			double conf = elong1_mate_hit_check( seed_p, this_iter_bepath, Itel, 0, seed_p, bepath, superpath[k], thisaddpath, id_bepath_map, bestpath, tig_bank );
		
			if ( conf > maxconf ) {
				maxconf = conf;
				addpath = thisaddpath;
			
			}
		} else {
			list< pair< Supertig_id, Forb > > revpath = reverseplist( superpath[k] );
		
			Itel = find( revpath.begin(), revpath.end(), seed_p );
			if ( Itel != revpath.end() ) {
				++Itel;
				list< pair< Supertig_id, Forb > > thisaddpath;
				PathIter this_iter_bepath = iter_bepath;
				double conf = elong1_mate_hit_check( seed_p, this_iter_bepath, Itel, 0, seed_p, bepath, revpath, thisaddpath, id_bepath_map, bestpath, tig_bank );
			
				if ( conf > maxconf ) {
					maxconf = conf;
					addpath = thisaddpath;
				
				}
			} else {
				cout<<"error no foinddsidj"<<endl;  exit(1);
			}
		}

	}
}

double elong1_mate_hit_check( pair< Supertig_id, Forb > seed_p,
							 PathIter &iter_bepath,
							 PathIter &iter_supath,
							 int elonglen,
							 pair< Supertig_id, Forb > lastp,
							 list< pair< Supertig_id, Forb > > &bepath,
							 list< pair< Supertig_id, Forb > > &supath,
							 list< pair< Supertig_id, Forb > > &addpath,
							 map< Supertig_id, size_t > &id_bepath_map,
							 vector< list< pair< Supertig_id, Forb > > > &bestpath,
							 Supertig_bank &tig_bank )
{
	if ( iter_supath == supath.end() )
		return 0;

	
	
	int gap = 0;

	if ( iter_bepath != bepath.end() ) {
		
		++iter_bepath;
		pair< Supertig_id, Forb > this_lastp = lastp;
		while ( iter_bepath != bepath.end() && iter_supath != supath.end() ) {
			if ( *iter_bepath != *iter_supath ) 
				return 0;
			Supertig_id tid = iter_supath->first;
			int ovlen = get_ovlen_from_lk_tig( this_lastp, reversepht(*iter_supath ) , tig_bank );
			gap = elonglen - ovlen;
			elonglen = gap + tig_bank.Supertig_Map[tid].length;
			this_lastp = *iter_supath;
			++iter_bepath;
			++iter_supath;
		}
	} else {
		Supertig_id tid = iter_supath->first;
		int ovlen = get_ovlen_from_lk_tig( lastp, reversepht(*iter_supath ) , tig_bank );
		gap = elonglen - ovlen;
		elonglen = gap + tig_bank.Supertig_Map[tid].length;
	}

	if ( iter_bepath == bepath.end() && iter_supath != supath.end() ) {
		Supertig_id tid = iter_supath->first;
		if ( id_bepath_map.find( tid ) != id_bepath_map.end() ) {
			
			size_t k = id_bepath_map[ tid];
			PathIter niter = find( bestpath[k].begin(), bestpath[k].end(), *iter_supath );
		
			if ( niter != bestpath[k].end() ) {
				PathIter tempiterinsupath = iter_supath;
				
				bool contra = false;
				
				while ( tempiterinsupath != supath.begin() && niter != bestpath[k].begin() ) {
					--tempiterinsupath;
					--niter;
					if ( *niter != *tempiterinsupath ) {
						contra = true;
						break;
					}
				}
			
				if ( contra )
					return 0;
				else {
					
					double conf = 0;
					Scaffold_Gap scf;
					if ( scf_check( seed_p, *iter_supath, gap, tig_bank, scf ) ) {
						conf = scf.conf;
					}
				
					if ( conf > 0 )
						addpath.push_back( *iter_supath );
					return conf;
				}
			}
			list< pair< Supertig_id, Forb > > revbepath = reverseplist( bestpath[k] );
			niter = find( revbepath.begin(), revbepath.end(), *iter_supath );
			if ( niter != revbepath.end() ) {
				PathIter tempiterinsupath = iter_supath;
				bool contra = false;
			
				while ( tempiterinsupath != supath.begin() && niter != revbepath.begin() ) {
					--tempiterinsupath;
					--niter;
					if ( *niter != *tempiterinsupath ) {
						contra = true;
						break;
					}
				}
				
				if ( contra  )
					return 0;
				else {
					double conf = 0;
					Scaffold_Gap scf;
					if ( scf_check( seed_p, *iter_supath, gap, tig_bank, scf ) ) {
						conf = scf.conf;
					}
				
					if ( conf > 0 )
						addpath.push_back( *iter_supath );
					return conf;
				}

			}
			cout<<"error why!"<<endl;  
		}
	
		double conf = 0;
		Scaffold_Gap scf;
		if ( scf_check( seed_p, *iter_supath, gap, tig_bank, scf ) ) {
			conf = scf.conf;
		}
	
		///iterator/////////////
		list< pair< Supertig_id, Forb > > nextaddpath;
		pair< Supertig_id, Forb > this_p = *iter_supath;
		++iter_supath;
	
		
		double nextconf = elong1_mate_hit_check( seed_p, iter_bepath, iter_supath, elonglen, this_p, bepath, supath, nextaddpath, id_bepath_map, bestpath, tig_bank );
	
		if ( nextconf > 0 ) {
			addpath.push_back( this_p );
			addpath.insert( addpath.end(), nextaddpath.begin(), nextaddpath.end() );
			conf += nextconf;
		} else if ( conf > 0 ) {
			addpath.push_back( this_p );
		}

		return conf;
		

	} else {       // iter_bepath != bepath.end()
		return 0;
	
	}

}

void getbestpath2( vector< list< pair< Supertig_id, Forb > > > &bestpath, 
				  set< Supertig_id > &bone_id_all,
				  Supertig_bank &tig_bank )
{
	size_t vesize = bestpath.size();
	for ( size_t i = 0; i < vesize; ++i ) {
		list< pair< Supertig_id, Forb > > selectpath;
		getbestpath2_t( bestpath[i], selectpath, bone_id_all, tig_bank );
		bestpath[i] = selectpath;
	
	}
}

void getbestpath2_t( list< pair< Supertig_id, Forb > > &bepath,
					list< pair< Supertig_id, Forb > > &selectpath,
					set< Supertig_id > &bone_id_all,
					Supertig_bank &tig_bank )
{

	set< Supertig_id > bone_in_path;
	set< Supertig_id > bulb_in_path;
	list< pair< Supertig_id, Forb > >::iterator Itel;
	for ( Itel = bepath.begin(); Itel != bepath.end(); ++Itel ) {
		if ( tig_bank.Supertig_Map[Itel->first].single_tig || tig_bank.Supertig_Map[Itel->first].allseries ) {
			bone_in_path.insert( Itel->first );
		} else
			bulb_in_path.insert( Itel->first );
	}


	for ( Itel = bepath.begin(); Itel != bepath.end(); ++Itel ) {
		set< Supertig_id > fishid;
	
		if ( bone_in_path.find( Itel->first ) == bone_in_path.end() ) {
	
			fishid = bone_in_path;
			size_t vesize = tig_bank.Supertig_Map[Itel->first].Tig_Ve.size();
			for ( size_t i = 0; i < vesize; ++i ) {
				Supertig_id tid = tig_bank.Supertig_Map[Itel->first].Tig_Ve[i][0];
				if ( !tig_bank.Supertig_Map[tid].bubble ) {
					fishid.insert( tid );
				}
			}
			
		} 
		bulbpathselect( *Itel, selectpath, fishid, bone_id_all, tig_bank );
	}



}

void bulbpathselect( pair< Supertig_id, Forb > b_id_p, 
					list< pair< Supertig_id, Forb > > &selectp,
					set< Supertig_id > &fishid,
					set< Supertig_id > &bone_id_all,
					Supertig_bank &tig_bank )
{

	Supertig_id tid = b_id_p.first;
	Forb tfb = b_id_p.second;

	if ( tig_bank.Supertig_Map[tid].single_tig  ) {
	
		selectp.push_back( make_pair( tig_bank.Supertig_Map[tid].Tig_Ve[0][0], tfb ) );	
		bone_id_all.insert( tig_bank.Supertig_Map[tid].Tig_Ve[0][0] );
	} else if ( tig_bank.Supertig_Map[tid].series ) {
	
		if ( tfb == 0 ) {
			size_t vesize = tig_bank.Supertig_Map[tid].Tig_Ve.size();
			for ( size_t i = 0; i < vesize; ++i ) {
				Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[i][0];
				Forb nft = tig_bank.Supertig_Map[tid].Tig_F_Ve[i][0];
			
			
				bulbpathselect( make_pair(nid, nft), selectp, fishid, bone_id_all, tig_bank );
			
			}
		} else {
			int vesize = (int)tig_bank.Supertig_Map[tid].Tig_Ve.size();
			for ( int i = vesize - 1; i >= 0; --i ) {
				Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[i][0];
				Forb nft = tig_bank.Supertig_Map[tid].Tig_F_Ve[i][0];
			
			
				bulbpathselect( make_pair(nid, reverseforb(nft) ), selectp, fishid, bone_id_all, tig_bank );
		
			}
		}
					
	} else if ( tig_bank.Supertig_Map[tid].bubble ) {
	
		size_t k = bulbselectrule( tid, fishid, bone_id_all, tig_bank );
		Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[0][k];
		Forb nfb = tig_bank.Supertig_Map[tid].Tig_F_Ve[0][k];
	
		if ( tfb == 0 ) 
			bulbpathselect( make_pair( nid, nfb ), selectp, fishid, bone_id_all, tig_bank );
		else 
			bulbpathselect( make_pair( nid, reverseforb(nfb) ), selectp, fishid, bone_id_all, tig_bank );
	
	} else {
		cout<<"error in bulbpathselect unknown type of supertig"<<endl;  exit(1);
	}
		
}

size_t bulbselectrule( Supertig_id tid, set< Supertig_id > &fishid, set< Supertig_id > &bone_id_all, Supertig_bank &tig_bank ) 
{
	size_t select_k;
	size_t bsize = tig_bank.Supertig_Map[tid].Tig_Ve[0].size();

	///////////////select bulb path/////////////////////
	////////// first, check mate hit////////////////////
	map< double, vector< size_t >, greater<double> > mate_hit_map;
	for ( size_t i = 0; i < bsize; ++i ) {
		double conf = 0;
		Supertig_id bid = tig_bank.Supertig_Map[tid].Tig_Ve[0][i];
		if ( tig_bank.Pair_Scaffold_map.find( bid ) != tig_bank.Pair_Scaffold_map.end() ) {
			set< Supertig_id >::iterator Itef;
			for ( Itef = fishid.begin(); Itef != fishid.end(); ++Itef ) {
				if ( tig_bank.Pair_Scaffold_map[bid].find( *Itef ) != tig_bank.Pair_Scaffold_map[bid].end() ) {
					Scaffold_gap_id scid = tig_bank.Pair_Scaffold_map[bid][*Itef][0];
					conf += tig_bank.Scaffold_map[scid].conf;
				}
			}
		}
		if ( conf > 0 ) {
		
			mate_hit_map[conf].push_back( i );
		}
	}

	vector< size_t > remain_id;
	if ( !mate_hit_map.empty() ) {
		if ( mate_hit_map.begin()->second.size() == 1 ) {
			select_k = mate_hit_map.begin()->second[0];
		
			return select_k;
		} else {
			remain_id = mate_hit_map.begin()->second;
		}
	} else {
		for ( size_t i = 0; i < bsize; ++i )
			remain_id.push_back(i);

	}

	vector< size_t > remain_id_2;

	//////second, check used in bone_id_all, select false/////////////////
	for ( size_t i = 0; i < remain_id.size(); ++i ) {
		size_t k = remain_id[i];
		Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[0][k];
		if ( !check_used_in_bone( nid, tig_bank, bone_id_all ) ) {
			remain_id_2.push_back( k );
		
		} else {
		}
	}
	if ( !remain_id_2.empty() ) {
		if ( (int)remain_id_2.size() == 1 ) {
		
			return remain_id_2[0];
		} else {
			remain_id = remain_id_2;
			remain_id_2.clear();
		}
	} 


	//////third unused_in_bone, select the most//////////////////
	map< size_t, vector< size_t >, greater< size_t > > unused_size_map;
	for ( size_t i = 0; i < remain_id.size(); ++i ) {
		size_t k = remain_id[i];
		Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[0][k];
		set< Supertig_id > unused_id;
		size_t unused_size = check_unused_in_bone( nid, tig_bank, bone_id_all, unused_id );
		if ( unused_size > 0 ) {
			unused_size_map[unused_size].push_back( k );
		
		}
	}

	if ( !unused_size_map.empty() ) {
		if ( unused_size_map.begin()->second.size() == 1 ) {
			
			return unused_size_map.begin()->second[0];
		} else {
			remain_id = unused_size_map.begin()->second;
		}
	} 

	/////check used id size in bone, select the least/////////////////////
	multimap< size_t, size_t > id_num_map;
	for ( size_t i = 0; i < remain_id.size(); ++i ) {
		size_t k = remain_id[i];
		Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[0][k];
		set< Supertig_id > allid;
		size_t id_size = check_id_num_all( nid, tig_bank, allid );
		id_num_map.insert( make_pair( id_size, k ) );
	
	}
	return id_num_map.begin()->second;



}

bool check_used_in_bone( Supertig_id tid, Supertig_bank &tig_bank, set< Supertig_id > &usedset )
{
	if ( tig_bank.Supertig_Map[tid].single_tig ) {
		if ( usedset.find( tig_bank.Supertig_Map[tid].Tig_Ve[0][0] ) != usedset.end() )
			return true;
		else
			return false;
	} else if ( tig_bank.Supertig_Map[tid].series ) {
		size_t vesize = tig_bank.Supertig_Map[tid].Tig_Ve.size();
		for ( size_t i = 0; i < vesize; ++i ) {
			Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[i][0];
			if ( check_used_in_bone( nid, tig_bank, usedset ) ) {
				return true;
			}
		}
		return false;
	} else if ( tig_bank.Supertig_Map[tid].bubble ) {
		
		for ( size_t i = 0; i < tig_bank.Supertig_Map[tid].Tig_Ve[0].size(); ++i ) {
			if ( !check_used_in_bone( tig_bank.Supertig_Map[tid].Tig_Ve[0][i], tig_bank, usedset ) ) {
				
				return false;
			}
		}
		return true;
	} else {
		cout<<"error in check_used_in_bone unknown!"<<endl; exit(1);
	}
	
}

size_t check_unused_in_bone( Supertig_id tid, Supertig_bank &tig_bank, set< Supertig_id > &usedset, set< Supertig_id > &unused_id )
{
	if ( tig_bank.Supertig_Map[tid].single_tig ) {
		if ( usedset.find( tig_bank.Supertig_Map[tid].Tig_Ve[0][0] ) == usedset.end() ) {
			unused_id.insert( tig_bank.Supertig_Map[tid].Tig_Ve[0][0] );

		}
		return unused_id.size();
	} else if ( tig_bank.Supertig_Map[tid].series ) {
		size_t vesize = tig_bank.Supertig_Map[tid].Tig_Ve.size();
		for ( size_t i = 0; i < vesize; ++i ) {
			Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[i][0];
			check_unused_in_bone( nid, tig_bank, usedset, unused_id ); 
			
		}
		return unused_id.size();
	} else if ( tig_bank.Supertig_Map[tid].bubble ) {
		size_t vesize = tig_bank.Supertig_Map[tid].Tig_Ve[0].size();
		for ( size_t i = 0; i < vesize; ++i ) {
			Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[0][i];
			check_unused_in_bone( nid, tig_bank, usedset, unused_id );
		}
		return unused_id.size();
	} else {
		cout<<"error in check_unused_in_bone unknown!"<<endl; exit(1);
	}
}

size_t check_id_num_all( Supertig_id tid, Supertig_bank &tig_bank, set< Supertig_id > &allid )
{
	if ( tig_bank.Supertig_Map[tid].single_tig ) {
		
		allid.insert( tig_bank.Supertig_Map[tid].Tig_Ve[0][0] );
		return allid.size();
	} else if ( tig_bank.Supertig_Map[tid].series ) {
		size_t vesize = tig_bank.Supertig_Map[tid].Tig_Ve.size();
		for ( size_t i = 0; i < vesize; ++i ) {
			Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[i][0];
			check_id_num_all( nid, tig_bank, allid ); 
			
		}
		return allid.size();
	} else if ( tig_bank.Supertig_Map[tid].bubble ) {
		size_t vesize = tig_bank.Supertig_Map[tid].Tig_Ve[0].size();
		for ( size_t i = 0; i < vesize; ++i ) {
			Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[0][i];
			check_id_num_all( nid, tig_bank, allid );
		}
		return allid.size();
	} else {
		cout<<"error in check_unused_in_bone unknown!"<<endl; exit(1);
	}

}

void getremainpath( vector< list< pair< Supertig_id, Forb > > > &bestpath, 
				   vector< list< pair< Supertig_id, Forb > > > &superpath,
				   vector< list< pair< Supertig_id, Forb > > > &remainpath,
				   set< Supertig_id > &single_id )
{
	size_t bsize = bestpath.size();
	set< Supertig_id > used;
	for ( size_t i = 0; i < bsize; ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Itel;
		for ( Itel = bestpath[i].begin(); Itel != bestpath[i].end(); ++Itel ) {
			used.insert( Itel->first );
		}
	}

	set< Supertig_id > unused;
	set< Supertig_id > used_sec;
	size_t susize = superpath.size(); 
	for ( size_t i = 0; i < susize; ++i ) {
		list< pair< Supertig_id, Forb > > apath;
		list< pair< Supertig_id, Forb > >::iterator Itel;
		for ( Itel = superpath[i].begin(); Itel != superpath[i].end(); ++Itel  ) {
			if ( used.find( Itel->first ) != used.end() ) {
				if ( (int)apath.size() > 1 ) {
					remainpath.push_back( apath );

					//////////add to used_sec///////////
					list< pair< Supertig_id, Forb > >::iterator subite;
					for ( subite = apath.begin(); subite != apath.end(); ++subite )
						used_sec.insert( subite->first );
				}
				apath.clear();
			} else {
				apath.push_back( *Itel );
				unused.insert( Itel->first );
			}
		}
	}

	set< Supertig_id >::iterator Ites;
	for ( Ites = unused.begin(); Ites != unused.end(); ++Ites ) {
		if ( used_sec.find( *Ites ) == used_sec.end() )
			single_id.insert( *Ites );
	}

	if ( !remainpath.empty() )
		reduceredunpl_t( remainpath);
}


// get simple path from remain path
void getspfrp( vector< list< pair< Supertig_id, Forb > > > &remainpath,
			  vector< list< pair< Supertig_id, Forb > > > &simpath, 
			  subgraph &graph_t,
			  Supertig_bank &tig_bank,
			  set< Supertig_id > &single_id )
{

	set< Supertig_id > all_id;
	set< Supertig_id > id_in_sp;

	for ( size_t i = 0; i < remainpath.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Ite;
		for ( Ite = remainpath[i].begin(); Ite != remainpath[i].end(); ++Ite )
			all_id.insert( Ite->first );
	}

	map< Supertig_id, Supertig_Overlap_Link > tmp_ov_link;
	form_Link_fr_superpath( tmp_ov_link, graph_t.Supertig_Overlap_Link_Map, remainpath, tig_bank );

	merge_sim_path_fr_Link( tmp_ov_link, simpath );

	for ( size_t i = 0; i < simpath.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Ite;
		for ( Ite = simpath[i].begin(); Ite != simpath[i].end(); ++Ite )
			id_in_sp.insert( Ite->first );
	}

	if ( id_in_sp.empty() )
		single_id.insert( all_id.begin(), all_id.end() );
	else {
		set< Supertig_id >::iterator Ites;
		for ( Ites = all_id.begin(); Ites != all_id.end(); ++Ites ) {
			if ( id_in_sp.find( *Ites ) == id_in_sp.end() )
				single_id.insert( *Ites );
		}
	}

}

void unpack_left_single( set< Supertig_id > &single,
						set< Supertig_id > &single_series,
						vector< list< pair< Supertig_id, Forb > > > &selectpve,
						set< Supertig_id > &bone_id_all,
						Supertig_bank &tig_bank )
{
	set< Supertig_id >::iterator Ites;
	for ( Ites = single.begin(); Ites != single.end(); ++Ites ) {
	
		if ( tig_bank.Supertig_Map[*Ites].single_tig ) {
		
			continue;
		}
		if (  tig_bank.Supertig_Map[*Ites].allseries ) {

			single_series.insert( *Ites );
			continue;
		}
		
		list< pair< Supertig_id, Forb > > selectp;
		set< Supertig_id > fish;
		if ( tig_bank.Supertig_Map[*Ites].Tig_Ve.size() > 1 ) {
			size_t vesize = tig_bank.Supertig_Map[*Ites].Tig_Ve.size();
			for ( size_t i = 0; i < vesize; ++i ) {
				Supertig_id tid = tig_bank.Supertig_Map[*Ites].Tig_Ve[i][0];
				if ( !tig_bank.Supertig_Map[tid].bubble ) {
					fish.insert( tid );
				}
			}
		
			bulbpathselect( make_pair( *Ites, 0 ), selectp, fish, bone_id_all, tig_bank );

			selectpve.push_back( selectp );
			
		} else {

			bulbtig_select( make_pair( *Ites, 0 ), selectp, selectpve, fish, bone_id_all, tig_bank );

		}


	}

}

void bulbtig_select( pair< Supertig_id, Forb > b_id_p, 
					list< pair< Supertig_id, Forb > > &selectp,
					vector< list< pair< Supertig_id, Forb > > > &selectpve,
					set< Supertig_id > fish,
					set< Supertig_id > &bone_id_all,
					Supertig_bank &tig_bank )
{
	Supertig_id tid = b_id_p.first;
	Forb tfb = b_id_p.second;

	if ( tig_bank.Supertig_Map[tid].single_tig  ) {
		if ( bone_id_all.find( tig_bank.Supertig_Map[tid].Tig_Ve[0][0] ) != bone_id_all.end() ) {
		
			if ( (int)selectp.size() > 1 ) {
				selectpve.push_back( selectp );
				
			}
			selectp.clear();
		} else {
		
			selectp.push_back( make_pair( tig_bank.Supertig_Map[tid].Tig_Ve[0][0], tfb ) );	
			bone_id_all.insert( tig_bank.Supertig_Map[tid].Tig_Ve[0][0] );
		}
	} else if ( tig_bank.Supertig_Map[tid].series ) {
	
		if ( tfb == 0 ) {
			size_t vesize = tig_bank.Supertig_Map[tid].Tig_Ve.size();
			for ( size_t i = 0; i < vesize; ++i ) {
				Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[i][0];
				Forb nft = tig_bank.Supertig_Map[tid].Tig_F_Ve[i][0];

			
				bulbtig_select( make_pair(nid, nft), selectp, selectpve, fish, bone_id_all, tig_bank );
			
			}
		} else {
			int vesize = (int)tig_bank.Supertig_Map[tid].Tig_Ve.size();
			for ( int i = vesize - 1; i >= 0; --i ) {
				Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[i][0];
				Forb nft = tig_bank.Supertig_Map[tid].Tig_F_Ve[i][0];
			
			
				bulbtig_select( make_pair(nid, reverseforb(nft) ), selectp, selectpve, fish, bone_id_all, tig_bank );
			
			}
		}
					
	} else if ( tig_bank.Supertig_Map[tid].bubble ) {
	
		vector< size_t > select_k;
		if ( bulbtigselectrule( tid, fish, bone_id_all, tig_bank, select_k ) ) {
			
			size_t k = select_k[0];
			Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[0][k];
			Forb nfb = tig_bank.Supertig_Map[tid].Tig_F_Ve[0][k];
		
			if ( tfb == 0 ) {
				bulbtig_select( make_pair( nid, nfb ), selectp, selectpve, fish, bone_id_all, tig_bank );
			} else 
				bulbtig_select( make_pair(nid, reverseforb(nfb) ), selectp, selectpve, fish, bone_id_all, tig_bank );
		
		} else {
		
			if ( (int)selectp.size() > 1 ) {
				selectpve.push_back( selectp );
				
			}
			selectp.clear();
		}
		
	} else {
		cout<<"error in bulbpathselect unknown type of supertig"<<endl;  exit(1);
	}

}

bool bulbtigselectrule( Supertig_id tid, set< Supertig_id > &fishid, set< Supertig_id > &bone_id_all, Supertig_bank &tig_bank, vector< size_t> &select_k )
{
	
	size_t bsize = tig_bank.Supertig_Map[tid].Tig_Ve[0].size();


	if ( !fishid.empty() ) {
		map< double, vector< size_t >, greater<double> > mate_hit_map;
		for ( size_t i = 0; i < bsize; ++i ) {
			double conf = 0;
			Supertig_id bid = tig_bank.Supertig_Map[tid].Tig_Ve[0][i];
			if ( tig_bank.Pair_Scaffold_map.find( bid ) != tig_bank.Pair_Scaffold_map.end() ) {
				set< Supertig_id >::iterator Itef;
				for ( Itef = fishid.begin(); Itef != fishid.end(); ++Itef ) {
					if ( tig_bank.Pair_Scaffold_map[bid].find( *Itef ) != tig_bank.Pair_Scaffold_map[bid].end() ) {
						Scaffold_gap_id scid = tig_bank.Pair_Scaffold_map[bid][*Itef][0];
						conf += tig_bank.Scaffold_map[scid].conf;
					}
				}
			}
			if ( conf > 0 ) {
			
				mate_hit_map[conf].push_back( i );
			}
		}

		bool matehit = false;
		vector< size_t > remain_id;
		if ( !mate_hit_map.empty() ) {
			matehit = true;
			if ( mate_hit_map.begin()->second.size() == 1 ) {
				
			
				select_k.push_back( mate_hit_map.begin()->second[0] );
				return true;
			} else {
				remain_id = mate_hit_map.begin()->second;
			}
		} else {
			for ( size_t i = 0; i < bsize; ++i )
				remain_id.push_back(i);

		}
		vector< size_t > remain_id_2;
		for ( size_t i = 0; i < remain_id.size(); ++i ) {
			size_t k = remain_id[i];
			Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[0][i];
			if ( !check_used_in_bone( nid, tig_bank, bone_id_all ) ) {
				remain_id_2.push_back( k );
			
			} else {
			
			}
		}
		if ( !remain_id_2.empty() ) {
		
			select_k.push_back( remain_id_2[0] );
			return true;
		} else {
			if ( matehit ) {
			
				select_k.push_back( remain_id[0] );
				return true;
			} else
				return false;
		}
	} else {
		
	
		vector< size_t > remain_id_2;
	
		//////second, check used in bone_id_all, select false/////////////////
		for ( size_t i = 0; i < bsize; ++i ) { 
			Supertig_id nid = tig_bank.Supertig_Map[tid].Tig_Ve[0][i];
			if ( !check_used_in_bone( nid, tig_bank, bone_id_all ) ) {
				remain_id_2.push_back( i );
			
			} else {
			
			}
		}
		if ( !remain_id_2.empty() ) {
		
			select_k.push_back( remain_id_2[0] );
			return true;
		} else {
			return false;
		}
	}

	
}


void getpathfromseries( vector< list< pair< Supertig_id, Forb > > > &pathve,
					   set< Supertig_id > &single_series,
					   Supertig_bank &tig_bank )
{
	set< Supertig_id >::iterator Ites;
	for ( Ites = single_series.begin(); Ites != single_series.end(); ++Ites ) {
		list< pair< Supertig_id, Forb > > path;
 		tig_bank.Supertig_Map[*Ites].gettigpath( path );
		pathve.push_back( path );
	}
}

// get mate cover in best path 
void get_mcip( vector< list< pair< Supertig_id, Forb > > > &pathve,
			  vector< list< double > > &mate_cover_inpath,
			  Supertig_bank &tig_bank ) 
{

	for ( size_t i = 0; i < pathve.size(); ++i ) {
		list< double > mate_c;
		get_mcip_t( pathve[i], mate_c, tig_bank );
		mate_cover_inpath.push_back( mate_c );
	
	}

}

void get_mcip_t( list< pair< Supertig_id, Forb > > &path,
			  list< double > &mate_cover_inpath,
			  Supertig_bank &tig_bank ) 
{
	list< pair< Supertig_id, Forb > >::iterator Itel;

	for ( Itel = path.begin(); Itel != path.end(); ++Itel )
		mate_cover_inpath.push_back( 0 );

	list< double >::iterator Itelmc = mate_cover_inpath.begin();
	for ( Itel = path.begin(); Itel != path.end(); ++Itel ) {
		if ( Itelmc == mate_cover_inpath.end() ) {
			cout<<"error in getmcip Itelmc wrong"<<endl; exit(1);
		}
		pair< Supertig_id, Forb > frontp = *Itel;
		PathIter sec_iter = Itel;
		list< double >::iterator sec_itelmc = Itelmc;
		++sec_iter;
		++sec_itelmc;
		int elonglen = 0;
		pair< Supertig_id, Forb > lastp = *Itel;
		for (; sec_iter != path.end(); ++sec_iter ) {
			if ( sec_itelmc == mate_cover_inpath.end() ) {
				cout<<"error in getmcip Itelmc wrong"<<endl; exit(1);
			}
			pair< Supertig_id, Forb > thisp = *sec_iter;
			int ovlen = get_ovlen_fr_cnct_nodes( lastp, reversepht(thisp), tig_bank.fdm_ovlkmap );
			if ( ovlen == -1000 ) {
			
					cout<<"error in getmcip ovlen = -1000 "<<lastp.first<<","<<lastp.second<<","<<thisp.first<<","<<thisp.second<<endl;  exit(1);
		
			}
			int gaplen = elonglen - ovlen;
			elonglen = gaplen + tig_bank.Supertig_Map[thisp.first].length;

		
			Scaffold_Gap scf;
			if ( scf_check( frontp, thisp, gaplen, tig_bank, scf ) ) {
				double conf = scf.conf;
			
				list< double >::iterator subite = Itelmc;
				*subite += conf;
				++subite;
				for ( ; subite != sec_itelmc; ++subite ) {
					if ( subite == mate_cover_inpath.end() ) {
						cout<<"error sdf"<<endl; exit(1);
					}
					*subite += conf ;
				}
				
				
				*subite += conf;
			
			}

			lastp = thisp;


			++sec_itelmc;
		}

		++Itelmc;
	}
}

void get_mcip_2( vector< list< pair< Supertig_id, Forb > > > &pathve,
			   vector< list< double > > &mate_cover_inpath,
			   Supertig_bank &tig_bank ) 
{

	for ( size_t i = 0; i < pathve.size(); ++i ) {
		list< double > mate_c;
		get_mcip_2_t( pathve[i], mate_c, tig_bank );
		mate_cover_inpath.push_back( mate_c );
	
	}

}

void get_mcip_2_t( list< pair< Supertig_id, Forb > > &path,
			      list< double > &mate_cover_inpath,
			      Supertig_bank &tig_bank ) 
{
	list< pair< Supertig_id, Forb > >::iterator Itel;

	for ( Itel = path.begin(); Itel != path.end(); ++Itel )
		mate_cover_inpath.push_back( 0 );

	list< double >::iterator Itelmc = mate_cover_inpath.begin();
	for ( Itel = path.begin(); Itel != path.end(); ++Itel ) {
		if ( Itelmc == mate_cover_inpath.end() ) {
			cout<<"error in getmcip Itelmc wrong"<<endl; exit(1);
		}
		pair< Supertig_id, Forb > frontp = *Itel;
		PathIter sec_iter = Itel;
		list< double >::iterator sec_itelmc = Itelmc;
		++sec_iter;
		++sec_itelmc;
		int elonglen = 0;
		pair< Supertig_id, Forb > lastp = *Itel;
		for (; sec_iter != path.end(); ++sec_iter ) {
			if ( sec_itelmc == mate_cover_inpath.end() ) {
				cout<<"error in getmcip Itelmc wrong"<<endl; exit(1);
			}
			pair< Supertig_id, Forb > thisp = *sec_iter;
			int ovlen = get_ovlen_fr_cnct_nodes( lastp, reversepht(thisp), tig_bank.fdm_ovlkmap );
			if ( ovlen == -1000 ) {
			
					cout<<"error in getmcip ovlen = -1000 "<<lastp.first<<","<<lastp.second<<","<<thisp.first<<","<<thisp.second<<endl;  exit(1);
			
			}
			int gaplen = elonglen - ovlen;
			elonglen = gaplen + tig_bank.Supertig_Map[thisp.first].length;

		
			Scaffold_Gap scf;
			if ( scf_check( frontp, thisp, gaplen, tig_bank, scf ) ) {
				double conf = scf.conf;
			
				list< double >::iterator subite = Itelmc;
				*subite += conf;
				++subite;
				for ( ; subite != sec_itelmc; ++subite ) {
					if ( subite == mate_cover_inpath.end() ) {
						cout<<"error sdf"<<endl; exit(1);
					}
				
				}
				
				
				*subite += conf;

			}

			lastp = thisp;


			++sec_itelmc;
		}

		++Itelmc;
	}
}

void getrepeat( vector< list< pair< Supertig_id, Forb > > > &pathve, map< Supertig_id, int > &repeat )
{
	map< Supertig_id, int > occur;
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Itel;
		for ( Itel = pathve[i].begin(); Itel != pathve[i].end(); ++Itel ) {
			if ( occur.find( Itel->first ) != occur.end() )
				occur[Itel->first] += 1;
			else
				occur[Itel->first] = 1;
		}

	}

	map< Supertig_id, int >::iterator Itel;
	for ( Itel = occur.begin(); Itel != occur.end(); ++Itel ) {
		if ( Itel->second > 1 )
			repeat.insert( *Itel );
	}
}

int check_week_link_side( vector< list< pair< Supertig_id, Forb > > > &pathve, 
					    vector< list< double > > &matesc, 
					    map< Supertig_id, int > &repeat )
{
	double sc_middle = 2;
	double sc_flank = 2;
	map< Supertig_id, set< size_t > > protect_repeat;
	map< Supertig_id, map< double, set< size_t >, greater<double> > > higher_matesc_repeat;
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Itel = pathve[i].begin();
		list< double >::iterator Item = matesc[i].begin();
		for (; Itel != pathve[i].end(); ++Itel ) {
			PathIter lastpos = pathve[i].end();
			--lastpos;
			if ( repeat.find( Itel->first ) != repeat.end() ) {
				if ( Itel != pathve[i].begin() && Itel != lastpos ) {
					if ( *Item >= sc_middle ) {
						protect_repeat[Itel->first].insert( i );
					} else {
						higher_matesc_repeat[Itel->first][*Item].insert( i );
					}
				} else {
					if ( *Item >= sc_flank ) {
						protect_repeat[Itel->first].insert( i );
					} else {
						higher_matesc_repeat[Itel->first][*Item].insert( i );
					}
				}
			}
			++Item;
		}
	}

	map< Supertig_id, double > highest_matesc_repeat;
	map< Supertig_id, map< double, set< size_t >, greater<double> > >::iterator Iteh;
	for ( Iteh = higher_matesc_repeat.begin(); Iteh != higher_matesc_repeat.end(); ++Iteh ) {
		if ( protect_repeat.find( Iteh->first ) != protect_repeat.end() )
			continue;
		if ( (int)Iteh->second.begin()->second.size() == 1 ) {
			highest_matesc_repeat.insert( make_pair( Iteh->first, Iteh->second.begin()->first ) );
		}
	}


	int popsize = 0;
	vector< list< pair< Supertig_id, Forb > > > alpathve;
	for ( size_t i = 0; i < pathve.size(); ++i ) {
	
		list< pair< Supertig_id, Forb > >::iterator Itel;
		while ( !pathve[i].empty() ) {
			if ( matesc[i].empty() ) {
				cout<<"error matesc empty in check_week_link"<<endl;  exit(1);
			}
			if ( repeat.find( pathve[i].front().first ) != repeat.end() ) {
			
				if ( matesc[i].front() < sc_flank ) {
					if ( highest_matesc_repeat.find( pathve[i].front().first ) != highest_matesc_repeat.end() ) {
						if ( matesc[i].front() < highest_matesc_repeat[pathve[i].front().first] ) {
							if ( matesc[i].front() > 0 ) {
								list< double >::iterator Item = matesc[i].begin();
								++Item;
								if ( Item != matesc[i].end() ) {
									if ( *Item <= matesc[i].front() ) {
									
										pathve[i].pop_front();
										matesc[i].pop_front();
										popsize += 1;
									} else {
										break;
									}
								} else {
								
									pathve[i].pop_front();
									matesc[i].pop_front();
									popsize += 1;
								}
								
							} else {
							
								pathve[i].pop_front();
								matesc[i].pop_front();
								popsize += 1;
							}
						} else {
							break;
						}
					} else {
						if ( matesc[i].front() > 0 ) {
							list< double >::iterator Item = matesc[i].begin();
							++Item;
							if ( Item != matesc[i].end() ) {
								if ( *Item <= matesc[i].front() ) {
								
									pathve[i].pop_front();
									matesc[i].pop_front();
									popsize += 1;
								} else {
									break;
								}
							} else {
							
								pathve[i].pop_front();
								matesc[i].pop_front();
								popsize += 1;
							}
							
						} else {
						
							pathve[i].pop_front();
							matesc[i].pop_front();
							popsize += 1;
						}
					
					}
				} else {
					break;
				}
			} else {
				break;
			}
		}

		while ( !pathve[i].empty() ) {
			if ( matesc[i].empty() ) {
				cout<<"error matesc empty in check_week_link"<<endl;  exit(1);
			}

			if ( repeat.find( pathve[i].back().first ) != repeat.end() ) {
			
				if ( matesc[i].back() < sc_flank ) {
					if ( highest_matesc_repeat.find( pathve[i].back().first ) != highest_matesc_repeat.end() ) {
						if ( matesc[i].back() < highest_matesc_repeat[pathve[i].back().first] ) {
							if ( matesc[i].back() > 0 ) {
								list< double >::reverse_iterator Item = matesc[i].rbegin();
								++Item;
								if ( Item != matesc[i].rend() ) {
									if ( *Item <= matesc[i].back() ) {
									
										pathve[i].pop_back();
										matesc[i].pop_back();
										popsize += 1;
									} else {
										break;
									}
								} else {
								
									pathve[i].pop_back();
									matesc[i].pop_back();
									popsize += 1;
								}
								
							} else {
						
								pathve[i].pop_back();
								matesc[i].pop_back();
								popsize += 1;
							}
						} else {
							break;
						}
					} else {
						if ( matesc[i].back() > 0 ) {
							list< double >::reverse_iterator Item = matesc[i].rbegin();
							++Item;
							if ( Item != matesc[i].rend() ) {
								if ( *Item <= matesc[i].back() ) {
								
									pathve[i].pop_back();
									matesc[i].pop_back();
									popsize += 1;
								} else {
									break;
								}
							} else {
							
								pathve[i].pop_back();
								matesc[i].pop_back();
								popsize += 1;
							}
							
						} else {
						
							pathve[i].pop_back();
							matesc[i].pop_back();
							popsize += 1;
						}
					}
				} else {
					break;
				}
			} else {
				break;
			}
			
		}

	

		if ( (int)pathve[i].size() > 1 ) {
			
			bool bad = false;
			list< pair< Supertig_id, Forb > >::iterator Itel = pathve[i].begin();
			list< double >::iterator Items = matesc[i].begin();
			vector< list< pair< Supertig_id, Forb > > > npve;
			list< pair< Supertig_id, Forb > > np;
			for ( ; Itel != pathve[i].end(); ++Itel ) {
				if ( *Items == 0 && repeat.find( Itel->first ) != repeat.end() ) {
					if ( (int)np.size() > 1 ) {
						npve.push_back( np );
					}
					np.clear();
					popsize += 1;
					bad = true;
				} else {
					np.push_back( *Itel );
				}
				++Items;
			}

			if ( bad ) {
				if ( (int)np.size() > 1 ) {
					npve.push_back(np);
				}
				np.clear();
				if ( !npve.empty() ) {
					alpathve.insert( alpathve.end(), npve.begin(), npve.end() );
				}
			} else {
				alpathve.push_back( pathve[i] );
			}
		}

	
	}

	pathve = alpathve;

	return popsize;
}

void check_week_link_middle( vector< list< pair< Supertig_id, Forb > > > &pathve, 
						   vector< list< double > > &matesc, 
					       map< Supertig_id, int > &repeat,
						   vector< list< pair< Supertig_id, Forb > > > &con_pathve,
						   vector< vector< list< pair< Supertig_id, Forb > > > > &broken_pathve,
						   vector< vector< pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > > > &broken_p_ve,
						   vector< vector< int > > &broken_gap_ve,
						   Supertig_bank &tig_bank )
{
	
	set< Supertig_id > protect_repeat;
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Itel = pathve[i].begin();
		list< double >::iterator Item = matesc[i].begin();
		for (; Itel != pathve[i].end(); ++Itel ) {
			PathIter lastpos = pathve[i].end();
			--lastpos;
			if ( repeat.find( Itel->first ) != repeat.end() ) {
				if ( *Item > 0 ) {
					protect_repeat.insert( Itel->first );
				
				}
				
			}
			++Item;
		}
	}

	int mate_range = tig_bank.mate_len + 5 * tig_bank.mate_var;
	for ( size_t i = 0; i < pathve.size(); ++i ) {
	
		list< pair< int, int > > poslist;
		getposlist( pathve[i], poslist, tig_bank );

		list< pair< Supertig_id, Forb > >::iterator Itel = pathve[i].begin();
		list< pair< int, int > >::iterator Itepos = poslist.begin();
		list< double >::iterator Items = matesc[i].begin();
		list< pair< Supertig_id, Forb > >::iterator end_ite = pathve[i].end();
		--end_ite;
		++Itel;
		++Items;
		++Itepos;
		vector< list< pair< Supertig_id, Forb > > > npve;
		list< pair< Supertig_id, Forb > > np;
		np.push_back( pathve[i].front() );
		vector< pair< PathIter, PathIter > > broken_pos_ve;
		bool broken = false;
		int state = 0;
		PathIter f_b_p;
		PathIter b_b_p;
		for ( ; Itel != end_ite; ++Itel ) {
			if ( repeat.find( Itel->first) != repeat.end() ) {
			
				if ( *Items == 0 ) {
					
					
					if ( protect_repeat.find( Itel->first ) != protect_repeat.end() ) {
						list< double >::iterator bite = Items;
						list< double >::iterator aite = Items;
						--bite;
						++aite;
						if ( *aite < 2 || *bite < 2 ) {
						
							broken = true;
							if ( state == 0 ) {
								f_b_p = Itel;
								--f_b_p;
							
								state = 1;
							}
							if ( !np.empty() ) {
								npve.push_back( np );
							
								np.clear();
							} 
						} else {
							if ( Itepos->first > mate_range && Itepos->second > mate_range ) {
								broken = true;
							
								if ( state == 0 ) {
									f_b_p = Itel;
									--f_b_p;
								
									state = 1;
								}
								if ( !np.empty() ) {
									npve.push_back( np );
								
									np.clear();
								}
								
							} else {
								if ( tig_bank.Supertig_Map[Itel->first].hangingmate == 0 ) {
									broken = true;
								
									if ( state == 0 ) {
										f_b_p = Itel;
										--f_b_p;
									
										state = 1;
									}
									if ( !np.empty() ) {
										npve.push_back( np );
									
										np.clear();
									}
								} else {
									
									if ( state == 1 ) {
										b_b_p = Itel;
										broken_pos_ve.push_back( make_pair( f_b_p, b_b_p ) );
									
										state = 0;
									}
									np.push_back( *Itel );
								}
							}
						}
					} else {
						list< double >::iterator bite = Items;
						list< double >::iterator aite = Items;
						--bite;
						++aite;
						if ( *aite == 0 || *bite == 0 ) {
						
							broken = true;
							if ( state == 0 ) {
								f_b_p = Itel;
								--f_b_p;
							
								state = 1;
							}
							if ( !np.empty() ) {
								npve.push_back( np );
							
								np.clear();
							} 
						} else {
						
							if ( state == 1 ) {
								b_b_p = Itel;
								broken_pos_ve.push_back( make_pair( f_b_p, b_b_p ) );
							
								state = 0;
							}
							np.push_back( *Itel );
						}
					}
				} else {
				
					if ( state == 1 ) {
						b_b_p = Itel;
						broken_pos_ve.push_back( make_pair( f_b_p, b_b_p ) );

						state = 0;
					}
					np.push_back( *Itel );
				}
			} else {
			
				if ( state == 1 ) {
					b_b_p = Itel;
					broken_pos_ve.push_back( make_pair( f_b_p, b_b_p ) );

					state = 0;
				}
				np.push_back( *Itel );
			}
			++Items;
			++Itepos;
		}

		if ( broken ) {
			if ( state == 1 ) {
				b_b_p = end_ite;
				broken_pos_ve.push_back( make_pair( f_b_p, b_b_p ) );
			
				state = 0;
			}
			np.push_back( pathve[i].back() );
			
			npve.push_back( np );
		
			np.clear();
			
			/////////calculate the gap or overlap////////////////
		
			vector< pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > > broken_p;
			pair< Supertig_id, Forb > fp;
			pair< Supertig_id, Forb > bp;
			vector< int > broken_gap;
			vector< pair< PathIter, PathIter > >::iterator Itep = broken_pos_ve.begin();
			for ( Itel = pathve[i].begin(); Itel != pathve[i].end(); ++Itel ) {
				if ( Itel == Itep->first ) {
				
					fp = *Itel;
					++Itel;
					pair< Supertig_id, Forb > lastp = fp;
					pair< Supertig_id, Forb > thisp;
					int gap = 0;
					while ( Itel  != Itep->second ) {
						thisp = *Itel;
						int over = get_ovlen_fr_cnct_nodes( lastp, reversepht(thisp), tig_bank.fdm_ovlkmap );
						if ( over == -1000 ) {
							cout<<"error in 22 ovlen == -1000 "<<lastp.first<<","<<lastp.second<<","<<thisp.first<<","<<thisp.second<<endl;  exit(1);
						}
						gap -= over;
						gap += tig_bank.Supertig_Map[thisp.first].length;
						lastp = thisp;
						++Itel;
					}
					thisp = *Itel;
					int over = get_ovlen_fr_cnct_nodes( lastp, reversepht(thisp), tig_bank.fdm_ovlkmap );
					gap -= over;
					bp = *Itel;
					broken_p.push_back( make_pair( fp, bp ) );
					broken_gap.push_back( gap );
				
					++Itep;
					if ( Itep == broken_pos_ve.end() )
						break;
					--Itel;
				}
			}
			broken_p_ve.push_back( broken_p );
			broken_gap_ve.push_back( broken_gap );
			broken_pathve.push_back( npve );
		} else {

			con_pathve.push_back( pathve[i] );

		}
	
	}
}

void getsingle_bs( vector< list< pair< Supertig_id, Forb > > > &pathve, set< Supertig_id > &single_bs, Supertig_bank &tig_bank )
{
	set< Supertig_id > used;
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		PathIter ite = pathve[i].begin();
		for (; ite != pathve[i].end(); ++ite ) {
			used.insert( ite->first );
		}
	}

	set< Supertig_id >::iterator Ites;
	for ( Ites = tig_bank.Basic_tig_set.begin(); Ites != tig_bank.Basic_tig_set.end(); ++Ites ) {
		if ( used.find( *Ites ) == used.end() )
			single_bs.insert( *Ites );

	}
}

void getsingle_bs( vector< list< pair< Supertig_id, Forb > > > &con_pathve,
				  vector< vector< list< pair< Supertig_id, Forb > > > > &broken_pathve,
				  set< Supertig_id > &single_bs,
				  Supertig_bank &tig_bank )
{
	set< Supertig_id > used;
	for ( size_t i = 0; i < con_pathve.size(); ++i ) {
		PathIter ite = con_pathve[i].begin();
		for (; ite != con_pathve[i].end(); ++ite ) {
			used.insert( ite->first );
		}
	}

	for ( size_t i = 0; i < broken_pathve.size(); ++i ) {
		for ( size_t j = 0; j < broken_pathve[i].size(); ++j ) {
			PathIter Ite;
			for ( Ite = broken_pathve[i][j].begin(); Ite != broken_pathve[i][j].end(); ++Ite ) {
				used.insert( Ite->first );
			}
		}
	}

	set< Supertig_id >::iterator Ites;
	for ( Ites = tig_bank.Basic_tig_set.begin(); Ites != tig_bank.Basic_tig_set.end(); ++Ites ) {
		if ( used.find( *Ites ) == used.end() )
			single_bs.insert( *Ites );

	}

}

void finalpath( vector< list< pair< Supertig_id, Forb > > > &pathve, set< Supertig_id > &single_id, Supertig_bank &tig_bank )
{

	tig_bank.Single_tig_Set.clear();
	tig_bank.Single_tig_Set = single_id;
	tig_bank.final_path = pathve;

	
}

void finalpath(vector< list< pair< Supertig_id, Forb > > > &con_pathve,
			   vector< vector< list< pair< Supertig_id, Forb > > > > &broken_pathve,
			   vector< vector< pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > > > &broken_p_ve,
			   vector< vector< int > > &broken_gap_ve,
			   set< Supertig_id > &single_bs,
			   Supertig_bank &tig_bank )
{
	tig_bank.Single_tig_Set.clear();
	tig_bank.Single_tig_Set = single_bs;
	tig_bank.con_pathve = con_pathve;
	tig_bank.broken_pathve = broken_pathve;
	tig_bank.broken_p_ve = broken_p_ve;
	tig_bank.broken_gap_ve = broken_gap_ve;

}

void ass_finalpath( list< pair< Supertig_id, Forb > > &path, Supertig &n_tig, Supertig_bank &tig_bank )
{
	list< pair<Supertig_id, Forb > >::iterator Itel = path.begin();

	

	int this_pos = 0;
	vector< pair< int, int > > single_pos_ve_1;
	single_pos_ve_1.push_back( make_pair( 1, tig_bank.Supertig_Map[Itel->first].length ) );
	n_tig.Tig_P_Ve.push_back( single_pos_ve_1 );
	this_pos = tig_bank.Supertig_Map[Itel->first].length;

	
	for ( Itel = path.begin(); Itel != path.end(); ++Itel ) {

		vector< Supertig_id > single_tig_ve;
		single_tig_ve.push_back( Itel->first );
		n_tig.Tig_Ve.push_back( single_tig_ve );
		vector< Forb > single_tig_f_ve;
		single_tig_f_ve.push_back( Itel->second );
		n_tig.Tig_F_Ve.push_back( single_tig_f_ve );

		list< pair< Supertig_id, Forb > >::iterator secitel = Itel;
		++secitel;
		if ( secitel == path.end() )
			break;
		
		
		int ovlen = get_ovlen_fr_cnct_nodes( *Itel, reversepht( *secitel ), tig_bank.fdm_ovlkmap );
		if ( ovlen == -1000 ) {
			cout<<"error in ass_finalpath ovlen = -1000 "<<Itel->first<<","<<Itel->second<<", "<<secitel->first<<","<<secitel->second<<endl;  exit(1);
				
		}
		
		

		vector< pair< int, int > > single_pos_ve;
		int fpos = this_pos - ovlen + 1;
		int bpos = fpos + tig_bank.Supertig_Map[secitel->first].length - 1;
		single_pos_ve.push_back( make_pair( fpos, bpos ) );

		n_tig.Tig_P_Ve.push_back( single_pos_ve );

		this_pos = bpos;

	}


}

// connect linking paths that overlaps
void cn_ov_path( vector< list< pair< Supertig_id, Forb > > > &pathve )
{
	vector< list< pair< Supertig_id, Forb > > > alpathve;
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		if ( i == 0 ) {
			alpathve.push_back( pathve[0] );
			continue;
		}

		bool contain = false;
		for ( size_t j = 0; j < alpathve.size(); ++j ) {

			/////type I/////////////////////////
			pair< Supertig_id, Forb > frontp = pathve[i].front();
			list< pair< Supertig_id, Forb > >::iterator Itel;
			Itel = find( alpathve[j].begin(), alpathve[j].end(), frontp );
			if ( Itel != alpathve[j].end() ) {
				list< pair< Supertig_id, Forb > >::iterator Itel_pi = pathve[i].begin();
				bool eq = true;
				++Itel;
				++Itel_pi;
				while( Itel != alpathve[j].end() ) {
					if ( Itel_pi == pathve[i].end() )
						break;
					if ( *Itel != *Itel_pi ) {
						eq = false;
						break;
					}

					++Itel;
					++Itel_pi;
				}
				if ( eq ) {
					if ( Itel == alpathve[j].end() ) {
						while ( Itel_pi != pathve[i].end() ) {
							alpathve[j].push_back( *Itel_pi );
							++Itel_pi;
						}
					}
					contain = true;
					break;
				}
			}

			//type II///////////////////////
			pair< Supertig_id, Forb > backp = pathve[i].back();
			list< pair< Supertig_id, Forb > >::reverse_iterator rite;
			rite = find( alpathve[j].rbegin(), alpathve[j].rend(), backp );
			if ( rite != alpathve[j].rend() ) {
				list< pair< Supertig_id, Forb > >::reverse_iterator rite_pi = pathve[i].rbegin();
				++rite;
				++rite_pi;
				bool eq = true;
				while ( rite != alpathve[j].rend() ) {
					if ( rite_pi == pathve[i].rend() )
						break;
					if ( *rite != *rite_pi ) {
						eq = false;
						break;
					}
					++rite;
					++rite_pi;
				}
				if ( eq ) {
					if ( rite == alpathve[j].rend() ) {
						while ( rite_pi != pathve[i].rend() ) {
							alpathve[j].push_front( *rite_pi );
							++rite_pi;
						}
					}
					contain = true;
					break;
				}

			}

			// type III/////////////////////
			list< pair< Supertig_id, Forb > > revpath = reverseplist( pathve[i] );
			frontp = revpath.front();
		//	list< pair< Supertig_id, Forb > >::iterator Itel;
			Itel = find( alpathve[j].begin(), alpathve[j].end(), frontp );
			if ( Itel != alpathve[j].end() ) {
				list< pair< Supertig_id, Forb > >::iterator Itel_pi = revpath.begin();
				bool eq = true;
				++Itel;
				++Itel_pi;
				while( Itel != alpathve[j].end() ) {
					if ( Itel_pi == revpath.end() )
						break;
					if ( *Itel != *Itel_pi ) {
						eq = false;
						break;
					}

					++Itel;
					++Itel_pi;
				}
				if ( eq ) {
					if ( Itel == alpathve[j].end() ) {
						while ( Itel_pi != revpath.end() ) {
							alpathve[j].push_back( *Itel_pi );
							++Itel_pi;
						}
					}
					contain = true;
					break;
				}
			}

			//type II///////////////////////
			backp = revpath.back();
		//	list< pair< Supertig_id, Forb > >::reverse_iterator rite;
			rite = find( alpathve[j].rbegin(), alpathve[j].rend(), backp );
			if ( rite != alpathve[j].rend() ) {
				list< pair< Supertig_id, Forb > >::reverse_iterator rite_pi = revpath.rbegin();
				++rite;
				++rite_pi;
				bool eq = true;
				while ( rite != alpathve[j].rend() ) {
					if ( rite_pi == revpath.rend() )
						break;
					if ( *rite != *rite_pi ) {
						eq = false;
						break;
					}
					++rite;
					++rite_pi;
				}
				if ( eq ) {
					if ( rite == alpathve[j].rend() ) {
						while ( rite_pi != revpath.rend() ) {
							alpathve[j].push_front( *rite_pi );
							++rite_pi;
						}
					}
					contain = true;
					break;
				}

			}

		}

		if ( !contain ) {
			alpathve.push_back( pathve[i] );
		}

	}


	pathve = alpathve;
}




void getposlist( list< pair< Supertig_id, Forb > > &path, list< pair< int, int > > &poslist, Supertig_bank &tig_bank )
{
	list< pair< Supertig_id, Forb > >::iterator Itep = path.begin();
	poslist.push_back( make_pair( 1, tig_bank.Supertig_Map[Itep->first].length ) );
	int thispos = tig_bank.Supertig_Map[Itep->first].length;
	pair< Supertig_id, Forb > lastp = *path.begin();
	++Itep;
	for ( ; Itep != path.end(); ++Itep ) {
		pair< Supertig_id, Forb > thisp = *Itep;
		int overlap = get_ovlen_fr_cnct_nodes( lastp, reversepht(thisp), tig_bank.fdm_ovlkmap );
		if ( overlap == -1000 ) {
			cout<<"error in get poslist ovlen = -1000"<<endl;  exit(1); 
		}
		int fpos = thispos - overlap + 1;
		int bpos = fpos + tig_bank.Supertig_Map[thisp.first].length - 1;
		poslist.push_back( make_pair( fpos, bpos ) );
		lastp = thisp;
		thispos = bpos;

	}

	list< pair< int, int > >::iterator Itel;
	for ( Itel = poslist.begin(); Itel != poslist.end(); ++Itel ) {
		Itel->second = thispos - Itel->second + 1;
	}
}

