#ifndef GRAPH_BESTMATEPATH_H
#define GRAPH_BESTMATEPATH_H



#include "Graph_unp_Stig.h"


typedef list< pair< Supertig_id, Forb > >::iterator PathIter;

void getbestmatepath( subgraph &graph_t, Supertig_bank &tig_bank );

void unpack_tig( Supertig_id tig_id, subgraph &graph_t, Supertig_bank &tig_bank );

void exact_used_basetig( set< Supertig_id > &active_id, set< Supertig_id > &used_basetig, subgraph &graph_t, Supertig_bank &tig_bank );

//void exact_anchor_id( set< Supertig_id > &active_id, set< Supertig_id > &anchor_id, subgraph &graph_t, Supertig_bank &tig_bank );
void exact_single_allseries( set< Supertig_id > &single_s, 
							set< Supertig_id > &active_id,
							vector< list< pair< Supertig_id, Forb > > > superpath,
							Supertig_bank &tig_bank );

void getmateseedrank( set< Supertig_id > &active_id,
					 set< Supertig_id > &single_series,
					 map< double, multimap< int, Supertig_id, greater<int> >, greater< double > > &seed_rank, 
					 Supertig_bank &tig_bank );

void getMateseedrankAndNoncontra( set< Supertig_id > &active_id, 
								set< Supertig_id > &single_series,                // not in the super path, i.e. a separate node.
								map< int, Supertig_id > &seed_rank,
								set< Supertig_id > &non_contra,
								Supertig_bank &tig_bank );

bool checkbigbulb( Supertig_id tig_id, Supertig_bank &tig_bank );

double calculate_rd_mate_conf( Supertig_id tig_id, Supertig_bank &tig_bank );

void bestpath_1r( map< int, Supertig_id > &seed_rank,
				 vector< list< pair< Supertig_id, Forb > > > &superpath,
				 vector< list< pair< Supertig_id, Forb > > > &bestpath,
				 set< Supertig_id > &non_contra,
				 Supertig_bank &tig_bank,
				 subgraph &graph_t );

void getremainpath( vector< list< pair< Supertig_id, Forb > > > &bestpath, 
				   vector< list< pair< Supertig_id, Forb > > > &superpath,
				   vector< list< pair< Supertig_id, Forb > > > &remainpath,
				   set< Supertig_id > &single_id );

void getbestpath1( pair< Supertig_id, Forb> seed_p,
				 PathIter &iter_bepath,
				 list< pair< Supertig_id, Forb > > &bepath,
				 vector< size_t > id_supath,
				 vector<list< pair< Supertig_id, Forb > > > &superpath,
				 list< pair< Supertig_id, Forb > > &addpath,
				 map< Supertig_id, size_t > &id_bepath_map,
				 vector< list< pair< Supertig_id, Forb > > > &bestpath,
				 Supertig_bank &tig_bank );

double elong1_mate_hit_check( pair< Supertig_id, Forb > seed_p,
							 PathIter &iter_bepath,
							 PathIter &iter_supath,
							 int elonglen,
							 pair< Supertig_id, Forb > lastp,
							 list< pair< Supertig_id, Forb > > &bepath,
							 list< pair< Supertig_id, Forb > > &supath,
							 list< pair< Supertig_id, Forb > > &addpath,
							 map< Supertig_id, size_t > &id_bepath_map,
							 vector< list< pair< Supertig_id, Forb > > > &bestpath,
							 Supertig_bank &tig_bank );

void getbestpath2( vector< list< pair< Supertig_id, Forb > > > &bestpath, 
				  set< Supertig_id > &bone_id,
				  Supertig_bank &tig_bank );

void getbestpath2_t( list< pair< Supertig_id, Forb > > &bepath,
					list< pair< Supertig_id, Forb > > &selectpath,
					set< Supertig_id > &bone_id,
					Supertig_bank &tig_bank );

void bulbpathselect( pair< Supertig_id, Forb > b_id_p, 
					list< pair< Supertig_id, Forb > > &selectp,
					set< Supertig_id > &fishid,
					set< Supertig_id > &bone_id_all,
					Supertig_bank &tig_bank );

size_t bulbselectrule( Supertig_id tid, set< Supertig_id > &fishid, set< Supertig_id > &bone_id_all, Supertig_bank &tig_bank );

bool check_used_in_bone( Supertig_id tid, Supertig_bank &tig_bank, set< Supertig_id > &usedset );

size_t check_unused_in_bone( Supertig_id tid, Supertig_bank &tig_bank, set< Supertig_id > &usedset, set< Supertig_id > &unused_id );

size_t check_id_num_all( Supertig_id tid, Supertig_bank &tig_bank, set< Supertig_id > &allid );

void getspfrp( vector< list< pair< Supertig_id, Forb > > > &remainpath,
			  vector< list< pair< Supertig_id, Forb > > > &simpath, 
			  subgraph &graph_t,
			  Supertig_bank &tig_bank,
			  set< Supertig_id > &single_id );

void unpack_left_single( set< Supertig_id > &single,
						set< Supertig_id > &single_series,
						vector< list< pair< Supertig_id, Forb > > > &selectpve,
						set< Supertig_id > &bone_id_all,
						Supertig_bank &tig_bank );

void bulbtig_select( pair< Supertig_id, Forb > b_id_p, 
					list< pair< Supertig_id, Forb > > &selectp,
					vector< list< pair< Supertig_id, Forb > > > &selectpve,
					set< Supertig_id > fish,
					set< Supertig_id > &bone_id_all,
					Supertig_bank &tig_bank );

bool bulbtigselectrule( Supertig_id tid, set< Supertig_id > &fishid, set< Supertig_id > &bone_id_all, Supertig_bank &tig_bank, vector< size_t> &select_k );

void getpathfromseries( vector< list< pair< Supertig_id, Forb > > > &pathve,
					   set< Supertig_id > &single_series,
					   Supertig_bank &tig_bank );

void get_mcip( vector< list< pair< Supertig_id, Forb > > > &pathve,
			  vector< list< double > > &mate_cover_inpath,
			  Supertig_bank &tig_bank );

void get_mcip_t( list< pair< Supertig_id, Forb > > &path,
			  list< double > &mate_cover_inpath,
			  Supertig_bank &tig_bank );

void get_mcip_2( vector< list< pair< Supertig_id, Forb > > > &pathve,
			   vector< list< double > > &mate_cover_inpath,
			   Supertig_bank &tig_bank );

void get_mcip_2_t( list< pair< Supertig_id, Forb > > &path,
			      list< double > &mate_cover_inpath,
			      Supertig_bank &tig_bank );

void getrepeat( vector< list< pair< Supertig_id, Forb > > > &pathve, map< Supertig_id, int > &repeat );

void getnoncontra( set< Supertig_id > &activeid, set< Supertig_id > &non_contra, Supertig_bank &tig_bank );


int check_week_link_side( vector< list< pair< Supertig_id, Forb > > > &pathve, 
					    vector< list< double > > &matesc, 
					    map< Supertig_id, int > &repeat );

void check_week_link_middle( vector< list< pair< Supertig_id, Forb > > > &pathve, 
						   vector< list< double > > &matesc, 
					       map< Supertig_id, int > &repeat,
						   vector< list< pair< Supertig_id, Forb > > > &con_pathve,
						   vector< vector< list< pair< Supertig_id, Forb > > > > &broken_pathve,
						   vector< vector< pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > > > &broken_p_ve,
						   vector< vector< int > > &broken_gap_ve,
						   Supertig_bank &tig_bank );

void getsingle_bs( vector< list< pair< Supertig_id, Forb > > > &pathve, set< Supertig_id > &single_bs, Supertig_bank &tig_bank );

void getsingle_bs( vector< list< pair< Supertig_id, Forb > > > &con_pathve,
				  vector< vector< list< pair< Supertig_id, Forb > > > > &broken_pathve,
				  set< Supertig_id > &single_bs,
				  Supertig_bank &tig_bank );

void finalpath( vector< list< pair< Supertig_id, Forb > > > &pathve, set< Supertig_id > &single_id, Supertig_bank &tig_bank );

void finalpath(vector< list< pair< Supertig_id, Forb > > > &con_pathve,
			   vector< vector< list< pair< Supertig_id, Forb > > > > &broken_pathve,
			   vector< vector< pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > > > &broken_p_ve,
			   vector< vector< int > > &broken_gap_ve,
			   set< Supertig_id > &single_bs,
			   Supertig_bank &tig_bank );

void ass_finalpath( list< pair< Supertig_id, Forb > > &path, Supertig &n_tig, Supertig_bank &tig_bank );

void cn_ov_path( vector< list< pair< Supertig_id, Forb > > > &pathve );

void getposlist( list< pair< Supertig_id, Forb > > &path, list< pair< int, int > > &poslist, Supertig_bank &tig_bank );

#endif

