#include "Graph_bubble.h"

void graph_bubble( subgraph &graph_t, Scaffold_subset &scf_s, Supertig_bank &bank, int var_len )
{

	int tag = 0;
	map< pair< Supertig_id, Forb >, fished_bait >::iterator Iteb;
	for ( Iteb = scf_s.seed_bait_map.begin(); Iteb != scf_s.seed_bait_map.end(); ++Iteb ) {
		map< pair< Supertig_id, Forb >, set< int > >::iterator Ite_bb;
		map< int, pair< Supertig_id, Forb > > bb_rank;
		for ( Ite_bb = Iteb->second.bubble_bait_length_map.begin(); Ite_bb != Iteb->second.bubble_bait_length_map.end(); ++Ite_bb ) {
			bb_rank.insert( make_pair( *Ite_bb->second.begin(), Ite_bb->first ) );
		}

		map< int, pair< Supertig_id, Forb > >::iterator Ite_br;
		for ( Ite_br = bb_rank.begin(); Ite_br != bb_rank.end(); ++Ite_br ) {

			int lowb_len = Ite_br->first - var_len;
			int upb_len = Ite_br->first + var_len;

		
			if ( bubble_search( Iteb->first, Ite_br->second, graph_t, scf_s, bank, lowb_len, upb_len ) ) {
				tag = 1;
			}
		
			
		}
	}

	
}

bool bubble_search( pair< Supertig_id, Forb > seed, 
				   pair< Supertig_id, Forb > bait, 
				   subgraph &graph_t, 
				   Scaffold_subset &scf_s, 
				   Supertig_bank &bank,
				   int lowb_len,
				   int upb_len )
{

	
	vector< list< pair< Supertig_id, Forb > > > hitpath;
	bool semibulb = false;
	size_t vesize = scf_s.superpath.size();
	for ( size_t i = 0; i < vesize; ++i ) {
		list< pair< Supertig_id, Forb > > subpath;
		if ( bubble_s_subpath_find( seed, bait, scf_s.superpath[i], subpath, graph_t, bank, lowb_len, upb_len ) ) {
		
			if ( !subpath.empty() )
				insplist( hitpath, subpath );
			else
				semibulb = true;
		
		}
	}
	

	pair< Supertig_id, Forb > prep = seed;
	pair< Supertig_id, Forb > bp = bait;

	if ( bubble_s_bchop( hitpath, prep, bp ) ) {
	
		if ( semi_bubble_check( hitpath ) ) {
			semibulb = true;

		}
		

	

		if ( (int)hitpath.size() == 1 )
			return false;

		
	
	
		re_rank_hitpath( hitpath );

		reduceselftrave( hitpath );

		

		
		set< pair< Supertig_id, Forb > > left_linked_node;
		set< pair< Supertig_id, Forb > > right_linked_node;
		if ( !find_hete( prep, bp, hitpath, scf_s.superpath, graph_t, bank ) )
			return false;
	
	
		
		vector< Supertig_id > bubble;
		bubble_sim_path_ass( hitpath, graph_t, bank, scf_s.superpath, bubble );
		

		Supertig_id n_id = supertig_in_para_ass( bubble, graph_t, bank );
		vector< pair< Supertig_id, Forb > > b_tig_forb;
		get_bubble_tig_forb( bank.Supertig_Map[n_id], b_tig_forb );
	
		path_replace_in_para( b_tig_forb, scf_s.superpath, n_id );

		
		
	
		reduce_redunbulbpath( scf_s.superpath, n_id );
	

		removetendam( graph_t.scf_s.superpath );

		if ( semibulb )
			bank.Supertig_Map[n_id].semi_bulb = 1;

	
		return true;
	}

	return false;


}

void reduceselftrave( vector< list< pair< Supertig_id, Forb > > > &hitpath )
{
	vector< list< pair< Supertig_id, Forb > > > npathve;
	for ( size_t i = 0; i < hitpath.size(); ++i ) {
		if ( npathve.empty() )
			npathve.push_back( hitpath[i] );
		else {
			bool rev = false;
			for ( size_t j = 0; j < npathve.size(); ++j ) {
				if ( npathve[j] == reverseplist( hitpath[i] ) ) {
					rev = true;
					break;
				}
			}
			if ( !rev ) {
				npathve.push_back( hitpath[i] );
			}
		}
	}
	hitpath = npathve;
}

void removetendam( vector< list< pair< Supertig_id, Forb > > > &superpath )
{
	for ( size_t i = 0; i < superpath.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator itel = superpath[i].begin();
		list< pair< Supertig_id, Forb > > np;
		np.push_back( *itel );
		++itel;
		for ( ; itel != superpath[i].end(); ++itel ) {
			if ( *itel != np.back() ) {
				np.push_back( *itel );
			}
		}
		superpath[i] = np;

	}
}

void re_rank_hitpath( vector< list< pair< Supertig_id, Forb > > > &hitpath )
{
	multimap< size_t, list< pair< Supertig_id, Forb > >, greater< size_t > > hitpathmap;
	for ( size_t i = 0; i < hitpath.size(); ++i ) {
		hitpathmap.insert( make_pair( hitpath[i].size(), hitpath[i] ) );
	}
	hitpath.clear();
	multimap< size_t, list< pair< Supertig_id, Forb > >, greater< size_t > >::iterator Ite;
	for ( Ite = hitpathmap.begin(); Ite != hitpathmap.end(); ++Ite ) {
		hitpath.push_back( Ite->second );
	}
}

bool bubble_s_subpath_find( pair< Supertig_id, Forb > seed, 
						   pair< Supertig_id, Forb > bait, 
						   list< pair< Supertig_id, Forb > > &path,
						   list< pair< Supertig_id, Forb > > &outsubpath,
						   subgraph &graph_t, 
						   Supertig_bank &bank,
						   int lowb_len, 
						   int upb_len )
{
	if ( path.front() != seed )
		return false;
	if ( path.back() == bait ) {
	
		if ( bubble_s_elen_check( path, graph_t, bank, lowb_len, upb_len ) ) {
			outsubpath = path;
			outsubpath.pop_back();
			outsubpath.pop_front();
		
			return true;
		} 
	}
	list< pair< Supertig_id, Forb > >::iterator Ite = find( path.begin(), path.end(), bait );
	if ( Ite == path.end() || Ite == path.begin() )
		return false;
	else {
		++Ite;
		list< pair< Supertig_id, Forb > > ti_subpath;
		ti_subpath.insert( ti_subpath.end(), path.begin(), Ite );
		if ( bubble_s_elen_check( ti_subpath, graph_t, bank, lowb_len, upb_len ) ) {
			outsubpath = ti_subpath;
			outsubpath.pop_back();
			outsubpath.pop_front();
			return true;
		}
	}

	return false;

	
}

bool bubble_s_elen_check( list< pair< Supertig_id, Forb > > &path, subgraph &graph_t, Supertig_bank &tig_bank, int lowb_len, int upb_len )
{
	
	int elen = path_elengap_get( path, graph_t, tig_bank );

	if ( elen >= lowb_len && elen <= upb_len )
		return true;
	else
		return false;
}

bool bubble_s_bchop( vector< list< pair< Supertig_id, Forb > > >& pathve, pair< Supertig_id, Forb > &p, pair< Supertig_id, Forb > &baitp )
{
	int vesize = (int)pathve.size();
	if ( vesize <= 1 ) {
	//	cerr << "Warning in bubble_s_bchop: pathve size <= 1! " << vesize <<endl;
		return false;
	}
	list< pair< Supertig_id, Forb > > fir_path = pathve[0];
	
	
	while ( !bubble_s_bchop_comp( pathve ) ) {
		p = bubble_s_bchop_t( pathve );
	
	}

	while ( !bubble_s_bchop_comp_back( pathve ) ) {
		baitp = bubble_s_bchop_t_back( pathve );
	
	}

	bool bulb = bubble_s_bchop_check( pathve );
	if ( !bulb ) {
	
		return bulb;
	}
	int size_afterchop = (int)pathve.size();

	if ( size_afterchop < vesize ) {
		bulb = bubble_s_bchop( pathve, p, baitp );
	}
	return bulb;

}

bool bubble_s_bchop_comp( vector< list< pair< Supertig_id, Forb > > >& pathve )
{
	if ( pathve[0].empty() )
		return true;
	for ( size_t i = 1; i < pathve.size(); ++i ) {
		if ( pathve[i].empty() )
			return true;
		if ( pathve[i].front() != pathve[0].front() )
			return true;
	}
	return false;
}

bool bubble_s_bchop_comp_back( vector< list< pair< Supertig_id, Forb > > >& pathve )
{
	if ( pathve[0].empty() )
		return true;
	for ( size_t i = 1; i < pathve.size(); ++i ) {
		if ( pathve[i].empty() )
			return true;
		if ( pathve[i].back() != pathve[0].back() )
			return true;
	}
	return false;

}

pair< Supertig_id, Forb > bubble_s_bchop_t( vector< list< pair< Supertig_id, Forb > > >& pathve )
{
	pair< Supertig_id, Forb > p = pathve[0].front();
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		pathve[i].pop_front();

	}

	return p;
}

pair< Supertig_id, Forb > bubble_s_bchop_t_back( vector< list< pair< Supertig_id, Forb > > >& pathve )
{
	pair< Supertig_id, Forb > p = pathve[0].back();
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		pathve[i].pop_back();

	}

	return p;
}

bool bubble_s_bchop_check( vector< list< pair< Supertig_id, Forb > > >& pathve )
{
	vector< list< pair< Supertig_id, Forb > > > al_path_ve;
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		if ( !pathve[i].empty() ) {
			al_path_ve.push_back( pathve[i] );
		}

	}
	pathve = al_path_ve;
	if ( !pathve.empty() )
		return true;
	else
		return false;
	
}

void mark_semi_bulb( list< pair< Supertig_id, Forb > > & path, Supertig_bank &bank )
{
	list< pair< Supertig_id, Forb > >::iterator Ite;
	for ( Ite = path.begin(); Ite != path.end(); ++Ite ) {
		bank.Supertig_Map[Ite->first].semi_bulb = 1;
	}
}


bool bridge_info_empty_check( map< size_t, vector< bridge_info > > &bridge_info_map )
{
	map< size_t, vector< bridge_info > >::iterator Ite;
	for ( Ite = bridge_info_map.begin(); Ite != bridge_info_map.end(); ++Ite ) {
		if ( !Ite->second.empty() )
			return false;
	}
	return true;
}

bool find_hete( pair< Supertig_id, Forb > seed, 
			   pair< Supertig_id, Forb > bait,
			   vector< list< pair< Supertig_id, Forb > > > &hitpath,
			   vector< list< pair< Supertig_id, Forb > > > &superpath,
			   subgraph &graph_t,
			   Supertig_bank & bank )
{
	
	set< pair< Supertig_id, Forb > > left_linked_node;
	set< pair< Supertig_id, Forb > > right_linked_node;

	left_linked_node.insert( seed );
	right_linked_node.insert( reversepht( bait ) );
	
	vector< pair< Supertig_id, Forb > > tail_p_ve;
	vector< pair< Supertig_id, Forb > > head_p_ve;

	map< size_t, vector< bridge_info > > bridge_info_map;
	map< size_t, vector< Pos > > spath_pos_map;
	for ( size_t i = 0; i < hitpath.size(); ++i ) {
		if ( hitpath[i].empty() )
			continue;
		for ( size_t j = 0; j < superpath.size(); ++j ) {
			get_bridge_info( hitpath[i], superpath[j], j, i, spath_pos_map, bridge_info_map );
		}
	}

	set< size_t > non;
	for ( size_t i = 0; i < hitpath.size(); ++i ) {
		if ( bridge_info_map.find( i ) == bridge_info_map.end() ) {
			non.insert(i);
		}
	}
	if ( !non.empty() ) {
		map< size_t, vector< bridge_info > > albm;
		vector< list< pair< Supertig_id, Forb > > > alp;
		for ( size_t i = 0; i < hitpath.size(); ++i ) {
			if ( non.find(i) == non.end() ) {

				alp.push_back( hitpath[i] );
				size_t k = alp.size();
				albm.insert( make_pair( k-1, bridge_info_map[i] ) );
			}
		}
		hitpath = alp;
		bridge_info_map = albm;
	}


	bool red = reduce_spu_bridge( bridge_info_map );
	while ( red ) {
		red = reduce_spu_bridge( bridge_info_map );
	}


	if ( bridge_info_empty_check( bridge_info_map ) ) {

		return false;
	}


	// find tig need to replace

	set< Supertig_id > repl_tig_set;
	map< Supertig_id, map< size_t, vector< Pos > > > hete_pos_map;
	find_out_repl_tig( bridge_info_map, hitpath, superpath, repl_tig_set, hete_pos_map );

	


	// add new tig id to repl tig found in previous step or just in bridge

	map< pair< size_t, Supertig_id >, Supertig_id > id_map;
	assign_new_id_repl_tig( repl_tig_set, hitpath, graph_t, bank, id_map );

	if ( !id_map.empty() ) {
		// replace ovlk for new id
	
		replace_ovlk( bridge_info_map, id_map, graph_t, bank, hitpath, superpath, hete_pos_map );
		

		// replace new id in superpath
	
		replace_superpath( id_map, repl_tig_set, superpath, bridge_info_map );
		

		// replace new id in hitpath
	
		replace_hitpath( id_map, hitpath );
		
	}

	return true;

}

void replace_ovlk( map< size_t, vector< bridge_info > > &bridge_info_map,
				  map< pair< size_t, Supertig_id >, Supertig_id > &id_map,
				  subgraph &graph_t,
				  Supertig_bank &bank,
				  vector< list< pair< Supertig_id, Forb > > > &hitpath,
				  vector< list< pair< Supertig_id, Forb > > > &superpath,
				  map< Supertig_id, map< size_t, vector< Pos > > > &hete_pos_map )
{

	// add new ovlk for new added tig id
	pair< Supertig_id, Forb > null;

	map< pair< size_t, Supertig_id >, Supertig_id >::iterator Ite;

	for ( size_t i = 0; i < hitpath.size(); ++i ) {

		map< Supertig_id, Supertig_id > extended_id_map;
		map< pair< size_t, Supertig_id >, Supertig_id >::iterator Iteidmap;
		for ( Iteidmap = id_map.begin(); Iteidmap != id_map.end(); ++Iteidmap ) {
			if ( Iteidmap->first.first == i ) {
				extended_id_map.insert( make_pair( Iteidmap->first.second, Iteidmap->second ) );
			}
		}

		if ( (int)hitpath[i].size() > 1 ) {
			list< pair< Supertig_id, Forb > >::iterator Ite = hitpath[i].begin();
			pair< Supertig_id, Forb > prep = *Ite;
			if ( extended_id_map.find( prep.first ) == extended_id_map.end() ) {
				extended_id_map.insert( make_pair( prep.first, prep.first ) );
			}
			++Ite;
			for ( ; Ite != hitpath[i].end(); ++Ite ) {
				if ( extended_id_map.find( Ite->first ) == extended_id_map.end() ) {
					extended_id_map.insert( make_pair( Ite->first, Ite->first ) );
				}
				if ( id_map.find( make_pair( i, prep.first ) ) != id_map.end() || id_map.find( make_pair( i, Ite->first ) ) != id_map.end() ) {
					ov_link_add_2( prep, reversepht( *Ite ), extended_id_map, graph_t, bank );
				}
				prep = *Ite;
			}
		} 
		map< Supertig_id, Supertig_id >::iterator itee;
	

		///////////////////for test bug///////////////////////
		if ( bridge_info_map.find( i ) == bridge_info_map.end() ) {
			cerr << "Warning in replace_ovlk: idmap not find key i "<<i<<endl;   system("pause");
			continue;
		} 
		///////////////////////test end////////////////////

		for ( size_t k = 0; k < bridge_info_map[i].size(); ++k ) {
			if ( id_map.find( make_pair( i, hitpath[i].front().first ) ) != id_map.end() ) {
				if ( bridge_info_map[i][k].left_linked_node != null ) {
				
				
					int ovlen = get_ovlen_fr_cnct_nodes( bridge_info_map[i][k].left_linked_node, reversepht( hitpath[i].front() ), graph_t );
				
					ov_link_add( bridge_info_map[i][k].left_linked_node, make_pair( id_map[make_pair( i, hitpath[i].front().first ) ], reverseforb( hitpath[i].front().second ) ), graph_t, bank, ovlen );
					ov_link_add( make_pair( id_map[make_pair( i, hitpath[i].front().first ) ], reverseforb( hitpath[i].front().second ) ), bridge_info_map[i][k].left_linked_node, graph_t, bank, ovlen );
				
				}
			}
			if ( id_map.find( make_pair( i, hitpath[i].back().first ) ) != id_map.end() ) {
				if ( bridge_info_map[i][k].right_linked_node != null ) {
				
				
					int ovlen = get_ovlen_fr_cnct_nodes( bridge_info_map[i][k].right_linked_node, hitpath[i].back(), graph_t );
				
					ov_link_add( make_pair( id_map[make_pair( i, hitpath[i].back().first ) ], hitpath[i].back().second ), bridge_info_map[i][k].right_linked_node, graph_t, bank, ovlen );
					ov_link_add( bridge_info_map[i][k].right_linked_node, make_pair( id_map[make_pair( i, hitpath[i].back().first ) ], hitpath[i].back().second ), graph_t, bank, ovlen );
				
				}
			}
		}
	}

	// get protected ovlink
	set< pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > > protected_lk;
	for ( size_t i = 0; i < superpath.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Itel;
		for ( Itel = superpath[i].begin(); Itel != superpath[i].end(); ++Itel ) {
			if ( hete_pos_map.find( Itel->first ) != hete_pos_map.end() ) {
				if ( hete_pos_map[Itel->first].find( i ) != hete_pos_map[Itel->first].end() ) {
					if ( find_pos( hete_pos_map[Itel->first][i], Itel ) ) {
						if ( Itel != superpath[i].begin() ) {
							list< pair< Supertig_id, Forb > >::iterator tempite = Itel;
							--tempite;
							protected_lk.insert( make_pair( *tempite, reversepht( *Itel ) ) );
							
						}
						list< pair< Supertig_id, Forb > >::iterator tempite_2 = Itel;
						++tempite_2;
						if ( tempite_2 != superpath[i].end() ) {
							protected_lk.insert( make_pair( *Itel, reversepht( *tempite_2 ) ) );
						}
					}
				}
			}
		}
	}

	// erase lk that has replaced in add step
	for ( size_t i = 0; i < hitpath.size(); ++i ) {
		if ( (int)hitpath[i].size() > 1 ) {
			list< pair< Supertig_id, Forb > >::iterator Ite = hitpath[i].begin();
			pair< Supertig_id, Forb > prep = *Ite;
			++Ite;
			for ( ; Ite != hitpath[i].end(); ++Ite ) {
				if ( id_map.find( make_pair( i, prep.first ) ) != id_map.end() || id_map.find( make_pair( i, Ite->first ) ) != id_map.end() ) {
					if ( protected_lk.find( make_pair( prep, reversepht( *Ite ) ) ) == protected_lk.end() && 
						protected_lk.find( make_pair( reversepht( *Ite ), prep ) ) == protected_lk.end() ) {
							ov_link_erase( prep, reversepht( *Ite ), graph_t, bank );
							ov_link_erase( reversepht( *Ite ), prep, graph_t, bank );
						//	cout<<"erase lk:"<<prep.first<<","<<prep.second<<","<<Ite->first<<","<<reverseforb(Ite->second)<<endl;
					}
				}
				prep = *Ite;
			}
		}
		///////////////////for test bug///////////////////////
		if ( bridge_info_map.find( i ) == bridge_info_map.end() ) {
			cerr << "Warning in replace_ovlk: idmap not find key i "<<i<<endl;   system("pause");
			continue;
		} 
		///////////////////////test end////////////////////

		for ( size_t k = 0; k < bridge_info_map[i].size(); ++k ) {
			if ( id_map.find( make_pair( i, hitpath[i].front().first ) ) != id_map.end() ) {
				if ( bridge_info_map[i][k].left_linked_node != null ) {
					if ( protected_lk.find( make_pair( bridge_info_map[i][k].left_linked_node, reversepht( hitpath[i].front() ) ) ) == protected_lk.end() &&
						protected_lk.find( make_pair( reversepht( hitpath[i].front() ), bridge_info_map[i][k].left_linked_node ) ) == protected_lk.end() ) {
							ov_link_erase( bridge_info_map[i][k].left_linked_node, reversepht( hitpath[i].front() ), graph_t, bank );
							ov_link_erase( reversepht( hitpath[i].front() ), bridge_info_map[i][k].left_linked_node, graph_t, bank );
						
					}
					
				}
			}
			if ( id_map.find( make_pair( i, hitpath[i].back().first ) ) != id_map.end() ) {
				if ( bridge_info_map[i][k].right_linked_node != null ) {
					if ( protected_lk.find( make_pair( bridge_info_map[i][k].right_linked_node, hitpath[i].back() ) ) == protected_lk.end() &&
						protected_lk.find( make_pair( hitpath[i].back(), bridge_info_map[i][k].right_linked_node ) ) == protected_lk.end() ) {
							ov_link_erase( hitpath[i].back(), bridge_info_map[i][k].right_linked_node, graph_t, bank );
							ov_link_erase( bridge_info_map[i][k].right_linked_node, hitpath[i].back(), graph_t, bank );
						
					}
				}
			}
		}
	}

}

Supertig_id get_repl_tigid( Supertig_id id,
					size_t spath_id,
					Pos pos,
					map< pair< size_t, Supertig_id >, Supertig_id > &id_map,
					map< size_t, vector< bridge_info > > &bridge_info_map )
{
	
	map< size_t, vector< bridge_info > >::iterator Ite;
	for ( Ite = bridge_info_map.begin(); Ite != bridge_info_map.end(); ++Ite ) {
		for ( size_t i = 0; i < Ite->second.size(); ++i ) {
			if ( Ite->second[i].path_id == spath_id ) {
				if ( find_pos( Ite->second[i].posve, pos ) ) {
				
					if ( id_map.find( make_pair( Ite->first, id ) ) == id_map.end() ) {
						cerr <<"Error in get_repl_tigid: "<<endl;
						exit(2);
					}
					return id_map[ make_pair( Ite->first, id ) ];
				}
			}
		}
	}

	return -1;

}
		

void replace_superpath( map< pair< size_t, Supertig_id >, Supertig_id > &id_map,
					   set< Supertig_id >& repl_tig_set,
					   vector< list< pair< Supertig_id, Forb > > > &superpath,
					   map< size_t, vector< bridge_info > > &bridge_info_map )
{
	for ( size_t i = 0; i < superpath.size(); ++i ) {
	
		list< pair< Supertig_id, Forb > >::iterator Ite;
		for ( Ite = superpath[i].begin(); Ite != superpath[i].end(); ++Ite ) {
			if ( repl_tig_set.find( Ite->first ) != repl_tig_set.end() ) {
				if ( find_pos( bridge_info_map, i, Ite ) ) {
					Supertig_id n_id = get_repl_tigid( Ite->first, i, Ite, id_map, bridge_info_map );
				
					Ite->first = n_id;
				}
			}
		}
	
	}
}

void replace_hitpath( map< pair< size_t, Supertig_id >, Supertig_id > &id_map, vector< list< pair< Supertig_id, Forb > > > &hitpath )
{
	for ( size_t i = 0; i < hitpath.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Ite;
		for ( Ite = hitpath[i].begin(); Ite != hitpath[i].end(); ++Ite ) {
			if ( id_map.find( make_pair( i, Ite->first ) ) != id_map.end() ) {
				Ite->first = id_map[make_pair( i, Ite->first )];
			}
		}
	}
}

bool find_pos( vector< Pos > &pos_ve, Pos pos )
{
	for ( size_t i = 0; i < pos_ve.size(); ++i ) {
		if ( pos_ve[i] == pos )
			return true;
	}
	return false;
}

void get_bridge_info( list< pair< Supertig_id, Forb > > &hitpath,
					 list< pair< Supertig_id, Forb > > &spath,
					 size_t spath_id,
					 size_t hitpath_id,
					 map< size_t, vector< Pos > > &spath_posmap,
					 map< size_t, vector< bridge_info > > &bridge_info_map )
{

	list< pair< Supertig_id, Forb > >::iterator Itel;
	pair< Supertig_id, Forb > prep = hitpath.front();
	Itel = find( spath.begin(), spath.end(), prep );
	vector< Pos > hit_pos_ve;
	if ( spath_posmap.find( spath_id ) != spath_posmap.end() )
		hit_pos_ve.insert( hit_pos_ve.end(), spath_posmap[spath_id].begin(), spath_posmap[spath_id].end() );

	while ( Itel != spath.end() ) {

		if ( find_pos( hit_pos_ve, Itel ) ) {
			if ( spath_id == 136 && hitpath_id == 3 ) {
				cout<<Itel->first<<","<<Itel->second<<endl;
				
			}
			++Itel;
			Itel = find( Itel, spath.end(), prep );
		
			continue;
		}

		list< pair< Supertig_id, Forb > >::iterator tempite = Itel;
		list< pair< Supertig_id, Forb > >::iterator tempite_2 = Itel;
		pair< Supertig_id, Forb > left_linked_node;
		if ( tempite != spath.begin() ) {
			--tempite;
			left_linked_node = *tempite;
		}

		list< pair< Supertig_id, Forb > >::iterator Ites = hitpath.begin();
		bool hit = true;
		vector< Pos > temphitpos;
		for ( ; Ites != hitpath.end(); ++Ites ) {
		
			if ( Itel == spath.end() ) {
			
				hit = false;
				break;
			}
			
			if ( *Itel != *Ites ) {
			
				hit = false;
				break;
			}
			temphitpos.push_back( Itel );
			++Itel;
		}
		if ( hit ) {
			hit_pos_ve.insert( hit_pos_ve.end(), temphitpos.begin(), temphitpos.end() );
			spath_posmap[spath_id].insert( spath_posmap[spath_id].end(), temphitpos.begin(), temphitpos.end() );

			bridge_info ob;
			ob.fb = 0;
			ob.left_linked_node = left_linked_node;
			if ( Itel != spath.end() ) {
			
				ob.right_linked_node = reversepht( *Itel );
			}
			ob.path_id = spath_id;
			ob.posve = temphitpos;
			ob.first_pos = tempite_2;
			bridge_info_map[hitpath_id].push_back( ob );

			Itel = find( Itel, spath.end(), prep );
		} else {
			Itel = tempite_2;
			++Itel;

			Itel = find( Itel, spath.end(), prep );
		}

	}

	pair< Supertig_id, Forb > rp = reversepht( prep );
	list< pair< Supertig_id, Forb > >::reverse_iterator rite = find( spath.rbegin(), spath.rend(), rp );
	while ( rite != spath.rend() ) {
		list< pair< Supertig_id, Forb > >::reverse_iterator temprite = rite;
		list< pair< Supertig_id, Forb > >::reverse_iterator temprite_2 = rite;
		list< pair< Supertig_id, Forb > >::iterator tempite_2( rite.base() );
		--tempite_2;
		pair< Supertig_id, Forb > left_linked_node;
		if ( temprite != spath.rbegin() ) {
			--temprite;
			left_linked_node = *temprite;
		}

		list< pair< Supertig_id, Forb > >::iterator Ites = hitpath.begin();
		bool hit = true;
		vector< Pos > temphitpos;
		for ( ; Ites != hitpath.end(); ++Ites ) {
			if ( rite == spath.rend() ) {
				hit = false;
				break;
			}
			Pos pos( rite.base() );
			--pos;
			if ( find_pos( hit_pos_ve, pos ) ) {
				hit = false;
				break;
			}
			if ( reversepht( *Ites ) != *rite ) {
				hit = false;
				break;
			}
			temphitpos.push_back( pos );
			++rite;
		}
		if ( hit ) {
			spath_posmap[spath_id].insert( spath_posmap[spath_id].end(), temphitpos.begin(), temphitpos.end() );

			bridge_info ob;
			ob.fb = 1;
			if ( left_linked_node != make_pair( 0, 0) )
				ob.left_linked_node = reversepht( left_linked_node );
			if ( rite != spath.rend() )
				ob.right_linked_node = *rite;
			ob.path_id = spath_id;
			ob.posve = temphitpos;
			ob.first_pos = tempite_2;
			bridge_info_map[hitpath_id].push_back( ob );

			rite = find( rite, spath.rend(), rp );
		} else {
			rite = temprite_2;
			++rite;

			rite = find( rite, spath.rend(), rp );
		}

	}
	

}

bool reduce_spu_bridge( map< size_t, vector< bridge_info > > &bridge_info_map )
{

	set< pair< Supertig_id, Forb > > left_linked_node;
	set< pair< Supertig_id, Forb > > right_linked_node;

	map< size_t, vector< bridge_info > >::iterator Ite;
	pair< Supertig_id, Forb > null;
	for ( Ite = bridge_info_map.begin(); Ite != bridge_info_map.end(); ++Ite ) {
		for ( size_t i = 0; i < Ite->second.size(); ++i ) {
			pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > this_p;
			if ( Ite->second[i].left_linked_node != null ) {
				left_linked_node.insert( Ite->second[i].left_linked_node );
			
			}
			if ( Ite->second[i].right_linked_node != null ) {
				right_linked_node.insert( Ite->second[i].right_linked_node );
		
			}
		}
	}

	set<  pair< Supertig_id, Forb > > spu_left_linked_node;
	set< pair< Supertig_id, Forb > >::iterator Itel;
	for ( Itel = left_linked_node.begin(); Itel != left_linked_node.end(); ++Itel ) {
		if ( !find_left_node( bridge_info_map, *Itel ) ) {
			spu_left_linked_node.insert( *Itel );
		}
	}
	set< pair< Supertig_id, Forb > > spu_right_linked_node;
	set< pair< Supertig_id, Forb > >::iterator Iter;
	for ( Iter = right_linked_node.begin(); Iter != right_linked_node.end(); ++Iter ) {
		if ( !find_right_node( bridge_info_map, *Iter ) ) {
			spu_right_linked_node.insert( *Iter );
		}
	}

	if ( !spu_left_linked_node.empty() || !spu_right_linked_node.empty() ) {
		for ( Ite = bridge_info_map.begin(); Ite != bridge_info_map.end(); ++Ite ) {
			vector< bridge_info > infove;
			for ( size_t i = 0; i < Ite->second.size(); ++i ) {
				if ( spu_left_linked_node.find( Ite->second[i].left_linked_node ) != spu_left_linked_node.end() ) {
					continue;
				}
				if ( spu_right_linked_node.find( Ite->second[i].right_linked_node ) != spu_right_linked_node.end() )
					continue;
				infove.push_back( Ite->second[i] );
			}
			Ite->second = infove;
		}
		return true;
	} else
		return false;
}

bool find_left_node( map< size_t, vector< bridge_info > > &bridge_info_map, pair< Supertig_id, Forb > left_linked_node )
{
	map< size_t, vector< bridge_info > >::iterator Ite;
	
	for ( Ite = bridge_info_map.begin(); Ite != bridge_info_map.end(); ++Ite ) {
		bool find_t = false;
		for ( size_t i = 0; i < Ite->second.size(); ++i ) {
			if ( Ite->second[i].left_linked_node == left_linked_node ) {
				find_t = true;
				break;
			}
		}
		if ( !find_t )
			return false;
	}

	return true;

}

bool find_right_node( map< size_t, vector< bridge_info > > &bridge_info_map, pair< Supertig_id, Forb > right_linked_node )
{
	map< size_t, vector< bridge_info > >::iterator Ite;
	
	for ( Ite = bridge_info_map.begin(); Ite != bridge_info_map.end(); ++Ite ) {
		bool find_t = false;
		for ( size_t i = 0; i < Ite->second.size(); ++i ) {
			if ( Ite->second[i].right_linked_node == right_linked_node ) {
				find_t = true;
				break;
			}
		}
		if ( !find_t )
			return false;
	}

	return true;
}

void collect_pos( map< size_t, vector< bridge_info > > &bridge_info_map, vector< Pos > &pos_ve )
{
	map< size_t, vector< bridge_info > >::iterator Ite;
	for ( Ite = bridge_info_map.begin(); Ite != bridge_info_map.end(); ++Ite ) {
		for ( size_t i = 0; i < Ite->second.size(); ++i ) {
			pos_ve.insert( pos_ve.end(), Ite->second[i].posve.begin(), Ite->second[i].posve.end() );
		}
	}
}

bool find_pos( map< size_t, vector< bridge_info > > &bridge_info_map, size_t k, Pos pos )
{

	map< size_t, vector< bridge_info > >::iterator Ite;
	for ( Ite = bridge_info_map.begin(); Ite != bridge_info_map.end(); ++Ite ) {
		for ( size_t i = 0; i < Ite->second.size(); ++i ) {
			if ( Ite->second[i].path_id == k ) {
				if ( find_pos( Ite->second[i].posve, pos ) ) {
					return true;
				}
			}
		}
	}
	return false;
}

void find_out_repl_tig( map< size_t, vector< bridge_info > > &bridge_info_map,
					   vector< list< pair< Supertig_id, Forb > > > &hitpath,
					   vector< list< pair< Supertig_id, Forb > > > &superpath,
					   set< Supertig_id > &repl_tig_set,
					   map< Supertig_id, map< size_t, vector< Pos > > > &hete_pos_map )
{
	set< Supertig_id > potential;
	for ( size_t i = 0; i < hitpath.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Ite;
		for ( Ite = hitpath[i].begin(); Ite != hitpath[i].end(); ++Ite ) {
			potential.insert( Ite->first );
		}
	}

	
	for ( size_t i = 0; i < superpath.size(); ++i ) {
	
		Pos spite;
		for ( spite = superpath[i].begin(); spite != superpath[i].end(); ++spite ) {
			
			if ( potential.find( spite->first ) != potential.end() ) {
				
				if ( !find_pos( bridge_info_map, i, spite ) ) {
					
					repl_tig_set.insert( spite->first );
					
					hete_pos_map[spite->first][i].push_back( spite );
					
				}
				
			}
			
		}
		
	}
	

}

void assign_new_id_repl_tig( set< Supertig_id >& repl_tig_set, 
							vector< list< pair< Supertig_id, Forb > > > &hitpath, 
							subgraph &graph_t, 
							Supertig_bank &bank, 
							map< pair< size_t, Supertig_id >, Supertig_id > &id_map )
{
	if ( !repl_tig_set.empty() ) {
		vector< pair< size_t, Supertig_id > > repl_tig_ve;
		for ( size_t i = 0; i < hitpath.size(); ++i ) {
			list< pair< Supertig_id, Forb > >::iterator Itel;
			for ( Itel = hitpath[i].begin(); Itel != hitpath[i].end(); ++Itel ) {
				if ( repl_tig_set.find( Itel->first ) != repl_tig_set.end() ) {
					repl_tig_ve.push_back( make_pair( i, Itel->first ) );
				}
			}
		}

		for ( size_t i = 0; i < repl_tig_ve.size(); ++i ) {
			Supertig n_tig;
			n_tig = bank.Supertig_Map[repl_tig_ve[i].second];

			Supertig_id n_id = bank.Supertig_Map.rbegin()->first + 1;
			if( bank.Supertig_Map.find( n_id ) != bank.Supertig_Map.end() ) {
				cerr << "Warning in  func replace_hete_t_spe: n_id already exist in bank.Supertig_Map " <<endl;
				return;
			}

			bank.Supertig_Map.insert( make_pair ( n_id, n_tig ) );

			scf_replace_spe( n_id, repl_tig_ve[i].second, bank );

			id_map.insert( make_pair( repl_tig_ve[i], n_id ) );
		}
	}

	// the same id in different bridge, but not in repl_tig_set. this case also needs to assign different ids to distinguish them.
	map< Supertig_id, set< size_t > > id_key_map;
	for ( size_t i = 0; i < hitpath.size(); ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Itel;
		for ( Itel = hitpath[i].begin(); Itel != hitpath[i].end(); ++Itel ) {
			if ( repl_tig_set.find( Itel->first ) == repl_tig_set.end() ) {
				id_key_map[Itel->first].insert( i );
			}
		}
	}
	map< Supertig_id, set< size_t > >::iterator Itek;
	for ( Itek = id_key_map.begin(); Itek != id_key_map.end(); ++Itek ) {
		if ( (int)Itek->second.size() > 1 ) {
		
			repl_tig_set.insert(Itek->first);
			set< size_t >::iterator Ites = Itek->second.begin();

			for ( ; Ites != Itek->second.end(); ++Ites ) {
				Supertig n_tig;
				n_tig = bank.Supertig_Map[Itek->first];

				Supertig_id n_id = bank.Supertig_Map.rbegin()->first + 1;

				bank.Supertig_Map.insert( make_pair( n_id, n_tig ) );

				scf_replace_spe( n_id, Itek->first, bank );

				id_map.insert( make_pair( make_pair( *Ites, Itek->first ), n_id ) );
			
			}
		}
	}


}



void bubble_sim_path_ass( vector< list< pair< Supertig_id, Forb > > > &subpath,
						 subgraph &graph_t,
						 Supertig_bank &bank,
						 vector< list< pair< Supertig_id, Forb > > >& pathve,
						 vector< Supertig_id > &bubble )
{
	multimap< size_t, list< pair< Supertig_id, Forb > >, greater< size_t > > subpathmap;
	size_t vesize = subpath.size(); 
	for ( size_t i = 0; i < vesize; ++i ) {
		subpathmap.insert( make_pair( subpath[i].size(), subpath[i] ) );
	/*	if ( (int)subpath[i].size() == 1 ) {
			bubble.push_back( subpath[i].front().first );
			continue;;
		}
		if ( (int)subpath[i].size() > 1 ) {
		
			Supertig_id n_id = supertig_in_seri_ass( subpath[i], graph_t, bank );
			path_replace_subpath( pathve, subpath[i], n_id );
			bubble.push_back( n_id );
		}*/
	}

	multimap< size_t, list< pair< Supertig_id, Forb > >, greater< size_t > >::iterator Itesm;
	for ( Itesm = subpathmap.begin(); Itesm != subpathmap.end(); ++Itesm ) {
		if ( Itesm->first == 1 ) {
			bubble.push_back( Itesm->second.front().first );
			continue;
		}
		if ( (int)Itesm->first > 1 ) {
			Supertig_id n_id = supertig_in_seri_ass( Itesm->second, graph_t, bank );
			path_replace_subpath( pathve, Itesm->second, n_id );
			bubble.push_back( n_id );
		}
	}
}

bool get_bubble_tig_forb( Supertig &n_tig, vector< pair< Supertig_id, Forb > > &bubble)
{
	if ( !n_tig.bubble ) {
		return false;
	}
	size_t bsize = n_tig.Tig_Ve[0].size();
	for ( size_t i = 0; i < bsize; ++i ) {
		bubble.push_back( make_pair( n_tig.Tig_Ve[0][i], n_tig.Tig_F_Ve[0][i] ) );
	}
	return true;
}

bool semi_bubble_check( vector< list< pair< Supertig_id, Forb > > > &path )
{
	vector< list< pair< Supertig_id, Forb > > > al_path;
	int tag = 0;
	size_t size = path.size();
	for ( size_t i = 0; i < size; ++i ) {
		if ( path[i].empty() )
			tag = 1;
		else 
			al_path.push_back( path[i] );
	}

	path = al_path;
	if ( tag == 1)
		return true;
	else
		return false;
}


void reduce_redunbulbpath( vector< list< pair< Supertig_id, Forb > > >& pathve, Supertig_id n_id )
{
	
	multimap< size_t, size_t > bulbkeymap;
	set< size_t > bulbkeyset;
	size_t vesize = pathve.size();
	for ( size_t i = 0; i < vesize; ++i ) {
		if ( find( pathve[i].begin(), pathve[i].end(), make_pair( n_id, 0 ) ) != pathve[i].end() ) {
			bulbkeymap.insert( make_pair( pathve[i].size(), i ) );
			bulbkeyset.insert( i );
		} else if ( find( pathve[i].begin(), pathve[i].end(), make_pair( n_id, 1 ) ) != pathve[i].end() ) {
			bulbkeymap.insert( make_pair( pathve[i].size(), i ) );
			bulbkeyset.insert( i );
		}
	}
	
	set< size_t > erased;


	multimap< size_t, size_t >::iterator Ite = bulbkeymap.begin();
	do {
	
		if ( reduce_redunbulbpath_check( pathve, Ite->second, bulbkeyset ) ) {
			erased.insert( Ite->second );
			bulbkeyset.erase( Ite->second );
		}
		++Ite;

	} while( Ite != bulbkeymap.end() );

	
	vector< list< pair< Supertig_id, Forb > > > alpathve;
	for ( size_t i = 0; i < vesize; ++i ) {
		if ( erased.find( i ) == erased.end() )
			alpathve.push_back( pathve[i] );
	}
	pathve = alpathve;
}

bool reduce_redunbulbpath_check( vector< list< pair< Supertig_id, Forb > > >& pathve,
								size_t k,
								set< size_t > &bulbkeyset )
{
	set< size_t >::iterator Ite;
	for ( Ite = bulbkeyset.begin(); Ite != bulbkeyset.end(); ++Ite ) {
		
		if ( *Ite == k )
			continue;
		int r = plistcomp( pathve[*Ite], pathve[k] );
		
		if ( r == 1 )
			return true;

		list< pair< Supertig_id, Forb > > revpl = reverseplist( pathve[k] );
		r = plistcomp( pathve[*Ite], revpl );

		if ( r == 1 )
			return true;
	}
	return false;
}

bool check_seri_spubulb( Supertig_id id, subgraph &graph_t, Supertig_bank &tig_bank )
{
	if ( !tig_bank.Supertig_Map[id].bubble )
		return false;
	if ( graph_t.Supertig_Overlap_Link_Map.find( id ) == graph_t.Supertig_Overlap_Link_Map.end() )
		return false;
	if ( (int)graph_t.Supertig_Overlap_Link_Map[id].head_links.size() == 1 && (int)graph_t.Supertig_Overlap_Link_Map[id].tail_links.size() == 1 ) {
		int leftovlen = graph_t.Supertig_Overlap_Link_Map[id].Head_Id_Ov_Ma.begin()->second;
		int rightovlen = graph_t.Supertig_Overlap_Link_Map[id].Tail_Id_Ov_Ma.begin()->second;
		if ( leftovlen + rightovlen > tig_bank.Supertig_Map[id].length )
			return true;
	}
	return false;
}



size_t get_key( vector< list< pair< Supertig_id, Forb > > > &pathve, list< pair< Supertig_id, Forb > > &pl )
{
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		if ( plistequalcheck( pathve[i], pl ) )
			return i;
	}
	cerr << "Error in get_key( vector< list< pair< Supertig_id, Forb > > > &pathve, list< pair< Supertig_id, Forb > > &pl ): not find"<<endl;   
	exit(1);
	return 0;
}

bool find_pos( vector< Pathmap_Pos > &posve, Pathmap_Pos pos )
{
	if ( posve.empty() )
		return false;

	for ( size_t i = 0; i < posve.size(); ++i ) {
		if ( posve[i] == pos )
			return true;
	}

	return false;
}


