#ifndef GRAPH_BUBBLE_H
#define GRAPH_BUBBLE_H

#include "Graph_subgraph.h"
#include "Graph_Suptig_Assbl.h"
#include "Graph_ovlk_rpl.h"
#include "Graph_rm_Contr.h"

using namespace std;

/////////////////////////////////////////////////////////////////////////////
// Bulb emerge in the graph when one path diverge at a node forming two or
// more paths, and these paths again converge at another node. The bulged nodes
// result from the large diversity of the sequences that are not determined as 
// overlaps due to either the sequencing errors or the polymorphism which may  
// more frequently occur in the metagenomes.
// 
// Bulbs may combine with other bulbs or other forks, complicating the graph. 
// To simplify the graph, bulbs are replaced by a special node in the graph
// representing a bulb tig which retain the bulb information with it, and may
// be dealt with in the post process. The separate nodes or paths of one bulb
// should satisfy the condition that their sequence length vary in a small value.
//
// Sometimes, path bulbs between two adjacent nodes, forming semi-bulbs. In this 
// case, we just break the link of the two nodes, making the bulb smooth.
//
// This aim of this session is to replace the bubble with a special node named 
// bulb node in order to simplify the graph. The process begins from each seeds
// with their marked bulb nodes which are marked in the super path finding session.
// Each marked bulb node may represent the end of a bulb. The initial site of bulb
// is searched by finding the first different nodes among the super paths which start
// from the seed and include the end bulb node. Then replace the subpath between the
// initial site and the ending site with the new created tig node which repreasent 
// the bulb. One seed may induce more than one bulb node. The closest bulb node from
// the seed is dealt with first so that no other bulb is inside the bulb. After 
// replacing the bulb with node, that bulb is removed from the graph. Then, deal with
// the next bulb node.
//
// Sometimes, some bulb nodes of the seed do not always induce a bulb. That's may because 
// the bulb has already been replaced from the reverse direction.
///////////////////////////////////////////////////////////////////////////////
// bubble == bulb ? Yes they have the same meaning in my code. Please forgive my pool English, yeah, very pool.
///////////////////////////////////////////////////////////////////////////////

void graph_bubble( subgraph &graph_t, Scaffold_subset &scf_s, Supertig_bank &bank, int var_len );

bool bubble_search( pair< Supertig_id, Forb > seed, 
				   pair< Supertig_id, Forb > bait, 
				   subgraph &graph_t, 
				   Scaffold_subset &scf_s, 
				   Supertig_bank &bank,
				   int lowb_len,
				   int upb_len );

bool bubble_s_subpath_find( pair< Supertig_id, Forb > seed,
						   pair< Supertig_id, Forb > bait,
						   list< pair< Supertig_id, Forb > > &path,
						   list< pair< Supertig_id, Forb > > &subpath,
						   subgraph &graph_t,
						   Supertig_bank &bank,
						   int lowb_len,
						   int upb_len );

bool bubble_s_elen_check( list< pair< Supertig_id, Forb > > &path, subgraph &graph_t, Supertig_bank &bank, int lowb_len, int upb_len );

bool bubble_s_bchop( vector< list< pair< Supertig_id, Forb > > > & pathve, pair< Supertig_id, Forb > &p, pair< Supertig_id, Forb > &baitp );

bool bubble_s_bchop_comp( vector< list< pair< Supertig_id, Forb > > >& pathve );
bool bubble_s_bchop_comp_back( vector< list< pair< Supertig_id, Forb > > >& pathve );

pair< Supertig_id, Forb > bubble_s_bchop_t( vector< list< pair< Supertig_id, Forb > > >& pathve );
pair< Supertig_id, Forb > bubble_s_bchop_t_back( vector< list< pair< Supertig_id, Forb > > >& pathve );

bool bubble_s_bchop_check( vector< list< pair< Supertig_id, Forb > > >& pathve );

void mark_semi_bulb( list< pair< Supertig_id, Forb > >& path, Supertig_bank &bank );

void re_rank_hitpath( vector< list< pair< Supertig_id, Forb > > > &hitpath );

typedef list< pair< Supertig_id, Forb > >::iterator Pos;

class bridge_info
{
public:
	size_t path_id;
	vector< Pos > posve;
	Pos first_pos;
	Forb fb;
	pair< Supertig_id, Forb > left_linked_node;
	pair< Supertig_id, Forb > right_linked_node;
};


bool bridge_info_empty_check( map< size_t, vector< bridge_info > > &bridge_info_map );

bool find_hete( pair< Supertig_id, Forb > seed, 
			   pair< Supertig_id, Forb > bait,
			   vector< list< pair< Supertig_id, Forb > > > &hitpath,
			   vector< list< pair< Supertig_id, Forb > > > &superpath,
			   subgraph &graph_t,
			   Supertig_bank & bank );

void get_bridge_info( list< pair< Supertig_id, Forb > > &hitpath,
					 list< pair< Supertig_id, Forb > > &spath,
					 size_t spath_id,
					 size_t hitpath_id,
					 map< size_t, vector< Pos > > &spath_posmap,
					 map< size_t, vector< bridge_info > > &bridge_info_map );

bool reduce_spu_bridge( map< size_t, vector< bridge_info > > &bridge_info_map );

void collect_pos( map< size_t, vector< bridge_info > > &bridge_info_map, vector< Pos > &pos_ve );

void find_out_repl_tig( map< size_t, vector< bridge_info > > &bridge_info_map,
					   vector< list< pair< Supertig_id, Forb > > > &hitpath,
					   vector< list< pair< Supertig_id, Forb > > > &superpath,
					   set< Supertig_id >& repl_tig_set,
					   map< Supertig_id, map< size_t, vector< Pos > > > &hete_pos_map );

void assign_new_id_repl_tig( set< Supertig_id >& repl_tig_set, 
							vector< list< pair< Supertig_id, Forb > > > &hitpath, 
							subgraph &graph_t,
							Supertig_bank &bank,
							map< pair< size_t, Supertig_id >, Supertig_id > &id_map );

void replace_ovlk( map< size_t, vector< bridge_info > > &bridge_info_map,
				  map< pair< size_t, Supertig_id >, Supertig_id > &id_map,
				  subgraph &graph_t,
				  Supertig_bank &bank,
				  vector< list< pair< Supertig_id, Forb > > > &hitpath,
				  vector< list< pair< Supertig_id, Forb > > > &superpath,
				  map< Supertig_id, map< size_t, vector< Pos > > > &hete_pos_map );

void replace_superpath( map< pair< size_t, Supertig_id >, Supertig_id > &id_map,
					   set< Supertig_id >& repl_tig_set,
					   vector< list< pair< Supertig_id, Forb > > > &superpath, 
					   map< size_t, vector< bridge_info > > &bridge_info_map );

void replace_hitpath( map< pair< size_t, Supertig_id >, Supertig_id > &id_map, vector< list< pair< Supertig_id, Forb > > > &hitpath );

bool find_left_node( map< size_t, vector< bridge_info > > &bridge_info_map, pair< Supertig_id, Forb > left_linked_node );

bool find_right_node( map< size_t, vector< bridge_info > > &bridge_info_map, pair< Supertig_id, Forb > right_linked_node );

bool find_pos( vector< Pos > &pos_ve, Pos pos );

bool find_pos( map< size_t, vector< bridge_info > > &bridge_info_map, size_t k, Pos pos );

Supertig_id get_repl_tigid( Supertig_id id,
					size_t spath_id,
					Pos pos,
					map< pair< size_t, Supertig_id >, Supertig_id > &id_map,
					map< size_t, vector< bridge_info > > &bridge_info_map );


void bubble_sim_path_ass( vector< list< pair< Supertig_id, Forb > > > &subpath,
						 subgraph &graph_t, 
						 Supertig_bank &bank,
						 vector< list< pair< Supertig_id, Forb > > >& pathve,
						 vector< Supertig_id > &bubble );

bool get_bubble_tig_forb( Supertig &n_tig, vector< pair< Supertig_id, Forb > > &bubble);

bool semi_bubble_check( vector< list< pair< Supertig_id, Forb > > > &path );


void reduce_redunbulbpath( vector< list< pair< Supertig_id, Forb > > >& pathve, Supertig_id n_id );

bool reduce_redunbulbpath_check( vector< list< pair< Supertig_id, Forb > > >& pathve,
								size_t k,
								set< size_t > &bulbkeyset );


bool check_seri_spubulb( Supertig_id id, subgraph &graph_t, Supertig_bank &tig_bank );

class semibulb
{
public:
	list< pair< Supertig_id, Forb > > mo_pl;
	list< pair< Supertig_id, Forb > > da_pl;
	list< pair< Supertig_id, Forb > > left_m_pl;
	list< pair< Supertig_id, Forb > > right_m_pl;
	size_t k;            // key in the hitpath that corresp da_pl.
	bool left_m;
	bool right_m;
};

typedef multimap< size_t, list< pair< Supertig_id, Forb > >, greater< size_t > >::iterator Pathmap_Pos;

bool find_pos( vector< Pathmap_Pos > &posve, Pathmap_Pos pos );

class semibulb_path
{
public:
	pair< Supertig_id, Forb > left_p;
	pair< Supertig_id, Forb > right_p;
	list< pair< Supertig_id, Forb > > m_pl;
};

void reduceselftrave( vector< list< pair< Supertig_id, Forb > > > &hitpath );

void removetendam( vector< list< pair< Supertig_id, Forb > > > &superpath );

#endif

