#include "Graph_ovlk_rpl.h"
#include "poperate.h"

void ov_link_erase( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, subgraph &graph_t, Supertig_bank &tig_bank )
{
	if( pa.second == 0 ) {
		graph_t.Supertig_Overlap_Link_Map[pa.first].head_links.erase( pb );
		graph_t.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma.erase( pb );

		tig_bank.Supertig_Overlap_Link_Map[pa.first].head_links.erase( pb );
		tig_bank.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma.erase( pb );
	} else {
		graph_t.Supertig_Overlap_Link_Map[pa.first].tail_links.erase( pb );
		graph_t.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma.erase( pb );

		tig_bank.Supertig_Overlap_Link_Map[pa.first].tail_links.erase( pb );
		tig_bank.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma.erase( pb );
		
	}
}

void ov_link_erase( pair< Supertig_id, Forb > pa, subgraph &graph_t, Supertig_bank &tig_bank )
{
	if ( pa.second == 0 ) {
		graph_t.Supertig_Overlap_Link_Map[pa.first].head_links.clear();
		graph_t.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma.clear();

		tig_bank.Supertig_Overlap_Link_Map[pa.first].head_links.clear();
		tig_bank.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma.clear();
	} else {

		graph_t.Supertig_Overlap_Link_Map[pa.first].tail_links.clear();
		graph_t.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma.clear();

		tig_bank.Supertig_Overlap_Link_Map[pa.first].tail_links.clear();
		tig_bank.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma.clear();
	}
}

void ov_link_erase( Supertig_id id, subgraph &graph_t, Supertig_bank &tig_bank )
{
	
	graph_t.Supertig_Overlap_Link_Map[id].head_links.clear();
	graph_t.Supertig_Overlap_Link_Map[id].Head_Id_Ov_Ma.clear();

	tig_bank.Supertig_Overlap_Link_Map[id].head_links.clear();
	tig_bank.Supertig_Overlap_Link_Map[id].Head_Id_Ov_Ma.clear();
	

	graph_t.Supertig_Overlap_Link_Map[id].tail_links.clear();
	graph_t.Supertig_Overlap_Link_Map[id].Tail_Id_Ov_Ma.clear();

	tig_bank.Supertig_Overlap_Link_Map[id].tail_links.clear();
	tig_bank.Supertig_Overlap_Link_Map[id].Tail_Id_Ov_Ma.clear();
}

void ov_link_id_erase(  Supertig_id id, subgraph &graph_t, Supertig_bank &tig_bank )
{
	graph_t.Supertig_Overlap_Link_Map.erase( id );
	tig_bank.Supertig_Overlap_Link_Map.erase( id );
}

void ov_link_id_erase_com( Supertig_id id, subgraph &graph_t, Supertig_bank &tig_bank )
{
	if ( graph_t.Supertig_Overlap_Link_Map.find( id ) == graph_t.Supertig_Overlap_Link_Map.end() )
		return;
	set< pair< Supertig_id, Forb > >::iterator Iteh;
	for ( Iteh = graph_t.Supertig_Overlap_Link_Map[id].head_links.begin(); Iteh != graph_t.Supertig_Overlap_Link_Map[id].head_links.end(); ++Iteh ) {
		ov_link_erase( *Iteh, make_pair( id, 0 ), graph_t, tig_bank );
	}
	set< pair< Supertig_id, Forb > >::iterator Itet;
	for ( Itet = graph_t.Supertig_Overlap_Link_Map[id].tail_links.begin(); Itet != graph_t.Supertig_Overlap_Link_Map[id].tail_links.end(); ++Itet ) {
		ov_link_erase( *Itet, make_pair( id, 1 ), graph_t, tig_bank );
	}
	ov_link_erase( id, graph_t, tig_bank );
	ov_link_id_erase( id, graph_t, tig_bank );
}

void ov_link_add( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, subgraph &graph_t, Supertig_bank &tig_bank, int ovlen )
{
	if( pa.second == 0 ) {


		graph_t.Supertig_Overlap_Link_Map[pa.first].head_links.insert( pb );
		graph_t.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma.insert( make_pair( pb, ovlen ) );

		
		tig_bank.Supertig_Overlap_Link_Map[pa.first].head_links.insert( pb );
		tig_bank.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma.insert( make_pair( pb, ovlen ) );
	} else {
		graph_t.Supertig_Overlap_Link_Map[pa.first].tail_links.insert( pb );
		graph_t.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma.insert( make_pair( pb, ovlen ) );

		tig_bank.Supertig_Overlap_Link_Map[pa.first].tail_links.insert( pb );
		tig_bank.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma.insert( make_pair( pb, ovlen ) );
		
	}
}

void ov_link_create( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, subgraph &graph_t, Supertig_bank &tig_bank, int ovlen )
{
	if( pa.second == 0 ) {

		

		graph_t.Supertig_Overlap_Link_Map[pa.first].head_links.insert( pb );
		graph_t.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma.insert( make_pair( pb, ovlen ) );

		tig_bank.Supertig_Overlap_Link_Map[pa.first].head_links.insert( pb );
		tig_bank.Supertig_Overlap_Link_Map[pa.first].Head_Id_Ov_Ma.insert( make_pair( pb, ovlen ) );
	} else {
		graph_t.Supertig_Overlap_Link_Map[pa.first].tail_links.insert( pb );
		graph_t.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma.insert( make_pair( pb, ovlen ) );

		tig_bank.Supertig_Overlap_Link_Map[pa.first].tail_links.insert( pb );
		tig_bank.Supertig_Overlap_Link_Map[pa.first].Tail_Id_Ov_Ma.insert( make_pair( pb, ovlen ) );
		
	}
}

void ov_link_replace( Supertig_id n_id,
					 Supertig & n_tig, 
					 subgraph &graph_t, 
					 Supertig_bank &tig_bank, 
					 vector< pair< pair< Supertig_id, Forb>, int > > &left_linked_nodes, 
					 vector< pair< pair< Supertig_id, Forb>, int > > &right_linked_nodes )
{
	// first add new link; then erase old link.
	size_t psize = n_tig.Tig_Ve.size();
	vector< Supertig_id > left_para_tigs = n_tig.Tig_Ve[0];
	vector< Supertig_id > right_para_tigs = n_tig.Tig_Ve[psize-1];
	vector< Forb > left_para_forb = n_tig.Tig_F_Ve[0];
	vector< Forb > right_para_forb = n_tig.Tig_F_Ve[psize-1];

	if( !left_linked_nodes.empty() ) {
		size_t left_nodes_size = left_linked_nodes.size();
		for ( size_t i = 0; i < left_nodes_size; ++i ) {
			ov_link_add( left_linked_nodes[i].first, make_pair( n_id, 1), graph_t, tig_bank, left_linked_nodes[i].second );
			ov_link_add( make_pair( n_id, 1), left_linked_nodes[i].first, graph_t, tig_bank, left_linked_nodes[i].second );

			size_t left_pt_size = left_para_tigs.size();
			for ( size_t j = 0; j < left_pt_size; ++j ) {
				ov_link_erase( left_linked_nodes[i].first, reversepht( make_pair( left_para_tigs[j], left_para_forb[j] ) ), graph_t, tig_bank );
			}
		}
	}
	if ( !right_linked_nodes.empty() ) {
		size_t right_nodes_size = right_linked_nodes.size();
		for ( size_t i = 0; i < right_nodes_size; ++i ) {
			ov_link_add( right_linked_nodes[i].first, make_pair( n_id, 0 ), graph_t, tig_bank, right_linked_nodes[i].second );
			ov_link_add( make_pair( n_id, 0 ), right_linked_nodes[i].first, graph_t, tig_bank, right_linked_nodes[i].second );

			size_t right_pt_size = right_para_tigs.size();
			for ( size_t j = 0; j < right_pt_size; ++j ) {
				ov_link_erase( right_linked_nodes[i].first, make_pair( right_para_tigs[j], right_para_forb[j] ), graph_t, tig_bank );
			}
		}
	}
	
	for ( size_t i = 0; i < psize; ++i ) {
		size_t tpsize = n_tig.Tig_Ve[i].size();
		for ( size_t j = 0; j < tpsize; ++j ) {
			ov_link_id_erase( n_tig.Tig_Ve[i][j], graph_t, tig_bank );
		}
	}

	
}

void ov_link_add_2( pair< Supertig_id, Forb > ida,
					 pair< Supertig_id, Forb > idb, 
					 map< Supertig_id, Supertig_id > &id_map,
					 subgraph &graph_t,
					 Supertig_bank &tig_bank )
{
	// for test bug if any!
	if ( id_map.find( ida.first ) == id_map.end() || id_map.find( idb.first ) == id_map.end() ) {
		cerr << "Warning in ov_link_replace! "<<endl;    exit(1);
	}
	//////////////////////////test end///////////////////////////////////////


	pair< Supertig_id, Forb > r_ida = make_pair( id_map[ida.first], ida.second );
	pair< Supertig_id, Forb > r_idb = make_pair( id_map[idb.first], idb.second );

	int ovlen = 0;
	if ( ida.second == 0 ) {
		if ( graph_t.Supertig_Overlap_Link_Map[ida.first].Head_Id_Ov_Ma.find( idb ) == graph_t.Supertig_Overlap_Link_Map[ida.first].Head_Id_Ov_Ma.end() ) {
			cerr << "Error in ov_link_replace[5] "<<ida.first<<","<<0<<","<<idb.first<<","<<idb.second<<endl;  exit(1);
		}
		ovlen = graph_t.Supertig_Overlap_Link_Map[ida.first].Head_Id_Ov_Ma[idb];
	} else {
		if ( graph_t.Supertig_Overlap_Link_Map[ida.first].Tail_Id_Ov_Ma.find( idb ) == graph_t.Supertig_Overlap_Link_Map[ida.first].Tail_Id_Ov_Ma.end() ) {
			cerr << "Error in ov_link_replace[5] "<<ida.first<<","<<0<<","<<idb.first<<","<<idb.second<<endl;  exit(1);
		}
		ovlen = graph_t.Supertig_Overlap_Link_Map[ida.first].Tail_Id_Ov_Ma[idb];
	}

	ov_link_add( r_ida, r_idb, graph_t, tig_bank, ovlen );
	ov_link_add( r_idb, r_ida, graph_t, tig_bank, ovlen );

	
}

void ov_link_replace_spe( Supertig_id n_id,					
						 subgraph &graph_t, 
						 Supertig_bank &tig_bank, 
						 pair< Supertig_id, Forb > tp, 
						 pair< Supertig_id, Forb > fp )
{
	if ( tp.second == 0 ) {
	
		graph_t.Supertig_Overlap_Link_Map[n_id].head_links.insert( fp );
		graph_t.Supertig_Overlap_Link_Map[n_id].Head_Id_Ov_Ma.insert( make_pair( fp, graph_t.Supertig_Overlap_Link_Map[tp.first].Head_Id_Ov_Ma[fp] ) );
		tig_bank.Supertig_Overlap_Link_Map[n_id].head_links.insert( fp );
		tig_bank.Supertig_Overlap_Link_Map[n_id].Head_Id_Ov_Ma.insert( make_pair ( fp, tig_bank.Supertig_Overlap_Link_Map[tp.first].Head_Id_Ov_Ma[fp] ) );
		graph_t.Supertig_Overlap_Link_Map[tp.first].head_links.erase( fp );
		graph_t.Supertig_Overlap_Link_Map[tp.first].Head_Id_Ov_Ma.erase( fp );
		tig_bank.Supertig_Overlap_Link_Map[tp.first].head_links.erase( fp );
		tig_bank.Supertig_Overlap_Link_Map[tp.first].Head_Id_Ov_Ma.erase( fp );
		
		map< pair< Supertig_id, Forb >, int >::iterator Itet;
		for ( Itet = graph_t.Supertig_Overlap_Link_Map[tp.first].Tail_Id_Ov_Ma.begin(); Itet != graph_t.Supertig_Overlap_Link_Map[tp.first].Tail_Id_Ov_Ma.end(); ++Itet ) {
			ov_link_add( make_pair( n_id, 1 ), Itet->first, graph_t, tig_bank, Itet->second );
			ov_link_add( Itet->first, make_pair( n_id, 1 ), graph_t, tig_bank, Itet->second );
		}
	} else {
		graph_t.Supertig_Overlap_Link_Map[n_id].tail_links.insert( fp );
		graph_t.Supertig_Overlap_Link_Map[n_id].Tail_Id_Ov_Ma.insert( make_pair( fp, graph_t.Supertig_Overlap_Link_Map[tp.first].Tail_Id_Ov_Ma[fp] ) );
		tig_bank.Supertig_Overlap_Link_Map[n_id].tail_links.insert( fp );
		tig_bank.Supertig_Overlap_Link_Map[n_id].Tail_Id_Ov_Ma.insert( make_pair ( fp, tig_bank.Supertig_Overlap_Link_Map[tp.first].Tail_Id_Ov_Ma[fp] ) );
		graph_t.Supertig_Overlap_Link_Map[tp.first].tail_links.erase( fp );
		graph_t.Supertig_Overlap_Link_Map[tp.first].Tail_Id_Ov_Ma.erase( fp );
		tig_bank.Supertig_Overlap_Link_Map[tp.first].tail_links.erase( fp );
		tig_bank.Supertig_Overlap_Link_Map[tp.first].Tail_Id_Ov_Ma.erase( fp );

		map< pair< Supertig_id, Forb >, int >::iterator Iteh;
		for ( Iteh = graph_t.Supertig_Overlap_Link_Map[tp.first].Head_Id_Ov_Ma.begin(); Iteh != graph_t.Supertig_Overlap_Link_Map[tp.first].Head_Id_Ov_Ma.end(); ++Iteh ) {
			ov_link_add( make_pair( n_id, 0 ), Iteh->first, graph_t, tig_bank, Iteh->second );
			ov_link_add( Iteh->first, make_pair( n_id, 0 ), graph_t, tig_bank, Iteh->second );
		}
	}

	if ( fp.second == 0 ) {
		graph_t.Supertig_Overlap_Link_Map[fp.first].head_links.insert( make_pair( n_id, tp.second ) );
		graph_t.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma.insert( make_pair( make_pair( n_id, tp.second ), graph_t.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma[tp] ) );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].head_links.insert( make_pair( n_id, tp.second ) );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma.insert( make_pair ( make_pair( n_id, tp.second ), tig_bank.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma[tp] ) );
		graph_t.Supertig_Overlap_Link_Map[fp.first].head_links.erase( tp );
		graph_t.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma.erase( tp );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].head_links.erase( tp );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma.erase( tp );
	} else {
		graph_t.Supertig_Overlap_Link_Map[fp.first].tail_links.insert( make_pair( n_id, tp.second ) );
		graph_t.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma.insert( make_pair( make_pair( n_id, tp.second ), graph_t.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma[tp] ) );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].tail_links.insert( make_pair( n_id, tp.second ) );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma.insert( make_pair ( make_pair( n_id, tp.second ), tig_bank.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma[tp] ) );
		graph_t.Supertig_Overlap_Link_Map[fp.first].tail_links.erase( tp );
		graph_t.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma.erase( tp );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].tail_links.erase( tp );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma.erase( tp );
	}
}

void ov_link_replace_assign( Supertig_id n_id,
							 subgraph &graph_t, 
							 Supertig_bank &tig_bank, 
							 pair< Supertig_id, Forb > tp, 
							 pair< Supertig_id, Forb > fp )
{
	if ( tp.second == 0 ) {
	
		graph_t.Supertig_Overlap_Link_Map[n_id].head_links.insert( fp );
		graph_t.Supertig_Overlap_Link_Map[n_id].Head_Id_Ov_Ma.insert( make_pair( fp, graph_t.Supertig_Overlap_Link_Map[tp.first].Head_Id_Ov_Ma[fp] ) );
		tig_bank.Supertig_Overlap_Link_Map[n_id].head_links.insert( fp );
		tig_bank.Supertig_Overlap_Link_Map[n_id].Head_Id_Ov_Ma.insert( make_pair ( fp, tig_bank.Supertig_Overlap_Link_Map[tp.first].Head_Id_Ov_Ma[fp] ) );
		graph_t.Supertig_Overlap_Link_Map[tp.first].head_links.erase( fp );
		graph_t.Supertig_Overlap_Link_Map[tp.first].Head_Id_Ov_Ma.erase( fp );
		tig_bank.Supertig_Overlap_Link_Map[tp.first].head_links.erase( fp );
		tig_bank.Supertig_Overlap_Link_Map[tp.first].Head_Id_Ov_Ma.erase( fp );
	} else {
		graph_t.Supertig_Overlap_Link_Map[n_id].tail_links.insert( fp );
		graph_t.Supertig_Overlap_Link_Map[n_id].Tail_Id_Ov_Ma.insert( make_pair( fp, graph_t.Supertig_Overlap_Link_Map[tp.first].Tail_Id_Ov_Ma[fp] ) );
		tig_bank.Supertig_Overlap_Link_Map[n_id].tail_links.insert( fp );
		tig_bank.Supertig_Overlap_Link_Map[n_id].Tail_Id_Ov_Ma.insert( make_pair ( fp, tig_bank.Supertig_Overlap_Link_Map[tp.first].Tail_Id_Ov_Ma[fp] ) );
		graph_t.Supertig_Overlap_Link_Map[tp.first].tail_links.erase( fp );
		graph_t.Supertig_Overlap_Link_Map[tp.first].Tail_Id_Ov_Ma.erase( fp );
		tig_bank.Supertig_Overlap_Link_Map[tp.first].tail_links.erase( fp );
		tig_bank.Supertig_Overlap_Link_Map[tp.first].Tail_Id_Ov_Ma.erase( fp );
	}

	if ( fp.second == 0 ) {
		graph_t.Supertig_Overlap_Link_Map[fp.first].head_links.insert( make_pair( n_id, tp.second ) );
		graph_t.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma.insert( make_pair( make_pair( n_id, tp.second ), graph_t.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma[tp] ) );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].head_links.insert( make_pair( n_id, tp.second ) );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma.insert( make_pair ( make_pair( n_id, tp.second ), tig_bank.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma[tp] ) );
		graph_t.Supertig_Overlap_Link_Map[fp.first].head_links.erase( tp );
		graph_t.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma.erase( tp );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].head_links.erase( tp );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].Head_Id_Ov_Ma.erase( tp );
	} else {
		graph_t.Supertig_Overlap_Link_Map[fp.first].tail_links.insert( make_pair( n_id, tp.second ) );
		graph_t.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma.insert( make_pair( make_pair( n_id, tp.second ), graph_t.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma[tp] ) );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].tail_links.insert( make_pair( n_id, tp.second ) );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma.insert( make_pair ( make_pair( n_id, tp.second ), tig_bank.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma[tp] ) );
		graph_t.Supertig_Overlap_Link_Map[fp.first].tail_links.erase( tp );
		graph_t.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma.erase( tp );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].tail_links.erase( tp );
		tig_bank.Supertig_Overlap_Link_Map[fp.first].Tail_Id_Ov_Ma.erase( tp );
	}
}

void ov_link_head_replace( Supertig_id fm_id, Supertig_id rp_id, subgraph &graph_t, Supertig_bank &tig_bank )
{
	if ( graph_t.Supertig_Overlap_Link_Map[fm_id].head_links.empty() )
		return;

	map< pair< Supertig_id, Forb >, int >::iterator Ite;
	for ( Ite = graph_t.Supertig_Overlap_Link_Map[fm_id].Head_Id_Ov_Ma.begin(); Ite != graph_t.Supertig_Overlap_Link_Map[fm_id].Head_Id_Ov_Ma.end(); ++Ite ) {
		ov_link_add( Ite->first, make_pair( rp_id, 0 ), graph_t, tig_bank, Ite->second );
		ov_link_erase( Ite->first, make_pair( fm_id, 0 ), graph_t, tig_bank );
	}
	graph_t.Supertig_Overlap_Link_Map[rp_id].head_links = graph_t.Supertig_Overlap_Link_Map[fm_id].head_links;
	graph_t.Supertig_Overlap_Link_Map[rp_id].Head_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Head_Id_Ov_Ma;
	tig_bank.Supertig_Overlap_Link_Map[rp_id].head_links = graph_t.Supertig_Overlap_Link_Map[fm_id].head_links;
	tig_bank.Supertig_Overlap_Link_Map[rp_id].Head_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Head_Id_Ov_Ma;
	ov_link_erase( make_pair( fm_id, 0 ), graph_t, tig_bank );
}

void ov_link_tail_replace( Supertig_id fm_id, Supertig_id rp_id, subgraph &graph_t, Supertig_bank &tig_bank )
{
	if ( graph_t.Supertig_Overlap_Link_Map[fm_id].tail_links.empty() )
		return;

	map< pair< Supertig_id, Forb >, int >::iterator Ite;
	for ( Ite = graph_t.Supertig_Overlap_Link_Map[fm_id].Tail_Id_Ov_Ma.begin(); Ite != graph_t.Supertig_Overlap_Link_Map[fm_id].Tail_Id_Ov_Ma.end(); ++Ite ) {
		ov_link_add( Ite->first, make_pair( rp_id, 1 ), graph_t, tig_bank, Ite->second );
		ov_link_erase( Ite->first, make_pair( fm_id, 1 ), graph_t, tig_bank );
	}
	graph_t.Supertig_Overlap_Link_Map[rp_id].tail_links = graph_t.Supertig_Overlap_Link_Map[fm_id].tail_links;
	graph_t.Supertig_Overlap_Link_Map[rp_id].Tail_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Tail_Id_Ov_Ma;
	tig_bank.Supertig_Overlap_Link_Map[rp_id].tail_links = graph_t.Supertig_Overlap_Link_Map[fm_id].tail_links;
	tig_bank.Supertig_Overlap_Link_Map[rp_id].Tail_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Tail_Id_Ov_Ma;
	ov_link_erase( make_pair( fm_id, 1 ), graph_t, tig_bank );
}

void ov_link_head_replace( Supertig_id fm_id, pair< Supertig_id, Forb > rp, subgraph &graph_t, Supertig_bank &tig_bank )
{
	if ( graph_t.Supertig_Overlap_Link_Map[fm_id].head_links.empty() )
		return;
	map< pair< Supertig_id, Forb >, int >::iterator Ite;
	for ( Ite = graph_t.Supertig_Overlap_Link_Map[fm_id].Head_Id_Ov_Ma.begin(); Ite != graph_t.Supertig_Overlap_Link_Map[fm_id].Head_Id_Ov_Ma.end(); ++Ite ) {
		ov_link_add( Ite->first, rp, graph_t, tig_bank, Ite->second );
		ov_link_erase( Ite->first, make_pair( fm_id, 0 ), graph_t, tig_bank );
	}

	if ( rp.second == 0 ) {
		graph_t.Supertig_Overlap_Link_Map[rp.first].head_links = graph_t.Supertig_Overlap_Link_Map[fm_id].head_links;
		graph_t.Supertig_Overlap_Link_Map[rp.first].Head_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Head_Id_Ov_Ma;
		tig_bank.Supertig_Overlap_Link_Map[rp.first].head_links = graph_t.Supertig_Overlap_Link_Map[fm_id].head_links;
		tig_bank.Supertig_Overlap_Link_Map[rp.first].Head_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Head_Id_Ov_Ma;
	} else {
		graph_t.Supertig_Overlap_Link_Map[rp.first].tail_links = graph_t.Supertig_Overlap_Link_Map[fm_id].head_links;
		graph_t.Supertig_Overlap_Link_Map[rp.first].Tail_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Head_Id_Ov_Ma;
		tig_bank.Supertig_Overlap_Link_Map[rp.first].tail_links = graph_t.Supertig_Overlap_Link_Map[fm_id].head_links;
		tig_bank.Supertig_Overlap_Link_Map[rp.first].Tail_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Head_Id_Ov_Ma;
	}

	ov_link_erase( make_pair( fm_id, 0 ), graph_t, tig_bank );
}

void ov_link_tail_replace( Supertig_id fm_id, pair< Supertig_id, Forb > rp, subgraph &graph_t, Supertig_bank &tig_bank )
{
	if ( graph_t.Supertig_Overlap_Link_Map[fm_id].tail_links.empty() )
		return;

	map< pair< Supertig_id, Forb >, int >::iterator Ite;
	for ( Ite = graph_t.Supertig_Overlap_Link_Map[fm_id].Tail_Id_Ov_Ma.begin(); Ite != graph_t.Supertig_Overlap_Link_Map[fm_id].Tail_Id_Ov_Ma.end(); ++Ite ) {
		ov_link_add( Ite->first, rp, graph_t, tig_bank, Ite->second );
		ov_link_erase( Ite->first, make_pair( fm_id, 1 ), graph_t, tig_bank );
	}

	if ( rp.second == 0 ) {
		graph_t.Supertig_Overlap_Link_Map[rp.first].head_links = graph_t.Supertig_Overlap_Link_Map[fm_id].tail_links;
		graph_t.Supertig_Overlap_Link_Map[rp.first].Head_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Tail_Id_Ov_Ma;
		tig_bank.Supertig_Overlap_Link_Map[rp.first].head_links = graph_t.Supertig_Overlap_Link_Map[fm_id].tail_links;
		tig_bank.Supertig_Overlap_Link_Map[rp.first].Head_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Tail_Id_Ov_Ma;
	} else {
		graph_t.Supertig_Overlap_Link_Map[rp.first].tail_links = graph_t.Supertig_Overlap_Link_Map[fm_id].tail_links;
		graph_t.Supertig_Overlap_Link_Map[rp.first].Tail_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Tail_Id_Ov_Ma;
		tig_bank.Supertig_Overlap_Link_Map[rp.first].tail_links = graph_t.Supertig_Overlap_Link_Map[fm_id].tail_links;
		tig_bank.Supertig_Overlap_Link_Map[rp.first].Tail_Id_Ov_Ma = graph_t.Supertig_Overlap_Link_Map[fm_id].Tail_Id_Ov_Ma;
	}
	ov_link_erase( make_pair( fm_id, 1 ), graph_t, tig_bank );
}


void ov_link_break_replace( Supertig_id fm_id, list< pair< Supertig_id, Forb > > &pl, subgraph &graph_t, Supertig_bank &tig_bank )
{
	
	ov_link_tail_replace( fm_id, reversepht( pl.front() ), graph_t, tig_bank );
	ov_link_head_replace( fm_id, pl.back(), graph_t, tig_bank );
	ov_link_id_erase( fm_id, graph_t, tig_bank );
}

