#ifndef GRAPH_OVLK_RPL_H
#define GRAPH_OVLK_RPL_H

#include "Graph_subgraph.h"

using namespace std;


// erase linked node pb off pa
void ov_link_erase( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, subgraph &graph_t, Supertig_bank &tig_bank );

// erase all the linked nodes off pa
void ov_link_erase( pair< Supertig_id, Forb > pa, subgraph &graph_t, Supertig_bank &tig_bank );

// erase all the linked nodes off both two sides of supertig id, still retain the id. 
void ov_link_erase( Supertig_id id, subgraph &graph_t, Supertig_bank &tig_bank );

// erase the supertig id off the ovlink map
void ov_link_id_erase(  Supertig_id id, subgraph &graph_t, Supertig_bank &tig_bank );

// erase the supertig id off the ovlink map along with other links to that id.
void ov_link_id_erase_com( Supertig_id id, subgraph &graph_t, Supertig_bank &tig_bank );

// add linking node pb to pa
void ov_link_add( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, subgraph &graph_t, Supertig_bank &tig_bank, int ovlen );

// add linking node pb to pa, if pa not exist in linkmap, create it.
void ov_link_create( pair< Supertig_id, Forb > pa, pair< Supertig_id, Forb > pb, subgraph &graph_t, Supertig_bank &tig_bank, int ovlen );

// newly assembled Supertig n_tig replace its component tigs in the ovlink map.
void ov_link_replace( Supertig_id n_id,
					 Supertig & n_tig, 
					 subgraph &graph_t, 
					 Supertig_bank &tig_bank, 
					 vector< pair< pair< Supertig_id, Forb>, int > > &left_linked_nodes, 
					 vector< pair< pair< Supertig_id, Forb>, int > > &right_linked_nodes );

void ov_link_add_2( pair< Supertig_id, Forb > ida,
					 pair< Supertig_id, Forb > idb, 
					 map< Supertig_id, Supertig_id > &id_map,
					 subgraph &graph_t,
					 Supertig_bank &tig_bank );

void ov_link_replace_spe( Supertig_id n_id,
						 subgraph &graph_t, 
						 Supertig_bank &tig_bank, 
						 pair< Supertig_id, Forb > tp, 
						 pair< Supertig_id, Forb > fp );

void ov_link_replace_assign( Supertig_id n_id,
							 subgraph &graph_t, 
							 Supertig_bank &tig_bank, 
							 pair< Supertig_id, Forb > tp, 
							 pair< Supertig_id, Forb > fp );

void ov_link_head_replace( Supertig_id fm_id, Supertig_id rp_id, subgraph &graph_t, Supertig_bank &tig_bank );

void ov_link_tail_replace( Supertig_id fm_id, Supertig_id rp_id, subgraph &graph_t, Supertig_bank &tig_bank );

void ov_link_head_replace( Supertig_id fm_id, pair< Supertig_id, Forb > rp, subgraph &graph_t, Supertig_bank &tig_bank );

void ov_link_tail_replace( Supertig_id fm_id, pair< Supertig_id, Forb > rp, subgraph &graph_t, Supertig_bank &tig_bank );

void ov_link_break_replace( Supertig_id fm_id, list< pair< Supertig_id, Forb > > &pl, subgraph &graph_t, Supertig_bank &tig_bank );

#endif

