#include "Graph_repeat_sep.h"

void repeat_seperate( subgraph &graph_t, Scaffold_subset &scf_s, Supertig_bank &bank )
{
	set< Supertig_id > repeat;
	set< pair< Supertig_id, Forb > > side_repeat;
	map< Supertig_id, Supertig_Overlap_Link > tmp_ov_link;
	form_Link_fr_superpath( tmp_ov_link, graph_t.Supertig_Overlap_Link_Map, scf_s.superpath, bank );

	map< Supertig_id, repeat_domain > Side_Re_dom_Map;

	if ( get_repeat_fr_link( tmp_ov_link, repeat, side_repeat ) ) {
		
		if ( !repeat.empty() ) {
			set< Supertig_id >::iterator Iter;
			for ( Iter = repeat.begin(); Iter != repeat.end(); ++Iter ) {
				repeat_domain rep;
				get_repeat_dom( scf_s.superpath, *Iter, rep );
				assign_n_id( *Iter, rep, graph_t, scf_s, bank );
			}
		}

		if ( !side_repeat.empty() ) {
			get_repeat_dom( tmp_ov_link, side_repeat, Side_Re_dom_Map );
		}

		reduceredunpl_t( scf_s.superpath );
	}


}


bool get_repeat_fr_link( map< Supertig_id, Supertig_Overlap_Link > & lmap, 
						set< Supertig_id > &repeat, 
						set< pair< Supertig_id, Forb > > &side_repeat )
{
	map< Supertig_id, Supertig_Overlap_Link >::iterator Ite;
	for ( Ite = lmap.begin(); Ite != lmap.end(); ++Ite ) {
		int h_rep = 0;
		if ( (int)Ite->second.head_links.size() > 1 )
			h_rep = 1;
		int t_rep = 0;
		if ( (int)Ite->second.tail_links.size() > 1 ) 
			t_rep = 1;

		if ( h_rep == 1 && h_rep == 1 ) {
			repeat.insert( Ite->first );
		} else {
			if ( h_rep == 1 )
				side_repeat.insert( make_pair( Ite->first, 0 ) );
			if ( t_rep == 1 )
				side_repeat.insert( make_pair( Ite->first, 1 ) );
		}
	}
	if ( ( !repeat.empty() ) || ( !side_repeat.empty() ) ) {
		return true;
	} else
		return false;
}


void get_repeat_dom( vector< list< pair< Supertig_id, Forb > > > &ultrapath, 
					 Supertig_id repeat_id,
					 repeat_domain &rep )
{

	set< pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > > repeatpset;

	for ( size_t i = 0; i < ultrapath.size(); ++i ) {
		
	
			pair< Supertig_id, Forb > p = make_pair( repeat_id, 0 );
			pair< Supertig_id, Forb > rp = make_pair( repeat_id, 1 );
			list< pair< Supertig_id, Forb > >::iterator Iteli;
			Iteli = find( ultrapath[i].begin(), ultrapath[i].end(), p );
			while ( Iteli != ultrapath[i].end() ) {
				list<pair< Supertig_id, Forb > >::iterator Iteli2 = Iteli;
				pair<pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > e_e;
			
				if ( Iteli2 != ultrapath[i].begin() ) {
					--Iteli2;
					e_e.first = *Iteli2;
		
					++Iteli2;
				}
				
				++Iteli2;
				if(   Iteli2 != ultrapath[i].end() ) {
					e_e.second = *Iteli2;
				
				}
				
				if ( repeatpset.empty() )
					repeatpset.insert( e_e );
				else {
					if ( repeatpset.find( e_e ) == repeatpset.end() ) {
						insertenex( repeatpset, e_e );
					}
				}

			

				
				Iteli = find( Iteli2, ultrapath[i].end(), p );
			}
			
			Iteli = find( ultrapath[i].begin(), ultrapath[i].end(), rp );
			while ( Iteli != ultrapath[i].end() ) {
				list<pair< Supertig_id, Forb > >::iterator Iteli2 = Iteli;
				pair<pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > e_e;
			
				if ( Iteli2 != ultrapath[i].begin() ) {
					--Iteli2;
					pair< Supertig_id, Forb > trp = reversepht( *Iteli2 );
					e_e.second = trp;
		
					++Iteli2;
				}
				
				++Iteli2;
				if ( Iteli2 != ultrapath[i].end() ) {
					pair< Supertig_id, Forb > trp = reversepht( *Iteli2 );
					e_e.first = trp;
	
				}

				if ( repeatpset.empty() )
					repeatpset.insert( e_e );
				else {
					if ( repeatpset.find( e_e ) == repeatpset.end() ) {
						insertenex( repeatpset, e_e );
					}
				}


			

				Iteli = find( Iteli2, ultrapath[i].end(), rp );
			}
	
	}

	pair< Supertig_id, Forb > nulp;


	vector< list< pair< Supertig_id, Forb > > > triple;



		
	set<pair<pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > >::iterator Ites;

	map<pair< Supertig_id, Forb >, int > en;
	set<pair< Supertig_id, Forb > > enset;
	map<pair< Supertig_id, Forb >, int > ex;
	set<pair< Supertig_id, Forb > > exset;
	for ( Ites = repeatpset.begin(); Ites != repeatpset.end(); ++Ites ) {


		if ( Ites->first == nulp || Ites->second == nulp )
			continue;

		if(en.find(Ites->first) != en.end()){
			en[Ites->first] = 1;
			
		}else{
			en.insert(make_pair(Ites->first, 0));
		}

		if(ex.find(Ites->second) != ex.end()){
			ex[Ites->second] = 1;
			
		}else{
			ex.insert(make_pair(Ites->second, 0));
		}

	}

	for ( Ites = repeatpset.begin(); Ites != repeatpset.end(); ++Ites ) {

		if ( Ites->first == nulp || Ites->second == nulp )
			continue;
		if ( en[Ites->first] == 0 && ex[Ites->second] == 0 ) {
			rep.traverse_path.push_back( *Ites );
		
			enset.insert( Ites->first );
			exset.insert( Ites->second );
		} 
		
	}
	for ( Ites = repeatpset.begin(); Ites != repeatpset.end(); ++Ites ) {

		
		if ( exset.find( Ites->second ) == exset.end() && Ites->second != nulp ) {
			rep.right_branch.insert( reversepht( Ites->second ) );
		}
	
		if ( enset.find( Ites->first ) == enset.end() && Ites->first != nulp ) {
			rep.left_branch.insert( Ites->first );
		}			
			
	}


}

void get_repeat_dom( map< Supertig_id, Supertig_Overlap_Link > & lmap, 
					 set< pair< Supertig_id, Forb > > &side_repeat,
					 map< Supertig_id, repeat_domain > &r_d )
{

	set< pair< Supertig_id, Forb > >::iterator Ite;
	for ( Ite = side_repeat.begin(); Ite != side_repeat.end(); ++Ite ) {
		if ( Ite->second == 0 ) {
			r_d[Ite->first].right_branch = lmap[Ite->first].head_links;
		} else {
			r_d[Ite->first].left_branch = lmap[Ite->first].tail_links;
		}
	}
}


void insertenex(set<pair<pair<Supertig_id, Forb>, pair<Supertig_id, Forb> > > &ss, pair<pair<Supertig_id, Forb>, pair<Supertig_id, Forb> > p)
{
	pair< Supertig_id, Forb > nulp;
	
	set<pair<pair<Supertig_id, Forb>, pair<Supertig_id, Forb> > >::iterator Ites;
	for(Ites = ss.begin(); Ites != ss.end(); ++Ites){
		if(p.first != nulp && Ites->first == p.first){
			if(p.second == Ites->second)
				return;
			if(p.second == nulp)
				return;
			if(Ites->second == nulp){
				ss.erase(Ites);
				
				break;
			}
		}
		if(p.second != nulp && Ites->second == p.second){
			if(p.first == Ites->first)
				return;
			if(p.first == nulp)
				return;
			if(Ites->first == nulp){
				ss.erase(Ites);
				
				break;
			}
		}
	}
	
	ss.insert(p);
}

void assign_n_id( Supertig_id id, repeat_domain &rep, subgraph &graph_t, Scaffold_subset &scf_s, Supertig_bank &bank )
{
	if ( !rep.traverse_path.empty() ) {

		mark_recur_tig( id, bank );

		for ( size_t i = 0; i < rep.traverse_path.size(); ++i ) {
			assign_n_id_t( id, 
				rep.traverse_path[i].first, 
				rep.traverse_path[i].second, 
				graph_t, 
				bank,
				scf_s.superpath, 
				rep.left_branch,
				rep.right_branch );
		}

		remove_old_id ( make_pair( id, 0 ), rep.left_branch, rep.right_branch, graph_t, bank, scf_s.superpath );

		
	
		graph_t.active_tig.erase( id );
	}
}

void assign_n_id_t( Supertig_id id, 
				   pair< Supertig_id, Forb > fp, 
				   pair< Supertig_id, Forb > bp,
				   subgraph &graph_t, 
				   Supertig_bank &tig_bank,
				   vector< list< pair< Supertig_id, Forb > > >& pathve,
				   set< pair< Supertig_id, Forb > > & left_branch, 
				   set< pair< Supertig_id, Forb > > &right_branch )
{
	Supertig n_tig;
	n_tig = tig_bank.Supertig_Map[id];

	Supertig_id n_id = tig_bank.Supertig_Map.rbegin()->first + 1;
	if( tig_bank.Supertig_Map.find( n_id ) != tig_bank.Supertig_Map.end() ) {
		cerr << "Warning in  func replace_hete_t_spe: n_id already exist in bank.Supertig_Map " <<endl;
		return;
	}


	graph_t.active_tig.insert( n_id );
	
	n_tig.Resv_Cut_link.tail_links = left_branch;

	n_tig.Resv_Cut_link.head_links = right_branch;
	

	tig_bank.Supertig_Map.insert( make_pair ( n_id, n_tig ) );

	
	ov_link_replace_assign( n_id, graph_t, tig_bank, make_pair( id, 1 ), fp );
	path_replace_spe(  make_pair( id, 0 ), pathve, n_id, fp ); 

	ov_link_replace_assign( n_id, graph_t, tig_bank, make_pair( id, 0 ), reversepht(bp) );
	path_replace_spe( make_pair( id, 1 ), pathve, n_id, reversepht(bp) ); 

	scf_replace_spe( n_id, id, tig_bank );



	
		
}

void remove_old_id( pair< Supertig_id, Forb > tp,
				   set< pair< Supertig_id, Forb > > & left_branch,
				   set< pair< Supertig_id, Forb > > &right_branch,
				   subgraph &graph_t, 
				   Supertig_bank &tig_bank, 
				   vector< list< pair< Supertig_id, Forb > > >& pathve )
{

	remove_old_id_ovlink( tp, left_branch, right_branch, graph_t, tig_bank );

	remove_old_id_fr_path( tp, pathve );
	remove_old_id_fr_path( reversepht(tp), pathve );

}

void remove_old_id_ovlink( pair< Supertig_id, Forb > tp,
						  set< pair< Supertig_id, Forb > > & left_branch,
						  set< pair< Supertig_id, Forb > > &right_branch,
						  subgraph &graph_t, 
						  Supertig_bank &tig_bank )
{
	if ( !left_branch.empty() ) {
		set< pair< Supertig_id, Forb > >::iterator Iteh;
		for ( Iteh = left_branch.begin(); Iteh != left_branch.end(); ++Iteh ) {
			ov_link_erase( *Iteh, reversepht(tp), graph_t, tig_bank );
		
		}

	}
	if ( !right_branch.empty() ) {
		set< pair< Supertig_id, Forb > >::iterator Itet;
		for ( Itet = right_branch.begin(); Itet != right_branch.end(); ++Itet ) {
			ov_link_erase( *Itet, tp, graph_t, tig_bank );
	
		}
	}
	ov_link_id_erase( tp.first, graph_t, tig_bank );
}

void remove_old_id_fr_path( pair< Supertig_id, Forb > tp, vector< list< pair< Supertig_id, Forb > > >& pathve )
{

	vector< list< pair< Supertig_id, Forb > > > pl;

	size_t vesize = pathve.size();
	for ( size_t i = 0; i < vesize; ++i ) {

		list< pair< Supertig_id, Forb > >::iterator Ite;
		list< pair< Supertig_id, Forb > >::iterator Ite_p = pathve[i].begin();
		list< pair< Supertig_id, Forb > > n_path;
		Ite = find( pathve[i].begin(), pathve[i].end(), tp );
		n_path.insert( n_path.end(), Ite_p, Ite );
		if ( (int)n_path.size() > 1 )
			pl.push_back( n_path );
		n_path.clear();
		while ( Ite != pathve[i].end() ) {
			
			++Ite;
			if ( Ite == pathve[i].end() )
				break;
			Ite_p = Ite;
			Ite = find( Ite_p, pathve[i].end(), tp );
			
			n_path.insert( n_path.end(), Ite_p, Ite );
			if ( (int)n_path.size() )
				pl.push_back( n_path );
			n_path.clear();

		}
	}
	pathve = pl;
}

