#ifndef GRAPH_REPEAT_SEP_H
#define GRAPH_REPEAT_SEP_H

#include "Graph_subgraph.h"
#include "Graph_rm_Contr.h"
#include "Graph_Suptig_Assbl.h"
#include "Graph_ovlk_rpl.h"

//////////////////////////////////////////////
// Repeats being traversed by a path means the path traverses the 
// repeat node with paired entrance and export in one-to-one 
// correspondence. The repeat nodes are denoted and seperated
// into two nodes by assigning the repeat node a new id for 
// each traversing path. 
//
//
//
//
//
//
/////////////////////////////////////////////////


void repeat_seperate( subgraph &graph_t, Scaffold_subset &scf_s, Supertig_bank &bank );

bool get_repeat_fr_link( map< Supertig_id, Supertig_Overlap_Link > & lmap, 
						set< Supertig_id > &repeat, 
						set< pair< Supertig_id, Forb > > &side_repeat );

void get_repeat_dom( vector< list< pair< Supertig_id, Forb > > > &ultrapath, 
					 Supertig_id repeat_id,
					 repeat_domain &rep );

void get_repeat_dom( map< Supertig_id, Supertig_Overlap_Link > & lmap,
					 set< pair< Supertig_id, Forb > > &side_repeat,
					 map< Supertig_id, repeat_domain > &r_d );

void insertenex(set<pair<pair<Supertig_id, Forb>, pair<Supertig_id, Forb> > > &ss, pair<pair<Supertig_id, Forb>, pair<Supertig_id, Forb> > p);

void assign_n_id( Supertig_id id, repeat_domain &rep, subgraph &graph_t, Scaffold_subset &scf_s, Supertig_bank &bank );

void assign_n_id_t( Supertig_id id,
				   pair< Supertig_id, Forb > fp, 
				   pair< Supertig_id, Forb > bp,
				   subgraph &graph_t, 
				   Supertig_bank &tig_bank,
				   vector< list< pair< Supertig_id, Forb > > >& pathve,
				   set< pair< Supertig_id, Forb > > & left_branch, 
				   set< pair< Supertig_id, Forb > > &right_branch );

void remove_old_id( pair< Supertig_id, Forb > tp,
				   set< pair< Supertig_id, Forb > > & left_branch,
				   set< pair< Supertig_id, Forb > > &right_branch,
				   subgraph &graph_t, 
				   Supertig_bank &tig_bank, 
				   vector< list< pair< Supertig_id, Forb > > >& pathve );

void remove_old_id_ovlink( pair< Supertig_id, Forb > tp,
						  set< pair< Supertig_id, Forb > > & left_branch,
						  set< pair< Supertig_id, Forb > > &right_branch,
						  subgraph &graph_t, 
						  Supertig_bank &tig_bank );

void remove_old_id_fr_path( pair< Supertig_id, Forb > tp, vector< list< pair< Supertig_id, Forb > > >& pathve );


#endif
