#include "Graph_rm_Contr.h"

void remove_contra_link( subgraph &graph_t, Scaffold_subset &scf_s, Supertig_bank &bank )
{

	map< Supertig_id, Supertig_Overlap_Link > tmp_ov_link;
	form_Link_fr_superpath( tmp_ov_link, graph_t.Supertig_Overlap_Link_Map, scf_s.superpath, bank );

	
	
	rm_contr_link( tmp_ov_link, graph_t.Supertig_Overlap_Link_Map, scf_s, bank );
	

	vector< list< pair< Supertig_id, Forb > > > simple_path;
	
	merge_sim_path_fr_Link( tmp_ov_link, simple_path );
	

	map< size_t, Supertig_id > n_id_map;

	if( !simple_path.empty() )
		ass_sim_path( simple_path, scf_s, graph_t, bank, n_id_map );

	if ( !n_id_map.empty() ) {
		replace_path( scf_s.superpath, simple_path, n_id_map );
		reduceredunpl_t( scf_s.superpath );
	}
	
	
	if ( !scf_s.seed_bait_map.empty() &&  !simple_path.empty() && !n_id_map.empty() )
		replace_baitmap( simple_path, scf_s.seed_bait_map, n_id_map, bank );  
	
	

	

}

void form_Link_fr_superpath( map< Supertig_id, Supertig_Overlap_Link > &lmap,
							map< Supertig_id, Supertig_Overlap_Link > &L_Map,
							vector< list< pair< Supertig_id, Forb > > > &superpath,
							Supertig_bank &tig_bank )
{
	size_t psize = superpath.size(); 
	for ( size_t i = 0; i < psize; ++i ) {
		form_Link_fr_path( lmap, L_Map, superpath[i], tig_bank );
	}
}

void form_Link_fr_path( map< Supertig_id, Supertig_Overlap_Link > &lmap, map< Supertig_id, Supertig_Overlap_Link > &L_Map, list<pair< Supertig_id, Forb > > &path, Supertig_bank &tig_bank )
{
	if( (int)path.size() <= 1 )
		return;
	list< pair< Supertig_id, Forb > >::iterator Itel = path.begin();
	pair< Supertig_id, Forb > p1 = *Itel;
	++Itel;
	for (; Itel != path.end(); ++Itel){
		pair< Supertig_id, Forb > p2 = *Itel;
		pair< Supertig_id, Forb > rp = reversepht(p2);
		int ovlen = -1000;
		int atag = 0;
	
		if ( L_Map.find(p1.first)==L_Map.end() ) {
			 atag = 1;
		} 
		if ( atag == 0 ) {
			if ( p1.second == 0 ) {
				if ( L_Map[p1.first].head_links.find( rp ) != L_Map[p1.first].head_links.end() )
					ovlen = L_Map[p1.first].Head_Id_Ov_Ma[rp];
				else
					atag = 1;
			} else {
				if ( L_Map[p1.first].tail_links.find( rp ) != L_Map[p1.first].tail_links.end() )
					ovlen = L_Map[p1.first].Tail_Id_Ov_Ma[rp];
				else
					atag = 1;
			}
		}
		if ( atag == 1 ) {
			ovlen = get_ovlen_via_basic_tig( p1, rp, tig_bank );
			if ( ovlen == -1000 )
				ovlen = get_ovlen_from_lk_tig( p1, rp, tig_bank );
		}
		if ( ovlen == -1000 )
			return;
		if ( lmap.find(p1.first) == lmap.end() ) {
			
			Supertig_Overlap_Link ob;
			if ( p1.second == 0 ) {
				ob.head_links.insert(rp);
				
				
				ob.Head_Id_Ov_Ma.insert( make_pair( rp, ovlen ) );
			} else {
				ob.tail_links.insert(rp);
				
				ob.Tail_Id_Ov_Ma.insert( make_pair( rp, ovlen ) );
			}
			lmap.insert( make_pair( p1.first, ob ) );
			
		} else {
			
			if ( p1.second == 0 ) {
				if( lmap[p1.first].head_links.find(rp) == lmap[p1.first].head_links.end() ) {
					lmap[p1.first].head_links.insert( rp );
					
					lmap[p1.first].Head_Id_Ov_Ma.insert( make_pair( rp, ovlen ) );
				}
			} else {
				if ( lmap[p1.first].tail_links.find(rp) == lmap[p1.first].tail_links.end() ) {
					lmap[p1.first].tail_links.insert( rp );
					
					lmap[p1.first].Tail_Id_Ov_Ma.insert( make_pair( rp, ovlen ) );
				}
			}
		}
	
		if ( lmap.find(rp.first) == lmap.end() ) {
			
			Supertig_Overlap_Link ob;
			if ( rp.second == 0 ) {
				ob.head_links.insert(p1);
				
				
				ob.Head_Id_Ov_Ma.insert( make_pair( p1, ovlen ) );
			} else {
				ob.tail_links.insert(p1);
				
				ob.Tail_Id_Ov_Ma.insert( make_pair( p1, ovlen ) );
			}
			lmap.insert( make_pair( rp.first, ob ) );
			
		} else {
			
			if ( rp.second == 0 ) {
				if( lmap[rp.first].head_links.find(p1) == lmap[rp.first].head_links.end() ) {
					lmap[rp.first].head_links.insert( p1 );
					
					lmap[rp.first].Head_Id_Ov_Ma.insert( make_pair( p1, ovlen ) );
				}
			} else {
				if ( lmap[rp.first].tail_links.find(p1) == lmap[rp.first].tail_links.end() ) {
					lmap[rp.first].tail_links.insert( p1 );
					
					lmap[rp.first].Tail_Id_Ov_Ma.insert( make_pair( p1, ovlen ) );
				}
			}
		}

		p1 = p2;
	}

}

void merge_sim_path_fr_Link( map< Supertig_id, Supertig_Overlap_Link > & lmap, vector< list< pair< Supertig_id, Forb > > > &unitigVe )  // path with nodes >= 2
{

	set< Supertig_id > remainid;
	map< Supertig_id, Supertig_Overlap_Link >::iterator IteL;
	for ( IteL = lmap.begin(); IteL != lmap.end(); ++IteL )
		remainid.insert( IteL->first );

	

	int i = 0;
	while(!remainid.empty()){
		i+=1;
	
		set< Supertig_id > walked;
		list< pair< Supertig_id, Forb > > unitig;
		Supertig_id id = *remainid.begin();

		unitig.push_back( make_pair( id, 0 ) );
		walked.insert( id );
		remainid.erase( id );
	
		if ( (int)lmap[id].head_links.size() == 1 ){
		
			int id1 = id;
			pair< Supertig_id, Forb > p1 = make_pair(id, 0);
			int tag = 0;
			int g = 0;
			int primer = 0;    
			while ( tag == 0 ){
				g += 1;
			
				Supertig_id id2;
				Forb ht2;
				if ( lmap.find( id1 ) == lmap.end() ) {
					cout << "error: L_Map.find(id1)==L_Map.end() "<<id1<<endl;  exit(1);
				}
			
				if ( primer == 0 ) {
					pair< Supertig_id, Forb > p2 = *lmap[id1].head_links.begin();
					id2 = p2.first;
					ht2 = p2.second;
			
				} else {
					pair< Supertig_id, Forb > p2 = *lmap[id1].tail_links.begin();
					id2 = p2.first;
					ht2 = p2.second;
				
				} 
			
				if ( walked.find( id2 ) != walked.end() ) {
				
					break;
				}
				
				if ( ht2 == 0 && (int)lmap[id2].head_links.size() == 1 ){
				
					
					unitig.push_back( make_pair( id2, 1 ) );
				
					walked.insert( id2 );
				
					remainid.erase( id2 );
				
					if ( (int)lmap[id2].tail_links.size() == 1 ) {
						id1 = id2;
						p1 = make_pair( id1, 1 );
						primer = 1;
					} else {
						tag = 1;
					}
				
				} else if ( ht2 == 1 && (int)lmap[id2].tail_links.size() == 1 ){
			
					if ( lmap[id2].tail_links.find(p1) == lmap[id2].tail_links.end() ) {
						cout<<"error2: in Assembly_Later::merge_to_unitig() "<<id1<<","<<id2<<endl;  exit(1);
					}
					unitig.push_back( make_pair( id2, 0 ) );
				
					walked.insert( id2 );
				
					remainid.erase( id2 );
			

					if ( (int)lmap[id2].head_links.size() == 1 ) {
						id1 = id2;
						p1 = make_pair( id1, 0 );
						primer = 0;
					} else {
						tag = 1;
					}
			

				} else {
					tag = 1;
				}
			}
		
		}
		if ( (int)lmap[id].tail_links.size() == 1 ) {
		
			int id1 = id;
			pair< Supertig_id, Forb > p1 = make_pair( id1, 1 );
			int tag = 0;
			int g = 0;
			int primer = 1;

			while ( tag == 0 ) {
				g += 1;
		
				Supertig_id id2;
				

				Forb ht2;
		
				if ( primer == 0 ) {
					pair< Supertig_id, Forb > p2 = *lmap[id1].head_links.begin();
					id2 = p2.first;
					ht2 = p2.second;
			

				} else {
					pair<int, int> p2 = *lmap[id1].tail_links.begin();
					id2 = p2.first;
					ht2 = p2.second;
			

				}

				if ( walked.find( id2 ) != walked.end() )
					break;
				
				if ( ht2 == 0 && (int)lmap[id2].head_links.size() == 1 ) {
					
					unitig.push_front( make_pair( id2, 0 ) );
			
					walked.insert( id2 );
					remainid.erase( id2 );

					if ( (int)lmap[id2].tail_links.size() == 1 ) {
						id1 = id2;
						p1 = make_pair( id1, 1 );
						primer = 1;
					} else {
						tag = 1;
					}

				} else if ( ht2 == 1 && (int)lmap[id2].tail_links.size() == 1 ){
					
					unitig.push_front( make_pair( id2, 1 ) );
			
					walked.insert( id2 );
					remainid.erase( id2 );

					if ( (int)lmap[id2].head_links.size() == 1 ) {
						id1 = id2;
						p1 = make_pair( id1, 0 );
						primer = 0;
					} else {
						tag = 1;
					}

				} else {
						tag = 1;
				}
			}
		}
		
		if ( (int)unitig.size() > 1 )
			unitigVe.push_back(unitig);

		unitig.erase(unitig.begin(), unitig.end());
		walked.erase(walked.begin(), walked.end());

	}
}

void rm_contr_link( map< Supertig_id, Supertig_Overlap_Link > &tmp_link, 
				   map< Supertig_id, Supertig_Overlap_Link > &pre_ov_link,
				   Scaffold_subset &scf_s, 
				   Supertig_bank &bank )
{

	map< Supertig_id, Supertig_Overlap_Link >::iterator Ite;
	for ( Ite = tmp_link.begin(); Ite != tmp_link.end(); ++Ite ) {
		if ( pre_ov_link.find( Ite->first ) == pre_ov_link.end() ) {
			cerr << "Warning in rm_contr_link: pre_ov_link not found "<< Ite->first <<endl; system("pause");
			continue;
		}
		if ( scf_s.incomplete_paired_id.find( Ite->first ) != scf_s.incomplete_paired_id.end() ) {
			if ( !Ite->second.head_links.empty() ) {
				set< pair< Supertig_id, Forb > >::iterator Iteh; 
				set< pair< Supertig_id, Forb > > era_set;
				for ( Iteh = pre_ov_link[Ite->first].head_links.begin(); Iteh != pre_ov_link[Ite->first].head_links.end(); ++Iteh ) {
					if ( Ite->second.head_links.find( *Iteh ) == Ite->second.head_links.end() )
						era_set.insert( *Iteh );
				}
				if ( !era_set.empty() ) {
					set< pair< Supertig_id, Forb > >::iterator Iter;
					for ( Iter = era_set.begin(); Iter != era_set.end(); ++Iter ) {
						
						bank.Supertig_Map[Ite->first].Resv_Cut_link.head_links.insert( *Iter );
						bank.Supertig_Map[Ite->first].Resv_Cut_link.Head_Id_Ov_Ma.insert( make_pair( *Iter, bank.Supertig_Overlap_Link_Map[Ite->first].Head_Id_Ov_Ma[ *Iter ] ) );
					}
					bank.Supertig_Map[Ite->first].resvcutlink = 1;
				}
			}

			if ( !Ite->second.tail_links.empty() ) {
				set< pair< Supertig_id, Forb > >::iterator Itet;
				set< pair< Supertig_id, Forb > > era_set;
				for ( Itet = pre_ov_link[Ite->first].tail_links.begin(); Itet != pre_ov_link[Ite->first].tail_links.end(); ++Itet ) {
					if ( Ite->second.tail_links.find( *Itet ) == Ite->second.tail_links.end() )
						era_set.insert( *Itet );
				}
				if ( !era_set.empty() ) {
					set< pair< Supertig_id, Forb > >::iterator Iter;
					for ( Iter = era_set.begin(); Iter != era_set.end(); ++Iter ) {
						
						bank.Supertig_Map[Ite->first].Resv_Cut_link.tail_links.insert( *Iter );
						bank.Supertig_Map[Ite->first].Resv_Cut_link.Tail_Id_Ov_Ma.insert( make_pair( *Iter, bank.Supertig_Overlap_Link_Map[Ite->first].Tail_Id_Ov_Ma[ *Iter ] ) );
					}
					bank.Supertig_Map[Ite->first].resvcutlink = 1;
				}
			}
		} 

	
			pre_ov_link[Ite->first].head_links = Ite->second.head_links;
			pre_ov_link[Ite->first].Head_Id_Ov_Ma = Ite->second.Head_Id_Ov_Ma;
			bank.Supertig_Overlap_Link_Map[Ite->first].head_links = Ite->second.head_links;
			bank.Supertig_Overlap_Link_Map[Ite->first].Head_Id_Ov_Ma = Ite->second.Head_Id_Ov_Ma;

	
			pre_ov_link[Ite->first].tail_links = Ite->second.tail_links;
			pre_ov_link[Ite->first].Tail_Id_Ov_Ma = Ite->second.Tail_Id_Ov_Ma;
			bank.Supertig_Overlap_Link_Map[Ite->first].tail_links = Ite->second.tail_links;
			bank.Supertig_Overlap_Link_Map[Ite->first].Tail_Id_Ov_Ma = Ite->second.Tail_Id_Ov_Ma;
	
		
	}

}

void ass_sim_path( vector< list< pair< Supertig_id, Forb > > > &path,
				  Scaffold_subset &scf_s,
				  subgraph &graph_t,
				  Supertig_bank &tig_bank,
				  map< size_t, Supertig_id > &n_id_map )
{
	size_t path_size = path.size();
	for ( size_t i = 0; i < path_size; ++i ) {
		list< pair< Supertig_id, Forb > >::iterator Itel;
		vector< pair< Supertig_id, Forb > > series;
		set< size_t > branch_tig;
		for ( Itel = path[i].begin(); Itel != path[i].end(); ++Itel ) {
			series.push_back( *Itel );
			if ( scf_s.incomplete_paired_id.find( Itel->first ) != scf_s.incomplete_paired_id.end() ) {
				branch_tig.insert( series.size() - 1 );
			}
		}

	

		Supertig_id n_id = supertig_in_seri_ass( series, graph_t, tig_bank );
		if ( n_id != -1 ) {
			tig_bank.Supertig_Map[n_id].branch_tig = branch_tig;
			n_id_map.insert( make_pair( i, n_id ) );
		}
	
	}
}

void replace_path( vector< list< pair< Supertig_id, Forb > > > &pl, 
				  vector< list< pair< Supertig_id, Forb > > > &unitigVe, 
				  map< size_t, Supertig_id > &n_id_map )
{

	
	vector< list< pair< Supertig_id, Forb > > > al_pl;

	for ( size_t j = 0; j < pl.size(); ++j ) {
		
		int ch = 0;
		int size = (int)pl[j].size();
		for ( size_t i = 0; i < unitigVe.size(); ++i){

			if ( n_id_map.find( i ) == n_id_map.end() )
				continue;

			int tag = 0;
			pair< Supertig_id, Forb > px = unitigVe[i].front();
			pair< Supertig_id, Forb > rpx = reversepht(px);
			pair< Supertig_id, Forb > py = unitigVe[i].back();
			pair< Supertig_id, Forb > rpy = reversepht(py);

			list< pair< Supertig_id, Forb > > npl = pl[j];
			list< pair< Supertig_id, Forb > > al_npl;
			list< pair< Supertig_id, Forb > >::iterator Iteli;
			Iteli = find(npl.begin(), npl.end(), px);

			int h = 0;
			while(Iteli != npl.end()){
				tag = 1;
				h += 1;
		
				al_npl.insert( al_npl.end(), npl.begin(), Iteli );
				al_npl.push_back( make_pair( n_id_map[i], 0 ) );
				list< pair< Supertig_id, Forb > >::iterator Itep = unitigVe[i].begin();
				for(; Iteli != npl.end(); ++Iteli){
					ch += 1;                                                   
					if(Itep == unitigVe[i].end())
						break;
					if(*Itep != *Iteli){
						cout<<"error1 in replace_path "<<Itep->first<<","<<Itep->second<<" "<<Iteli->first<<","<<Iteli->second<<endl;  exit(1);
					}
					++Itep;
				}
				if(Iteli != npl.end())
					al_npl.insert( al_npl.end(), Iteli, npl.end() );

				npl = al_npl;
				al_npl.clear();
				Iteli = find( npl.begin(), npl.end(), px );
			
			}

			list< pair< Supertig_id, Forb > >::reverse_iterator Riteli;
			Riteli = find( npl.rbegin(), npl.rend(), rpx );
	
			h = 0;
			while( Riteli != npl.rend() ) {

				
				tag = 1;
				h += 1;
			
				al_npl.insert( al_npl.end(), npl.rbegin(), Riteli );
				al_npl.push_back( make_pair( n_id_map[i], 1 ) );
				list< pair< Supertig_id, Forb > >::iterator Itep = unitigVe[i].begin();
				for ( ; Riteli != npl.rend(); ++Riteli ) {
					ch += 1;
					if(Itep == unitigVe[i].end())
						break;
					if(reversepht(*Itep) != *Riteli){
						cout<<"error1.2 in replace_path"<<endl;  exit(1);
					}
					++Itep;
				}
				if ( Riteli != npl.rend() )
					al_npl.insert(al_npl.end(), Riteli, npl.rend());

				al_npl.reverse();
				npl = al_npl;
				al_npl.clear();
				Riteli = find( npl.rbegin(), npl.rend(), rpx );
		
			}

			Riteli = find( npl.rbegin(), npl.rend(), py );
	
			h = 0;
			while ( Riteli != npl.rend() ) {
				tag = 1;
				h += 1;
		
				al_npl.insert( al_npl.end(), npl.rbegin(), Riteli );
				al_npl.push_back( make_pair( n_id_map[i], 0) );
				list< pair< Supertig_id, Forb > >::reverse_iterator Ritep = unitigVe[i].rbegin();
				for(; Riteli != npl.rend(); ++Riteli){
					ch += 1;
					if(Ritep == unitigVe[i].rend())
						break;
					if(*Ritep != *Riteli){
						cout<<"error1.3 in replace_path"<<endl;  exit(1);
					}
					++Ritep;
				}
				if(Riteli != npl.rend())
					al_npl.insert( al_npl.end(), Riteli, npl.rend() );

				al_npl.reverse();
				npl = al_npl;
				al_npl.clear();
				Riteli = find( npl.rbegin(), npl.rend(), py );
			
			}

			Iteli = find( npl.begin(), npl.end(), rpy );
		
			h = 0;
			while(Iteli != npl.end()){
				tag = 1;
				h += 1;
		
				al_npl.insert( al_npl.end(), npl.begin(), Iteli );
				al_npl.push_back( make_pair( n_id_map[i], 1) );
				list< pair< Supertig_id, Forb > >::reverse_iterator Ritep = unitigVe[i].rbegin();
				for( ; Iteli != npl.end(); ++Iteli ) {
					ch += 1;
					if( Ritep == unitigVe[i].rend() )
						break;
					if( reversepht(*Ritep) != *Iteli ) {
						cout<<"error1.4 in replace_path"<<Iteli->first<<","<<Ritep->first<<endl;  exit(1);
					}
					++Ritep;
				}
				if( Iteli != npl.end() )
					al_npl.insert( al_npl.end(), Iteli, npl.end() );

				npl = al_npl;
				al_npl.clear();
				Iteli = find( npl.begin(), npl.end(), rpy );
		
			}

			if ( tag == 0 && (int)npl.size() < (int)unitigVe[i].size() ) {
				if ( plistcomp( unitigVe[i], npl ) == 1 ) {
		
					al_npl.push_back( make_pair( n_id_map[i], 0) );
					npl = al_npl;
			
					al_npl.clear();
					tag = 1;
					ch = size;
				}
				if ( tag == 0 ) {
				
					list< pair< Supertig_id, Forb > > revpl = reverseplist( npl );
					if(plistcomp( unitigVe[i], revpl ) == 1){
				
						al_npl.push_back(make_pair( n_id_map[i], 1));
						npl = al_npl;
				
						al_npl.clear();
						tag = 1;
						ch = size;
					}
				}
			}

			pl[j] = npl;

		
		}
		
	}

	for ( size_t i = 0; i < pl.size(); ++i ) {
		if ( pl[i].size() > 1 )
			al_pl.push_back( pl[i] );
	}
	pl = al_pl;

	
}

void replace_baitmap( vector< list< pair< Supertig_id, Forb > > > &path, 
					 map< pair< Supertig_id, Forb >, fished_bait > &bait_map,
					 map< size_t, Supertig_id > &n_id_map,
					 Supertig_bank &tig_bank )
{

	map< pair< Supertig_id, Forb >, fished_bait > almap;
	map< pair< Supertig_id, Forb >, fished_bait >::iterator Iteb;
	for ( Iteb = bait_map.begin(); Iteb != bait_map.end(); ++Iteb ) {
	
		int tag = 0;
		pair< Supertig_id, Forb > alp;
		pair< int, int > var;
		int seedvar = 0;
		if ( replace_baitmap_t( path, Iteb->first, n_id_map, tig_bank, alp, var ) ) {
			seedvar = var.second;
			tag = 1;
		
		}
		map< pair< Supertig_id, Forb >, set< int > > albulbmap;
		map< pair< Supertig_id, Forb >, set< int > >::iterator subite;
		for ( subite = Iteb->second.bubble_bait_length_map.begin(); subite != Iteb->second.bubble_bait_length_map.end(); ++subite ) {
			pair< Supertig_id, Forb > albulbp;
			pair< int, int > bulbvar;
			int bulbvardefalt = 0;
		
			int tagbulb = 0;
			if ( replace_baitmap_t( path, subite->first, n_id_map, tig_bank, albulbp, bulbvar ) ) {
				bulbvardefalt = bulbvar.first;
			
				tagbulb = 1;
			}
			if ( tag == 1 || tagbulb == 1 ) {
				set< int > als;
				set< int >::iterator ites;
				for ( ites = subite->second.begin(); ites != subite->second.end(); ++ites ) {
					als.insert( *ites - seedvar - bulbvardefalt );
				}
				if ( tagbulb == 1 )
					albulbmap.insert( make_pair( albulbp, als ) );
				else
					albulbmap.insert( make_pair( subite->first, als ) );
			} else {
				albulbmap.insert( *subite );
			}
		}
		fished_bait fob;
		fob.bubble_bait_length_map = albulbmap;
		if ( tag == 0 ) 
			alp = Iteb->first;
		almap.insert( make_pair( alp, fob ) );
	}
	bait_map = almap;

}

bool replace_baitmap_t( vector< list< pair< Supertig_id, Forb > > > &path, 
					   pair< Supertig_id, Forb > p, 
					   map< size_t, Supertig_id > &n_id_map,
					   Supertig_bank &tig_bank,
					   pair< Supertig_id, Forb > &alp,
					   pair< int, int > &var )
{
	size_t psize = path.size();
	for ( size_t i = 0 ; i < psize; ++i ) {
		if ( replace_baitmap_t_t( path[i], p, i, n_id_map, tig_bank, alp, var ) ) 
			return true;
	}
	return false;
}

bool replace_baitmap_t_t( list< pair< Supertig_id, Forb > > &path, 
						 pair< Supertig_id, Forb > p, 
						 size_t k,
						 map< size_t, Supertig_id > &n_id_map,
						 Supertig_bank &tig_bank,
						 pair< Supertig_id, Forb > &alp,
						 pair< int, int > &var )
{
	if ( find( path.begin(), path.end(), p ) != path.end() ) {
		Supertig_id n_id = n_id_map[k];
		alp = make_pair( n_id, 0 );
		if ( replace_baitmap_getvar( p.first, 0, tig_bank.Supertig_Map[n_id], var ) ) {
			return true;
		} 
			
	} else if ( find( path.begin(), path.end(), reversepht( p ) ) != path.end() ) {
		Supertig_id n_id = n_id_map[k];
		alp = make_pair( n_id, 1 );
		if ( replace_baitmap_getvar( p.first, 1, tig_bank.Supertig_Map[n_id], var ) ) {
			return true;
		} 
	}
	return false;
}

bool replace_baitmap_getvar( Supertig_id tig_id, 
							int drct,
							Supertig &suptig,
							pair< int, int > &var )
{
	
	pair< int, int > p = suptig.gettigpos( tig_id );
	pair< int, int > nulp;
	if ( p == nulp ) {
		cerr << "Warning in replace_baitmap_getvar: no find pos in the suptig!"<<endl;
		return false;
	} 
	if ( drct == 0 ) {
		var.first = p.first - 1;
		var.second = suptig.length - p.second;
	} else {
		var.first = suptig.length - p.second;
		var.second = p.first - 1;
	}
	
	return true;
}



