#ifndef GRAPH_RM_CONTR_H
#define GRAPH_RM_CONTR_H

#include "Graph_subgraph.h"
#include "Graph_Suptig_Assbl.h"
#include "poperate.h"

using namespace std;

////////////////////////
//
// After super paths are found, the spurious overlap links are denoted as 
// those that contradict with the edge in the super path. These spurious
// links are thus removed from the graph.
//
//////////////////////////
void remove_contra_link( subgraph &graph_t, Scaffold_subset &scf_s, Supertig_bank &bank );

void form_Link_fr_superpath( map< Supertig_id, Supertig_Overlap_Link > &lmap,
							map< Supertig_id, Supertig_Overlap_Link > &L_Map,
							vector< list< pair< Supertig_id, Forb > > > &superpath,
							Supertig_bank &tig_bank );

void form_Link_fr_path( map< Supertig_id, Supertig_Overlap_Link > &lmap, map< Supertig_id, Supertig_Overlap_Link > &L_Map, list<pair< Supertig_id, Forb > > &path, Supertig_bank &tig_bank );

void merge_sim_path_fr_Link( map< Supertig_id, Supertig_Overlap_Link > & ov_link, vector< list< pair< Supertig_id, Forb > > > &simple_path );   // path with nodes >= 2

void rm_contr_link( map< Supertig_id, Supertig_Overlap_Link > &tmp_link, 
				   map< Supertig_id, Supertig_Overlap_Link > &pre_ov_link,
				   Scaffold_subset &scf_s,
				   Supertig_bank &bank );


void ass_sim_path( vector< list< pair< Supertig_id, Forb > > > &path,
				  Scaffold_subset &scf_s,
				  subgraph &graph_t,
				  Supertig_bank &tig_bank,
				  map< size_t, Supertig_id > &n_id_map );

void replace_path( vector< list< pair< Supertig_id, Forb > > > &path, 
				  vector< list< pair< Supertig_id, Forb > > > &sim_path, 
				  map< size_t, Supertig_id > &n_id_map );


void replace_baitmap( vector< list< pair< Supertig_id, Forb > > > &path, 
					 map< pair< Supertig_id, Forb >, fished_bait > &seed_bait_map,
					 map< size_t, Supertig_id > &n_id_map,
					 Supertig_bank &tig_bank );

bool replace_baitmap_t( vector< list< pair< Supertig_id, Forb > > > &path, 
					   pair< Supertig_id, Forb > p, 
					   map< size_t, Supertig_id > &n_id_map,
					   Supertig_bank &tig_bank,
					   pair< Supertig_id, Forb > &alp,
					   pair< int, int > &var );

bool replace_baitmap_t_t( list< pair< Supertig_id, Forb > > &path, 
						 pair< Supertig_id, Forb > p, 
						 size_t k,
						 map< size_t, Supertig_id > &n_id_map,
						 Supertig_bank &tig_bank,
						 pair< Supertig_id, Forb > &alp,
						 pair< int, int > &var );

bool replace_baitmap_getvar( Supertig_id tig_id, 
							int drct,
							Supertig &suptig,
							pair< int, int > &var );


#endif

