#include "Graph_simbbl.h"

void simple_bulb_find( subgraph &graph_t, vector< vector< Supertig_id > > &bulb_ve, Supertig_bank &tig_bank, int max_len_var )
{
	set< Supertig_id > single_linked_tig;
	
	single_linked_tig_find( graph_t, single_linked_tig );

	if( single_linked_tig.empty() )
		return;

	set< Supertig_id > used_id;
	set< Supertig_id >::iterator Ite;
	for ( Ite = single_linked_tig.begin(); Ite != single_linked_tig.end(); ++Ite ) {
		if ( used_id.find(*Ite) != used_id.end() )
			continue;

		simple_bulb_find_t( graph_t, bulb_ve, *Ite, used_id, single_linked_tig, tig_bank, max_len_var );
		
	}
	
}

void simple_bulb_find_t( subgraph &graph_t,
						  vector< vector< Supertig_id > > &bulb_ve,
						  Supertig_id single_id,
						  set< Supertig_id > &used_id, 
						  set< Supertig_id > &single_linked_tig,
						  Supertig_bank &tig_bank,
						  int max_len_var )
{
	if( (int)graph_t.Supertig_Overlap_Link_Map[single_id].head_links.size() != 1 ) {
		cerr << "Warning in func simple_bubble_find_t: head_link's szie of single_id does not equal to 1!"<<endl;
		return;
	}
	if( (int)graph_t.Supertig_Overlap_Link_Map[single_id].tail_links.size() != 1 ) {
		cerr << "Warning in func simple_bubble_find_t: tail_link's szie of single_id does not equal to 1!"<<endl;
		return;
	}

	pair< Supertig_id, Forb > head_linked_edge = *graph_t.Supertig_Overlap_Link_Map[single_id].head_links.begin();
	pair< Supertig_id, Forb > tail_linked_edge = *graph_t.Supertig_Overlap_Link_Map[single_id].tail_links.begin();

	set< Supertig_id > vac_head_link;
	set< Supertig_id > vac_tail_link;
	if( head_linked_edge.second == 0 ) {
		set< pair< Supertig_id, Forb > >::iterator Iteh;
		for ( Iteh = graph_t.Supertig_Overlap_Link_Map[ head_linked_edge.first ].head_links.begin(); Iteh != graph_t.Supertig_Overlap_Link_Map[ head_linked_edge.first ].head_links.end(); ++Iteh ) {
			if( Iteh->first == single_id )
				continue;
			if( single_linked_tig.find( Iteh->first ) != single_linked_tig.end() ) {
				vac_head_link.insert( Iteh->first );
			}
		}
		
	}else {
		set< pair< Supertig_id, Forb > >::iterator Itet;
		for ( Itet = graph_t.Supertig_Overlap_Link_Map[ head_linked_edge.first ].tail_links.begin(); Itet != graph_t.Supertig_Overlap_Link_Map[ head_linked_edge.first ].tail_links.end(); ++Itet ) {
			if( Itet->first == single_id )
				continue;
			if( single_linked_tig.find( Itet->first ) != single_linked_tig.end() ) {
				vac_head_link.insert( Itet->first );
			}
		}
		
	}

	if( vac_head_link.empty() )
		return;

	if( tail_linked_edge.second == 0 ) {
		set< pair< Supertig_id, Forb > >::iterator Iteh;
		for ( Iteh = graph_t.Supertig_Overlap_Link_Map[ tail_linked_edge.first ].head_links.begin(); Iteh != graph_t.Supertig_Overlap_Link_Map[ tail_linked_edge.first ].head_links.end(); ++Iteh ) {
			if( Iteh->first == single_id )
				continue;
			if( single_linked_tig.find( Iteh->first ) != single_linked_tig.end() ) {
				vac_tail_link.insert( Iteh->first );
			}
		}
	}else {
		set< pair< Supertig_id, Forb > >::iterator Itet;
		for ( Itet = graph_t.Supertig_Overlap_Link_Map[ tail_linked_edge.first ].tail_links.begin(); Itet != graph_t.Supertig_Overlap_Link_Map[ tail_linked_edge.first ].tail_links.end(); ++Itet ) {
			if( Itet->first == single_id )
				continue;
			if( single_linked_tig.find( Itet->first ) != single_linked_tig.end() ) {
				vac_tail_link.insert( Itet->first );
			}
		}
	}

	if( vac_tail_link.empty() )
		return;

	vector< Supertig_id > bulb;

	set< Supertig_id >::iterator Iteset;
	for ( Iteset = vac_head_link.begin(); Iteset != vac_head_link.end(); ++Iteset ) {
		if ( vac_tail_link.find( *Iteset ) != vac_tail_link.end() ) {
			if ( length_check_bulb( *Iteset, single_id, tig_bank, max_len_var ) ) {
				bulb.push_back( *Iteset );
				used_id.insert( *Iteset );
			}
		}
	}
	if( !bulb.empty() )
		bulb.push_back( single_id );

	if( !bulb.empty() )
		bulb_ve.push_back( bulb );
	
	
}

bool length_check_bulb( Supertig_id ida, Supertig_id idb, Supertig_bank &tig_bank, int max_len_var )
{

	int lena = tig_bank.Supertig_Map[ida].length;
	int lenb = tig_bank.Supertig_Map[idb].length;

	if( abs( lena - lenb ) > max_len_var )
		return false;
	else
		return true;
	

}

void single_linked_tig_find( subgraph &graph_t, set< Supertig_id > &single_linked_tig )
{
	map< Supertig_id, Supertig_Overlap_Link >::iterator Ite;
	for ( Ite = graph_t.Supertig_Overlap_Link_Map.begin(); Ite != graph_t.Supertig_Overlap_Link_Map.end(); ++Ite ) {
		if ( Ite->second.head_links.size() == 1 && Ite->second.tail_links.size() == 1 )
			single_linked_tig.insert( Ite->first );
	}
}

void simple_bulb_assbl( vector< Supertig_id > & bulb, subgraph &graph_t, Supertig_bank &tig_bank )
{
	Supertig n_tig;
	n_tig.Tig_Ve.push_back( bulb );

	vector< Forb > Forb_ve;
	vector< pair< int, int > > Pos_ve;

	set< Supertig_id > tigset;
	for ( size_t i = 0; i < bulb.size(); ++i )
		tigset.insert( bulb[i] );

	map< Supertig_id, int > head_ovlen_map;
	map< Supertig_id, int > tail_ovlen_map;

	pair< Supertig_id, Forb > head_linked_edge = *graph_t.Supertig_Overlap_Link_Map[bulb[0]].tail_links.begin();
	pair< Supertig_id, Forb > tail_linked_edge = *graph_t.Supertig_Overlap_Link_Map[bulb[0]].head_links.begin();
	if( head_linked_edge.second == 0 ) {
		for ( size_t i = 0; i < bulb.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bulb[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.end() ) {
				Forb_ve.push_back( 1 );
				head_ovlen_map.insert( make_pair( bulb[i], graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].Head_Id_Ov_Ma[p] ) );
			} else {
				p = make_pair( bulb[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.end() ) {
					Forb_ve.push_back( 0 );
					head_ovlen_map.insert( make_pair( bulb[i], graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].Head_Id_Ov_Ma[p] ) );
				} else {
					cerr << "Warning in func simple_bubble_assbl: the tig bulb[i] not found in head linked edge " <<endl;
					return;
				}
			}
		}

	} else {
		for ( size_t i = 0; i < bulb.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bulb[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.end() ) {
				Forb_ve.push_back( 1 );
				head_ovlen_map.insert( make_pair( bulb[i], graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].Tail_Id_Ov_Ma[p] ) );
			} else {
				p = make_pair( bulb[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.end() ) {
					Forb_ve.push_back( 0 );
					head_ovlen_map.insert( make_pair( bulb[i], graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].Tail_Id_Ov_Ma[p] ) );
				} else {
					cerr << "Warning in func simple_bubble_assbl: the tig bulb[i] not found in head linked edge " <<endl;
					return;
				}
			}
		}
	}

	if( tail_linked_edge.second == 0 ) {
		for ( size_t i = 0; i < bulb.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bulb[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.end() ) {
				
				tail_ovlen_map.insert( make_pair( bulb[i], graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].Head_Id_Ov_Ma[p] ) );
			} else {
				p = make_pair( bulb[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.end() ) {
					
					tail_ovlen_map.insert( make_pair( bulb[i], graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].Head_Id_Ov_Ma[p] ) );
				} else {
					cerr << "Warning in func simple_bubble_assbl: the tig bulb[i] not found in tail linked edge " <<endl;
					return;
				}
			}
		}

	} else {
		for ( size_t i = 0; i < bulb.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bulb[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.end() ) {
				
				tail_ovlen_map.insert( make_pair( bulb[i], graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].Tail_Id_Ov_Ma[p] ) );
			} else {
				p = make_pair( bulb[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.end() ) {
					
					tail_ovlen_map.insert( make_pair( bulb[i], graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].Tail_Id_Ov_Ma[p] ) );
				} else {
					cerr << "Warning in func simple_bubble_assbl: the tig bulb[i] not found in tail linked edge " <<endl;
					return;
				}
			}
		}
	}

	double body_len = 0;
	int max_left_ovlen = 0;
	int max_right_ovlen = 0;

	for ( size_t i = 0; i < bulb.size(); ++i ) {
		int this_body_len = tig_bank.Supertig_Map[bulb[i]].length - head_ovlen_map[bulb[i]] - tail_ovlen_map[bulb[i]];
		body_len =  double( i * body_len + this_body_len ) / ( i + 1 );
		if ( head_ovlen_map[bulb[i]] > max_left_ovlen ) {
			max_left_ovlen = head_ovlen_map[bulb[i]];
		}
		if ( tail_ovlen_map[bulb[i]] > max_right_ovlen ) {
			max_right_ovlen = tail_ovlen_map[bulb[i]];
		}
	}

	int body_len_i = (int)body_len;
	n_tig.length = max_left_ovlen + body_len_i + max_right_ovlen;
	for ( size_t i = 0; i < bulb.size(); ++i ) {
		Pos_ve.push_back( make_pair( max_left_ovlen - head_ovlen_map[bulb[i]] + 1, n_tig.length - ( max_right_ovlen - tail_ovlen_map[bulb[i]] ) ) );
	}

	n_tig.Tig_F_Ve.push_back( Forb_ve );
	n_tig.Tig_P_Ve.push_back( Pos_ve );
	n_tig.bubble = true;

	Supertig_id n_id = tig_bank.Supertig_Map.rbegin()->first + 1;
	if( tig_bank.Supertig_Map.find( n_id ) != tig_bank.Supertig_Map.end() ) {
		cerr << "Warning in  func simple_bubble_assbl: n_id already exist in tig_bank.Supertig_Map " <<endl;
		return;
	}

	//erase merged tig from active_tig set, add the n_tig in the active_tig set.
	for ( size_t i = 0; i < bulb.size(); ++i ) {
		if ( graph_t.active_tig.find( bulb[i] ) != graph_t.active_tig.end() )
			graph_t.active_tig.erase( bulb[i] );
	}
	graph_t.active_tig.insert( n_id );
	///////////////////////////////////////////////////////

	tig_bank.Supertig_Map.insert( make_pair ( n_id, n_tig ) );


	simple_bulb_ov_link_replace( n_id, graph_t, tig_bank, head_linked_edge, tail_linked_edge, bulb, max_left_ovlen, max_right_ovlen );


	suptig_scf_replace( n_id, n_tig, tig_bank );

}

void simple_bulb_ov_link_replace(  Supertig_id id,
								   subgraph &graph_t, 
								   Supertig_bank &tig_bank, 
								   pair< Supertig_id, Forb > head_linked_edge, 
								   pair< Supertig_id, Forb > tail_linked_edge, 
								   vector< Supertig_id > & bulb,
								   int max_left_ovlen,
								   int max_right_ovlen )
{

	if( head_linked_edge.second == 0 ) {
		for ( size_t i = 0; i < bulb.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bulb[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.end() ) {
				graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.erase(p);
				graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].Head_Id_Ov_Ma.erase(p);

				tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.erase(p);
				tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].Head_Id_Ov_Ma.erase(p);
				
			} else {
				p = make_pair( bulb[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.end() ) {
					graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.erase(p);
					graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].Head_Id_Ov_Ma.erase(p);

					tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.erase(p);
					tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].Head_Id_Ov_Ma.erase(p);
				} else {
					cerr << "Warning in func simple_bubble_assbl: the tig bulb[i] not found in head linked edge " <<endl;
					return;
				}
			}
		}
		graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.insert( make_pair( id, 1 ) );
		graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].Head_Id_Ov_Ma[ make_pair( id, 1 ) ] = max_left_ovlen;

		tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].head_links.insert( make_pair( id, 1 ) );
		tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].Head_Id_Ov_Ma[ make_pair( id, 1 ) ] = max_left_ovlen;

	} else {
		for ( size_t i = 0; i < bulb.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bulb[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.end() ) {
				graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.erase(p);
				graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].Tail_Id_Ov_Ma.erase(p);

				tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.erase(p);
				tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].Tail_Id_Ov_Ma.erase(p);
			} else {
				p = make_pair( bulb[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.end() ) {
					graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.erase(p);
					graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].Tail_Id_Ov_Ma.erase(p);

					tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.erase(p);
					tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].Tail_Id_Ov_Ma.erase(p);
				} else {
					cerr << "Warning in func simple_bubble_assbl: the tig bulb[i] not found in head linked edge " <<endl;
					return;
				}
			}
		}
		graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.insert( make_pair( id, 1 ) );
		graph_t.Supertig_Overlap_Link_Map[head_linked_edge.first].Tail_Id_Ov_Ma[make_pair( id, 1 )] = max_left_ovlen;

		tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].tail_links.insert( make_pair( id, 1 ) );
		tig_bank.Supertig_Overlap_Link_Map[head_linked_edge.first].Tail_Id_Ov_Ma[make_pair( id, 1 )] = max_left_ovlen;
	}

	if( tail_linked_edge.second == 0 ) {
		for ( size_t i = 0; i < bulb.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bulb[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.end() ) {
				
				graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.erase(p);
				graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].Head_Id_Ov_Ma.erase(p);

				tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.erase(p);
				tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].Head_Id_Ov_Ma.erase(p);
			} else {
				p = make_pair( bulb[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.end() ) {
					
					graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.erase(p);
					graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].Head_Id_Ov_Ma.erase(p);

					tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.erase(p);
					tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].Head_Id_Ov_Ma.erase(p);
				} else {
					cerr << "Warning in func simple_bubble_assbl: the tig bulb[i] not found in tail linked edge " <<endl;
					return;
				}
			}
		}

		graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.insert( make_pair( id, 0 ) );
		graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].Head_Id_Ov_Ma[make_pair( id, 0 )] = max_right_ovlen;

		tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].head_links.insert( make_pair( id, 0 ) );
		tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].Head_Id_Ov_Ma[make_pair( id, 0 )] = max_right_ovlen;

	} else {
		for ( size_t i = 0; i < bulb.size(); ++i ) {
			pair< Supertig_id, Forb > p = make_pair( bulb[i], 0 );
			if ( graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.end() ) {
				
				graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.erase(p);
				graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].Tail_Id_Ov_Ma.erase(p);

				tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.erase(p);
				tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].Tail_Id_Ov_Ma.erase(p);
			} else {
				p = make_pair( bulb[i], 1 );
				if ( graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.find( p ) != graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.end() ) {
					
					graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.erase(p);
					graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].Tail_Id_Ov_Ma.erase(p);

					tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.erase(p);
					tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].Tail_Id_Ov_Ma.erase(p);
				} else {
					cerr << "Warning in func simple_bubble_assbl: the tig bulb[i] not found in tail linked edge " <<endl;
					return;
				}
			}
		}

		graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.insert( make_pair( id, 0 ) );
		graph_t.Supertig_Overlap_Link_Map[tail_linked_edge.first].Tail_Id_Ov_Ma[make_pair( id, 0 )] = max_right_ovlen;

		tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].tail_links.insert( make_pair( id, 0 ) );
		tig_bank.Supertig_Overlap_Link_Map[tail_linked_edge.first].Tail_Id_Ov_Ma[make_pair( id, 0 )] = max_right_ovlen;
	}

	for ( size_t i = 0; i < bulb.size(); ++i ) {
		graph_t.Supertig_Overlap_Link_Map.erase( bulb[i] );
		tig_bank.Supertig_Overlap_Link_Map.erase( bulb[i] );
	}

	Supertig_Overlap_Link n_link;
	n_link.head_links.insert( tail_linked_edge );
	n_link.Head_Id_Ov_Ma[tail_linked_edge] = max_right_ovlen;
	n_link.tail_links.insert( head_linked_edge );
	n_link.Tail_Id_Ov_Ma[head_linked_edge] = max_left_ovlen;

	graph_t.Supertig_Overlap_Link_Map.insert( make_pair( id, n_link ) );
	tig_bank.Supertig_Overlap_Link_Map.insert( make_pair( id, n_link ) );


	
}



