#ifndef GRAPH_SIMBBL_H
#define GRAPH_SIMBBL_H

#include <math.h>
#include "Graph_subgraph.h"
#include "Graph_Scf_rpl.h"
#include "Graph_Suptig_Assbl.h"

using namespace std;

///////////////////////////////////////////////
// simple bulb indecate the simplest bulb consisting of two bridges
// which are both single node in the graph, i.e. single tig. In addition,
// the bridge tig has no other branches. Thus, replace them with a supertig
// in the graph is easy work. So assemble them at first.
//////////////////////////////////////////////

void simple_bulb_find( subgraph &graph_t, vector< vector< Supertig_id > > &bulb_ve, Supertig_bank &tig_bank, int max_len_var );

void simple_bulb_find_t( subgraph &graph_t, 
						  vector< vector< Supertig_id > > &bulb_ve, 
						  Supertig_id single_id, 
						  set< Supertig_id > &used_id, 
						  set< Supertig_id > &single_linked_tig, 
						  Supertig_bank &tig_bank,
						  int max_len_var );

bool length_check_bulb( Supertig_id ida, Supertig_id idb, Supertig_bank &tig_bank, int max_len_var );

void single_linked_tig_find( subgraph &graph_t, set< Supertig_id > &single_linked_tig );

void simple_bulb_assbl( vector< Supertig_id > & bulb, subgraph &graph_t, Supertig_bank &tig_bank );

void simple_bulb_ov_link_replace( Supertig_id id,
								   subgraph &graph_t, 
								   Supertig_bank &tig_bank, 
								   pair< Supertig_id, Forb > head_linked_edge, 
								   pair< Supertig_id, Forb > tail_linked_edge, 
								   vector< Supertig_id > & bulb,
								   int max_left_ovlen,
								   int max_right_ovlen );



#endif


