#include "Graph_structure.h"



void cut_subgraph( Graph_structure &graph, Supertig_bank &bank, int max_size, int min_high_degree )
{


	subgraph start_subgraph_t;
	start_subgraph_t.Supertig_Overlap_Link_Map = bank.Supertig_Overlap_Link_Map;

	if ( (int)start_subgraph_t.Supertig_Overlap_Link_Map.size() <= max_size ) {

		graph.subgraph_ve.push_back( start_subgraph_t );

	} else {

		multimap< int, pair< Supertig_id, Forb >, greater<int> > degree_rank;
		compute_degree_rank( bank, degree_rank, min_high_degree );

		graph.subgraph_ve = graph_divide( start_subgraph_t, max_size, degree_rank );
	}
}

vector< subgraph > graph_divide( subgraph &subgraph_t, int max_size, multimap< int, pair< Supertig_id, Forb >, greater<int> > &degree_rank )
{
	vector< subgraph > value;

	pair<  Supertig_id, Forb > cut_edge;
	int state = 0;
	multimap< int, pair< Supertig_id, Forb >, greater< int > >::iterator Ite;
	for( Ite = degree_rank.begin(); Ite != degree_rank.end(); ++Ite ) {
		if ( subgraph_t.Supertig_Overlap_Link_Map.find( Ite->second.first ) == subgraph_t.Supertig_Overlap_Link_Map.end() )
			continue;
		
		if ( subgraph_t.brink_set.find( Ite->second ) != subgraph_t.brink_set.end() ) {
			continue;
		}
		cut_edge = Ite->second;
		state = 1;
		break;

	}

	if( state == 0 ) {
		value.push_back( subgraph_t );
		return value;
	} else {   // state = 1
		erase_cut_edge( subgraph_t, cut_edge );
		
	}


	set<Supertig_id> remained;

	
	
	
	vector< subgraph > subgraph_ve;

	map< Supertig_id, Supertig_Overlap_Link >::iterator IteL;
	for(IteL = subgraph_t.Supertig_Overlap_Link_Map.begin(); IteL != subgraph_t.Supertig_Overlap_Link_Map.end(); ++IteL){
		
		remained.insert(IteL->first);
	}

	while(!remained.empty()){
		Supertig_id seed_id = *remained.begin();
		subgraph sub_subgraph;
		
		add_tig_to_subgraph( subgraph_t, sub_subgraph, seed_id, remained);

		add_brinkedge_to_subgraph( subgraph_t, sub_subgraph );
		
		subgraph_ve.push_back( sub_subgraph );
		sub_subgraph.brink_set.clear();
		sub_subgraph.Supertig_Overlap_Link_Map.clear();

	}

	size_t vesize = subgraph_ve.size();
	for ( size_t i = 0; i < vesize; ++i ) {
		if ( (int)subgraph_ve[i].Supertig_Overlap_Link_Map.size() <= max_size ) {
			value.push_back( subgraph_ve[i]);
		} else {
			vector< subgraph > next_subgraph_ve;
			next_subgraph_ve = graph_divide( subgraph_ve[i], max_size, degree_rank );
			value.insert( value.end(), next_subgraph_ve.begin(), next_subgraph_ve.end() );
		}
	}

	return value;

}

void erase_cut_edge( subgraph &graph, pair< Supertig_id, Forb > cut_edge )
{
	if( graph.Supertig_Overlap_Link_Map.find( cut_edge.first ) == graph.Supertig_Overlap_Link_Map.end() ) {
		cerr << "Warning: not find cut_edge: "<<cut_edge.first<<endl;
		return;
	}

	graph.brink_set.insert( cut_edge );

	if( cut_edge.second == 0 ) {
		set<pair<Supertig_id, Forb> >::iterator Itehl;
		for( Itehl = graph.Supertig_Overlap_Link_Map[cut_edge.first].head_links.begin(); Itehl != graph.Supertig_Overlap_Link_Map[cut_edge.first].head_links.end(); ++Itehl ) {
			if( graph.brink_set.find ( *Itehl ) == graph.brink_set.end() ) {
				
				erase_cut_edge( graph, *Itehl );
			}
		}
		graph.Supertig_Overlap_Link_Map[cut_edge.first].head_links.clear();
		graph.Supertig_Overlap_Link_Map[cut_edge.first].Head_Id_Ov_Ma.clear();
	}
	if( cut_edge.second == 1 ) {
		set<pair<Supertig_id, Forb> >::iterator Itetl;
		for( Itetl = graph.Supertig_Overlap_Link_Map[cut_edge.first].tail_links.begin(); Itetl != graph.Supertig_Overlap_Link_Map[cut_edge.first].tail_links.end(); ++Itetl ) {
			if( graph.brink_set.find ( *Itetl ) == graph.brink_set.end() ) {
				erase_cut_edge( graph, *Itetl );
			}
		}
		graph.Supertig_Overlap_Link_Map[cut_edge.first].tail_links.clear();
		graph.Supertig_Overlap_Link_Map[cut_edge.first].Tail_Id_Ov_Ma.clear();
	}
}

void add_tig_to_subgraph( subgraph &graph, subgraph & subgraph_t, Supertig_id seed_id, set< Supertig_id > &remain_idset )
{
	if( graph.Supertig_Overlap_Link_Map.find( seed_id ) == graph.Supertig_Overlap_Link_Map.end() ) {
		cerr << " Warning in func add_tig_to_subgraph: seed_id is not found in graph "<<seed_id<<endl;
		return;
	}

	subgraph_t.Supertig_Overlap_Link_Map.insert( make_pair( seed_id, graph.Supertig_Overlap_Link_Map[seed_id]) );
	remain_idset.erase( seed_id );
	if( remain_idset.empty() )
		return;

	set<pair<Supertig_id, Forb> >::iterator Itehl;
	for( Itehl = graph.Supertig_Overlap_Link_Map[seed_id].head_links.begin(); Itehl != graph.Supertig_Overlap_Link_Map[seed_id].head_links.end(); ++Itehl ) {
		if( remain_idset.find( Itehl->first ) != remain_idset.end() ) {
			add_tig_to_subgraph( graph, subgraph_t, Itehl->first, remain_idset );
		}
	}

	set<pair<Supertig_id, Forb> >::iterator Itetl;
	for( Itetl = graph.Supertig_Overlap_Link_Map[seed_id].tail_links.begin(); Itetl != graph.Supertig_Overlap_Link_Map[seed_id].tail_links.end(); ++Itetl ) {
		if( remain_idset.find( Itetl->first ) != remain_idset.end() ) {
			add_tig_to_subgraph( graph, subgraph_t, Itetl->first, remain_idset );
		}
	}

}

void add_brinkedge_to_subgraph( subgraph &graph, subgraph & subgraph_t )
{
	set< pair<Supertig_id, Forb> >::iterator Ite;
	for ( Ite = graph.brink_set.begin(); Ite != graph.brink_set.end(); ++Ite ) {
		if( subgraph_t.Supertig_Overlap_Link_Map.find( Ite->first ) != subgraph_t.Supertig_Overlap_Link_Map.end() )
			subgraph_t.brink_set.insert( *Ite );
	}
}

void compute_degree_rank( Supertig_bank &bank, multimap< int, pair< Supertig_id, Forb >, greater<int> > &degree_rank, int min_high_degree )
{
	map< Supertig_id, Supertig_Overlap_Link >::iterator Ite;
	for ( Ite = bank.Supertig_Overlap_Link_Map.begin(); Ite != bank.Supertig_Overlap_Link_Map.end(); ++Ite ) {
		if( !Ite->second.head_links.empty() ) {
			int size = (int)Ite->second.head_links.size();
			if ( size >= min_high_degree ) {
				degree_rank.insert( make_pair( size, make_pair( Ite->first, 0 ) ) );
			}
		}
		if( !Ite->second.tail_links.empty() ) {
			int size = (int)Ite->second.tail_links.size();
			if( size >= min_high_degree ) {
				degree_rank.insert( make_pair( size, make_pair( Ite->first, 1 ) ) );
			}
		}
	}
}

void subgraph_edit( subgraph & subgraph_t, Supertig_bank & bank )
{
	ini_active_tig( subgraph_t );
	vector< vector< Supertig_id > > simple_bulb_ve;
	
	simple_bulb_find( subgraph_t, simple_bulb_ve, bank, bank.tig_len );

	
	if ( simple_bulb_ve.empty() ) {
		
	} else {
		for ( size_t i = 0; i < simple_bulb_ve.size(); ++i ) {
			simple_bulb_assbl( simple_bulb_ve[i], subgraph_t, bank );
		}
	}


	if ( get_subg_scf( subgraph_t, bank, bank.mate_len ) ) {
	
		Supath_find( subgraph_t.Supertig_Overlap_Link_Map, subgraph_t.scf_s, subgraph_t, bank );
	
	} 

	remove_contra_link( subgraph_t, subgraph_t.scf_s, bank );


	
	int var_len = bank.tig_len;
	graph_bubble( subgraph_t, subgraph_t.scf_s, bank, var_len );
	
	simple_path_merge( subgraph_t, subgraph_t.scf_s, bank );   

	
	repeat_seperate( subgraph_t, subgraph_t.scf_s, bank );

	
	simple_path_merge( subgraph_t, subgraph_t.scf_s, bank );

	

	
}

void ini_active_tig( subgraph &graph_t )
{
	map< Supertig_id, Supertig_Overlap_Link >::iterator Ite;
	for ( Ite = graph_t.Supertig_Overlap_Link_Map.begin(); Ite != graph_t.Supertig_Overlap_Link_Map.end(); ++Ite ) {
		graph_t.active_tig.insert( Ite->first );
	}
}

int get_size_biggest_subgraph( Graph_structure &stru )
{
	size_t vesize = stru.subgraph_ve.size();
	int val = 0;
	for ( size_t i = 0; i < vesize; ++i ) {
		if ( (int)stru.subgraph_ve[i].Supertig_Overlap_Link_Map.size() > val )
			val = (int)stru.subgraph_ve[i].Supertig_Overlap_Link_Map.size();
	}

	return val;
}

void graph_stru_pro( Graph_structure &stru, Supertig_bank & bank )
{ 
	
	size_t str_size = 1000000;
	int biggestsize = 0;
	do { 
		int max_size = 1000000;
		int min_high_degree = 4;
		cut_subgraph( stru, bank, max_size, min_high_degree );

		int new_biggestsize = get_size_biggest_subgraph( stru );
	
		if ( biggestsize > 0 ) {
			
			while ( biggestsize == new_biggestsize ) {
				if ( min_high_degree < 10 )
					min_high_degree += 1;
				else
					max_size += 1000000;
				cut_subgraph( stru, bank, max_size, min_high_degree );
				new_biggestsize = get_size_biggest_subgraph( stru );
			}

		}

		
		biggestsize = new_biggestsize;
		str_size = stru.subgraph_ve.size();

		for ( size_t i = 0; i < str_size; ++i ) {
			subgraph_edit( stru.subgraph_ve[i], bank );
			
		}
		
		

	} while ( str_size > 1 );

	
	getbestmatepath( stru.subgraph_ve[0], bank );


}


