#ifndef GRAPH_STRUCTUR_H
#define GRAPH_STRUCTUR_H

#include "Graph_subgraph.h"
#include "Graph_simbbl.h"
#include "Graph_subg_Scf.h"
#include "Graph_superpath.h"
#include "Graph_rm_Contr.h"
#include "Graph_bubble.h"
#include "Graph_simple_path.h"
#include "Graph_repeat_sep.h"
#include "Graph_unp_Stig.h"
#include "Graph_bestmatepath.h"
#include <map>
#include <set>

using namespace std;


class Graph_structure
{
public:
	vector< subgraph > subgraph_ve;
};

// This function aims to divide the graph into more components.
// This step can constrain the graph reducion or simplify process in the
// small subgraph with priority, in order to save time and space. As more 
// supertigs are assembled into larger supertigs, the graph size reduce. Then
// iterate cutting the upgraded graph into sub graph and excute the graph editing process.
void cut_subgraph( Graph_structure &graph, Supertig_bank &bank,  int max_size, int min_high_degree );

// This function is called when the size of the subgraph_t is bigger than the maximal threshold.
// In order to cut subgraph into more componants, the func first erase the most degree edge in the 
// subgraph as well as the edges that have the closest relatives (i.e. share the overlap sequence more or less).
// Then several un_connected sub_subgraphs could be obtained. If the obtained sub_subgraphs' size is still
// larger than maximal threshold, recur the function.
vector< subgraph > graph_divide( subgraph &subgraph_t, int max_size, multimap< int, pair< Supertig_id, Forb >, greater<int> > &degree_rank );

// To erase the cut_edge along with its relevant edges
void erase_cut_edge( subgraph &graph, pair< Supertig_id, Forb > cut_edge );

// add the tig along with its overlap_link from the graph to the tite subgraph_t.
void add_tig_to_subgraph( subgraph &graph, subgraph & subgraph_t, Supertig_id seed_id, set< Supertig_id > &remain_idset );
void add_brinkedge_to_subgraph( subgraph &graph, subgraph & subgraph_t );

void compute_degree_rank( Supertig_bank &bank, multimap< int, pair< Supertig_id, Forb >, greater<int> > &degree_rank, int min_high_degree );

// first step: simple bubble finding.
void subgraph_edit( subgraph & subgraph_t, Supertig_bank & bank );

// At the beginning, all the tigs are active tig because no merge done.
void ini_active_tig( subgraph & subgraph_t );

int get_size_biggest_subgraph( Graph_structure &stru );

void graph_stru_pro( Graph_structure &stru, Supertig_bank & bank );




#endif

