#include "Graph_subg_Scf.h"

bool get_subg_scf( subgraph &graph, Supertig_bank &bank, int max_gap_len )
{
	graph.scf_s.Pair_map.clear();

	map< Supertig_id, Supertig_Overlap_Link >::iterator Ite;
	for ( Ite = graph.Supertig_Overlap_Link_Map.begin(); Ite != graph.Supertig_Overlap_Link_Map.end(); ++Ite ) {
		get_subg_scf_s_t( Ite->first, graph, bank, max_gap_len );
	}
	if ( !graph.scf_s.Pair_map.empty() ) {
	
		graph.scf_s.gap_length_bound = max_gap_len;
		get_subg_scf_seed( graph.scf_s );
		return true;

	} else {

		return false;
	}

}

void get_subg_scf_s_t( Supertig_id id, subgraph &graph, Supertig_bank &bank, int max_gap_len )
{
	if ( bank.Pair_Scaffold_map.find( id ) == bank.Pair_Scaffold_map.end() )
		return;

	map< Supertig_id, vector< Scaffold_gap_id > >::iterator Ite;
	for ( Ite = bank.Pair_Scaffold_map[id].begin(); Ite != bank.Pair_Scaffold_map[id].end(); ++Ite) {
		if ( Ite->first == id )
			continue;
		if ( graph.Supertig_Overlap_Link_Map.find( Ite->first ) == graph.Supertig_Overlap_Link_Map.end() )
			continue;

		if ( graph.scf_s.Pair_map.find( Ite->first ) != graph.scf_s.Pair_map.end() ) {
			if ( graph.scf_s.Pair_map[Ite->first].find( id ) != graph.scf_s.Pair_map[Ite->first].end() ) {
				graph.scf_s.Pair_map[id].insert( make_pair( Ite->first, graph.scf_s.Pair_map[Ite->first][id] ) );

			}
			continue;
		} else {
			vector< Scaffold_gap_id > scf_ve;
			for ( size_t i = 0; i < Ite->second.size(); ++i ) {
				if ( bank.Scaffold_map[Ite->second[i]].lowb <= max_gap_len ) {
					scf_ve.push_back( Ite->second[i] );
				}
			}
			if ( !scf_ve.empty() ) {
				graph.scf_s.Pair_map[id][Ite->first] = scf_ve;
			}
		}


	}
}

void get_subg_scf_seed( Scaffold_subset &scf_s )
{
	multimap< int, Supertig_id, greater< int > > rank;
	int total = 0;
	map< Supertig_id, map< Supertig_id, vector< Scaffold_gap_id > > >::iterator Ite;
	for ( Ite = scf_s.Pair_map.begin(); Ite != scf_s.Pair_map.end(); ++Ite ) {
		int si = (int)Ite->second.size();
		total += si;
		rank.insert( make_pair( si, Ite->first ) );
	}

	multimap< int, Supertig_id, greater< int > >::iterator Iterank;
	
	
	
	for ( Iterank = rank.begin(); Iterank != rank.end(); ++Iterank ) {
		
		

		map< Supertig_id, vector< Scaffold_gap_id > >::iterator Item;
		int tag = 0;
		for ( Item = scf_s.Pair_map[Iterank->second].begin(); Item != scf_s.Pair_map[Iterank->second].end(); ++Item ) {
			if ( scf_s.seeds.find( Item->first ) == scf_s.seeds.end() ) {
				tag = 1;
				break;
			}
		}
		if ( tag == 1 ) {
			scf_s.seeds.insert( Iterank->second );
		}
		
	}
}



